/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Audio Language Selection
 */
@Generated("software.amazon.awssdk:codegen")
public final class AudioLanguageSelection implements SdkPojo, Serializable,
        ToCopyableBuilder<AudioLanguageSelection.Builder, AudioLanguageSelection> {
    private static final SdkField<String> LANGUAGE_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AudioLanguageSelection::languageCode)).setter(setter(Builder::languageCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("languageCode").build()).build();

    private static final SdkField<String> LANGUAGE_SELECTION_POLICY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AudioLanguageSelection::languageSelectionPolicyAsString))
            .setter(setter(Builder::languageSelectionPolicy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("languageSelectionPolicy").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LANGUAGE_CODE_FIELD,
            LANGUAGE_SELECTION_POLICY_FIELD));

    private static final long serialVersionUID = 1L;

    private final String languageCode;

    private final String languageSelectionPolicy;

    private AudioLanguageSelection(BuilderImpl builder) {
        this.languageCode = builder.languageCode;
        this.languageSelectionPolicy = builder.languageSelectionPolicy;
    }

    /**
     * Selects a specific three-letter language code from within an audio source.
     * 
     * @return Selects a specific three-letter language code from within an audio source.
     */
    public String languageCode() {
        return languageCode;
    }

    /**
     * When set to "strict", the transport stream demux strictly identifies audio streams by their language descriptor.
     * If a PMT update occurs such that an audio stream matching the initially selected language is no longer present
     * then mute will be encoded until the language returns. If "loose", then on a PMT update the demux will choose
     * another audio stream in the program with the same stream type if it can't find one with the same language.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #languageSelectionPolicy} will return {@link AudioLanguageSelectionPolicy#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #languageSelectionPolicyAsString}.
     * </p>
     * 
     * @return When set to "strict", the transport stream demux strictly identifies audio streams by their language
     *         descriptor. If a PMT update occurs such that an audio stream matching the initially selected language is
     *         no longer present then mute will be encoded until the language returns. If "loose", then on a PMT update
     *         the demux will choose another audio stream in the program with the same stream type if it can't find one
     *         with the same language.
     * @see AudioLanguageSelectionPolicy
     */
    public AudioLanguageSelectionPolicy languageSelectionPolicy() {
        return AudioLanguageSelectionPolicy.fromValue(languageSelectionPolicy);
    }

    /**
     * When set to "strict", the transport stream demux strictly identifies audio streams by their language descriptor.
     * If a PMT update occurs such that an audio stream matching the initially selected language is no longer present
     * then mute will be encoded until the language returns. If "loose", then on a PMT update the demux will choose
     * another audio stream in the program with the same stream type if it can't find one with the same language.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #languageSelectionPolicy} will return {@link AudioLanguageSelectionPolicy#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #languageSelectionPolicyAsString}.
     * </p>
     * 
     * @return When set to "strict", the transport stream demux strictly identifies audio streams by their language
     *         descriptor. If a PMT update occurs such that an audio stream matching the initially selected language is
     *         no longer present then mute will be encoded until the language returns. If "loose", then on a PMT update
     *         the demux will choose another audio stream in the program with the same stream type if it can't find one
     *         with the same language.
     * @see AudioLanguageSelectionPolicy
     */
    public String languageSelectionPolicyAsString() {
        return languageSelectionPolicy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(languageCode());
        hashCode = 31 * hashCode + Objects.hashCode(languageSelectionPolicyAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AudioLanguageSelection)) {
            return false;
        }
        AudioLanguageSelection other = (AudioLanguageSelection) obj;
        return Objects.equals(languageCode(), other.languageCode())
                && Objects.equals(languageSelectionPolicyAsString(), other.languageSelectionPolicyAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("AudioLanguageSelection").add("LanguageCode", languageCode())
                .add("LanguageSelectionPolicy", languageSelectionPolicyAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LanguageCode":
            return Optional.ofNullable(clazz.cast(languageCode()));
        case "LanguageSelectionPolicy":
            return Optional.ofNullable(clazz.cast(languageSelectionPolicyAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AudioLanguageSelection, T> g) {
        return obj -> g.apply((AudioLanguageSelection) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AudioLanguageSelection> {
        /**
         * Selects a specific three-letter language code from within an audio source.
         * 
         * @param languageCode
         *        Selects a specific three-letter language code from within an audio source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder languageCode(String languageCode);

        /**
         * When set to "strict", the transport stream demux strictly identifies audio streams by their language
         * descriptor. If a PMT update occurs such that an audio stream matching the initially selected language is no
         * longer present then mute will be encoded until the language returns. If "loose", then on a PMT update the
         * demux will choose another audio stream in the program with the same stream type if it can't find one with the
         * same language.
         * 
         * @param languageSelectionPolicy
         *        When set to "strict", the transport stream demux strictly identifies audio streams by their language
         *        descriptor. If a PMT update occurs such that an audio stream matching the initially selected language
         *        is no longer present then mute will be encoded until the language returns. If "loose", then on a PMT
         *        update the demux will choose another audio stream in the program with the same stream type if it can't
         *        find one with the same language.
         * @see AudioLanguageSelectionPolicy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AudioLanguageSelectionPolicy
         */
        Builder languageSelectionPolicy(String languageSelectionPolicy);

        /**
         * When set to "strict", the transport stream demux strictly identifies audio streams by their language
         * descriptor. If a PMT update occurs such that an audio stream matching the initially selected language is no
         * longer present then mute will be encoded until the language returns. If "loose", then on a PMT update the
         * demux will choose another audio stream in the program with the same stream type if it can't find one with the
         * same language.
         * 
         * @param languageSelectionPolicy
         *        When set to "strict", the transport stream demux strictly identifies audio streams by their language
         *        descriptor. If a PMT update occurs such that an audio stream matching the initially selected language
         *        is no longer present then mute will be encoded until the language returns. If "loose", then on a PMT
         *        update the demux will choose another audio stream in the program with the same stream type if it can't
         *        find one with the same language.
         * @see AudioLanguageSelectionPolicy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AudioLanguageSelectionPolicy
         */
        Builder languageSelectionPolicy(AudioLanguageSelectionPolicy languageSelectionPolicy);
    }

    static final class BuilderImpl implements Builder {
        private String languageCode;

        private String languageSelectionPolicy;

        private BuilderImpl() {
        }

        private BuilderImpl(AudioLanguageSelection model) {
            languageCode(model.languageCode);
            languageSelectionPolicy(model.languageSelectionPolicy);
        }

        public final String getLanguageCode() {
            return languageCode;
        }

        @Override
        public final Builder languageCode(String languageCode) {
            this.languageCode = languageCode;
            return this;
        }

        public final void setLanguageCode(String languageCode) {
            this.languageCode = languageCode;
        }

        public final String getLanguageSelectionPolicy() {
            return languageSelectionPolicy;
        }

        @Override
        public final Builder languageSelectionPolicy(String languageSelectionPolicy) {
            this.languageSelectionPolicy = languageSelectionPolicy;
            return this;
        }

        @Override
        public final Builder languageSelectionPolicy(AudioLanguageSelectionPolicy languageSelectionPolicy) {
            this.languageSelectionPolicy(languageSelectionPolicy == null ? null : languageSelectionPolicy.toString());
            return this;
        }

        public final void setLanguageSelectionPolicy(String languageSelectionPolicy) {
            this.languageSelectionPolicy = languageSelectionPolicy;
        }

        @Override
        public AudioLanguageSelection build() {
            return new AudioLanguageSelection(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
