/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.medialive.model.BadGatewayException;
import software.amazon.awssdk.services.medialive.model.BadRequestException;
import software.amazon.awssdk.services.medialive.model.BatchUpdateScheduleRequest;
import software.amazon.awssdk.services.medialive.model.BatchUpdateScheduleResponse;
import software.amazon.awssdk.services.medialive.model.ConflictException;
import software.amazon.awssdk.services.medialive.model.CreateChannelRequest;
import software.amazon.awssdk.services.medialive.model.CreateChannelResponse;
import software.amazon.awssdk.services.medialive.model.CreateInputRequest;
import software.amazon.awssdk.services.medialive.model.CreateInputResponse;
import software.amazon.awssdk.services.medialive.model.CreateInputSecurityGroupRequest;
import software.amazon.awssdk.services.medialive.model.CreateInputSecurityGroupResponse;
import software.amazon.awssdk.services.medialive.model.CreateMultiplexProgramRequest;
import software.amazon.awssdk.services.medialive.model.CreateMultiplexProgramResponse;
import software.amazon.awssdk.services.medialive.model.CreateMultiplexRequest;
import software.amazon.awssdk.services.medialive.model.CreateMultiplexResponse;
import software.amazon.awssdk.services.medialive.model.CreateTagsRequest;
import software.amazon.awssdk.services.medialive.model.CreateTagsResponse;
import software.amazon.awssdk.services.medialive.model.DeleteChannelRequest;
import software.amazon.awssdk.services.medialive.model.DeleteChannelResponse;
import software.amazon.awssdk.services.medialive.model.DeleteInputRequest;
import software.amazon.awssdk.services.medialive.model.DeleteInputResponse;
import software.amazon.awssdk.services.medialive.model.DeleteInputSecurityGroupRequest;
import software.amazon.awssdk.services.medialive.model.DeleteInputSecurityGroupResponse;
import software.amazon.awssdk.services.medialive.model.DeleteMultiplexProgramRequest;
import software.amazon.awssdk.services.medialive.model.DeleteMultiplexProgramResponse;
import software.amazon.awssdk.services.medialive.model.DeleteMultiplexRequest;
import software.amazon.awssdk.services.medialive.model.DeleteMultiplexResponse;
import software.amazon.awssdk.services.medialive.model.DeleteReservationRequest;
import software.amazon.awssdk.services.medialive.model.DeleteReservationResponse;
import software.amazon.awssdk.services.medialive.model.DeleteScheduleRequest;
import software.amazon.awssdk.services.medialive.model.DeleteScheduleResponse;
import software.amazon.awssdk.services.medialive.model.DeleteTagsRequest;
import software.amazon.awssdk.services.medialive.model.DeleteTagsResponse;
import software.amazon.awssdk.services.medialive.model.DescribeChannelRequest;
import software.amazon.awssdk.services.medialive.model.DescribeChannelResponse;
import software.amazon.awssdk.services.medialive.model.DescribeInputDeviceRequest;
import software.amazon.awssdk.services.medialive.model.DescribeInputDeviceResponse;
import software.amazon.awssdk.services.medialive.model.DescribeInputRequest;
import software.amazon.awssdk.services.medialive.model.DescribeInputResponse;
import software.amazon.awssdk.services.medialive.model.DescribeInputSecurityGroupRequest;
import software.amazon.awssdk.services.medialive.model.DescribeInputSecurityGroupResponse;
import software.amazon.awssdk.services.medialive.model.DescribeMultiplexProgramRequest;
import software.amazon.awssdk.services.medialive.model.DescribeMultiplexProgramResponse;
import software.amazon.awssdk.services.medialive.model.DescribeMultiplexRequest;
import software.amazon.awssdk.services.medialive.model.DescribeMultiplexResponse;
import software.amazon.awssdk.services.medialive.model.DescribeOfferingRequest;
import software.amazon.awssdk.services.medialive.model.DescribeOfferingResponse;
import software.amazon.awssdk.services.medialive.model.DescribeReservationRequest;
import software.amazon.awssdk.services.medialive.model.DescribeReservationResponse;
import software.amazon.awssdk.services.medialive.model.DescribeScheduleRequest;
import software.amazon.awssdk.services.medialive.model.DescribeScheduleResponse;
import software.amazon.awssdk.services.medialive.model.ForbiddenException;
import software.amazon.awssdk.services.medialive.model.GatewayTimeoutException;
import software.amazon.awssdk.services.medialive.model.InternalServerErrorException;
import software.amazon.awssdk.services.medialive.model.ListChannelsRequest;
import software.amazon.awssdk.services.medialive.model.ListChannelsResponse;
import software.amazon.awssdk.services.medialive.model.ListInputDevicesRequest;
import software.amazon.awssdk.services.medialive.model.ListInputDevicesResponse;
import software.amazon.awssdk.services.medialive.model.ListInputSecurityGroupsRequest;
import software.amazon.awssdk.services.medialive.model.ListInputSecurityGroupsResponse;
import software.amazon.awssdk.services.medialive.model.ListInputsRequest;
import software.amazon.awssdk.services.medialive.model.ListInputsResponse;
import software.amazon.awssdk.services.medialive.model.ListMultiplexProgramsRequest;
import software.amazon.awssdk.services.medialive.model.ListMultiplexProgramsResponse;
import software.amazon.awssdk.services.medialive.model.ListMultiplexesRequest;
import software.amazon.awssdk.services.medialive.model.ListMultiplexesResponse;
import software.amazon.awssdk.services.medialive.model.ListOfferingsRequest;
import software.amazon.awssdk.services.medialive.model.ListOfferingsResponse;
import software.amazon.awssdk.services.medialive.model.ListReservationsRequest;
import software.amazon.awssdk.services.medialive.model.ListReservationsResponse;
import software.amazon.awssdk.services.medialive.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.medialive.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.medialive.model.MediaLiveException;
import software.amazon.awssdk.services.medialive.model.NotFoundException;
import software.amazon.awssdk.services.medialive.model.PurchaseOfferingRequest;
import software.amazon.awssdk.services.medialive.model.PurchaseOfferingResponse;
import software.amazon.awssdk.services.medialive.model.StartChannelRequest;
import software.amazon.awssdk.services.medialive.model.StartChannelResponse;
import software.amazon.awssdk.services.medialive.model.StartMultiplexRequest;
import software.amazon.awssdk.services.medialive.model.StartMultiplexResponse;
import software.amazon.awssdk.services.medialive.model.StopChannelRequest;
import software.amazon.awssdk.services.medialive.model.StopChannelResponse;
import software.amazon.awssdk.services.medialive.model.StopMultiplexRequest;
import software.amazon.awssdk.services.medialive.model.StopMultiplexResponse;
import software.amazon.awssdk.services.medialive.model.TooManyRequestsException;
import software.amazon.awssdk.services.medialive.model.UnprocessableEntityException;
import software.amazon.awssdk.services.medialive.model.UpdateChannelClassRequest;
import software.amazon.awssdk.services.medialive.model.UpdateChannelClassResponse;
import software.amazon.awssdk.services.medialive.model.UpdateChannelRequest;
import software.amazon.awssdk.services.medialive.model.UpdateChannelResponse;
import software.amazon.awssdk.services.medialive.model.UpdateInputDeviceRequest;
import software.amazon.awssdk.services.medialive.model.UpdateInputDeviceResponse;
import software.amazon.awssdk.services.medialive.model.UpdateInputRequest;
import software.amazon.awssdk.services.medialive.model.UpdateInputResponse;
import software.amazon.awssdk.services.medialive.model.UpdateInputSecurityGroupRequest;
import software.amazon.awssdk.services.medialive.model.UpdateInputSecurityGroupResponse;
import software.amazon.awssdk.services.medialive.model.UpdateMultiplexProgramRequest;
import software.amazon.awssdk.services.medialive.model.UpdateMultiplexProgramResponse;
import software.amazon.awssdk.services.medialive.model.UpdateMultiplexRequest;
import software.amazon.awssdk.services.medialive.model.UpdateMultiplexResponse;
import software.amazon.awssdk.services.medialive.model.UpdateReservationRequest;
import software.amazon.awssdk.services.medialive.model.UpdateReservationResponse;
import software.amazon.awssdk.services.medialive.paginators.DescribeScheduleIterable;
import software.amazon.awssdk.services.medialive.paginators.ListChannelsIterable;
import software.amazon.awssdk.services.medialive.paginators.ListInputDevicesIterable;
import software.amazon.awssdk.services.medialive.paginators.ListInputSecurityGroupsIterable;
import software.amazon.awssdk.services.medialive.paginators.ListInputsIterable;
import software.amazon.awssdk.services.medialive.paginators.ListMultiplexProgramsIterable;
import software.amazon.awssdk.services.medialive.paginators.ListMultiplexesIterable;
import software.amazon.awssdk.services.medialive.paginators.ListOfferingsIterable;
import software.amazon.awssdk.services.medialive.paginators.ListReservationsIterable;

/**
 * Service client for accessing MediaLive. This can be created using the static {@link #builder()} method.
 *
 * API for AWS Elemental MediaLive
 */
@Generated("software.amazon.awssdk:codegen")
public interface MediaLiveClient extends SdkClient {
    String SERVICE_NAME = "medialive";

    /**
     * Create a {@link MediaLiveClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static MediaLiveClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link MediaLiveClient}.
     */
    static MediaLiveClientBuilder builder() {
        return new DefaultMediaLiveClientBuilder();
    }

    /**
     * Update a channel schedule
     *
     * @param batchUpdateScheduleRequest
     *        List of actions to create and list of actions to delete.
     * @return Result of the BatchUpdateSchedule operation returned by the service.
     * @throws BadRequestException
     *         This request was invalid.
     * @throws UnprocessableEntityException
     *         The update schedule request failed validation.
     * @throws InternalServerErrorException
     *         Unexpected internal service error.
     * @throws ForbiddenException
     *         You do not have permission to update the channel schedule.
     * @throws BadGatewayException
     *         Bad Gateway Error
     * @throws NotFoundException
     *         The specified channel id does not exist.
     * @throws GatewayTimeoutException
     *         Gateway Timeout Error
     * @throws TooManyRequestsException
     *         Request limit exceeded on update schedule calls.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.BatchUpdateSchedule
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/BatchUpdateSchedule" target="_top">AWS
     *      API Documentation</a>
     */
    default BatchUpdateScheduleResponse batchUpdateSchedule(BatchUpdateScheduleRequest batchUpdateScheduleRequest)
            throws BadRequestException, UnprocessableEntityException, InternalServerErrorException, ForbiddenException,
            BadGatewayException, NotFoundException, GatewayTimeoutException, TooManyRequestsException, AwsServiceException,
            SdkClientException, MediaLiveException {
        throw new UnsupportedOperationException();
    }

    /**
     * Update a channel schedule<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchUpdateScheduleRequest.Builder} avoiding the
     * need to create one manually via {@link BatchUpdateScheduleRequest#builder()}
     * </p>
     *
     * @param batchUpdateScheduleRequest
     *        A {@link Consumer} that will call methods on {@link BatchUpdateScheduleRequest.Builder} to create a
     *        request. List of actions to create and list of actions to delete.
     * @return Result of the BatchUpdateSchedule operation returned by the service.
     * @throws BadRequestException
     *         This request was invalid.
     * @throws UnprocessableEntityException
     *         The update schedule request failed validation.
     * @throws InternalServerErrorException
     *         Unexpected internal service error.
     * @throws ForbiddenException
     *         You do not have permission to update the channel schedule.
     * @throws BadGatewayException
     *         Bad Gateway Error
     * @throws NotFoundException
     *         The specified channel id does not exist.
     * @throws GatewayTimeoutException
     *         Gateway Timeout Error
     * @throws TooManyRequestsException
     *         Request limit exceeded on update schedule calls.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.BatchUpdateSchedule
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/BatchUpdateSchedule" target="_top">AWS
     *      API Documentation</a>
     */
    default BatchUpdateScheduleResponse batchUpdateSchedule(
            Consumer<BatchUpdateScheduleRequest.Builder> batchUpdateScheduleRequest) throws BadRequestException,
            UnprocessableEntityException, InternalServerErrorException, ForbiddenException, BadGatewayException,
            NotFoundException, GatewayTimeoutException, TooManyRequestsException, AwsServiceException, SdkClientException,
            MediaLiveException {
        return batchUpdateSchedule(BatchUpdateScheduleRequest.builder().applyMutation(batchUpdateScheduleRequest).build());
    }

    /**
     * Creates a new channel
     *
     * @param createChannelRequest
     *        A request to create a channel
     * @return Result of the CreateChannel operation returned by the service.
     * @throws BadRequestException
     *         This request was invalid.
     * @throws UnprocessableEntityException
     *         The Channel failed validation and could not be created.
     * @throws InternalServerErrorException
     *         Unexpected internal service error.
     * @throws ForbiddenException
     *         You do not have permission to create the channel.
     * @throws BadGatewayException
     *         Bad Gateway Error
     * @throws GatewayTimeoutException
     *         Gateway Timeout Error
     * @throws TooManyRequestsException
     *         Request limit exceeded on create channel calls to channel service.
     * @throws ConflictException
     *         The channel is unable to create due to an issue with channel resources.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.CreateChannel
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/CreateChannel" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateChannelResponse createChannel(CreateChannelRequest createChannelRequest) throws BadRequestException,
            UnprocessableEntityException, InternalServerErrorException, ForbiddenException, BadGatewayException,
            GatewayTimeoutException, TooManyRequestsException, ConflictException, AwsServiceException, SdkClientException,
            MediaLiveException {
        throw new UnsupportedOperationException();
    }

    /**
     * Creates a new channel<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateChannelRequest.Builder} avoiding the need to
     * create one manually via {@link CreateChannelRequest#builder()}
     * </p>
     *
     * @param createChannelRequest
     *        A {@link Consumer} that will call methods on {@link CreateChannelRequest.Builder} to create a request. A
     *        request to create a channel
     * @return Result of the CreateChannel operation returned by the service.
     * @throws BadRequestException
     *         This request was invalid.
     * @throws UnprocessableEntityException
     *         The Channel failed validation and could not be created.
     * @throws InternalServerErrorException
     *         Unexpected internal service error.
     * @throws ForbiddenException
     *         You do not have permission to create the channel.
     * @throws BadGatewayException
     *         Bad Gateway Error
     * @throws GatewayTimeoutException
     *         Gateway Timeout Error
     * @throws TooManyRequestsException
     *         Request limit exceeded on create channel calls to channel service.
     * @throws ConflictException
     *         The channel is unable to create due to an issue with channel resources.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.CreateChannel
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/CreateChannel" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateChannelResponse createChannel(Consumer<CreateChannelRequest.Builder> createChannelRequest)
            throws BadRequestException, UnprocessableEntityException, InternalServerErrorException, ForbiddenException,
            BadGatewayException, GatewayTimeoutException, TooManyRequestsException, ConflictException, AwsServiceException,
            SdkClientException, MediaLiveException {
        return createChannel(CreateChannelRequest.builder().applyMutation(createChannelRequest).build());
    }

    /**
     * Create an input
     *
     * @param createInputRequest
     *        The name of the input
     * @return Result of the CreateInput operation returned by the service.
     * @throws BadRequestException
     *         This request was invalid
     * @throws InternalServerErrorException
     *         Internal Service Error
     * @throws ForbiddenException
     *         Access was denied
     * @throws BadGatewayException
     *         Bad Gateway Error
     * @throws GatewayTimeoutException
     *         Gateway Timeout Error
     * @throws TooManyRequestsException
     *         Limit exceeded
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.CreateInput
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/CreateInput" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateInputResponse createInput(CreateInputRequest createInputRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, BadGatewayException, GatewayTimeoutException,
            TooManyRequestsException, AwsServiceException, SdkClientException, MediaLiveException {
        throw new UnsupportedOperationException();
    }

    /**
     * Create an input<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateInputRequest.Builder} avoiding the need to
     * create one manually via {@link CreateInputRequest#builder()}
     * </p>
     *
     * @param createInputRequest
     *        A {@link Consumer} that will call methods on {@link CreateInputRequest.Builder} to create a request. The
     *        name of the input
     * @return Result of the CreateInput operation returned by the service.
     * @throws BadRequestException
     *         This request was invalid
     * @throws InternalServerErrorException
     *         Internal Service Error
     * @throws ForbiddenException
     *         Access was denied
     * @throws BadGatewayException
     *         Bad Gateway Error
     * @throws GatewayTimeoutException
     *         Gateway Timeout Error
     * @throws TooManyRequestsException
     *         Limit exceeded
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.CreateInput
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/CreateInput" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateInputResponse createInput(Consumer<CreateInputRequest.Builder> createInputRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, BadGatewayException, GatewayTimeoutException,
            TooManyRequestsException, AwsServiceException, SdkClientException, MediaLiveException {
        return createInput(CreateInputRequest.builder().applyMutation(createInputRequest).build());
    }

    /**
     * Creates a Input Security Group
     *
     * @param createInputSecurityGroupRequest
     *        The IPv4 CIDRs to whitelist for this Input Security Group
     * @return Result of the CreateInputSecurityGroup operation returned by the service.
     * @throws BadRequestException
     *         The request to create an Input Security Group was Invalid
     * @throws InternalServerErrorException
     *         Internal Server Error
     * @throws ForbiddenException
     *         The requester does not have permission to create an Input Security Group
     * @throws BadGatewayException
     *         Bad Gateway Error
     * @throws GatewayTimeoutException
     *         Gateway Timeout Error
     * @throws TooManyRequestsException
     *         Limit Exceeded Error
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.CreateInputSecurityGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/CreateInputSecurityGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateInputSecurityGroupResponse createInputSecurityGroup(
            CreateInputSecurityGroupRequest createInputSecurityGroupRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, BadGatewayException, GatewayTimeoutException,
            TooManyRequestsException, AwsServiceException, SdkClientException, MediaLiveException {
        throw new UnsupportedOperationException();
    }

    /**
     * Creates a Input Security Group<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateInputSecurityGroupRequest.Builder} avoiding
     * the need to create one manually via {@link CreateInputSecurityGroupRequest#builder()}
     * </p>
     *
     * @param createInputSecurityGroupRequest
     *        A {@link Consumer} that will call methods on {@link CreateInputSecurityGroupRequest.Builder} to create a
     *        request. The IPv4 CIDRs to whitelist for this Input Security Group
     * @return Result of the CreateInputSecurityGroup operation returned by the service.
     * @throws BadRequestException
     *         The request to create an Input Security Group was Invalid
     * @throws InternalServerErrorException
     *         Internal Server Error
     * @throws ForbiddenException
     *         The requester does not have permission to create an Input Security Group
     * @throws BadGatewayException
     *         Bad Gateway Error
     * @throws GatewayTimeoutException
     *         Gateway Timeout Error
     * @throws TooManyRequestsException
     *         Limit Exceeded Error
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.CreateInputSecurityGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/CreateInputSecurityGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateInputSecurityGroupResponse createInputSecurityGroup(
            Consumer<CreateInputSecurityGroupRequest.Builder> createInputSecurityGroupRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, BadGatewayException, GatewayTimeoutException,
            TooManyRequestsException, AwsServiceException, SdkClientException, MediaLiveException {
        return createInputSecurityGroup(CreateInputSecurityGroupRequest.builder().applyMutation(createInputSecurityGroupRequest)
                .build());
    }

    /**
     * Create a new multiplex.
     *
     * @param createMultiplexRequest
     *        A request to create a multiplex.
     * @return Result of the CreateMultiplex operation returned by the service.
     * @throws BadRequestException
     *         MediaLive can't process your request because of a problem in the request. Please check your request form
     *         and syntax.
     * @throws UnprocessableEntityException
     *         The Multiplex failed validation and could not be created.
     * @throws InternalServerErrorException
     *         Unexpected internal service error.
     * @throws ForbiddenException
     *         You don't have permission to create the multiplex.
     * @throws BadGatewayException
     *         Bad Gateway Error.
     * @throws GatewayTimeoutException
     *         Gateway Timeout Error.
     * @throws TooManyRequestsException
     *         Request limit exceeded on create multiplex calls to multiplex service.
     * @throws ConflictException
     *         The multiplex is unable to create due to an issue with multiplex resources.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.CreateMultiplex
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/CreateMultiplex" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateMultiplexResponse createMultiplex(CreateMultiplexRequest createMultiplexRequest) throws BadRequestException,
            UnprocessableEntityException, InternalServerErrorException, ForbiddenException, BadGatewayException,
            GatewayTimeoutException, TooManyRequestsException, ConflictException, AwsServiceException, SdkClientException,
            MediaLiveException {
        throw new UnsupportedOperationException();
    }

    /**
     * Create a new multiplex.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateMultiplexRequest.Builder} avoiding the need
     * to create one manually via {@link CreateMultiplexRequest#builder()}
     * </p>
     *
     * @param createMultiplexRequest
     *        A {@link Consumer} that will call methods on {@link CreateMultiplexRequest.Builder} to create a request. A
     *        request to create a multiplex.
     * @return Result of the CreateMultiplex operation returned by the service.
     * @throws BadRequestException
     *         MediaLive can't process your request because of a problem in the request. Please check your request form
     *         and syntax.
     * @throws UnprocessableEntityException
     *         The Multiplex failed validation and could not be created.
     * @throws InternalServerErrorException
     *         Unexpected internal service error.
     * @throws ForbiddenException
     *         You don't have permission to create the multiplex.
     * @throws BadGatewayException
     *         Bad Gateway Error.
     * @throws GatewayTimeoutException
     *         Gateway Timeout Error.
     * @throws TooManyRequestsException
     *         Request limit exceeded on create multiplex calls to multiplex service.
     * @throws ConflictException
     *         The multiplex is unable to create due to an issue with multiplex resources.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.CreateMultiplex
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/CreateMultiplex" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateMultiplexResponse createMultiplex(Consumer<CreateMultiplexRequest.Builder> createMultiplexRequest)
            throws BadRequestException, UnprocessableEntityException, InternalServerErrorException, ForbiddenException,
            BadGatewayException, GatewayTimeoutException, TooManyRequestsException, ConflictException, AwsServiceException,
            SdkClientException, MediaLiveException {
        return createMultiplex(CreateMultiplexRequest.builder().applyMutation(createMultiplexRequest).build());
    }

    /**
     * Create a new program in the multiplex.
     *
     * @param createMultiplexProgramRequest
     *        A request to create a program in a multiplex.
     * @return Result of the CreateMultiplexProgram operation returned by the service.
     * @throws BadRequestException
     *         MediaLive can't process your request because of a problem in the request. Please check your request form
     *         and syntax.
     * @throws UnprocessableEntityException
     *         The Multiplex program failed validation and could not be created.
     * @throws InternalServerErrorException
     *         Unexpected internal service error.
     * @throws ForbiddenException
     *         You do not have permission to create a program.
     * @throws BadGatewayException
     *         Bad Gateway Error.
     * @throws GatewayTimeoutException
     *         Gateway Timeout Error.
     * @throws TooManyRequestsException
     *         Request limit exceeded on create multiplex program calls to multiplex service.
     * @throws ConflictException
     *         The multiplex program is unable to create due to an issue with multiplex resources.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.CreateMultiplexProgram
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/CreateMultiplexProgram"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateMultiplexProgramResponse createMultiplexProgram(CreateMultiplexProgramRequest createMultiplexProgramRequest)
            throws BadRequestException, UnprocessableEntityException, InternalServerErrorException, ForbiddenException,
            BadGatewayException, GatewayTimeoutException, TooManyRequestsException, ConflictException, AwsServiceException,
            SdkClientException, MediaLiveException {
        throw new UnsupportedOperationException();
    }

    /**
     * Create a new program in the multiplex.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateMultiplexProgramRequest.Builder} avoiding the
     * need to create one manually via {@link CreateMultiplexProgramRequest#builder()}
     * </p>
     *
     * @param createMultiplexProgramRequest
     *        A {@link Consumer} that will call methods on {@link CreateMultiplexProgramRequest.Builder} to create a
     *        request. A request to create a program in a multiplex.
     * @return Result of the CreateMultiplexProgram operation returned by the service.
     * @throws BadRequestException
     *         MediaLive can't process your request because of a problem in the request. Please check your request form
     *         and syntax.
     * @throws UnprocessableEntityException
     *         The Multiplex program failed validation and could not be created.
     * @throws InternalServerErrorException
     *         Unexpected internal service error.
     * @throws ForbiddenException
     *         You do not have permission to create a program.
     * @throws BadGatewayException
     *         Bad Gateway Error.
     * @throws GatewayTimeoutException
     *         Gateway Timeout Error.
     * @throws TooManyRequestsException
     *         Request limit exceeded on create multiplex program calls to multiplex service.
     * @throws ConflictException
     *         The multiplex program is unable to create due to an issue with multiplex resources.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.CreateMultiplexProgram
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/CreateMultiplexProgram"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateMultiplexProgramResponse createMultiplexProgram(
            Consumer<CreateMultiplexProgramRequest.Builder> createMultiplexProgramRequest) throws BadRequestException,
            UnprocessableEntityException, InternalServerErrorException, ForbiddenException, BadGatewayException,
            GatewayTimeoutException, TooManyRequestsException, ConflictException, AwsServiceException, SdkClientException,
            MediaLiveException {
        return createMultiplexProgram(CreateMultiplexProgramRequest.builder().applyMutation(createMultiplexProgramRequest)
                .build());
    }

    /**
     * Create tags for a resource
     *
     * @param createTagsRequest
     *        Placeholder documentation for CreateTagsRequest
     * @return Result of the CreateTags operation returned by the service.
     * @throws NotFoundException
     *         The arn was not found.
     * @throws BadRequestException
     *         This request was invalid
     * @throws InternalServerErrorException
     *         Internal Service Error
     * @throws ForbiddenException
     *         Access was denied
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.CreateTags
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/CreateTags" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateTagsResponse createTags(CreateTagsRequest createTagsRequest) throws NotFoundException, BadRequestException,
            InternalServerErrorException, ForbiddenException, AwsServiceException, SdkClientException, MediaLiveException {
        throw new UnsupportedOperationException();
    }

    /**
     * Create tags for a resource<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateTagsRequest.Builder} avoiding the need to
     * create one manually via {@link CreateTagsRequest#builder()}
     * </p>
     *
     * @param createTagsRequest
     *        A {@link Consumer} that will call methods on {@link CreateTagsRequest.Builder} to create a request.
     *        Placeholder documentation for CreateTagsRequest
     * @return Result of the CreateTags operation returned by the service.
     * @throws NotFoundException
     *         The arn was not found.
     * @throws BadRequestException
     *         This request was invalid
     * @throws InternalServerErrorException
     *         Internal Service Error
     * @throws ForbiddenException
     *         Access was denied
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.CreateTags
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/CreateTags" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateTagsResponse createTags(Consumer<CreateTagsRequest.Builder> createTagsRequest) throws NotFoundException,
            BadRequestException, InternalServerErrorException, ForbiddenException, AwsServiceException, SdkClientException,
            MediaLiveException {
        return createTags(CreateTagsRequest.builder().applyMutation(createTagsRequest).build());
    }

    /**
     * Starts deletion of channel. The associated outputs are also deleted.
     *
     * @param deleteChannelRequest
     *        Placeholder documentation for DeleteChannelRequest
     * @return Result of the DeleteChannel operation returned by the service.
     * @throws BadRequestException
     *         This request was invalid
     * @throws InternalServerErrorException
     *         Unexpected internal service error.
     * @throws ForbiddenException
     *         You do not have permission to delete the channel.
     * @throws BadGatewayException
     *         Bad Gateway Error
     * @throws NotFoundException
     *         The channel you're requesting to delete does not exist.
     * @throws GatewayTimeoutException
     *         Gateway Timeout Error
     * @throws TooManyRequestsException
     *         Request limit exceeded on delete channel calls to channel service.
     * @throws ConflictException
     *         The channel is unable to delete due to an issue with channel resources.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.DeleteChannel
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DeleteChannel" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteChannelResponse deleteChannel(DeleteChannelRequest deleteChannelRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, BadGatewayException, NotFoundException, GatewayTimeoutException,
            TooManyRequestsException, ConflictException, AwsServiceException, SdkClientException, MediaLiveException {
        throw new UnsupportedOperationException();
    }

    /**
     * Starts deletion of channel. The associated outputs are also deleted.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteChannelRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteChannelRequest#builder()}
     * </p>
     *
     * @param deleteChannelRequest
     *        A {@link Consumer} that will call methods on {@link DeleteChannelRequest.Builder} to create a request.
     *        Placeholder documentation for DeleteChannelRequest
     * @return Result of the DeleteChannel operation returned by the service.
     * @throws BadRequestException
     *         This request was invalid
     * @throws InternalServerErrorException
     *         Unexpected internal service error.
     * @throws ForbiddenException
     *         You do not have permission to delete the channel.
     * @throws BadGatewayException
     *         Bad Gateway Error
     * @throws NotFoundException
     *         The channel you're requesting to delete does not exist.
     * @throws GatewayTimeoutException
     *         Gateway Timeout Error
     * @throws TooManyRequestsException
     *         Request limit exceeded on delete channel calls to channel service.
     * @throws ConflictException
     *         The channel is unable to delete due to an issue with channel resources.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.DeleteChannel
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DeleteChannel" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteChannelResponse deleteChannel(Consumer<DeleteChannelRequest.Builder> deleteChannelRequest)
            throws BadRequestException, InternalServerErrorException, ForbiddenException, BadGatewayException, NotFoundException,
            GatewayTimeoutException, TooManyRequestsException, ConflictException, AwsServiceException, SdkClientException,
            MediaLiveException {
        return deleteChannel(DeleteChannelRequest.builder().applyMutation(deleteChannelRequest).build());
    }

    /**
     * Deletes the input end point
     *
     * @param deleteInputRequest
     *        Placeholder documentation for DeleteInputRequest
     * @return Result of the DeleteInput operation returned by the service.
     * @throws BadRequestException
     *         This request was invalid
     * @throws InternalServerErrorException
     *         Internal Service Error
     * @throws ForbiddenException
     *         Access was denied
     * @throws BadGatewayException
     *         Bad Gateway Error
     * @throws NotFoundException
     *         Input not found
     * @throws GatewayTimeoutException
     *         Gateway Timeout Error
     * @throws TooManyRequestsException
     *         Limit exceeded
     * @throws ConflictException
     *         Resource conflict
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.DeleteInput
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DeleteInput" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteInputResponse deleteInput(DeleteInputRequest deleteInputRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, BadGatewayException, NotFoundException, GatewayTimeoutException,
            TooManyRequestsException, ConflictException, AwsServiceException, SdkClientException, MediaLiveException {
        throw new UnsupportedOperationException();
    }

    /**
     * Deletes the input end point<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteInputRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteInputRequest#builder()}
     * </p>
     *
     * @param deleteInputRequest
     *        A {@link Consumer} that will call methods on {@link DeleteInputRequest.Builder} to create a request.
     *        Placeholder documentation for DeleteInputRequest
     * @return Result of the DeleteInput operation returned by the service.
     * @throws BadRequestException
     *         This request was invalid
     * @throws InternalServerErrorException
     *         Internal Service Error
     * @throws ForbiddenException
     *         Access was denied
     * @throws BadGatewayException
     *         Bad Gateway Error
     * @throws NotFoundException
     *         Input not found
     * @throws GatewayTimeoutException
     *         Gateway Timeout Error
     * @throws TooManyRequestsException
     *         Limit exceeded
     * @throws ConflictException
     *         Resource conflict
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.DeleteInput
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DeleteInput" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteInputResponse deleteInput(Consumer<DeleteInputRequest.Builder> deleteInputRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, BadGatewayException, NotFoundException, GatewayTimeoutException,
            TooManyRequestsException, ConflictException, AwsServiceException, SdkClientException, MediaLiveException {
        return deleteInput(DeleteInputRequest.builder().applyMutation(deleteInputRequest).build());
    }

    /**
     * Deletes an Input Security Group
     *
     * @param deleteInputSecurityGroupRequest
     *        Placeholder documentation for DeleteInputSecurityGroupRequest
     * @return Result of the DeleteInputSecurityGroup operation returned by the service.
     * @throws BadRequestException
     *         The request to delete the Input Security Group was Invalid
     * @throws InternalServerErrorException
     *         Internal Server Error
     * @throws ForbiddenException
     *         The requester does not have permission to delete this Input Security Group
     * @throws BadGatewayException
     *         Bad Gateway Error
     * @throws NotFoundException
     *         Input Security Group not found
     * @throws GatewayTimeoutException
     *         Gateway Timeout Error
     * @throws TooManyRequestsException
     *         Limit Exceeded Error
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.DeleteInputSecurityGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DeleteInputSecurityGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteInputSecurityGroupResponse deleteInputSecurityGroup(
            DeleteInputSecurityGroupRequest deleteInputSecurityGroupRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, BadGatewayException, NotFoundException, GatewayTimeoutException,
            TooManyRequestsException, AwsServiceException, SdkClientException, MediaLiveException {
        throw new UnsupportedOperationException();
    }

    /**
     * Deletes an Input Security Group<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteInputSecurityGroupRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteInputSecurityGroupRequest#builder()}
     * </p>
     *
     * @param deleteInputSecurityGroupRequest
     *        A {@link Consumer} that will call methods on {@link DeleteInputSecurityGroupRequest.Builder} to create a
     *        request. Placeholder documentation for DeleteInputSecurityGroupRequest
     * @return Result of the DeleteInputSecurityGroup operation returned by the service.
     * @throws BadRequestException
     *         The request to delete the Input Security Group was Invalid
     * @throws InternalServerErrorException
     *         Internal Server Error
     * @throws ForbiddenException
     *         The requester does not have permission to delete this Input Security Group
     * @throws BadGatewayException
     *         Bad Gateway Error
     * @throws NotFoundException
     *         Input Security Group not found
     * @throws GatewayTimeoutException
     *         Gateway Timeout Error
     * @throws TooManyRequestsException
     *         Limit Exceeded Error
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.DeleteInputSecurityGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DeleteInputSecurityGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteInputSecurityGroupResponse deleteInputSecurityGroup(
            Consumer<DeleteInputSecurityGroupRequest.Builder> deleteInputSecurityGroupRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, BadGatewayException, NotFoundException, GatewayTimeoutException,
            TooManyRequestsException, AwsServiceException, SdkClientException, MediaLiveException {
        return deleteInputSecurityGroup(DeleteInputSecurityGroupRequest.builder().applyMutation(deleteInputSecurityGroupRequest)
                .build());
    }

    /**
     * Delete a multiplex. The multiplex must be idle.
     *
     * @param deleteMultiplexRequest
     *        Placeholder documentation for DeleteMultiplexRequest
     * @return Result of the DeleteMultiplex operation returned by the service.
     * @throws BadRequestException
     *         This request was invalid.
     * @throws InternalServerErrorException
     *         Unexpected internal service error.
     * @throws ForbiddenException
     *         You don't have permission to delete the multiplex.
     * @throws BadGatewayException
     *         Bad Gateway Error.
     * @throws NotFoundException
     *         The multiplex that you are trying to delete doesn’t exist. Check the ID and try again.
     * @throws GatewayTimeoutException
     *         Gateway Timeout Error.
     * @throws TooManyRequestsException
     *         Request limit exceeded on delete multiplex calls to multiplex service.
     * @throws ConflictException
     *         The multiplex is unable to delete due to an issue with multiplex resources.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.DeleteMultiplex
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DeleteMultiplex" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteMultiplexResponse deleteMultiplex(DeleteMultiplexRequest deleteMultiplexRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, BadGatewayException, NotFoundException, GatewayTimeoutException,
            TooManyRequestsException, ConflictException, AwsServiceException, SdkClientException, MediaLiveException {
        throw new UnsupportedOperationException();
    }

    /**
     * Delete a multiplex. The multiplex must be idle.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteMultiplexRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteMultiplexRequest#builder()}
     * </p>
     *
     * @param deleteMultiplexRequest
     *        A {@link Consumer} that will call methods on {@link DeleteMultiplexRequest.Builder} to create a request.
     *        Placeholder documentation for DeleteMultiplexRequest
     * @return Result of the DeleteMultiplex operation returned by the service.
     * @throws BadRequestException
     *         This request was invalid.
     * @throws InternalServerErrorException
     *         Unexpected internal service error.
     * @throws ForbiddenException
     *         You don't have permission to delete the multiplex.
     * @throws BadGatewayException
     *         Bad Gateway Error.
     * @throws NotFoundException
     *         The multiplex that you are trying to delete doesn’t exist. Check the ID and try again.
     * @throws GatewayTimeoutException
     *         Gateway Timeout Error.
     * @throws TooManyRequestsException
     *         Request limit exceeded on delete multiplex calls to multiplex service.
     * @throws ConflictException
     *         The multiplex is unable to delete due to an issue with multiplex resources.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.DeleteMultiplex
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DeleteMultiplex" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteMultiplexResponse deleteMultiplex(Consumer<DeleteMultiplexRequest.Builder> deleteMultiplexRequest)
            throws BadRequestException, InternalServerErrorException, ForbiddenException, BadGatewayException, NotFoundException,
            GatewayTimeoutException, TooManyRequestsException, ConflictException, AwsServiceException, SdkClientException,
            MediaLiveException {
        return deleteMultiplex(DeleteMultiplexRequest.builder().applyMutation(deleteMultiplexRequest).build());
    }

    /**
     * Delete a program from a multiplex.
     *
     * @param deleteMultiplexProgramRequest
     *        Placeholder documentation for DeleteMultiplexProgramRequest
     * @return Result of the DeleteMultiplexProgram operation returned by the service.
     * @throws BadRequestException
     *         This request was invalid.
     * @throws InternalServerErrorException
     *         Unexpected internal service error.
     * @throws ForbiddenException
     *         You don't have permission to delete the multiplex program.
     * @throws BadGatewayException
     *         Bad Gateway Error.
     * @throws NotFoundException
     *         The program that you are trying to delete doesn’t exist. Check the ID and try again.
     * @throws GatewayTimeoutException
     *         Gateway Timeout Error.
     * @throws TooManyRequestsException
     *         Request limit exceeded on delete multiplex program calls to multiplex service.
     * @throws ConflictException
     *         The multiplex program is unable to delete due to an issue with multiplex resources.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.DeleteMultiplexProgram
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DeleteMultiplexProgram"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteMultiplexProgramResponse deleteMultiplexProgram(DeleteMultiplexProgramRequest deleteMultiplexProgramRequest)
            throws BadRequestException, InternalServerErrorException, ForbiddenException, BadGatewayException, NotFoundException,
            GatewayTimeoutException, TooManyRequestsException, ConflictException, AwsServiceException, SdkClientException,
            MediaLiveException {
        throw new UnsupportedOperationException();
    }

    /**
     * Delete a program from a multiplex.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteMultiplexProgramRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteMultiplexProgramRequest#builder()}
     * </p>
     *
     * @param deleteMultiplexProgramRequest
     *        A {@link Consumer} that will call methods on {@link DeleteMultiplexProgramRequest.Builder} to create a
     *        request. Placeholder documentation for DeleteMultiplexProgramRequest
     * @return Result of the DeleteMultiplexProgram operation returned by the service.
     * @throws BadRequestException
     *         This request was invalid.
     * @throws InternalServerErrorException
     *         Unexpected internal service error.
     * @throws ForbiddenException
     *         You don't have permission to delete the multiplex program.
     * @throws BadGatewayException
     *         Bad Gateway Error.
     * @throws NotFoundException
     *         The program that you are trying to delete doesn’t exist. Check the ID and try again.
     * @throws GatewayTimeoutException
     *         Gateway Timeout Error.
     * @throws TooManyRequestsException
     *         Request limit exceeded on delete multiplex program calls to multiplex service.
     * @throws ConflictException
     *         The multiplex program is unable to delete due to an issue with multiplex resources.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.DeleteMultiplexProgram
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DeleteMultiplexProgram"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteMultiplexProgramResponse deleteMultiplexProgram(
            Consumer<DeleteMultiplexProgramRequest.Builder> deleteMultiplexProgramRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, BadGatewayException, NotFoundException, GatewayTimeoutException,
            TooManyRequestsException, ConflictException, AwsServiceException, SdkClientException, MediaLiveException {
        return deleteMultiplexProgram(DeleteMultiplexProgramRequest.builder().applyMutation(deleteMultiplexProgramRequest)
                .build());
    }

    /**
     * Delete an expired reservation.
     *
     * @param deleteReservationRequest
     *        Placeholder documentation for DeleteReservationRequest
     * @return Result of the DeleteReservation operation returned by the service.
     * @throws BadRequestException
     *         This request was invalid
     * @throws InternalServerErrorException
     *         Internal service error
     * @throws ForbiddenException
     *         You do not have permission to delete reservation
     * @throws BadGatewayException
     *         Bad gateway error
     * @throws NotFoundException
     *         Reservation you're attempting to delete does not exist
     * @throws GatewayTimeoutException
     *         Gateway timeout error
     * @throws TooManyRequestsException
     *         Request limit exceeded on delete reservation request
     * @throws ConflictException
     *         The reservation could not be deleted because it is currently active.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.DeleteReservation
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DeleteReservation" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteReservationResponse deleteReservation(DeleteReservationRequest deleteReservationRequest)
            throws BadRequestException, InternalServerErrorException, ForbiddenException, BadGatewayException, NotFoundException,
            GatewayTimeoutException, TooManyRequestsException, ConflictException, AwsServiceException, SdkClientException,
            MediaLiveException {
        throw new UnsupportedOperationException();
    }

    /**
     * Delete an expired reservation.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteReservationRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteReservationRequest#builder()}
     * </p>
     *
     * @param deleteReservationRequest
     *        A {@link Consumer} that will call methods on {@link DeleteReservationRequest.Builder} to create a request.
     *        Placeholder documentation for DeleteReservationRequest
     * @return Result of the DeleteReservation operation returned by the service.
     * @throws BadRequestException
     *         This request was invalid
     * @throws InternalServerErrorException
     *         Internal service error
     * @throws ForbiddenException
     *         You do not have permission to delete reservation
     * @throws BadGatewayException
     *         Bad gateway error
     * @throws NotFoundException
     *         Reservation you're attempting to delete does not exist
     * @throws GatewayTimeoutException
     *         Gateway timeout error
     * @throws TooManyRequestsException
     *         Request limit exceeded on delete reservation request
     * @throws ConflictException
     *         The reservation could not be deleted because it is currently active.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.DeleteReservation
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DeleteReservation" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteReservationResponse deleteReservation(Consumer<DeleteReservationRequest.Builder> deleteReservationRequest)
            throws BadRequestException, InternalServerErrorException, ForbiddenException, BadGatewayException, NotFoundException,
            GatewayTimeoutException, TooManyRequestsException, ConflictException, AwsServiceException, SdkClientException,
            MediaLiveException {
        return deleteReservation(DeleteReservationRequest.builder().applyMutation(deleteReservationRequest).build());
    }

    /**
     * Delete all schedule actions on a channel.
     *
     * @param deleteScheduleRequest
     *        Placeholder documentation for DeleteScheduleRequest
     * @return Result of the DeleteSchedule operation returned by the service.
     * @throws BadRequestException
     *         This request to delete the schedule on this channel was invalid.
     * @throws InternalServerErrorException
     *         Unexpected internal service error.
     * @throws ForbiddenException
     *         You do not have permission to delete the channel schedule.
     * @throws BadGatewayException
     *         Bad Gateway Error
     * @throws NotFoundException
     *         The specified channel does not exist to have its schedule deleted.
     * @throws GatewayTimeoutException
     *         Gateway Timeout Error
     * @throws TooManyRequestsException
     *         Request limit exceeded on delete schedule calls.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.DeleteSchedule
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DeleteSchedule" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteScheduleResponse deleteSchedule(DeleteScheduleRequest deleteScheduleRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, BadGatewayException, NotFoundException, GatewayTimeoutException,
            TooManyRequestsException, AwsServiceException, SdkClientException, MediaLiveException {
        throw new UnsupportedOperationException();
    }

    /**
     * Delete all schedule actions on a channel.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteScheduleRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteScheduleRequest#builder()}
     * </p>
     *
     * @param deleteScheduleRequest
     *        A {@link Consumer} that will call methods on {@link DeleteScheduleRequest.Builder} to create a request.
     *        Placeholder documentation for DeleteScheduleRequest
     * @return Result of the DeleteSchedule operation returned by the service.
     * @throws BadRequestException
     *         This request to delete the schedule on this channel was invalid.
     * @throws InternalServerErrorException
     *         Unexpected internal service error.
     * @throws ForbiddenException
     *         You do not have permission to delete the channel schedule.
     * @throws BadGatewayException
     *         Bad Gateway Error
     * @throws NotFoundException
     *         The specified channel does not exist to have its schedule deleted.
     * @throws GatewayTimeoutException
     *         Gateway Timeout Error
     * @throws TooManyRequestsException
     *         Request limit exceeded on delete schedule calls.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.DeleteSchedule
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DeleteSchedule" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteScheduleResponse deleteSchedule(Consumer<DeleteScheduleRequest.Builder> deleteScheduleRequest)
            throws BadRequestException, InternalServerErrorException, ForbiddenException, BadGatewayException, NotFoundException,
            GatewayTimeoutException, TooManyRequestsException, AwsServiceException, SdkClientException, MediaLiveException {
        return deleteSchedule(DeleteScheduleRequest.builder().applyMutation(deleteScheduleRequest).build());
    }

    /**
     * Removes tags for a resource
     *
     * @param deleteTagsRequest
     *        Placeholder documentation for DeleteTagsRequest
     * @return Result of the DeleteTags operation returned by the service.
     * @throws NotFoundException
     *         The arn was not found.
     * @throws BadRequestException
     *         This request was invalid
     * @throws InternalServerErrorException
     *         Internal Service Error
     * @throws ForbiddenException
     *         Access was denied
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.DeleteTags
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DeleteTags" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteTagsResponse deleteTags(DeleteTagsRequest deleteTagsRequest) throws NotFoundException, BadRequestException,
            InternalServerErrorException, ForbiddenException, AwsServiceException, SdkClientException, MediaLiveException {
        throw new UnsupportedOperationException();
    }

    /**
     * Removes tags for a resource<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteTagsRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteTagsRequest#builder()}
     * </p>
     *
     * @param deleteTagsRequest
     *        A {@link Consumer} that will call methods on {@link DeleteTagsRequest.Builder} to create a request.
     *        Placeholder documentation for DeleteTagsRequest
     * @return Result of the DeleteTags operation returned by the service.
     * @throws NotFoundException
     *         The arn was not found.
     * @throws BadRequestException
     *         This request was invalid
     * @throws InternalServerErrorException
     *         Internal Service Error
     * @throws ForbiddenException
     *         Access was denied
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.DeleteTags
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DeleteTags" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteTagsResponse deleteTags(Consumer<DeleteTagsRequest.Builder> deleteTagsRequest) throws NotFoundException,
            BadRequestException, InternalServerErrorException, ForbiddenException, AwsServiceException, SdkClientException,
            MediaLiveException {
        return deleteTags(DeleteTagsRequest.builder().applyMutation(deleteTagsRequest).build());
    }

    /**
     * Gets details about a channel
     *
     * @param describeChannelRequest
     *        Placeholder documentation for DescribeChannelRequest
     * @return Result of the DescribeChannel operation returned by the service.
     * @throws BadRequestException
     *         This request was invalid
     * @throws InternalServerErrorException
     *         Unexpected internal service error.
     * @throws ForbiddenException
     *         You do not have permission to describe the channel.
     * @throws BadGatewayException
     *         Bad Gateway Error
     * @throws NotFoundException
     *         The channel you're requesting to describe does not exist.
     * @throws GatewayTimeoutException
     *         Gateway Timeout Error
     * @throws TooManyRequestsException
     *         Request limit exceeded on describe channel calls to channel service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.DescribeChannel
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DescribeChannel" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeChannelResponse describeChannel(DescribeChannelRequest describeChannelRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, BadGatewayException, NotFoundException, GatewayTimeoutException,
            TooManyRequestsException, AwsServiceException, SdkClientException, MediaLiveException {
        throw new UnsupportedOperationException();
    }

    /**
     * Gets details about a channel<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeChannelRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeChannelRequest#builder()}
     * </p>
     *
     * @param describeChannelRequest
     *        A {@link Consumer} that will call methods on {@link DescribeChannelRequest.Builder} to create a request.
     *        Placeholder documentation for DescribeChannelRequest
     * @return Result of the DescribeChannel operation returned by the service.
     * @throws BadRequestException
     *         This request was invalid
     * @throws InternalServerErrorException
     *         Unexpected internal service error.
     * @throws ForbiddenException
     *         You do not have permission to describe the channel.
     * @throws BadGatewayException
     *         Bad Gateway Error
     * @throws NotFoundException
     *         The channel you're requesting to describe does not exist.
     * @throws GatewayTimeoutException
     *         Gateway Timeout Error
     * @throws TooManyRequestsException
     *         Request limit exceeded on describe channel calls to channel service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.DescribeChannel
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DescribeChannel" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeChannelResponse describeChannel(Consumer<DescribeChannelRequest.Builder> describeChannelRequest)
            throws BadRequestException, InternalServerErrorException, ForbiddenException, BadGatewayException, NotFoundException,
            GatewayTimeoutException, TooManyRequestsException, AwsServiceException, SdkClientException, MediaLiveException {
        return describeChannel(DescribeChannelRequest.builder().applyMutation(describeChannelRequest).build());
    }

    /**
     * Produces details about an input
     *
     * @param describeInputRequest
     *        Placeholder documentation for DescribeInputRequest
     * @return Result of the DescribeInput operation returned by the service.
     * @throws BadRequestException
     *         This request was invalid
     * @throws InternalServerErrorException
     *         Internal Service Error
     * @throws ForbiddenException
     *         Access was denied
     * @throws BadGatewayException
     *         Bad Gateway Error
     * @throws NotFoundException
     *         Input not found
     * @throws GatewayTimeoutException
     *         Gateway Timeout Error
     * @throws TooManyRequestsException
     *         Limit exceeded
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.DescribeInput
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DescribeInput" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeInputResponse describeInput(DescribeInputRequest describeInputRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, BadGatewayException, NotFoundException, GatewayTimeoutException,
            TooManyRequestsException, AwsServiceException, SdkClientException, MediaLiveException {
        throw new UnsupportedOperationException();
    }

    /**
     * Produces details about an input<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeInputRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeInputRequest#builder()}
     * </p>
     *
     * @param describeInputRequest
     *        A {@link Consumer} that will call methods on {@link DescribeInputRequest.Builder} to create a request.
     *        Placeholder documentation for DescribeInputRequest
     * @return Result of the DescribeInput operation returned by the service.
     * @throws BadRequestException
     *         This request was invalid
     * @throws InternalServerErrorException
     *         Internal Service Error
     * @throws ForbiddenException
     *         Access was denied
     * @throws BadGatewayException
     *         Bad Gateway Error
     * @throws NotFoundException
     *         Input not found
     * @throws GatewayTimeoutException
     *         Gateway Timeout Error
     * @throws TooManyRequestsException
     *         Limit exceeded
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.DescribeInput
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DescribeInput" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeInputResponse describeInput(Consumer<DescribeInputRequest.Builder> describeInputRequest)
            throws BadRequestException, InternalServerErrorException, ForbiddenException, BadGatewayException, NotFoundException,
            GatewayTimeoutException, TooManyRequestsException, AwsServiceException, SdkClientException, MediaLiveException {
        return describeInput(DescribeInputRequest.builder().applyMutation(describeInputRequest).build());
    }

    /**
     * Gets the details for the input device
     *
     * @param describeInputDeviceRequest
     *        Placeholder documentation for DescribeInputDeviceRequest
     * @return Result of the DescribeInputDevice operation returned by the service.
     * @throws BadRequestException
     *         This request was invalid.
     * @throws InternalServerErrorException
     *         Unexpected internal service error.
     * @throws ForbiddenException
     *         You do not have permission to describe the input device.
     * @throws BadGatewayException
     *         Bad gateway error.
     * @throws NotFoundException
     *         The input device you're requesting to describe does not exist. Check the ID.
     * @throws GatewayTimeoutException
     *         Gateway timeout error.
     * @throws TooManyRequestsException
     *         Request limit exceeded on describe calls to the input device service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.DescribeInputDevice
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DescribeInputDevice" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeInputDeviceResponse describeInputDevice(DescribeInputDeviceRequest describeInputDeviceRequest)
            throws BadRequestException, InternalServerErrorException, ForbiddenException, BadGatewayException, NotFoundException,
            GatewayTimeoutException, TooManyRequestsException, AwsServiceException, SdkClientException, MediaLiveException {
        throw new UnsupportedOperationException();
    }

    /**
     * Gets the details for the input device<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeInputDeviceRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeInputDeviceRequest#builder()}
     * </p>
     *
     * @param describeInputDeviceRequest
     *        A {@link Consumer} that will call methods on {@link DescribeInputDeviceRequest.Builder} to create a
     *        request. Placeholder documentation for DescribeInputDeviceRequest
     * @return Result of the DescribeInputDevice operation returned by the service.
     * @throws BadRequestException
     *         This request was invalid.
     * @throws InternalServerErrorException
     *         Unexpected internal service error.
     * @throws ForbiddenException
     *         You do not have permission to describe the input device.
     * @throws BadGatewayException
     *         Bad gateway error.
     * @throws NotFoundException
     *         The input device you're requesting to describe does not exist. Check the ID.
     * @throws GatewayTimeoutException
     *         Gateway timeout error.
     * @throws TooManyRequestsException
     *         Request limit exceeded on describe calls to the input device service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.DescribeInputDevice
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DescribeInputDevice" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeInputDeviceResponse describeInputDevice(
            Consumer<DescribeInputDeviceRequest.Builder> describeInputDeviceRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, BadGatewayException, NotFoundException, GatewayTimeoutException,
            TooManyRequestsException, AwsServiceException, SdkClientException, MediaLiveException {
        return describeInputDevice(DescribeInputDeviceRequest.builder().applyMutation(describeInputDeviceRequest).build());
    }

    /**
     * Produces a summary of an Input Security Group
     *
     * @param describeInputSecurityGroupRequest
     *        Placeholder documentation for DescribeInputSecurityGroupRequest
     * @return Result of the DescribeInputSecurityGroup operation returned by the service.
     * @throws BadRequestException
     *         The request to describe an Input Security Group was Invalid
     * @throws InternalServerErrorException
     *         Internal Server Error
     * @throws ForbiddenException
     *         The requester does not have permission to describe this Input Security Group
     * @throws BadGatewayException
     *         Bad Gateway Error
     * @throws NotFoundException
     *         Input Security Group not found
     * @throws GatewayTimeoutException
     *         Gateway Timeout Error
     * @throws TooManyRequestsException
     *         Limit Exceeded Error
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.DescribeInputSecurityGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DescribeInputSecurityGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeInputSecurityGroupResponse describeInputSecurityGroup(
            DescribeInputSecurityGroupRequest describeInputSecurityGroupRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, BadGatewayException, NotFoundException, GatewayTimeoutException,
            TooManyRequestsException, AwsServiceException, SdkClientException, MediaLiveException {
        throw new UnsupportedOperationException();
    }

    /**
     * Produces a summary of an Input Security Group<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeInputSecurityGroupRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeInputSecurityGroupRequest#builder()}
     * </p>
     *
     * @param describeInputSecurityGroupRequest
     *        A {@link Consumer} that will call methods on {@link DescribeInputSecurityGroupRequest.Builder} to create a
     *        request. Placeholder documentation for DescribeInputSecurityGroupRequest
     * @return Result of the DescribeInputSecurityGroup operation returned by the service.
     * @throws BadRequestException
     *         The request to describe an Input Security Group was Invalid
     * @throws InternalServerErrorException
     *         Internal Server Error
     * @throws ForbiddenException
     *         The requester does not have permission to describe this Input Security Group
     * @throws BadGatewayException
     *         Bad Gateway Error
     * @throws NotFoundException
     *         Input Security Group not found
     * @throws GatewayTimeoutException
     *         Gateway Timeout Error
     * @throws TooManyRequestsException
     *         Limit Exceeded Error
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.DescribeInputSecurityGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DescribeInputSecurityGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeInputSecurityGroupResponse describeInputSecurityGroup(
            Consumer<DescribeInputSecurityGroupRequest.Builder> describeInputSecurityGroupRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, BadGatewayException, NotFoundException, GatewayTimeoutException,
            TooManyRequestsException, AwsServiceException, SdkClientException, MediaLiveException {
        return describeInputSecurityGroup(DescribeInputSecurityGroupRequest.builder()
                .applyMutation(describeInputSecurityGroupRequest).build());
    }

    /**
     * Gets details about a multiplex.
     *
     * @param describeMultiplexRequest
     *        Placeholder documentation for DescribeMultiplexRequest
     * @return Result of the DescribeMultiplex operation returned by the service.
     * @throws BadRequestException
     *         This request was invalid.
     * @throws InternalServerErrorException
     *         Unexpected internal service error.
     * @throws ForbiddenException
     *         You don't have permission to describe the multiplex.
     * @throws BadGatewayException
     *         Bad Gateway Error.
     * @throws NotFoundException
     *         The multiplex that you are trying to describe doesn’t exist. Check the ID and try again.
     * @throws GatewayTimeoutException
     *         Gateway Timeout Error.
     * @throws TooManyRequestsException
     *         Request limit exceeded on describe multiplex calls to multiplex service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.DescribeMultiplex
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DescribeMultiplex" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeMultiplexResponse describeMultiplex(DescribeMultiplexRequest describeMultiplexRequest)
            throws BadRequestException, InternalServerErrorException, ForbiddenException, BadGatewayException, NotFoundException,
            GatewayTimeoutException, TooManyRequestsException, AwsServiceException, SdkClientException, MediaLiveException {
        throw new UnsupportedOperationException();
    }

    /**
     * Gets details about a multiplex.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeMultiplexRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeMultiplexRequest#builder()}
     * </p>
     *
     * @param describeMultiplexRequest
     *        A {@link Consumer} that will call methods on {@link DescribeMultiplexRequest.Builder} to create a request.
     *        Placeholder documentation for DescribeMultiplexRequest
     * @return Result of the DescribeMultiplex operation returned by the service.
     * @throws BadRequestException
     *         This request was invalid.
     * @throws InternalServerErrorException
     *         Unexpected internal service error.
     * @throws ForbiddenException
     *         You don't have permission to describe the multiplex.
     * @throws BadGatewayException
     *         Bad Gateway Error.
     * @throws NotFoundException
     *         The multiplex that you are trying to describe doesn’t exist. Check the ID and try again.
     * @throws GatewayTimeoutException
     *         Gateway Timeout Error.
     * @throws TooManyRequestsException
     *         Request limit exceeded on describe multiplex calls to multiplex service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.DescribeMultiplex
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DescribeMultiplex" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeMultiplexResponse describeMultiplex(Consumer<DescribeMultiplexRequest.Builder> describeMultiplexRequest)
            throws BadRequestException, InternalServerErrorException, ForbiddenException, BadGatewayException, NotFoundException,
            GatewayTimeoutException, TooManyRequestsException, AwsServiceException, SdkClientException, MediaLiveException {
        return describeMultiplex(DescribeMultiplexRequest.builder().applyMutation(describeMultiplexRequest).build());
    }

    /**
     * Get the details for a program in a multiplex.
     *
     * @param describeMultiplexProgramRequest
     *        Placeholder documentation for DescribeMultiplexProgramRequest
     * @return Result of the DescribeMultiplexProgram operation returned by the service.
     * @throws BadRequestException
     *         This request was invalid.
     * @throws InternalServerErrorException
     *         Unexpected internal service error.
     * @throws ForbiddenException
     *         You don't have permission to describe the multiplex program.
     * @throws BadGatewayException
     *         Bad Gateway Error.
     * @throws NotFoundException
     *         MediaLive can't describe the program. The multiplex or the program that you specified doesn’t exist.
     *         Check the IDs and try again.
     * @throws GatewayTimeoutException
     *         Gateway Timeout Error.
     * @throws TooManyRequestsException
     *         Request limit exceeded on describe multiplex program calls to multiplex service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.DescribeMultiplexProgram
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DescribeMultiplexProgram"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeMultiplexProgramResponse describeMultiplexProgram(
            DescribeMultiplexProgramRequest describeMultiplexProgramRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, BadGatewayException, NotFoundException, GatewayTimeoutException,
            TooManyRequestsException, AwsServiceException, SdkClientException, MediaLiveException {
        throw new UnsupportedOperationException();
    }

    /**
     * Get the details for a program in a multiplex.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeMultiplexProgramRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeMultiplexProgramRequest#builder()}
     * </p>
     *
     * @param describeMultiplexProgramRequest
     *        A {@link Consumer} that will call methods on {@link DescribeMultiplexProgramRequest.Builder} to create a
     *        request. Placeholder documentation for DescribeMultiplexProgramRequest
     * @return Result of the DescribeMultiplexProgram operation returned by the service.
     * @throws BadRequestException
     *         This request was invalid.
     * @throws InternalServerErrorException
     *         Unexpected internal service error.
     * @throws ForbiddenException
     *         You don't have permission to describe the multiplex program.
     * @throws BadGatewayException
     *         Bad Gateway Error.
     * @throws NotFoundException
     *         MediaLive can't describe the program. The multiplex or the program that you specified doesn’t exist.
     *         Check the IDs and try again.
     * @throws GatewayTimeoutException
     *         Gateway Timeout Error.
     * @throws TooManyRequestsException
     *         Request limit exceeded on describe multiplex program calls to multiplex service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.DescribeMultiplexProgram
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DescribeMultiplexProgram"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeMultiplexProgramResponse describeMultiplexProgram(
            Consumer<DescribeMultiplexProgramRequest.Builder> describeMultiplexProgramRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, BadGatewayException, NotFoundException, GatewayTimeoutException,
            TooManyRequestsException, AwsServiceException, SdkClientException, MediaLiveException {
        return describeMultiplexProgram(DescribeMultiplexProgramRequest.builder().applyMutation(describeMultiplexProgramRequest)
                .build());
    }

    /**
     * Get details for an offering.
     *
     * @param describeOfferingRequest
     *        Placeholder documentation for DescribeOfferingRequest
     * @return Result of the DescribeOffering operation returned by the service.
     * @throws BadRequestException
     *         This request was invalid
     * @throws InternalServerErrorException
     *         Internal service error
     * @throws ForbiddenException
     *         You do not have permission to describe offering
     * @throws BadGatewayException
     *         Bad gateway error
     * @throws NotFoundException
     *         Offering you're attempting to describe does not exist
     * @throws GatewayTimeoutException
     *         Gateway timeout error
     * @throws TooManyRequestsException
     *         Request limit exceeded on describe offering request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.DescribeOffering
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DescribeOffering" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeOfferingResponse describeOffering(DescribeOfferingRequest describeOfferingRequest)
            throws BadRequestException, InternalServerErrorException, ForbiddenException, BadGatewayException, NotFoundException,
            GatewayTimeoutException, TooManyRequestsException, AwsServiceException, SdkClientException, MediaLiveException {
        throw new UnsupportedOperationException();
    }

    /**
     * Get details for an offering.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeOfferingRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeOfferingRequest#builder()}
     * </p>
     *
     * @param describeOfferingRequest
     *        A {@link Consumer} that will call methods on {@link DescribeOfferingRequest.Builder} to create a request.
     *        Placeholder documentation for DescribeOfferingRequest
     * @return Result of the DescribeOffering operation returned by the service.
     * @throws BadRequestException
     *         This request was invalid
     * @throws InternalServerErrorException
     *         Internal service error
     * @throws ForbiddenException
     *         You do not have permission to describe offering
     * @throws BadGatewayException
     *         Bad gateway error
     * @throws NotFoundException
     *         Offering you're attempting to describe does not exist
     * @throws GatewayTimeoutException
     *         Gateway timeout error
     * @throws TooManyRequestsException
     *         Request limit exceeded on describe offering request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.DescribeOffering
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DescribeOffering" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeOfferingResponse describeOffering(Consumer<DescribeOfferingRequest.Builder> describeOfferingRequest)
            throws BadRequestException, InternalServerErrorException, ForbiddenException, BadGatewayException, NotFoundException,
            GatewayTimeoutException, TooManyRequestsException, AwsServiceException, SdkClientException, MediaLiveException {
        return describeOffering(DescribeOfferingRequest.builder().applyMutation(describeOfferingRequest).build());
    }

    /**
     * Get details for a reservation.
     *
     * @param describeReservationRequest
     *        Placeholder documentation for DescribeReservationRequest
     * @return Result of the DescribeReservation operation returned by the service.
     * @throws BadRequestException
     *         This request was invalid
     * @throws InternalServerErrorException
     *         Internal service error
     * @throws ForbiddenException
     *         You do not have permission to describe reservation
     * @throws BadGatewayException
     *         Bad gateway error
     * @throws NotFoundException
     *         Reservation you're attempting to describe does not exist
     * @throws GatewayTimeoutException
     *         Gateway timeout error
     * @throws TooManyRequestsException
     *         Request limit exceeded on describe reservation request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.DescribeReservation
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DescribeReservation" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeReservationResponse describeReservation(DescribeReservationRequest describeReservationRequest)
            throws BadRequestException, InternalServerErrorException, ForbiddenException, BadGatewayException, NotFoundException,
            GatewayTimeoutException, TooManyRequestsException, AwsServiceException, SdkClientException, MediaLiveException {
        throw new UnsupportedOperationException();
    }

    /**
     * Get details for a reservation.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeReservationRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeReservationRequest#builder()}
     * </p>
     *
     * @param describeReservationRequest
     *        A {@link Consumer} that will call methods on {@link DescribeReservationRequest.Builder} to create a
     *        request. Placeholder documentation for DescribeReservationRequest
     * @return Result of the DescribeReservation operation returned by the service.
     * @throws BadRequestException
     *         This request was invalid
     * @throws InternalServerErrorException
     *         Internal service error
     * @throws ForbiddenException
     *         You do not have permission to describe reservation
     * @throws BadGatewayException
     *         Bad gateway error
     * @throws NotFoundException
     *         Reservation you're attempting to describe does not exist
     * @throws GatewayTimeoutException
     *         Gateway timeout error
     * @throws TooManyRequestsException
     *         Request limit exceeded on describe reservation request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.DescribeReservation
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DescribeReservation" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeReservationResponse describeReservation(
            Consumer<DescribeReservationRequest.Builder> describeReservationRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, BadGatewayException, NotFoundException, GatewayTimeoutException,
            TooManyRequestsException, AwsServiceException, SdkClientException, MediaLiveException {
        return describeReservation(DescribeReservationRequest.builder().applyMutation(describeReservationRequest).build());
    }

    /**
     * Get a channel schedule
     *
     * @param describeScheduleRequest
     *        Placeholder documentation for DescribeScheduleRequest
     * @return Result of the DescribeSchedule operation returned by the service.
     * @throws BadRequestException
     *         This request was invalid.
     * @throws InternalServerErrorException
     *         Unexpected internal service error.
     * @throws ForbiddenException
     *         You do not have permission to describe the channel schedule.
     * @throws BadGatewayException
     *         Bad Gateway Error
     * @throws NotFoundException
     *         The channel you're requesting a schedule describe for does not exist.
     * @throws GatewayTimeoutException
     *         Gateway Timeout Error
     * @throws TooManyRequestsException
     *         Request limit exceeded on describe schedule calls.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.DescribeSchedule
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DescribeSchedule" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeScheduleResponse describeSchedule(DescribeScheduleRequest describeScheduleRequest)
            throws BadRequestException, InternalServerErrorException, ForbiddenException, BadGatewayException, NotFoundException,
            GatewayTimeoutException, TooManyRequestsException, AwsServiceException, SdkClientException, MediaLiveException {
        throw new UnsupportedOperationException();
    }

    /**
     * Get a channel schedule<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeScheduleRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeScheduleRequest#builder()}
     * </p>
     *
     * @param describeScheduleRequest
     *        A {@link Consumer} that will call methods on {@link DescribeScheduleRequest.Builder} to create a request.
     *        Placeholder documentation for DescribeScheduleRequest
     * @return Result of the DescribeSchedule operation returned by the service.
     * @throws BadRequestException
     *         This request was invalid.
     * @throws InternalServerErrorException
     *         Unexpected internal service error.
     * @throws ForbiddenException
     *         You do not have permission to describe the channel schedule.
     * @throws BadGatewayException
     *         Bad Gateway Error
     * @throws NotFoundException
     *         The channel you're requesting a schedule describe for does not exist.
     * @throws GatewayTimeoutException
     *         Gateway Timeout Error
     * @throws TooManyRequestsException
     *         Request limit exceeded on describe schedule calls.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.DescribeSchedule
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DescribeSchedule" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeScheduleResponse describeSchedule(Consumer<DescribeScheduleRequest.Builder> describeScheduleRequest)
            throws BadRequestException, InternalServerErrorException, ForbiddenException, BadGatewayException, NotFoundException,
            GatewayTimeoutException, TooManyRequestsException, AwsServiceException, SdkClientException, MediaLiveException {
        return describeSchedule(DescribeScheduleRequest.builder().applyMutation(describeScheduleRequest).build());
    }

    /**
     * Get a channel schedule<br/>
     * <p>
     * This is a variant of
     * {@link #describeSchedule(software.amazon.awssdk.services.medialive.model.DescribeScheduleRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.medialive.paginators.DescribeScheduleIterable responses = client.describeSchedulePaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.medialive.paginators.DescribeScheduleIterable responses = client
     *             .describeSchedulePaginator(request);
     *     for (software.amazon.awssdk.services.medialive.model.DescribeScheduleResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.medialive.paginators.DescribeScheduleIterable responses = client.describeSchedulePaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeSchedule(software.amazon.awssdk.services.medialive.model.DescribeScheduleRequest)} operation.</b>
     * </p>
     *
     * @param describeScheduleRequest
     *        Placeholder documentation for DescribeScheduleRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws BadRequestException
     *         This request was invalid.
     * @throws InternalServerErrorException
     *         Unexpected internal service error.
     * @throws ForbiddenException
     *         You do not have permission to describe the channel schedule.
     * @throws BadGatewayException
     *         Bad Gateway Error
     * @throws NotFoundException
     *         The channel you're requesting a schedule describe for does not exist.
     * @throws GatewayTimeoutException
     *         Gateway Timeout Error
     * @throws TooManyRequestsException
     *         Request limit exceeded on describe schedule calls.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.DescribeSchedule
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DescribeSchedule" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeScheduleIterable describeSchedulePaginator(DescribeScheduleRequest describeScheduleRequest)
            throws BadRequestException, InternalServerErrorException, ForbiddenException, BadGatewayException, NotFoundException,
            GatewayTimeoutException, TooManyRequestsException, AwsServiceException, SdkClientException, MediaLiveException {
        throw new UnsupportedOperationException();
    }

    /**
     * Get a channel schedule<br/>
     * <p>
     * This is a variant of
     * {@link #describeSchedule(software.amazon.awssdk.services.medialive.model.DescribeScheduleRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.medialive.paginators.DescribeScheduleIterable responses = client.describeSchedulePaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.medialive.paginators.DescribeScheduleIterable responses = client
     *             .describeSchedulePaginator(request);
     *     for (software.amazon.awssdk.services.medialive.model.DescribeScheduleResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.medialive.paginators.DescribeScheduleIterable responses = client.describeSchedulePaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeSchedule(software.amazon.awssdk.services.medialive.model.DescribeScheduleRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeScheduleRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeScheduleRequest#builder()}
     * </p>
     *
     * @param describeScheduleRequest
     *        A {@link Consumer} that will call methods on {@link DescribeScheduleRequest.Builder} to create a request.
     *        Placeholder documentation for DescribeScheduleRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws BadRequestException
     *         This request was invalid.
     * @throws InternalServerErrorException
     *         Unexpected internal service error.
     * @throws ForbiddenException
     *         You do not have permission to describe the channel schedule.
     * @throws BadGatewayException
     *         Bad Gateway Error
     * @throws NotFoundException
     *         The channel you're requesting a schedule describe for does not exist.
     * @throws GatewayTimeoutException
     *         Gateway Timeout Error
     * @throws TooManyRequestsException
     *         Request limit exceeded on describe schedule calls.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.DescribeSchedule
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DescribeSchedule" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeScheduleIterable describeSchedulePaginator(Consumer<DescribeScheduleRequest.Builder> describeScheduleRequest)
            throws BadRequestException, InternalServerErrorException, ForbiddenException, BadGatewayException, NotFoundException,
            GatewayTimeoutException, TooManyRequestsException, AwsServiceException, SdkClientException, MediaLiveException {
        return describeSchedulePaginator(DescribeScheduleRequest.builder().applyMutation(describeScheduleRequest).build());
    }

    /**
     * Produces list of channels that have been created
     *
     * @return Result of the ListChannels operation returned by the service.
     * @throws BadRequestException
     *         This request was invalid.
     * @throws InternalServerErrorException
     *         Unexpected internal service error.
     * @throws ForbiddenException
     *         You do not have permission to list channels.
     * @throws BadGatewayException
     *         Bad Gateway Error
     * @throws GatewayTimeoutException
     *         Gateway Timeout Error
     * @throws TooManyRequestsException
     *         Request limit exceeded on list channel calls to channel service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.ListChannels
     * @see #listChannels(ListChannelsRequest)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListChannels" target="_top">AWS API
     *      Documentation</a>
     */
    default ListChannelsResponse listChannels() throws BadRequestException, InternalServerErrorException, ForbiddenException,
            BadGatewayException, GatewayTimeoutException, TooManyRequestsException, AwsServiceException, SdkClientException,
            MediaLiveException {
        return listChannels(ListChannelsRequest.builder().build());
    }

    /**
     * Produces list of channels that have been created
     *
     * @param listChannelsRequest
     *        Placeholder documentation for ListChannelsRequest
     * @return Result of the ListChannels operation returned by the service.
     * @throws BadRequestException
     *         This request was invalid.
     * @throws InternalServerErrorException
     *         Unexpected internal service error.
     * @throws ForbiddenException
     *         You do not have permission to list channels.
     * @throws BadGatewayException
     *         Bad Gateway Error
     * @throws GatewayTimeoutException
     *         Gateway Timeout Error
     * @throws TooManyRequestsException
     *         Request limit exceeded on list channel calls to channel service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.ListChannels
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListChannels" target="_top">AWS API
     *      Documentation</a>
     */
    default ListChannelsResponse listChannels(ListChannelsRequest listChannelsRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, BadGatewayException, GatewayTimeoutException,
            TooManyRequestsException, AwsServiceException, SdkClientException, MediaLiveException {
        throw new UnsupportedOperationException();
    }

    /**
     * Produces list of channels that have been created<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListChannelsRequest.Builder} avoiding the need to
     * create one manually via {@link ListChannelsRequest#builder()}
     * </p>
     *
     * @param listChannelsRequest
     *        A {@link Consumer} that will call methods on {@link ListChannelsRequest.Builder} to create a request.
     *        Placeholder documentation for ListChannelsRequest
     * @return Result of the ListChannels operation returned by the service.
     * @throws BadRequestException
     *         This request was invalid.
     * @throws InternalServerErrorException
     *         Unexpected internal service error.
     * @throws ForbiddenException
     *         You do not have permission to list channels.
     * @throws BadGatewayException
     *         Bad Gateway Error
     * @throws GatewayTimeoutException
     *         Gateway Timeout Error
     * @throws TooManyRequestsException
     *         Request limit exceeded on list channel calls to channel service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.ListChannels
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListChannels" target="_top">AWS API
     *      Documentation</a>
     */
    default ListChannelsResponse listChannels(Consumer<ListChannelsRequest.Builder> listChannelsRequest)
            throws BadRequestException, InternalServerErrorException, ForbiddenException, BadGatewayException,
            GatewayTimeoutException, TooManyRequestsException, AwsServiceException, SdkClientException, MediaLiveException {
        return listChannels(ListChannelsRequest.builder().applyMutation(listChannelsRequest).build());
    }

    /**
     * Produces list of channels that have been created<br/>
     * <p>
     * This is a variant of {@link #listChannels(software.amazon.awssdk.services.medialive.model.ListChannelsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.medialive.paginators.ListChannelsIterable responses = client.listChannelsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.medialive.paginators.ListChannelsIterable responses = client.listChannelsPaginator(request);
     *     for (software.amazon.awssdk.services.medialive.model.ListChannelsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.medialive.paginators.ListChannelsIterable responses = client.listChannelsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listChannels(software.amazon.awssdk.services.medialive.model.ListChannelsRequest)} operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws BadRequestException
     *         This request was invalid.
     * @throws InternalServerErrorException
     *         Unexpected internal service error.
     * @throws ForbiddenException
     *         You do not have permission to list channels.
     * @throws BadGatewayException
     *         Bad Gateway Error
     * @throws GatewayTimeoutException
     *         Gateway Timeout Error
     * @throws TooManyRequestsException
     *         Request limit exceeded on list channel calls to channel service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.ListChannels
     * @see #listChannelsPaginator(ListChannelsRequest)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListChannels" target="_top">AWS API
     *      Documentation</a>
     */
    default ListChannelsIterable listChannelsPaginator() throws BadRequestException, InternalServerErrorException,
            ForbiddenException, BadGatewayException, GatewayTimeoutException, TooManyRequestsException, AwsServiceException,
            SdkClientException, MediaLiveException {
        return listChannelsPaginator(ListChannelsRequest.builder().build());
    }

    /**
     * Produces list of channels that have been created<br/>
     * <p>
     * This is a variant of {@link #listChannels(software.amazon.awssdk.services.medialive.model.ListChannelsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.medialive.paginators.ListChannelsIterable responses = client.listChannelsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.medialive.paginators.ListChannelsIterable responses = client.listChannelsPaginator(request);
     *     for (software.amazon.awssdk.services.medialive.model.ListChannelsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.medialive.paginators.ListChannelsIterable responses = client.listChannelsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listChannels(software.amazon.awssdk.services.medialive.model.ListChannelsRequest)} operation.</b>
     * </p>
     *
     * @param listChannelsRequest
     *        Placeholder documentation for ListChannelsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws BadRequestException
     *         This request was invalid.
     * @throws InternalServerErrorException
     *         Unexpected internal service error.
     * @throws ForbiddenException
     *         You do not have permission to list channels.
     * @throws BadGatewayException
     *         Bad Gateway Error
     * @throws GatewayTimeoutException
     *         Gateway Timeout Error
     * @throws TooManyRequestsException
     *         Request limit exceeded on list channel calls to channel service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.ListChannels
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListChannels" target="_top">AWS API
     *      Documentation</a>
     */
    default ListChannelsIterable listChannelsPaginator(ListChannelsRequest listChannelsRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, BadGatewayException, GatewayTimeoutException,
            TooManyRequestsException, AwsServiceException, SdkClientException, MediaLiveException {
        throw new UnsupportedOperationException();
    }

    /**
     * Produces list of channels that have been created<br/>
     * <p>
     * This is a variant of {@link #listChannels(software.amazon.awssdk.services.medialive.model.ListChannelsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.medialive.paginators.ListChannelsIterable responses = client.listChannelsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.medialive.paginators.ListChannelsIterable responses = client.listChannelsPaginator(request);
     *     for (software.amazon.awssdk.services.medialive.model.ListChannelsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.medialive.paginators.ListChannelsIterable responses = client.listChannelsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listChannels(software.amazon.awssdk.services.medialive.model.ListChannelsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListChannelsRequest.Builder} avoiding the need to
     * create one manually via {@link ListChannelsRequest#builder()}
     * </p>
     *
     * @param listChannelsRequest
     *        A {@link Consumer} that will call methods on {@link ListChannelsRequest.Builder} to create a request.
     *        Placeholder documentation for ListChannelsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws BadRequestException
     *         This request was invalid.
     * @throws InternalServerErrorException
     *         Unexpected internal service error.
     * @throws ForbiddenException
     *         You do not have permission to list channels.
     * @throws BadGatewayException
     *         Bad Gateway Error
     * @throws GatewayTimeoutException
     *         Gateway Timeout Error
     * @throws TooManyRequestsException
     *         Request limit exceeded on list channel calls to channel service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.ListChannels
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListChannels" target="_top">AWS API
     *      Documentation</a>
     */
    default ListChannelsIterable listChannelsPaginator(Consumer<ListChannelsRequest.Builder> listChannelsRequest)
            throws BadRequestException, InternalServerErrorException, ForbiddenException, BadGatewayException,
            GatewayTimeoutException, TooManyRequestsException, AwsServiceException, SdkClientException, MediaLiveException {
        return listChannelsPaginator(ListChannelsRequest.builder().applyMutation(listChannelsRequest).build());
    }

    /**
     * List input devices
     *
     * @param listInputDevicesRequest
     *        Placeholder documentation for ListInputDevicesRequest
     * @return Result of the ListInputDevices operation returned by the service.
     * @throws BadRequestException
     *         This request was invalid.
     * @throws InternalServerErrorException
     *         Unexpected internal service error.
     * @throws ForbiddenException
     *         You do not have permission to list input devices.
     * @throws BadGatewayException
     *         Bad gateway error.
     * @throws GatewayTimeoutException
     *         Gateway timeout error.
     * @throws TooManyRequestsException
     *         Request limit exceeded on list devices calls to the input device service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.ListInputDevices
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListInputDevices" target="_top">AWS API
     *      Documentation</a>
     */
    default ListInputDevicesResponse listInputDevices(ListInputDevicesRequest listInputDevicesRequest)
            throws BadRequestException, InternalServerErrorException, ForbiddenException, BadGatewayException,
            GatewayTimeoutException, TooManyRequestsException, AwsServiceException, SdkClientException, MediaLiveException {
        throw new UnsupportedOperationException();
    }

    /**
     * List input devices<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListInputDevicesRequest.Builder} avoiding the need
     * to create one manually via {@link ListInputDevicesRequest#builder()}
     * </p>
     *
     * @param listInputDevicesRequest
     *        A {@link Consumer} that will call methods on {@link ListInputDevicesRequest.Builder} to create a request.
     *        Placeholder documentation for ListInputDevicesRequest
     * @return Result of the ListInputDevices operation returned by the service.
     * @throws BadRequestException
     *         This request was invalid.
     * @throws InternalServerErrorException
     *         Unexpected internal service error.
     * @throws ForbiddenException
     *         You do not have permission to list input devices.
     * @throws BadGatewayException
     *         Bad gateway error.
     * @throws GatewayTimeoutException
     *         Gateway timeout error.
     * @throws TooManyRequestsException
     *         Request limit exceeded on list devices calls to the input device service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.ListInputDevices
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListInputDevices" target="_top">AWS API
     *      Documentation</a>
     */
    default ListInputDevicesResponse listInputDevices(Consumer<ListInputDevicesRequest.Builder> listInputDevicesRequest)
            throws BadRequestException, InternalServerErrorException, ForbiddenException, BadGatewayException,
            GatewayTimeoutException, TooManyRequestsException, AwsServiceException, SdkClientException, MediaLiveException {
        return listInputDevices(ListInputDevicesRequest.builder().applyMutation(listInputDevicesRequest).build());
    }

    /**
     * List input devices<br/>
     * <p>
     * This is a variant of
     * {@link #listInputDevices(software.amazon.awssdk.services.medialive.model.ListInputDevicesRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.medialive.paginators.ListInputDevicesIterable responses = client.listInputDevicesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.medialive.paginators.ListInputDevicesIterable responses = client
     *             .listInputDevicesPaginator(request);
     *     for (software.amazon.awssdk.services.medialive.model.ListInputDevicesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.medialive.paginators.ListInputDevicesIterable responses = client.listInputDevicesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listInputDevices(software.amazon.awssdk.services.medialive.model.ListInputDevicesRequest)} operation.</b>
     * </p>
     *
     * @param listInputDevicesRequest
     *        Placeholder documentation for ListInputDevicesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws BadRequestException
     *         This request was invalid.
     * @throws InternalServerErrorException
     *         Unexpected internal service error.
     * @throws ForbiddenException
     *         You do not have permission to list input devices.
     * @throws BadGatewayException
     *         Bad gateway error.
     * @throws GatewayTimeoutException
     *         Gateway timeout error.
     * @throws TooManyRequestsException
     *         Request limit exceeded on list devices calls to the input device service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.ListInputDevices
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListInputDevices" target="_top">AWS API
     *      Documentation</a>
     */
    default ListInputDevicesIterable listInputDevicesPaginator(ListInputDevicesRequest listInputDevicesRequest)
            throws BadRequestException, InternalServerErrorException, ForbiddenException, BadGatewayException,
            GatewayTimeoutException, TooManyRequestsException, AwsServiceException, SdkClientException, MediaLiveException {
        throw new UnsupportedOperationException();
    }

    /**
     * List input devices<br/>
     * <p>
     * This is a variant of
     * {@link #listInputDevices(software.amazon.awssdk.services.medialive.model.ListInputDevicesRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.medialive.paginators.ListInputDevicesIterable responses = client.listInputDevicesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.medialive.paginators.ListInputDevicesIterable responses = client
     *             .listInputDevicesPaginator(request);
     *     for (software.amazon.awssdk.services.medialive.model.ListInputDevicesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.medialive.paginators.ListInputDevicesIterable responses = client.listInputDevicesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listInputDevices(software.amazon.awssdk.services.medialive.model.ListInputDevicesRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListInputDevicesRequest.Builder} avoiding the need
     * to create one manually via {@link ListInputDevicesRequest#builder()}
     * </p>
     *
     * @param listInputDevicesRequest
     *        A {@link Consumer} that will call methods on {@link ListInputDevicesRequest.Builder} to create a request.
     *        Placeholder documentation for ListInputDevicesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws BadRequestException
     *         This request was invalid.
     * @throws InternalServerErrorException
     *         Unexpected internal service error.
     * @throws ForbiddenException
     *         You do not have permission to list input devices.
     * @throws BadGatewayException
     *         Bad gateway error.
     * @throws GatewayTimeoutException
     *         Gateway timeout error.
     * @throws TooManyRequestsException
     *         Request limit exceeded on list devices calls to the input device service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.ListInputDevices
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListInputDevices" target="_top">AWS API
     *      Documentation</a>
     */
    default ListInputDevicesIterable listInputDevicesPaginator(Consumer<ListInputDevicesRequest.Builder> listInputDevicesRequest)
            throws BadRequestException, InternalServerErrorException, ForbiddenException, BadGatewayException,
            GatewayTimeoutException, TooManyRequestsException, AwsServiceException, SdkClientException, MediaLiveException {
        return listInputDevicesPaginator(ListInputDevicesRequest.builder().applyMutation(listInputDevicesRequest).build());
    }

    /**
     * Produces a list of Input Security Groups for an account
     *
     * @return Result of the ListInputSecurityGroups operation returned by the service.
     * @throws BadRequestException
     *         The request to list Input Security Groups was invalid
     * @throws InternalServerErrorException
     *         Internal Server Error
     * @throws ForbiddenException
     *         The requester does not have permission to call ListInputSecurityGroups
     * @throws BadGatewayException
     *         Bad Gateway Error
     * @throws GatewayTimeoutException
     *         Gateway Timeout Error
     * @throws TooManyRequestsException
     *         Limit Exceeded Error
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.ListInputSecurityGroups
     * @see #listInputSecurityGroups(ListInputSecurityGroupsRequest)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListInputSecurityGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default ListInputSecurityGroupsResponse listInputSecurityGroups() throws BadRequestException, InternalServerErrorException,
            ForbiddenException, BadGatewayException, GatewayTimeoutException, TooManyRequestsException, AwsServiceException,
            SdkClientException, MediaLiveException {
        return listInputSecurityGroups(ListInputSecurityGroupsRequest.builder().build());
    }

    /**
     * Produces a list of Input Security Groups for an account
     *
     * @param listInputSecurityGroupsRequest
     *        Placeholder documentation for ListInputSecurityGroupsRequest
     * @return Result of the ListInputSecurityGroups operation returned by the service.
     * @throws BadRequestException
     *         The request to list Input Security Groups was invalid
     * @throws InternalServerErrorException
     *         Internal Server Error
     * @throws ForbiddenException
     *         The requester does not have permission to call ListInputSecurityGroups
     * @throws BadGatewayException
     *         Bad Gateway Error
     * @throws GatewayTimeoutException
     *         Gateway Timeout Error
     * @throws TooManyRequestsException
     *         Limit Exceeded Error
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.ListInputSecurityGroups
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListInputSecurityGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default ListInputSecurityGroupsResponse listInputSecurityGroups(ListInputSecurityGroupsRequest listInputSecurityGroupsRequest)
            throws BadRequestException, InternalServerErrorException, ForbiddenException, BadGatewayException,
            GatewayTimeoutException, TooManyRequestsException, AwsServiceException, SdkClientException, MediaLiveException {
        throw new UnsupportedOperationException();
    }

    /**
     * Produces a list of Input Security Groups for an account<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListInputSecurityGroupsRequest.Builder} avoiding
     * the need to create one manually via {@link ListInputSecurityGroupsRequest#builder()}
     * </p>
     *
     * @param listInputSecurityGroupsRequest
     *        A {@link Consumer} that will call methods on {@link ListInputSecurityGroupsRequest.Builder} to create a
     *        request. Placeholder documentation for ListInputSecurityGroupsRequest
     * @return Result of the ListInputSecurityGroups operation returned by the service.
     * @throws BadRequestException
     *         The request to list Input Security Groups was invalid
     * @throws InternalServerErrorException
     *         Internal Server Error
     * @throws ForbiddenException
     *         The requester does not have permission to call ListInputSecurityGroups
     * @throws BadGatewayException
     *         Bad Gateway Error
     * @throws GatewayTimeoutException
     *         Gateway Timeout Error
     * @throws TooManyRequestsException
     *         Limit Exceeded Error
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.ListInputSecurityGroups
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListInputSecurityGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default ListInputSecurityGroupsResponse listInputSecurityGroups(
            Consumer<ListInputSecurityGroupsRequest.Builder> listInputSecurityGroupsRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, BadGatewayException, GatewayTimeoutException,
            TooManyRequestsException, AwsServiceException, SdkClientException, MediaLiveException {
        return listInputSecurityGroups(ListInputSecurityGroupsRequest.builder().applyMutation(listInputSecurityGroupsRequest)
                .build());
    }

    /**
     * Produces a list of Input Security Groups for an account<br/>
     * <p>
     * This is a variant of
     * {@link #listInputSecurityGroups(software.amazon.awssdk.services.medialive.model.ListInputSecurityGroupsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.medialive.paginators.ListInputSecurityGroupsIterable responses = client.listInputSecurityGroupsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.medialive.paginators.ListInputSecurityGroupsIterable responses = client
     *             .listInputSecurityGroupsPaginator(request);
     *     for (software.amazon.awssdk.services.medialive.model.ListInputSecurityGroupsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.medialive.paginators.ListInputSecurityGroupsIterable responses = client.listInputSecurityGroupsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listInputSecurityGroups(software.amazon.awssdk.services.medialive.model.ListInputSecurityGroupsRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws BadRequestException
     *         The request to list Input Security Groups was invalid
     * @throws InternalServerErrorException
     *         Internal Server Error
     * @throws ForbiddenException
     *         The requester does not have permission to call ListInputSecurityGroups
     * @throws BadGatewayException
     *         Bad Gateway Error
     * @throws GatewayTimeoutException
     *         Gateway Timeout Error
     * @throws TooManyRequestsException
     *         Limit Exceeded Error
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.ListInputSecurityGroups
     * @see #listInputSecurityGroupsPaginator(ListInputSecurityGroupsRequest)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListInputSecurityGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default ListInputSecurityGroupsIterable listInputSecurityGroupsPaginator() throws BadRequestException,
            InternalServerErrorException, ForbiddenException, BadGatewayException, GatewayTimeoutException,
            TooManyRequestsException, AwsServiceException, SdkClientException, MediaLiveException {
        return listInputSecurityGroupsPaginator(ListInputSecurityGroupsRequest.builder().build());
    }

    /**
     * Produces a list of Input Security Groups for an account<br/>
     * <p>
     * This is a variant of
     * {@link #listInputSecurityGroups(software.amazon.awssdk.services.medialive.model.ListInputSecurityGroupsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.medialive.paginators.ListInputSecurityGroupsIterable responses = client.listInputSecurityGroupsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.medialive.paginators.ListInputSecurityGroupsIterable responses = client
     *             .listInputSecurityGroupsPaginator(request);
     *     for (software.amazon.awssdk.services.medialive.model.ListInputSecurityGroupsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.medialive.paginators.ListInputSecurityGroupsIterable responses = client.listInputSecurityGroupsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listInputSecurityGroups(software.amazon.awssdk.services.medialive.model.ListInputSecurityGroupsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listInputSecurityGroupsRequest
     *        Placeholder documentation for ListInputSecurityGroupsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws BadRequestException
     *         The request to list Input Security Groups was invalid
     * @throws InternalServerErrorException
     *         Internal Server Error
     * @throws ForbiddenException
     *         The requester does not have permission to call ListInputSecurityGroups
     * @throws BadGatewayException
     *         Bad Gateway Error
     * @throws GatewayTimeoutException
     *         Gateway Timeout Error
     * @throws TooManyRequestsException
     *         Limit Exceeded Error
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.ListInputSecurityGroups
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListInputSecurityGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default ListInputSecurityGroupsIterable listInputSecurityGroupsPaginator(
            ListInputSecurityGroupsRequest listInputSecurityGroupsRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, BadGatewayException, GatewayTimeoutException,
            TooManyRequestsException, AwsServiceException, SdkClientException, MediaLiveException {
        throw new UnsupportedOperationException();
    }

    /**
     * Produces a list of Input Security Groups for an account<br/>
     * <p>
     * This is a variant of
     * {@link #listInputSecurityGroups(software.amazon.awssdk.services.medialive.model.ListInputSecurityGroupsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.medialive.paginators.ListInputSecurityGroupsIterable responses = client.listInputSecurityGroupsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.medialive.paginators.ListInputSecurityGroupsIterable responses = client
     *             .listInputSecurityGroupsPaginator(request);
     *     for (software.amazon.awssdk.services.medialive.model.ListInputSecurityGroupsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.medialive.paginators.ListInputSecurityGroupsIterable responses = client.listInputSecurityGroupsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listInputSecurityGroups(software.amazon.awssdk.services.medialive.model.ListInputSecurityGroupsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListInputSecurityGroupsRequest.Builder} avoiding
     * the need to create one manually via {@link ListInputSecurityGroupsRequest#builder()}
     * </p>
     *
     * @param listInputSecurityGroupsRequest
     *        A {@link Consumer} that will call methods on {@link ListInputSecurityGroupsRequest.Builder} to create a
     *        request. Placeholder documentation for ListInputSecurityGroupsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws BadRequestException
     *         The request to list Input Security Groups was invalid
     * @throws InternalServerErrorException
     *         Internal Server Error
     * @throws ForbiddenException
     *         The requester does not have permission to call ListInputSecurityGroups
     * @throws BadGatewayException
     *         Bad Gateway Error
     * @throws GatewayTimeoutException
     *         Gateway Timeout Error
     * @throws TooManyRequestsException
     *         Limit Exceeded Error
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.ListInputSecurityGroups
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListInputSecurityGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default ListInputSecurityGroupsIterable listInputSecurityGroupsPaginator(
            Consumer<ListInputSecurityGroupsRequest.Builder> listInputSecurityGroupsRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, BadGatewayException, GatewayTimeoutException,
            TooManyRequestsException, AwsServiceException, SdkClientException, MediaLiveException {
        return listInputSecurityGroupsPaginator(ListInputSecurityGroupsRequest.builder()
                .applyMutation(listInputSecurityGroupsRequest).build());
    }

    /**
     * Produces list of inputs that have been created
     *
     * @return Result of the ListInputs operation returned by the service.
     * @throws BadRequestException
     *         This request was invalid
     * @throws InternalServerErrorException
     *         Internal Service Error
     * @throws ForbiddenException
     *         Access was denied
     * @throws BadGatewayException
     *         Bad Gateway Error
     * @throws GatewayTimeoutException
     *         Gateway Timeout Error
     * @throws TooManyRequestsException
     *         Limit exceeded
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.ListInputs
     * @see #listInputs(ListInputsRequest)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListInputs" target="_top">AWS API
     *      Documentation</a>
     */
    default ListInputsResponse listInputs() throws BadRequestException, InternalServerErrorException, ForbiddenException,
            BadGatewayException, GatewayTimeoutException, TooManyRequestsException, AwsServiceException, SdkClientException,
            MediaLiveException {
        return listInputs(ListInputsRequest.builder().build());
    }

    /**
     * Produces list of inputs that have been created
     *
     * @param listInputsRequest
     *        Placeholder documentation for ListInputsRequest
     * @return Result of the ListInputs operation returned by the service.
     * @throws BadRequestException
     *         This request was invalid
     * @throws InternalServerErrorException
     *         Internal Service Error
     * @throws ForbiddenException
     *         Access was denied
     * @throws BadGatewayException
     *         Bad Gateway Error
     * @throws GatewayTimeoutException
     *         Gateway Timeout Error
     * @throws TooManyRequestsException
     *         Limit exceeded
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.ListInputs
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListInputs" target="_top">AWS API
     *      Documentation</a>
     */
    default ListInputsResponse listInputs(ListInputsRequest listInputsRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, BadGatewayException, GatewayTimeoutException,
            TooManyRequestsException, AwsServiceException, SdkClientException, MediaLiveException {
        throw new UnsupportedOperationException();
    }

    /**
     * Produces list of inputs that have been created<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListInputsRequest.Builder} avoiding the need to
     * create one manually via {@link ListInputsRequest#builder()}
     * </p>
     *
     * @param listInputsRequest
     *        A {@link Consumer} that will call methods on {@link ListInputsRequest.Builder} to create a request.
     *        Placeholder documentation for ListInputsRequest
     * @return Result of the ListInputs operation returned by the service.
     * @throws BadRequestException
     *         This request was invalid
     * @throws InternalServerErrorException
     *         Internal Service Error
     * @throws ForbiddenException
     *         Access was denied
     * @throws BadGatewayException
     *         Bad Gateway Error
     * @throws GatewayTimeoutException
     *         Gateway Timeout Error
     * @throws TooManyRequestsException
     *         Limit exceeded
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.ListInputs
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListInputs" target="_top">AWS API
     *      Documentation</a>
     */
    default ListInputsResponse listInputs(Consumer<ListInputsRequest.Builder> listInputsRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, BadGatewayException, GatewayTimeoutException,
            TooManyRequestsException, AwsServiceException, SdkClientException, MediaLiveException {
        return listInputs(ListInputsRequest.builder().applyMutation(listInputsRequest).build());
    }

    /**
     * Produces list of inputs that have been created<br/>
     * <p>
     * This is a variant of {@link #listInputs(software.amazon.awssdk.services.medialive.model.ListInputsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.medialive.paginators.ListInputsIterable responses = client.listInputsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.medialive.paginators.ListInputsIterable responses = client.listInputsPaginator(request);
     *     for (software.amazon.awssdk.services.medialive.model.ListInputsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.medialive.paginators.ListInputsIterable responses = client.listInputsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listInputs(software.amazon.awssdk.services.medialive.model.ListInputsRequest)} operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws BadRequestException
     *         This request was invalid
     * @throws InternalServerErrorException
     *         Internal Service Error
     * @throws ForbiddenException
     *         Access was denied
     * @throws BadGatewayException
     *         Bad Gateway Error
     * @throws GatewayTimeoutException
     *         Gateway Timeout Error
     * @throws TooManyRequestsException
     *         Limit exceeded
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.ListInputs
     * @see #listInputsPaginator(ListInputsRequest)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListInputs" target="_top">AWS API
     *      Documentation</a>
     */
    default ListInputsIterable listInputsPaginator() throws BadRequestException, InternalServerErrorException,
            ForbiddenException, BadGatewayException, GatewayTimeoutException, TooManyRequestsException, AwsServiceException,
            SdkClientException, MediaLiveException {
        return listInputsPaginator(ListInputsRequest.builder().build());
    }

    /**
     * Produces list of inputs that have been created<br/>
     * <p>
     * This is a variant of {@link #listInputs(software.amazon.awssdk.services.medialive.model.ListInputsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.medialive.paginators.ListInputsIterable responses = client.listInputsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.medialive.paginators.ListInputsIterable responses = client.listInputsPaginator(request);
     *     for (software.amazon.awssdk.services.medialive.model.ListInputsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.medialive.paginators.ListInputsIterable responses = client.listInputsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listInputs(software.amazon.awssdk.services.medialive.model.ListInputsRequest)} operation.</b>
     * </p>
     *
     * @param listInputsRequest
     *        Placeholder documentation for ListInputsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws BadRequestException
     *         This request was invalid
     * @throws InternalServerErrorException
     *         Internal Service Error
     * @throws ForbiddenException
     *         Access was denied
     * @throws BadGatewayException
     *         Bad Gateway Error
     * @throws GatewayTimeoutException
     *         Gateway Timeout Error
     * @throws TooManyRequestsException
     *         Limit exceeded
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.ListInputs
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListInputs" target="_top">AWS API
     *      Documentation</a>
     */
    default ListInputsIterable listInputsPaginator(ListInputsRequest listInputsRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, BadGatewayException, GatewayTimeoutException,
            TooManyRequestsException, AwsServiceException, SdkClientException, MediaLiveException {
        throw new UnsupportedOperationException();
    }

    /**
     * Produces list of inputs that have been created<br/>
     * <p>
     * This is a variant of {@link #listInputs(software.amazon.awssdk.services.medialive.model.ListInputsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.medialive.paginators.ListInputsIterable responses = client.listInputsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.medialive.paginators.ListInputsIterable responses = client.listInputsPaginator(request);
     *     for (software.amazon.awssdk.services.medialive.model.ListInputsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.medialive.paginators.ListInputsIterable responses = client.listInputsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listInputs(software.amazon.awssdk.services.medialive.model.ListInputsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListInputsRequest.Builder} avoiding the need to
     * create one manually via {@link ListInputsRequest#builder()}
     * </p>
     *
     * @param listInputsRequest
     *        A {@link Consumer} that will call methods on {@link ListInputsRequest.Builder} to create a request.
     *        Placeholder documentation for ListInputsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws BadRequestException
     *         This request was invalid
     * @throws InternalServerErrorException
     *         Internal Service Error
     * @throws ForbiddenException
     *         Access was denied
     * @throws BadGatewayException
     *         Bad Gateway Error
     * @throws GatewayTimeoutException
     *         Gateway Timeout Error
     * @throws TooManyRequestsException
     *         Limit exceeded
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.ListInputs
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListInputs" target="_top">AWS API
     *      Documentation</a>
     */
    default ListInputsIterable listInputsPaginator(Consumer<ListInputsRequest.Builder> listInputsRequest)
            throws BadRequestException, InternalServerErrorException, ForbiddenException, BadGatewayException,
            GatewayTimeoutException, TooManyRequestsException, AwsServiceException, SdkClientException, MediaLiveException {
        return listInputsPaginator(ListInputsRequest.builder().applyMutation(listInputsRequest).build());
    }

    /**
     * List the programs that currently exist for a specific multiplex.
     *
     * @param listMultiplexProgramsRequest
     *        Placeholder documentation for ListMultiplexProgramsRequest
     * @return Result of the ListMultiplexPrograms operation returned by the service.
     * @throws BadRequestException
     *         MediaLive can't process your request because of a problem in the request. Please check your request form
     *         and syntax.
     * @throws InternalServerErrorException
     *         Unexpected internal service error.
     * @throws ForbiddenException
     *         You do not have permission to list multiplex programs.
     * @throws BadGatewayException
     *         Bad Gateway Error.
     * @throws NotFoundException
     *         MediaLive can't provide the list of programs. The multiplex that you specified doesn’t exist. Check the
     *         ID and try again.
     * @throws GatewayTimeoutException
     *         Gateway Timeout Error.
     * @throws TooManyRequestsException
     *         Request limit exceeded on list multiplex calls to multiplex service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.ListMultiplexPrograms
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListMultiplexPrograms"
     *      target="_top">AWS API Documentation</a>
     */
    default ListMultiplexProgramsResponse listMultiplexPrograms(ListMultiplexProgramsRequest listMultiplexProgramsRequest)
            throws BadRequestException, InternalServerErrorException, ForbiddenException, BadGatewayException, NotFoundException,
            GatewayTimeoutException, TooManyRequestsException, AwsServiceException, SdkClientException, MediaLiveException {
        throw new UnsupportedOperationException();
    }

    /**
     * List the programs that currently exist for a specific multiplex.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListMultiplexProgramsRequest.Builder} avoiding the
     * need to create one manually via {@link ListMultiplexProgramsRequest#builder()}
     * </p>
     *
     * @param listMultiplexProgramsRequest
     *        A {@link Consumer} that will call methods on {@link ListMultiplexProgramsRequest.Builder} to create a
     *        request. Placeholder documentation for ListMultiplexProgramsRequest
     * @return Result of the ListMultiplexPrograms operation returned by the service.
     * @throws BadRequestException
     *         MediaLive can't process your request because of a problem in the request. Please check your request form
     *         and syntax.
     * @throws InternalServerErrorException
     *         Unexpected internal service error.
     * @throws ForbiddenException
     *         You do not have permission to list multiplex programs.
     * @throws BadGatewayException
     *         Bad Gateway Error.
     * @throws NotFoundException
     *         MediaLive can't provide the list of programs. The multiplex that you specified doesn’t exist. Check the
     *         ID and try again.
     * @throws GatewayTimeoutException
     *         Gateway Timeout Error.
     * @throws TooManyRequestsException
     *         Request limit exceeded on list multiplex calls to multiplex service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.ListMultiplexPrograms
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListMultiplexPrograms"
     *      target="_top">AWS API Documentation</a>
     */
    default ListMultiplexProgramsResponse listMultiplexPrograms(
            Consumer<ListMultiplexProgramsRequest.Builder> listMultiplexProgramsRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, BadGatewayException, NotFoundException, GatewayTimeoutException,
            TooManyRequestsException, AwsServiceException, SdkClientException, MediaLiveException {
        return listMultiplexPrograms(ListMultiplexProgramsRequest.builder().applyMutation(listMultiplexProgramsRequest).build());
    }

    /**
     * List the programs that currently exist for a specific multiplex.<br/>
     * <p>
     * This is a variant of
     * {@link #listMultiplexPrograms(software.amazon.awssdk.services.medialive.model.ListMultiplexProgramsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.medialive.paginators.ListMultiplexProgramsIterable responses = client.listMultiplexProgramsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.medialive.paginators.ListMultiplexProgramsIterable responses = client
     *             .listMultiplexProgramsPaginator(request);
     *     for (software.amazon.awssdk.services.medialive.model.ListMultiplexProgramsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.medialive.paginators.ListMultiplexProgramsIterable responses = client.listMultiplexProgramsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listMultiplexPrograms(software.amazon.awssdk.services.medialive.model.ListMultiplexProgramsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listMultiplexProgramsRequest
     *        Placeholder documentation for ListMultiplexProgramsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws BadRequestException
     *         MediaLive can't process your request because of a problem in the request. Please check your request form
     *         and syntax.
     * @throws InternalServerErrorException
     *         Unexpected internal service error.
     * @throws ForbiddenException
     *         You do not have permission to list multiplex programs.
     * @throws BadGatewayException
     *         Bad Gateway Error.
     * @throws NotFoundException
     *         MediaLive can't provide the list of programs. The multiplex that you specified doesn’t exist. Check the
     *         ID and try again.
     * @throws GatewayTimeoutException
     *         Gateway Timeout Error.
     * @throws TooManyRequestsException
     *         Request limit exceeded on list multiplex calls to multiplex service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.ListMultiplexPrograms
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListMultiplexPrograms"
     *      target="_top">AWS API Documentation</a>
     */
    default ListMultiplexProgramsIterable listMultiplexProgramsPaginator(ListMultiplexProgramsRequest listMultiplexProgramsRequest)
            throws BadRequestException, InternalServerErrorException, ForbiddenException, BadGatewayException, NotFoundException,
            GatewayTimeoutException, TooManyRequestsException, AwsServiceException, SdkClientException, MediaLiveException {
        throw new UnsupportedOperationException();
    }

    /**
     * List the programs that currently exist for a specific multiplex.<br/>
     * <p>
     * This is a variant of
     * {@link #listMultiplexPrograms(software.amazon.awssdk.services.medialive.model.ListMultiplexProgramsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.medialive.paginators.ListMultiplexProgramsIterable responses = client.listMultiplexProgramsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.medialive.paginators.ListMultiplexProgramsIterable responses = client
     *             .listMultiplexProgramsPaginator(request);
     *     for (software.amazon.awssdk.services.medialive.model.ListMultiplexProgramsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.medialive.paginators.ListMultiplexProgramsIterable responses = client.listMultiplexProgramsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listMultiplexPrograms(software.amazon.awssdk.services.medialive.model.ListMultiplexProgramsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListMultiplexProgramsRequest.Builder} avoiding the
     * need to create one manually via {@link ListMultiplexProgramsRequest#builder()}
     * </p>
     *
     * @param listMultiplexProgramsRequest
     *        A {@link Consumer} that will call methods on {@link ListMultiplexProgramsRequest.Builder} to create a
     *        request. Placeholder documentation for ListMultiplexProgramsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws BadRequestException
     *         MediaLive can't process your request because of a problem in the request. Please check your request form
     *         and syntax.
     * @throws InternalServerErrorException
     *         Unexpected internal service error.
     * @throws ForbiddenException
     *         You do not have permission to list multiplex programs.
     * @throws BadGatewayException
     *         Bad Gateway Error.
     * @throws NotFoundException
     *         MediaLive can't provide the list of programs. The multiplex that you specified doesn’t exist. Check the
     *         ID and try again.
     * @throws GatewayTimeoutException
     *         Gateway Timeout Error.
     * @throws TooManyRequestsException
     *         Request limit exceeded on list multiplex calls to multiplex service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.ListMultiplexPrograms
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListMultiplexPrograms"
     *      target="_top">AWS API Documentation</a>
     */
    default ListMultiplexProgramsIterable listMultiplexProgramsPaginator(
            Consumer<ListMultiplexProgramsRequest.Builder> listMultiplexProgramsRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, BadGatewayException, NotFoundException, GatewayTimeoutException,
            TooManyRequestsException, AwsServiceException, SdkClientException, MediaLiveException {
        return listMultiplexProgramsPaginator(ListMultiplexProgramsRequest.builder().applyMutation(listMultiplexProgramsRequest)
                .build());
    }

    /**
     * Retrieve a list of the existing multiplexes.
     *
     * @param listMultiplexesRequest
     *        Placeholder documentation for ListMultiplexesRequest
     * @return Result of the ListMultiplexes operation returned by the service.
     * @throws BadRequestException
     *         MediaLive can't process your request because of a problem in the request. Please check your request form
     *         and syntax.
     * @throws InternalServerErrorException
     *         Unexpected internal service error.
     * @throws ForbiddenException
     *         You don't have permission to list multiplexes.
     * @throws BadGatewayException
     *         Bad Gateway Error.
     * @throws GatewayTimeoutException
     *         Gateway Timeout Error.
     * @throws TooManyRequestsException
     *         Request limit exceeded on list multiplex calls to multiplex service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.ListMultiplexes
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListMultiplexes" target="_top">AWS API
     *      Documentation</a>
     */
    default ListMultiplexesResponse listMultiplexes(ListMultiplexesRequest listMultiplexesRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, BadGatewayException, GatewayTimeoutException,
            TooManyRequestsException, AwsServiceException, SdkClientException, MediaLiveException {
        throw new UnsupportedOperationException();
    }

    /**
     * Retrieve a list of the existing multiplexes.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListMultiplexesRequest.Builder} avoiding the need
     * to create one manually via {@link ListMultiplexesRequest#builder()}
     * </p>
     *
     * @param listMultiplexesRequest
     *        A {@link Consumer} that will call methods on {@link ListMultiplexesRequest.Builder} to create a request.
     *        Placeholder documentation for ListMultiplexesRequest
     * @return Result of the ListMultiplexes operation returned by the service.
     * @throws BadRequestException
     *         MediaLive can't process your request because of a problem in the request. Please check your request form
     *         and syntax.
     * @throws InternalServerErrorException
     *         Unexpected internal service error.
     * @throws ForbiddenException
     *         You don't have permission to list multiplexes.
     * @throws BadGatewayException
     *         Bad Gateway Error.
     * @throws GatewayTimeoutException
     *         Gateway Timeout Error.
     * @throws TooManyRequestsException
     *         Request limit exceeded on list multiplex calls to multiplex service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.ListMultiplexes
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListMultiplexes" target="_top">AWS API
     *      Documentation</a>
     */
    default ListMultiplexesResponse listMultiplexes(Consumer<ListMultiplexesRequest.Builder> listMultiplexesRequest)
            throws BadRequestException, InternalServerErrorException, ForbiddenException, BadGatewayException,
            GatewayTimeoutException, TooManyRequestsException, AwsServiceException, SdkClientException, MediaLiveException {
        return listMultiplexes(ListMultiplexesRequest.builder().applyMutation(listMultiplexesRequest).build());
    }

    /**
     * Retrieve a list of the existing multiplexes.<br/>
     * <p>
     * This is a variant of
     * {@link #listMultiplexes(software.amazon.awssdk.services.medialive.model.ListMultiplexesRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.medialive.paginators.ListMultiplexesIterable responses = client.listMultiplexesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.medialive.paginators.ListMultiplexesIterable responses = client
     *             .listMultiplexesPaginator(request);
     *     for (software.amazon.awssdk.services.medialive.model.ListMultiplexesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.medialive.paginators.ListMultiplexesIterable responses = client.listMultiplexesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listMultiplexes(software.amazon.awssdk.services.medialive.model.ListMultiplexesRequest)} operation.</b>
     * </p>
     *
     * @param listMultiplexesRequest
     *        Placeholder documentation for ListMultiplexesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws BadRequestException
     *         MediaLive can't process your request because of a problem in the request. Please check your request form
     *         and syntax.
     * @throws InternalServerErrorException
     *         Unexpected internal service error.
     * @throws ForbiddenException
     *         You don't have permission to list multiplexes.
     * @throws BadGatewayException
     *         Bad Gateway Error.
     * @throws GatewayTimeoutException
     *         Gateway Timeout Error.
     * @throws TooManyRequestsException
     *         Request limit exceeded on list multiplex calls to multiplex service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.ListMultiplexes
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListMultiplexes" target="_top">AWS API
     *      Documentation</a>
     */
    default ListMultiplexesIterable listMultiplexesPaginator(ListMultiplexesRequest listMultiplexesRequest)
            throws BadRequestException, InternalServerErrorException, ForbiddenException, BadGatewayException,
            GatewayTimeoutException, TooManyRequestsException, AwsServiceException, SdkClientException, MediaLiveException {
        throw new UnsupportedOperationException();
    }

    /**
     * Retrieve a list of the existing multiplexes.<br/>
     * <p>
     * This is a variant of
     * {@link #listMultiplexes(software.amazon.awssdk.services.medialive.model.ListMultiplexesRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.medialive.paginators.ListMultiplexesIterable responses = client.listMultiplexesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.medialive.paginators.ListMultiplexesIterable responses = client
     *             .listMultiplexesPaginator(request);
     *     for (software.amazon.awssdk.services.medialive.model.ListMultiplexesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.medialive.paginators.ListMultiplexesIterable responses = client.listMultiplexesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listMultiplexes(software.amazon.awssdk.services.medialive.model.ListMultiplexesRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListMultiplexesRequest.Builder} avoiding the need
     * to create one manually via {@link ListMultiplexesRequest#builder()}
     * </p>
     *
     * @param listMultiplexesRequest
     *        A {@link Consumer} that will call methods on {@link ListMultiplexesRequest.Builder} to create a request.
     *        Placeholder documentation for ListMultiplexesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws BadRequestException
     *         MediaLive can't process your request because of a problem in the request. Please check your request form
     *         and syntax.
     * @throws InternalServerErrorException
     *         Unexpected internal service error.
     * @throws ForbiddenException
     *         You don't have permission to list multiplexes.
     * @throws BadGatewayException
     *         Bad Gateway Error.
     * @throws GatewayTimeoutException
     *         Gateway Timeout Error.
     * @throws TooManyRequestsException
     *         Request limit exceeded on list multiplex calls to multiplex service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.ListMultiplexes
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListMultiplexes" target="_top">AWS API
     *      Documentation</a>
     */
    default ListMultiplexesIterable listMultiplexesPaginator(Consumer<ListMultiplexesRequest.Builder> listMultiplexesRequest)
            throws BadRequestException, InternalServerErrorException, ForbiddenException, BadGatewayException,
            GatewayTimeoutException, TooManyRequestsException, AwsServiceException, SdkClientException, MediaLiveException {
        return listMultiplexesPaginator(ListMultiplexesRequest.builder().applyMutation(listMultiplexesRequest).build());
    }

    /**
     * List offerings available for purchase.
     *
     * @return Result of the ListOfferings operation returned by the service.
     * @throws BadRequestException
     *         This request was invalid
     * @throws InternalServerErrorException
     *         Internal service error
     * @throws ForbiddenException
     *         You do not have permission to list offerings
     * @throws BadGatewayException
     *         Bad gateway error
     * @throws GatewayTimeoutException
     *         Gateway timeout error
     * @throws TooManyRequestsException
     *         Request limit exceeded on list offerings request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.ListOfferings
     * @see #listOfferings(ListOfferingsRequest)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListOfferings" target="_top">AWS API
     *      Documentation</a>
     */
    default ListOfferingsResponse listOfferings() throws BadRequestException, InternalServerErrorException, ForbiddenException,
            BadGatewayException, GatewayTimeoutException, TooManyRequestsException, AwsServiceException, SdkClientException,
            MediaLiveException {
        return listOfferings(ListOfferingsRequest.builder().build());
    }

    /**
     * List offerings available for purchase.
     *
     * @param listOfferingsRequest
     *        Placeholder documentation for ListOfferingsRequest
     * @return Result of the ListOfferings operation returned by the service.
     * @throws BadRequestException
     *         This request was invalid
     * @throws InternalServerErrorException
     *         Internal service error
     * @throws ForbiddenException
     *         You do not have permission to list offerings
     * @throws BadGatewayException
     *         Bad gateway error
     * @throws GatewayTimeoutException
     *         Gateway timeout error
     * @throws TooManyRequestsException
     *         Request limit exceeded on list offerings request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.ListOfferings
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListOfferings" target="_top">AWS API
     *      Documentation</a>
     */
    default ListOfferingsResponse listOfferings(ListOfferingsRequest listOfferingsRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, BadGatewayException, GatewayTimeoutException,
            TooManyRequestsException, AwsServiceException, SdkClientException, MediaLiveException {
        throw new UnsupportedOperationException();
    }

    /**
     * List offerings available for purchase.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListOfferingsRequest.Builder} avoiding the need to
     * create one manually via {@link ListOfferingsRequest#builder()}
     * </p>
     *
     * @param listOfferingsRequest
     *        A {@link Consumer} that will call methods on {@link ListOfferingsRequest.Builder} to create a request.
     *        Placeholder documentation for ListOfferingsRequest
     * @return Result of the ListOfferings operation returned by the service.
     * @throws BadRequestException
     *         This request was invalid
     * @throws InternalServerErrorException
     *         Internal service error
     * @throws ForbiddenException
     *         You do not have permission to list offerings
     * @throws BadGatewayException
     *         Bad gateway error
     * @throws GatewayTimeoutException
     *         Gateway timeout error
     * @throws TooManyRequestsException
     *         Request limit exceeded on list offerings request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.ListOfferings
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListOfferings" target="_top">AWS API
     *      Documentation</a>
     */
    default ListOfferingsResponse listOfferings(Consumer<ListOfferingsRequest.Builder> listOfferingsRequest)
            throws BadRequestException, InternalServerErrorException, ForbiddenException, BadGatewayException,
            GatewayTimeoutException, TooManyRequestsException, AwsServiceException, SdkClientException, MediaLiveException {
        return listOfferings(ListOfferingsRequest.builder().applyMutation(listOfferingsRequest).build());
    }

    /**
     * List offerings available for purchase.<br/>
     * <p>
     * This is a variant of {@link #listOfferings(software.amazon.awssdk.services.medialive.model.ListOfferingsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.medialive.paginators.ListOfferingsIterable responses = client.listOfferingsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.medialive.paginators.ListOfferingsIterable responses = client.listOfferingsPaginator(request);
     *     for (software.amazon.awssdk.services.medialive.model.ListOfferingsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.medialive.paginators.ListOfferingsIterable responses = client.listOfferingsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listOfferings(software.amazon.awssdk.services.medialive.model.ListOfferingsRequest)} operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws BadRequestException
     *         This request was invalid
     * @throws InternalServerErrorException
     *         Internal service error
     * @throws ForbiddenException
     *         You do not have permission to list offerings
     * @throws BadGatewayException
     *         Bad gateway error
     * @throws GatewayTimeoutException
     *         Gateway timeout error
     * @throws TooManyRequestsException
     *         Request limit exceeded on list offerings request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.ListOfferings
     * @see #listOfferingsPaginator(ListOfferingsRequest)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListOfferings" target="_top">AWS API
     *      Documentation</a>
     */
    default ListOfferingsIterable listOfferingsPaginator() throws BadRequestException, InternalServerErrorException,
            ForbiddenException, BadGatewayException, GatewayTimeoutException, TooManyRequestsException, AwsServiceException,
            SdkClientException, MediaLiveException {
        return listOfferingsPaginator(ListOfferingsRequest.builder().build());
    }

    /**
     * List offerings available for purchase.<br/>
     * <p>
     * This is a variant of {@link #listOfferings(software.amazon.awssdk.services.medialive.model.ListOfferingsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.medialive.paginators.ListOfferingsIterable responses = client.listOfferingsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.medialive.paginators.ListOfferingsIterable responses = client.listOfferingsPaginator(request);
     *     for (software.amazon.awssdk.services.medialive.model.ListOfferingsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.medialive.paginators.ListOfferingsIterable responses = client.listOfferingsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listOfferings(software.amazon.awssdk.services.medialive.model.ListOfferingsRequest)} operation.</b>
     * </p>
     *
     * @param listOfferingsRequest
     *        Placeholder documentation for ListOfferingsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws BadRequestException
     *         This request was invalid
     * @throws InternalServerErrorException
     *         Internal service error
     * @throws ForbiddenException
     *         You do not have permission to list offerings
     * @throws BadGatewayException
     *         Bad gateway error
     * @throws GatewayTimeoutException
     *         Gateway timeout error
     * @throws TooManyRequestsException
     *         Request limit exceeded on list offerings request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.ListOfferings
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListOfferings" target="_top">AWS API
     *      Documentation</a>
     */
    default ListOfferingsIterable listOfferingsPaginator(ListOfferingsRequest listOfferingsRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, BadGatewayException, GatewayTimeoutException,
            TooManyRequestsException, AwsServiceException, SdkClientException, MediaLiveException {
        throw new UnsupportedOperationException();
    }

    /**
     * List offerings available for purchase.<br/>
     * <p>
     * This is a variant of {@link #listOfferings(software.amazon.awssdk.services.medialive.model.ListOfferingsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.medialive.paginators.ListOfferingsIterable responses = client.listOfferingsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.medialive.paginators.ListOfferingsIterable responses = client.listOfferingsPaginator(request);
     *     for (software.amazon.awssdk.services.medialive.model.ListOfferingsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.medialive.paginators.ListOfferingsIterable responses = client.listOfferingsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listOfferings(software.amazon.awssdk.services.medialive.model.ListOfferingsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListOfferingsRequest.Builder} avoiding the need to
     * create one manually via {@link ListOfferingsRequest#builder()}
     * </p>
     *
     * @param listOfferingsRequest
     *        A {@link Consumer} that will call methods on {@link ListOfferingsRequest.Builder} to create a request.
     *        Placeholder documentation for ListOfferingsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws BadRequestException
     *         This request was invalid
     * @throws InternalServerErrorException
     *         Internal service error
     * @throws ForbiddenException
     *         You do not have permission to list offerings
     * @throws BadGatewayException
     *         Bad gateway error
     * @throws GatewayTimeoutException
     *         Gateway timeout error
     * @throws TooManyRequestsException
     *         Request limit exceeded on list offerings request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.ListOfferings
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListOfferings" target="_top">AWS API
     *      Documentation</a>
     */
    default ListOfferingsIterable listOfferingsPaginator(Consumer<ListOfferingsRequest.Builder> listOfferingsRequest)
            throws BadRequestException, InternalServerErrorException, ForbiddenException, BadGatewayException,
            GatewayTimeoutException, TooManyRequestsException, AwsServiceException, SdkClientException, MediaLiveException {
        return listOfferingsPaginator(ListOfferingsRequest.builder().applyMutation(listOfferingsRequest).build());
    }

    /**
     * List purchased reservations.
     *
     * @return Result of the ListReservations operation returned by the service.
     * @throws BadRequestException
     *         This request was invalid
     * @throws InternalServerErrorException
     *         Internal service error
     * @throws ForbiddenException
     *         You do not have permission to list reservations
     * @throws BadGatewayException
     *         Bad gateway error
     * @throws GatewayTimeoutException
     *         Gateway timeout error
     * @throws TooManyRequestsException
     *         Request limit exceeded on list reservations request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.ListReservations
     * @see #listReservations(ListReservationsRequest)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListReservations" target="_top">AWS API
     *      Documentation</a>
     */
    default ListReservationsResponse listReservations() throws BadRequestException, InternalServerErrorException,
            ForbiddenException, BadGatewayException, GatewayTimeoutException, TooManyRequestsException, AwsServiceException,
            SdkClientException, MediaLiveException {
        return listReservations(ListReservationsRequest.builder().build());
    }

    /**
     * List purchased reservations.
     *
     * @param listReservationsRequest
     *        Placeholder documentation for ListReservationsRequest
     * @return Result of the ListReservations operation returned by the service.
     * @throws BadRequestException
     *         This request was invalid
     * @throws InternalServerErrorException
     *         Internal service error
     * @throws ForbiddenException
     *         You do not have permission to list reservations
     * @throws BadGatewayException
     *         Bad gateway error
     * @throws GatewayTimeoutException
     *         Gateway timeout error
     * @throws TooManyRequestsException
     *         Request limit exceeded on list reservations request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.ListReservations
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListReservations" target="_top">AWS API
     *      Documentation</a>
     */
    default ListReservationsResponse listReservations(ListReservationsRequest listReservationsRequest)
            throws BadRequestException, InternalServerErrorException, ForbiddenException, BadGatewayException,
            GatewayTimeoutException, TooManyRequestsException, AwsServiceException, SdkClientException, MediaLiveException {
        throw new UnsupportedOperationException();
    }

    /**
     * List purchased reservations.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListReservationsRequest.Builder} avoiding the need
     * to create one manually via {@link ListReservationsRequest#builder()}
     * </p>
     *
     * @param listReservationsRequest
     *        A {@link Consumer} that will call methods on {@link ListReservationsRequest.Builder} to create a request.
     *        Placeholder documentation for ListReservationsRequest
     * @return Result of the ListReservations operation returned by the service.
     * @throws BadRequestException
     *         This request was invalid
     * @throws InternalServerErrorException
     *         Internal service error
     * @throws ForbiddenException
     *         You do not have permission to list reservations
     * @throws BadGatewayException
     *         Bad gateway error
     * @throws GatewayTimeoutException
     *         Gateway timeout error
     * @throws TooManyRequestsException
     *         Request limit exceeded on list reservations request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.ListReservations
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListReservations" target="_top">AWS API
     *      Documentation</a>
     */
    default ListReservationsResponse listReservations(Consumer<ListReservationsRequest.Builder> listReservationsRequest)
            throws BadRequestException, InternalServerErrorException, ForbiddenException, BadGatewayException,
            GatewayTimeoutException, TooManyRequestsException, AwsServiceException, SdkClientException, MediaLiveException {
        return listReservations(ListReservationsRequest.builder().applyMutation(listReservationsRequest).build());
    }

    /**
     * List purchased reservations.<br/>
     * <p>
     * This is a variant of
     * {@link #listReservations(software.amazon.awssdk.services.medialive.model.ListReservationsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.medialive.paginators.ListReservationsIterable responses = client.listReservationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.medialive.paginators.ListReservationsIterable responses = client
     *             .listReservationsPaginator(request);
     *     for (software.amazon.awssdk.services.medialive.model.ListReservationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.medialive.paginators.ListReservationsIterable responses = client.listReservationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listReservations(software.amazon.awssdk.services.medialive.model.ListReservationsRequest)} operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws BadRequestException
     *         This request was invalid
     * @throws InternalServerErrorException
     *         Internal service error
     * @throws ForbiddenException
     *         You do not have permission to list reservations
     * @throws BadGatewayException
     *         Bad gateway error
     * @throws GatewayTimeoutException
     *         Gateway timeout error
     * @throws TooManyRequestsException
     *         Request limit exceeded on list reservations request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.ListReservations
     * @see #listReservationsPaginator(ListReservationsRequest)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListReservations" target="_top">AWS API
     *      Documentation</a>
     */
    default ListReservationsIterable listReservationsPaginator() throws BadRequestException, InternalServerErrorException,
            ForbiddenException, BadGatewayException, GatewayTimeoutException, TooManyRequestsException, AwsServiceException,
            SdkClientException, MediaLiveException {
        return listReservationsPaginator(ListReservationsRequest.builder().build());
    }

    /**
     * List purchased reservations.<br/>
     * <p>
     * This is a variant of
     * {@link #listReservations(software.amazon.awssdk.services.medialive.model.ListReservationsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.medialive.paginators.ListReservationsIterable responses = client.listReservationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.medialive.paginators.ListReservationsIterable responses = client
     *             .listReservationsPaginator(request);
     *     for (software.amazon.awssdk.services.medialive.model.ListReservationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.medialive.paginators.ListReservationsIterable responses = client.listReservationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listReservations(software.amazon.awssdk.services.medialive.model.ListReservationsRequest)} operation.</b>
     * </p>
     *
     * @param listReservationsRequest
     *        Placeholder documentation for ListReservationsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws BadRequestException
     *         This request was invalid
     * @throws InternalServerErrorException
     *         Internal service error
     * @throws ForbiddenException
     *         You do not have permission to list reservations
     * @throws BadGatewayException
     *         Bad gateway error
     * @throws GatewayTimeoutException
     *         Gateway timeout error
     * @throws TooManyRequestsException
     *         Request limit exceeded on list reservations request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.ListReservations
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListReservations" target="_top">AWS API
     *      Documentation</a>
     */
    default ListReservationsIterable listReservationsPaginator(ListReservationsRequest listReservationsRequest)
            throws BadRequestException, InternalServerErrorException, ForbiddenException, BadGatewayException,
            GatewayTimeoutException, TooManyRequestsException, AwsServiceException, SdkClientException, MediaLiveException {
        throw new UnsupportedOperationException();
    }

    /**
     * List purchased reservations.<br/>
     * <p>
     * This is a variant of
     * {@link #listReservations(software.amazon.awssdk.services.medialive.model.ListReservationsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.medialive.paginators.ListReservationsIterable responses = client.listReservationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.medialive.paginators.ListReservationsIterable responses = client
     *             .listReservationsPaginator(request);
     *     for (software.amazon.awssdk.services.medialive.model.ListReservationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.medialive.paginators.ListReservationsIterable responses = client.listReservationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listReservations(software.amazon.awssdk.services.medialive.model.ListReservationsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListReservationsRequest.Builder} avoiding the need
     * to create one manually via {@link ListReservationsRequest#builder()}
     * </p>
     *
     * @param listReservationsRequest
     *        A {@link Consumer} that will call methods on {@link ListReservationsRequest.Builder} to create a request.
     *        Placeholder documentation for ListReservationsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws BadRequestException
     *         This request was invalid
     * @throws InternalServerErrorException
     *         Internal service error
     * @throws ForbiddenException
     *         You do not have permission to list reservations
     * @throws BadGatewayException
     *         Bad gateway error
     * @throws GatewayTimeoutException
     *         Gateway timeout error
     * @throws TooManyRequestsException
     *         Request limit exceeded on list reservations request
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.ListReservations
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListReservations" target="_top">AWS API
     *      Documentation</a>
     */
    default ListReservationsIterable listReservationsPaginator(Consumer<ListReservationsRequest.Builder> listReservationsRequest)
            throws BadRequestException, InternalServerErrorException, ForbiddenException, BadGatewayException,
            GatewayTimeoutException, TooManyRequestsException, AwsServiceException, SdkClientException, MediaLiveException {
        return listReservationsPaginator(ListReservationsRequest.builder().applyMutation(listReservationsRequest).build());
    }

    /**
     * Produces list of tags that have been created for a resource
     *
     * @param listTagsForResourceRequest
     *        Placeholder documentation for ListTagsForResourceRequest
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws NotFoundException
     *         The arn was not found
     * @throws BadRequestException
     *         This request was invalid
     * @throws InternalServerErrorException
     *         Internal Service Error
     * @throws ForbiddenException
     *         Access was denied
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.ListTagsForResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListTagsForResource" target="_top">AWS
     *      API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest)
            throws NotFoundException, BadRequestException, InternalServerErrorException, ForbiddenException, AwsServiceException,
            SdkClientException, MediaLiveException {
        throw new UnsupportedOperationException();
    }

    /**
     * Produces list of tags that have been created for a resource<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on {@link ListTagsForResourceRequest.Builder} to create a
     *        request. Placeholder documentation for ListTagsForResourceRequest
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws NotFoundException
     *         The arn was not found
     * @throws BadRequestException
     *         This request was invalid
     * @throws InternalServerErrorException
     *         Internal Service Error
     * @throws ForbiddenException
     *         Access was denied
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.ListTagsForResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListTagsForResource" target="_top">AWS
     *      API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) throws NotFoundException,
            BadRequestException, InternalServerErrorException, ForbiddenException, AwsServiceException, SdkClientException,
            MediaLiveException {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * Purchase an offering and create a reservation.
     *
     * @param purchaseOfferingRequest
     *        Placeholder documentation for PurchaseOfferingRequest
     * @return Result of the PurchaseOffering operation returned by the service.
     * @throws BadRequestException
     *         This request was invalid
     * @throws InternalServerErrorException
     *         Internal service error
     * @throws ForbiddenException
     *         You do not have permission to purchase the offering
     * @throws BadGatewayException
     *         Bad gateway error
     * @throws NotFoundException
     *         Offering you're attempting to purchase does not exist
     * @throws GatewayTimeoutException
     *         Gateway timeout error
     * @throws TooManyRequestsException
     *         Request limit exceeded on purchase offering request
     * @throws ConflictException
     *         Offering purchase prevented by service resource issue
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.PurchaseOffering
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/PurchaseOffering" target="_top">AWS API
     *      Documentation</a>
     */
    default PurchaseOfferingResponse purchaseOffering(PurchaseOfferingRequest purchaseOfferingRequest)
            throws BadRequestException, InternalServerErrorException, ForbiddenException, BadGatewayException, NotFoundException,
            GatewayTimeoutException, TooManyRequestsException, ConflictException, AwsServiceException, SdkClientException,
            MediaLiveException {
        throw new UnsupportedOperationException();
    }

    /**
     * Purchase an offering and create a reservation.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PurchaseOfferingRequest.Builder} avoiding the need
     * to create one manually via {@link PurchaseOfferingRequest#builder()}
     * </p>
     *
     * @param purchaseOfferingRequest
     *        A {@link Consumer} that will call methods on {@link PurchaseOfferingRequest.Builder} to create a request.
     *        Placeholder documentation for PurchaseOfferingRequest
     * @return Result of the PurchaseOffering operation returned by the service.
     * @throws BadRequestException
     *         This request was invalid
     * @throws InternalServerErrorException
     *         Internal service error
     * @throws ForbiddenException
     *         You do not have permission to purchase the offering
     * @throws BadGatewayException
     *         Bad gateway error
     * @throws NotFoundException
     *         Offering you're attempting to purchase does not exist
     * @throws GatewayTimeoutException
     *         Gateway timeout error
     * @throws TooManyRequestsException
     *         Request limit exceeded on purchase offering request
     * @throws ConflictException
     *         Offering purchase prevented by service resource issue
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.PurchaseOffering
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/PurchaseOffering" target="_top">AWS API
     *      Documentation</a>
     */
    default PurchaseOfferingResponse purchaseOffering(Consumer<PurchaseOfferingRequest.Builder> purchaseOfferingRequest)
            throws BadRequestException, InternalServerErrorException, ForbiddenException, BadGatewayException, NotFoundException,
            GatewayTimeoutException, TooManyRequestsException, ConflictException, AwsServiceException, SdkClientException,
            MediaLiveException {
        return purchaseOffering(PurchaseOfferingRequest.builder().applyMutation(purchaseOfferingRequest).build());
    }

    /**
     * Starts an existing channel
     *
     * @param startChannelRequest
     *        Placeholder documentation for StartChannelRequest
     * @return Result of the StartChannel operation returned by the service.
     * @throws BadRequestException
     *         This request was invalid.
     * @throws InternalServerErrorException
     *         Unexpected internal service error.
     * @throws ForbiddenException
     *         You do not have permission to start the channel.
     * @throws BadGatewayException
     *         Bad Gateway Error
     * @throws NotFoundException
     *         The channel you're requesting to start does not exist.
     * @throws GatewayTimeoutException
     *         Gateway Timeout Error
     * @throws TooManyRequestsException
     *         Request limit exceeded on start channel calls to channel service.
     * @throws ConflictException
     *         The channel is unable to start due to an issue with channel resources.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.StartChannel
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/StartChannel" target="_top">AWS API
     *      Documentation</a>
     */
    default StartChannelResponse startChannel(StartChannelRequest startChannelRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, BadGatewayException, NotFoundException, GatewayTimeoutException,
            TooManyRequestsException, ConflictException, AwsServiceException, SdkClientException, MediaLiveException {
        throw new UnsupportedOperationException();
    }

    /**
     * Starts an existing channel<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartChannelRequest.Builder} avoiding the need to
     * create one manually via {@link StartChannelRequest#builder()}
     * </p>
     *
     * @param startChannelRequest
     *        A {@link Consumer} that will call methods on {@link StartChannelRequest.Builder} to create a request.
     *        Placeholder documentation for StartChannelRequest
     * @return Result of the StartChannel operation returned by the service.
     * @throws BadRequestException
     *         This request was invalid.
     * @throws InternalServerErrorException
     *         Unexpected internal service error.
     * @throws ForbiddenException
     *         You do not have permission to start the channel.
     * @throws BadGatewayException
     *         Bad Gateway Error
     * @throws NotFoundException
     *         The channel you're requesting to start does not exist.
     * @throws GatewayTimeoutException
     *         Gateway Timeout Error
     * @throws TooManyRequestsException
     *         Request limit exceeded on start channel calls to channel service.
     * @throws ConflictException
     *         The channel is unable to start due to an issue with channel resources.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.StartChannel
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/StartChannel" target="_top">AWS API
     *      Documentation</a>
     */
    default StartChannelResponse startChannel(Consumer<StartChannelRequest.Builder> startChannelRequest)
            throws BadRequestException, InternalServerErrorException, ForbiddenException, BadGatewayException, NotFoundException,
            GatewayTimeoutException, TooManyRequestsException, ConflictException, AwsServiceException, SdkClientException,
            MediaLiveException {
        return startChannel(StartChannelRequest.builder().applyMutation(startChannelRequest).build());
    }

    /**
     * Start (run) the multiplex. Starting the multiplex does not start the channels. You must explicitly start each
     * channel.
     *
     * @param startMultiplexRequest
     *        Placeholder documentation for StartMultiplexRequest
     * @return Result of the StartMultiplex operation returned by the service.
     * @throws BadRequestException
     *         MediaLive can't process your request because of a problem in the request. Please check your request form
     *         and syntax.
     * @throws InternalServerErrorException
     *         Unexpected internal service error.
     * @throws ForbiddenException
     *         You don't have permission to start the multiplex.
     * @throws BadGatewayException
     *         Bad Gateway Error.
     * @throws NotFoundException
     *         The multiplex that you are trying to start doesn’t exist. Check the ID and try again.
     * @throws GatewayTimeoutException
     *         Gateway Timeout Error.
     * @throws TooManyRequestsException
     *         Request limit exceeded on start multiplex calls to multiplex service.
     * @throws ConflictException
     *         The multiplex is unable to start due to an issue with multiplex resources.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.StartMultiplex
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/StartMultiplex" target="_top">AWS API
     *      Documentation</a>
     */
    default StartMultiplexResponse startMultiplex(StartMultiplexRequest startMultiplexRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, BadGatewayException, NotFoundException, GatewayTimeoutException,
            TooManyRequestsException, ConflictException, AwsServiceException, SdkClientException, MediaLiveException {
        throw new UnsupportedOperationException();
    }

    /**
     * Start (run) the multiplex. Starting the multiplex does not start the channels. You must explicitly start each
     * channel.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartMultiplexRequest.Builder} avoiding the need to
     * create one manually via {@link StartMultiplexRequest#builder()}
     * </p>
     *
     * @param startMultiplexRequest
     *        A {@link Consumer} that will call methods on {@link StartMultiplexRequest.Builder} to create a request.
     *        Placeholder documentation for StartMultiplexRequest
     * @return Result of the StartMultiplex operation returned by the service.
     * @throws BadRequestException
     *         MediaLive can't process your request because of a problem in the request. Please check your request form
     *         and syntax.
     * @throws InternalServerErrorException
     *         Unexpected internal service error.
     * @throws ForbiddenException
     *         You don't have permission to start the multiplex.
     * @throws BadGatewayException
     *         Bad Gateway Error.
     * @throws NotFoundException
     *         The multiplex that you are trying to start doesn’t exist. Check the ID and try again.
     * @throws GatewayTimeoutException
     *         Gateway Timeout Error.
     * @throws TooManyRequestsException
     *         Request limit exceeded on start multiplex calls to multiplex service.
     * @throws ConflictException
     *         The multiplex is unable to start due to an issue with multiplex resources.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.StartMultiplex
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/StartMultiplex" target="_top">AWS API
     *      Documentation</a>
     */
    default StartMultiplexResponse startMultiplex(Consumer<StartMultiplexRequest.Builder> startMultiplexRequest)
            throws BadRequestException, InternalServerErrorException, ForbiddenException, BadGatewayException, NotFoundException,
            GatewayTimeoutException, TooManyRequestsException, ConflictException, AwsServiceException, SdkClientException,
            MediaLiveException {
        return startMultiplex(StartMultiplexRequest.builder().applyMutation(startMultiplexRequest).build());
    }

    /**
     * Stops a running channel
     *
     * @param stopChannelRequest
     *        Placeholder documentation for StopChannelRequest
     * @return Result of the StopChannel operation returned by the service.
     * @throws BadRequestException
     *         This request was invalid.
     * @throws InternalServerErrorException
     *         Unexpected internal service error.
     * @throws ForbiddenException
     *         You do not have permission to stop the channel.
     * @throws BadGatewayException
     *         Bad Gateway Error
     * @throws NotFoundException
     *         The channel you're requesting to stop does not exist.
     * @throws GatewayTimeoutException
     *         Gateway Timeout Error
     * @throws TooManyRequestsException
     *         Request limit exceeded on stop channel calls to channel service.
     * @throws ConflictException
     *         The channel is unable to stop due to an issue with channel resources.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.StopChannel
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/StopChannel" target="_top">AWS API
     *      Documentation</a>
     */
    default StopChannelResponse stopChannel(StopChannelRequest stopChannelRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, BadGatewayException, NotFoundException, GatewayTimeoutException,
            TooManyRequestsException, ConflictException, AwsServiceException, SdkClientException, MediaLiveException {
        throw new UnsupportedOperationException();
    }

    /**
     * Stops a running channel<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StopChannelRequest.Builder} avoiding the need to
     * create one manually via {@link StopChannelRequest#builder()}
     * </p>
     *
     * @param stopChannelRequest
     *        A {@link Consumer} that will call methods on {@link StopChannelRequest.Builder} to create a request.
     *        Placeholder documentation for StopChannelRequest
     * @return Result of the StopChannel operation returned by the service.
     * @throws BadRequestException
     *         This request was invalid.
     * @throws InternalServerErrorException
     *         Unexpected internal service error.
     * @throws ForbiddenException
     *         You do not have permission to stop the channel.
     * @throws BadGatewayException
     *         Bad Gateway Error
     * @throws NotFoundException
     *         The channel you're requesting to stop does not exist.
     * @throws GatewayTimeoutException
     *         Gateway Timeout Error
     * @throws TooManyRequestsException
     *         Request limit exceeded on stop channel calls to channel service.
     * @throws ConflictException
     *         The channel is unable to stop due to an issue with channel resources.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.StopChannel
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/StopChannel" target="_top">AWS API
     *      Documentation</a>
     */
    default StopChannelResponse stopChannel(Consumer<StopChannelRequest.Builder> stopChannelRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, BadGatewayException, NotFoundException, GatewayTimeoutException,
            TooManyRequestsException, ConflictException, AwsServiceException, SdkClientException, MediaLiveException {
        return stopChannel(StopChannelRequest.builder().applyMutation(stopChannelRequest).build());
    }

    /**
     * Stops a running multiplex. If the multiplex isn't running, this action has no effect.
     *
     * @param stopMultiplexRequest
     *        Placeholder documentation for StopMultiplexRequest
     * @return Result of the StopMultiplex operation returned by the service.
     * @throws BadRequestException
     *         MediaLive can't process your request because of a problem in the request. Please check your request form
     *         and syntax.
     * @throws InternalServerErrorException
     *         Unexpected internal service error.
     * @throws ForbiddenException
     *         You don't have permission to stop the multiplex.
     * @throws BadGatewayException
     *         Bad Gateway Error.
     * @throws NotFoundException
     *         The multiplex that you are trying to stop doesn’t exist. Check the ID and try again.
     * @throws GatewayTimeoutException
     *         Gateway Timeout Error.
     * @throws TooManyRequestsException
     *         Request limit exceeded on stop multiplex calls to multiplex service.
     * @throws ConflictException
     *         The multiplex is unable to stop due to an issue with multiplex resources.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.StopMultiplex
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/StopMultiplex" target="_top">AWS API
     *      Documentation</a>
     */
    default StopMultiplexResponse stopMultiplex(StopMultiplexRequest stopMultiplexRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, BadGatewayException, NotFoundException, GatewayTimeoutException,
            TooManyRequestsException, ConflictException, AwsServiceException, SdkClientException, MediaLiveException {
        throw new UnsupportedOperationException();
    }

    /**
     * Stops a running multiplex. If the multiplex isn't running, this action has no effect.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StopMultiplexRequest.Builder} avoiding the need to
     * create one manually via {@link StopMultiplexRequest#builder()}
     * </p>
     *
     * @param stopMultiplexRequest
     *        A {@link Consumer} that will call methods on {@link StopMultiplexRequest.Builder} to create a request.
     *        Placeholder documentation for StopMultiplexRequest
     * @return Result of the StopMultiplex operation returned by the service.
     * @throws BadRequestException
     *         MediaLive can't process your request because of a problem in the request. Please check your request form
     *         and syntax.
     * @throws InternalServerErrorException
     *         Unexpected internal service error.
     * @throws ForbiddenException
     *         You don't have permission to stop the multiplex.
     * @throws BadGatewayException
     *         Bad Gateway Error.
     * @throws NotFoundException
     *         The multiplex that you are trying to stop doesn’t exist. Check the ID and try again.
     * @throws GatewayTimeoutException
     *         Gateway Timeout Error.
     * @throws TooManyRequestsException
     *         Request limit exceeded on stop multiplex calls to multiplex service.
     * @throws ConflictException
     *         The multiplex is unable to stop due to an issue with multiplex resources.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.StopMultiplex
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/StopMultiplex" target="_top">AWS API
     *      Documentation</a>
     */
    default StopMultiplexResponse stopMultiplex(Consumer<StopMultiplexRequest.Builder> stopMultiplexRequest)
            throws BadRequestException, InternalServerErrorException, ForbiddenException, BadGatewayException, NotFoundException,
            GatewayTimeoutException, TooManyRequestsException, ConflictException, AwsServiceException, SdkClientException,
            MediaLiveException {
        return stopMultiplex(StopMultiplexRequest.builder().applyMutation(stopMultiplexRequest).build());
    }

    /**
     * Updates a channel.
     *
     * @param updateChannelRequest
     *        A request to update a channel.
     * @return Result of the UpdateChannel operation returned by the service.
     * @throws BadRequestException
     *         This request was invalid.
     * @throws UnprocessableEntityException
     *         The channel configuration failed validation and could not be updated.
     * @throws InternalServerErrorException
     *         Unexpected internal service error.
     * @throws ForbiddenException
     *         You do not have permission to update the channel.
     * @throws BadGatewayException
     *         Bad Gateway Error
     * @throws GatewayTimeoutException
     *         Gateway Timeout Error
     * @throws ConflictException
     *         The channel is unable to update due to an issue with channel resources.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.UpdateChannel
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/UpdateChannel" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateChannelResponse updateChannel(UpdateChannelRequest updateChannelRequest) throws BadRequestException,
            UnprocessableEntityException, InternalServerErrorException, ForbiddenException, BadGatewayException,
            GatewayTimeoutException, ConflictException, AwsServiceException, SdkClientException, MediaLiveException {
        throw new UnsupportedOperationException();
    }

    /**
     * Updates a channel.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateChannelRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateChannelRequest#builder()}
     * </p>
     *
     * @param updateChannelRequest
     *        A {@link Consumer} that will call methods on {@link UpdateChannelRequest.Builder} to create a request. A
     *        request to update a channel.
     * @return Result of the UpdateChannel operation returned by the service.
     * @throws BadRequestException
     *         This request was invalid.
     * @throws UnprocessableEntityException
     *         The channel configuration failed validation and could not be updated.
     * @throws InternalServerErrorException
     *         Unexpected internal service error.
     * @throws ForbiddenException
     *         You do not have permission to update the channel.
     * @throws BadGatewayException
     *         Bad Gateway Error
     * @throws GatewayTimeoutException
     *         Gateway Timeout Error
     * @throws ConflictException
     *         The channel is unable to update due to an issue with channel resources.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.UpdateChannel
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/UpdateChannel" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateChannelResponse updateChannel(Consumer<UpdateChannelRequest.Builder> updateChannelRequest)
            throws BadRequestException, UnprocessableEntityException, InternalServerErrorException, ForbiddenException,
            BadGatewayException, GatewayTimeoutException, ConflictException, AwsServiceException, SdkClientException,
            MediaLiveException {
        return updateChannel(UpdateChannelRequest.builder().applyMutation(updateChannelRequest).build());
    }

    /**
     * Changes the class of the channel.
     *
     * @param updateChannelClassRequest
     *        Channel class that the channel should be updated to.
     * @return Result of the UpdateChannelClass operation returned by the service.
     * @throws BadRequestException
     *         This request to update the channel class was invalid.
     * @throws UnprocessableEntityException
     *         The channel configuration failed validation when attempting to update the channel class.
     * @throws InternalServerErrorException
     *         Unexpected internal service error.
     * @throws ForbiddenException
     *         You do not have permission to update the class of this channel.
     * @throws BadGatewayException
     *         Bad Gateway Error
     * @throws NotFoundException
     *         The channel you're trying to update the class on does not exist.
     * @throws GatewayTimeoutException
     *         Gateway Timeout Error
     * @throws TooManyRequestsException
     *         Request limit exceeded on update channel class calls.
     * @throws ConflictException
     *         The channel class cannot be updated due to an issue with channel resources.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.UpdateChannelClass
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/UpdateChannelClass" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdateChannelClassResponse updateChannelClass(UpdateChannelClassRequest updateChannelClassRequest)
            throws BadRequestException, UnprocessableEntityException, InternalServerErrorException, ForbiddenException,
            BadGatewayException, NotFoundException, GatewayTimeoutException, TooManyRequestsException, ConflictException,
            AwsServiceException, SdkClientException, MediaLiveException {
        throw new UnsupportedOperationException();
    }

    /**
     * Changes the class of the channel.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateChannelClassRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateChannelClassRequest#builder()}
     * </p>
     *
     * @param updateChannelClassRequest
     *        A {@link Consumer} that will call methods on {@link UpdateChannelClassRequest.Builder} to create a
     *        request. Channel class that the channel should be updated to.
     * @return Result of the UpdateChannelClass operation returned by the service.
     * @throws BadRequestException
     *         This request to update the channel class was invalid.
     * @throws UnprocessableEntityException
     *         The channel configuration failed validation when attempting to update the channel class.
     * @throws InternalServerErrorException
     *         Unexpected internal service error.
     * @throws ForbiddenException
     *         You do not have permission to update the class of this channel.
     * @throws BadGatewayException
     *         Bad Gateway Error
     * @throws NotFoundException
     *         The channel you're trying to update the class on does not exist.
     * @throws GatewayTimeoutException
     *         Gateway Timeout Error
     * @throws TooManyRequestsException
     *         Request limit exceeded on update channel class calls.
     * @throws ConflictException
     *         The channel class cannot be updated due to an issue with channel resources.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.UpdateChannelClass
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/UpdateChannelClass" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdateChannelClassResponse updateChannelClass(Consumer<UpdateChannelClassRequest.Builder> updateChannelClassRequest)
            throws BadRequestException, UnprocessableEntityException, InternalServerErrorException, ForbiddenException,
            BadGatewayException, NotFoundException, GatewayTimeoutException, TooManyRequestsException, ConflictException,
            AwsServiceException, SdkClientException, MediaLiveException {
        return updateChannelClass(UpdateChannelClassRequest.builder().applyMutation(updateChannelClassRequest).build());
    }

    /**
     * Updates an input.
     *
     * @param updateInputRequest
     *        A request to update an input.
     * @return Result of the UpdateInput operation returned by the service.
     * @throws BadRequestException
     *         This request to update the input was invalid.
     * @throws InternalServerErrorException
     *         Internal Service Error
     * @throws ForbiddenException
     *         The requester does not have permission to update an input.
     * @throws BadGatewayException
     *         Bad Gateway Error
     * @throws NotFoundException
     *         The input was not found.
     * @throws GatewayTimeoutException
     *         Gateway Timeout Error
     * @throws ConflictException
     *         The input was unable to be updated at this time due to an issue with input resources.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.UpdateInput
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/UpdateInput" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateInputResponse updateInput(UpdateInputRequest updateInputRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, BadGatewayException, NotFoundException, GatewayTimeoutException,
            ConflictException, AwsServiceException, SdkClientException, MediaLiveException {
        throw new UnsupportedOperationException();
    }

    /**
     * Updates an input.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateInputRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateInputRequest#builder()}
     * </p>
     *
     * @param updateInputRequest
     *        A {@link Consumer} that will call methods on {@link UpdateInputRequest.Builder} to create a request. A
     *        request to update an input.
     * @return Result of the UpdateInput operation returned by the service.
     * @throws BadRequestException
     *         This request to update the input was invalid.
     * @throws InternalServerErrorException
     *         Internal Service Error
     * @throws ForbiddenException
     *         The requester does not have permission to update an input.
     * @throws BadGatewayException
     *         Bad Gateway Error
     * @throws NotFoundException
     *         The input was not found.
     * @throws GatewayTimeoutException
     *         Gateway Timeout Error
     * @throws ConflictException
     *         The input was unable to be updated at this time due to an issue with input resources.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.UpdateInput
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/UpdateInput" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateInputResponse updateInput(Consumer<UpdateInputRequest.Builder> updateInputRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, BadGatewayException, NotFoundException, GatewayTimeoutException,
            ConflictException, AwsServiceException, SdkClientException, MediaLiveException {
        return updateInput(UpdateInputRequest.builder().applyMutation(updateInputRequest).build());
    }

    /**
     * Updates the parameters for the input device.
     *
     * @param updateInputDeviceRequest
     *        A request to update an input device.
     * @return Result of the UpdateInputDevice operation returned by the service.
     * @throws BadRequestException
     *         This request was invalid.
     * @throws UnprocessableEntityException
     *         Input device failed validation and could not be created.
     * @throws InternalServerErrorException
     *         Unexpected internal service error.
     * @throws ForbiddenException
     *         You do not have permission to update the input device.
     * @throws BadGatewayException
     *         Bad gateway error.
     * @throws NotFoundException
     *         The input device you're requesting to does not exist. Check the ID.
     * @throws GatewayTimeoutException
     *         Gateway timeout error.
     * @throws TooManyRequestsException
     *         Request limit exceeded on update calls to the input device service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.UpdateInputDevice
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/UpdateInputDevice" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdateInputDeviceResponse updateInputDevice(UpdateInputDeviceRequest updateInputDeviceRequest)
            throws BadRequestException, UnprocessableEntityException, InternalServerErrorException, ForbiddenException,
            BadGatewayException, NotFoundException, GatewayTimeoutException, TooManyRequestsException, AwsServiceException,
            SdkClientException, MediaLiveException {
        throw new UnsupportedOperationException();
    }

    /**
     * Updates the parameters for the input device.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateInputDeviceRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateInputDeviceRequest#builder()}
     * </p>
     *
     * @param updateInputDeviceRequest
     *        A {@link Consumer} that will call methods on {@link UpdateInputDeviceRequest.Builder} to create a request.
     *        A request to update an input device.
     * @return Result of the UpdateInputDevice operation returned by the service.
     * @throws BadRequestException
     *         This request was invalid.
     * @throws UnprocessableEntityException
     *         Input device failed validation and could not be created.
     * @throws InternalServerErrorException
     *         Unexpected internal service error.
     * @throws ForbiddenException
     *         You do not have permission to update the input device.
     * @throws BadGatewayException
     *         Bad gateway error.
     * @throws NotFoundException
     *         The input device you're requesting to does not exist. Check the ID.
     * @throws GatewayTimeoutException
     *         Gateway timeout error.
     * @throws TooManyRequestsException
     *         Request limit exceeded on update calls to the input device service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.UpdateInputDevice
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/UpdateInputDevice" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdateInputDeviceResponse updateInputDevice(Consumer<UpdateInputDeviceRequest.Builder> updateInputDeviceRequest)
            throws BadRequestException, UnprocessableEntityException, InternalServerErrorException, ForbiddenException,
            BadGatewayException, NotFoundException, GatewayTimeoutException, TooManyRequestsException, AwsServiceException,
            SdkClientException, MediaLiveException {
        return updateInputDevice(UpdateInputDeviceRequest.builder().applyMutation(updateInputDeviceRequest).build());
    }

    /**
     * Update an Input Security Group's Whilelists.
     *
     * @param updateInputSecurityGroupRequest
     *        The request to update some combination of the Input Security Group name and the IPv4 CIDRs the Input
     *        Security Group should allow.
     * @return Result of the UpdateInputSecurityGroup operation returned by the service.
     * @throws BadRequestException
     *         The request to update the Input Security Group was invalid
     * @throws InternalServerErrorException
     *         Internal Server Error
     * @throws ForbiddenException
     *         The requester does not have permission to update an Input Security Group
     * @throws BadGatewayException
     *         Bad Gateway Error
     * @throws NotFoundException
     *         The Input Security Group was not found.
     * @throws GatewayTimeoutException
     *         Gateway Timeout Error
     * @throws ConflictException
     *         The Input Security Group was unable to be updated due to an issue with input security group resources.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.UpdateInputSecurityGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/UpdateInputSecurityGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateInputSecurityGroupResponse updateInputSecurityGroup(
            UpdateInputSecurityGroupRequest updateInputSecurityGroupRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, BadGatewayException, NotFoundException, GatewayTimeoutException,
            ConflictException, AwsServiceException, SdkClientException, MediaLiveException {
        throw new UnsupportedOperationException();
    }

    /**
     * Update an Input Security Group's Whilelists.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateInputSecurityGroupRequest.Builder} avoiding
     * the need to create one manually via {@link UpdateInputSecurityGroupRequest#builder()}
     * </p>
     *
     * @param updateInputSecurityGroupRequest
     *        A {@link Consumer} that will call methods on {@link UpdateInputSecurityGroupRequest.Builder} to create a
     *        request. The request to update some combination of the Input Security Group name and the IPv4 CIDRs the
     *        Input Security Group should allow.
     * @return Result of the UpdateInputSecurityGroup operation returned by the service.
     * @throws BadRequestException
     *         The request to update the Input Security Group was invalid
     * @throws InternalServerErrorException
     *         Internal Server Error
     * @throws ForbiddenException
     *         The requester does not have permission to update an Input Security Group
     * @throws BadGatewayException
     *         Bad Gateway Error
     * @throws NotFoundException
     *         The Input Security Group was not found.
     * @throws GatewayTimeoutException
     *         Gateway Timeout Error
     * @throws ConflictException
     *         The Input Security Group was unable to be updated due to an issue with input security group resources.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.UpdateInputSecurityGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/UpdateInputSecurityGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateInputSecurityGroupResponse updateInputSecurityGroup(
            Consumer<UpdateInputSecurityGroupRequest.Builder> updateInputSecurityGroupRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, BadGatewayException, NotFoundException, GatewayTimeoutException,
            ConflictException, AwsServiceException, SdkClientException, MediaLiveException {
        return updateInputSecurityGroup(UpdateInputSecurityGroupRequest.builder().applyMutation(updateInputSecurityGroupRequest)
                .build());
    }

    /**
     * Updates a multiplex.
     *
     * @param updateMultiplexRequest
     *        A request to update a multiplex.
     * @return Result of the UpdateMultiplex operation returned by the service.
     * @throws BadRequestException
     *         MediaLive can't process your request because of a problem in the request. Please check your request form
     *         and syntax.
     * @throws UnprocessableEntityException
     *         The multiplex configuration failed validation and could not be updated.
     * @throws InternalServerErrorException
     *         Unexpected internal service error.
     * @throws ForbiddenException
     *         You don't have permission to update the multiplex.
     * @throws BadGatewayException
     *         Bad Gateway Error.
     * @throws NotFoundException
     *         The multiplex that you are trying to update doesn’t exist. Check the ID and try again.
     * @throws GatewayTimeoutException
     *         Gateway Timeout Error.
     * @throws ConflictException
     *         The multiplex is unable to update due to an issue with multiplex resources.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.UpdateMultiplex
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/UpdateMultiplex" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateMultiplexResponse updateMultiplex(UpdateMultiplexRequest updateMultiplexRequest) throws BadRequestException,
            UnprocessableEntityException, InternalServerErrorException, ForbiddenException, BadGatewayException,
            NotFoundException, GatewayTimeoutException, ConflictException, AwsServiceException, SdkClientException,
            MediaLiveException {
        throw new UnsupportedOperationException();
    }

    /**
     * Updates a multiplex.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateMultiplexRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateMultiplexRequest#builder()}
     * </p>
     *
     * @param updateMultiplexRequest
     *        A {@link Consumer} that will call methods on {@link UpdateMultiplexRequest.Builder} to create a request. A
     *        request to update a multiplex.
     * @return Result of the UpdateMultiplex operation returned by the service.
     * @throws BadRequestException
     *         MediaLive can't process your request because of a problem in the request. Please check your request form
     *         and syntax.
     * @throws UnprocessableEntityException
     *         The multiplex configuration failed validation and could not be updated.
     * @throws InternalServerErrorException
     *         Unexpected internal service error.
     * @throws ForbiddenException
     *         You don't have permission to update the multiplex.
     * @throws BadGatewayException
     *         Bad Gateway Error.
     * @throws NotFoundException
     *         The multiplex that you are trying to update doesn’t exist. Check the ID and try again.
     * @throws GatewayTimeoutException
     *         Gateway Timeout Error.
     * @throws ConflictException
     *         The multiplex is unable to update due to an issue with multiplex resources.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.UpdateMultiplex
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/UpdateMultiplex" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateMultiplexResponse updateMultiplex(Consumer<UpdateMultiplexRequest.Builder> updateMultiplexRequest)
            throws BadRequestException, UnprocessableEntityException, InternalServerErrorException, ForbiddenException,
            BadGatewayException, NotFoundException, GatewayTimeoutException, ConflictException, AwsServiceException,
            SdkClientException, MediaLiveException {
        return updateMultiplex(UpdateMultiplexRequest.builder().applyMutation(updateMultiplexRequest).build());
    }

    /**
     * Update a program in a multiplex.
     *
     * @param updateMultiplexProgramRequest
     *        A request to update a program in a multiplex.
     * @return Result of the UpdateMultiplexProgram operation returned by the service.
     * @throws BadRequestException
     *         MediaLive can't process your request because of a problem in the request. Please check your request form
     *         and syntax.
     * @throws UnprocessableEntityException
     *         The multiplex program failed validation and could not be updated.
     * @throws InternalServerErrorException
     *         Unexpected internal service error.
     * @throws ForbiddenException
     *         You don't have permission to update the multiplex program.
     * @throws BadGatewayException
     *         Bad Gateway Error.
     * @throws NotFoundException
     *         MediaLive can't update the program. The multiplex or the program that you specified doesn’t exist. Check
     *         the IDs and try again.
     * @throws GatewayTimeoutException
     *         Gateway Timeout Error.
     * @throws ConflictException
     *         The multiplex program is unable to update due to an issue with multiplex resources.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.UpdateMultiplexProgram
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/UpdateMultiplexProgram"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateMultiplexProgramResponse updateMultiplexProgram(UpdateMultiplexProgramRequest updateMultiplexProgramRequest)
            throws BadRequestException, UnprocessableEntityException, InternalServerErrorException, ForbiddenException,
            BadGatewayException, NotFoundException, GatewayTimeoutException, ConflictException, AwsServiceException,
            SdkClientException, MediaLiveException {
        throw new UnsupportedOperationException();
    }

    /**
     * Update a program in a multiplex.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateMultiplexProgramRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateMultiplexProgramRequest#builder()}
     * </p>
     *
     * @param updateMultiplexProgramRequest
     *        A {@link Consumer} that will call methods on {@link UpdateMultiplexProgramRequest.Builder} to create a
     *        request. A request to update a program in a multiplex.
     * @return Result of the UpdateMultiplexProgram operation returned by the service.
     * @throws BadRequestException
     *         MediaLive can't process your request because of a problem in the request. Please check your request form
     *         and syntax.
     * @throws UnprocessableEntityException
     *         The multiplex program failed validation and could not be updated.
     * @throws InternalServerErrorException
     *         Unexpected internal service error.
     * @throws ForbiddenException
     *         You don't have permission to update the multiplex program.
     * @throws BadGatewayException
     *         Bad Gateway Error.
     * @throws NotFoundException
     *         MediaLive can't update the program. The multiplex or the program that you specified doesn’t exist. Check
     *         the IDs and try again.
     * @throws GatewayTimeoutException
     *         Gateway Timeout Error.
     * @throws ConflictException
     *         The multiplex program is unable to update due to an issue with multiplex resources.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.UpdateMultiplexProgram
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/UpdateMultiplexProgram"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateMultiplexProgramResponse updateMultiplexProgram(
            Consumer<UpdateMultiplexProgramRequest.Builder> updateMultiplexProgramRequest) throws BadRequestException,
            UnprocessableEntityException, InternalServerErrorException, ForbiddenException, BadGatewayException,
            NotFoundException, GatewayTimeoutException, ConflictException, AwsServiceException, SdkClientException,
            MediaLiveException {
        return updateMultiplexProgram(UpdateMultiplexProgramRequest.builder().applyMutation(updateMultiplexProgramRequest)
                .build());
    }

    /**
     * Update reservation.
     *
     * @param updateReservationRequest
     *        Request to update a reservation
     * @return Result of the UpdateReservation operation returned by the service.
     * @throws BadRequestException
     *         This request was invalid
     * @throws InternalServerErrorException
     *         Internal service error
     * @throws ForbiddenException
     *         You do not have permission to update reservation
     * @throws BadGatewayException
     *         Bad gateway error
     * @throws NotFoundException
     *         Reservation not found
     * @throws GatewayTimeoutException
     *         Gateway timeout error
     * @throws TooManyRequestsException
     *         Request limit exceeded
     * @throws ConflictException
     *         The reservation could not be updated
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.UpdateReservation
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/UpdateReservation" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdateReservationResponse updateReservation(UpdateReservationRequest updateReservationRequest)
            throws BadRequestException, InternalServerErrorException, ForbiddenException, BadGatewayException, NotFoundException,
            GatewayTimeoutException, TooManyRequestsException, ConflictException, AwsServiceException, SdkClientException,
            MediaLiveException {
        throw new UnsupportedOperationException();
    }

    /**
     * Update reservation.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateReservationRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateReservationRequest#builder()}
     * </p>
     *
     * @param updateReservationRequest
     *        A {@link Consumer} that will call methods on {@link UpdateReservationRequest.Builder} to create a request.
     *        Request to update a reservation
     * @return Result of the UpdateReservation operation returned by the service.
     * @throws BadRequestException
     *         This request was invalid
     * @throws InternalServerErrorException
     *         Internal service error
     * @throws ForbiddenException
     *         You do not have permission to update reservation
     * @throws BadGatewayException
     *         Bad gateway error
     * @throws NotFoundException
     *         Reservation not found
     * @throws GatewayTimeoutException
     *         Gateway timeout error
     * @throws TooManyRequestsException
     *         Request limit exceeded
     * @throws ConflictException
     *         The reservation could not be updated
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaLiveException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaLiveClient.UpdateReservation
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/UpdateReservation" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdateReservationResponse updateReservation(Consumer<UpdateReservationRequest.Builder> updateReservationRequest)
            throws BadRequestException, InternalServerErrorException, ForbiddenException, BadGatewayException, NotFoundException,
            GatewayTimeoutException, TooManyRequestsException, ConflictException, AwsServiceException, SdkClientException,
            MediaLiveException {
        return updateReservation(UpdateReservationRequest.builder().applyMutation(updateReservationRequest).build());
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of("medialive");
    }
}
