/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.services.medialive.model.BatchUpdateScheduleRequest;
import software.amazon.awssdk.services.medialive.model.BatchUpdateScheduleResponse;
import software.amazon.awssdk.services.medialive.model.CreateChannelRequest;
import software.amazon.awssdk.services.medialive.model.CreateChannelResponse;
import software.amazon.awssdk.services.medialive.model.CreateInputRequest;
import software.amazon.awssdk.services.medialive.model.CreateInputResponse;
import software.amazon.awssdk.services.medialive.model.CreateInputSecurityGroupRequest;
import software.amazon.awssdk.services.medialive.model.CreateInputSecurityGroupResponse;
import software.amazon.awssdk.services.medialive.model.CreateMultiplexProgramRequest;
import software.amazon.awssdk.services.medialive.model.CreateMultiplexProgramResponse;
import software.amazon.awssdk.services.medialive.model.CreateMultiplexRequest;
import software.amazon.awssdk.services.medialive.model.CreateMultiplexResponse;
import software.amazon.awssdk.services.medialive.model.CreateTagsRequest;
import software.amazon.awssdk.services.medialive.model.CreateTagsResponse;
import software.amazon.awssdk.services.medialive.model.DeleteChannelRequest;
import software.amazon.awssdk.services.medialive.model.DeleteChannelResponse;
import software.amazon.awssdk.services.medialive.model.DeleteInputRequest;
import software.amazon.awssdk.services.medialive.model.DeleteInputResponse;
import software.amazon.awssdk.services.medialive.model.DeleteInputSecurityGroupRequest;
import software.amazon.awssdk.services.medialive.model.DeleteInputSecurityGroupResponse;
import software.amazon.awssdk.services.medialive.model.DeleteMultiplexProgramRequest;
import software.amazon.awssdk.services.medialive.model.DeleteMultiplexProgramResponse;
import software.amazon.awssdk.services.medialive.model.DeleteMultiplexRequest;
import software.amazon.awssdk.services.medialive.model.DeleteMultiplexResponse;
import software.amazon.awssdk.services.medialive.model.DeleteReservationRequest;
import software.amazon.awssdk.services.medialive.model.DeleteReservationResponse;
import software.amazon.awssdk.services.medialive.model.DeleteScheduleRequest;
import software.amazon.awssdk.services.medialive.model.DeleteScheduleResponse;
import software.amazon.awssdk.services.medialive.model.DeleteTagsRequest;
import software.amazon.awssdk.services.medialive.model.DeleteTagsResponse;
import software.amazon.awssdk.services.medialive.model.DescribeChannelRequest;
import software.amazon.awssdk.services.medialive.model.DescribeChannelResponse;
import software.amazon.awssdk.services.medialive.model.DescribeInputDeviceRequest;
import software.amazon.awssdk.services.medialive.model.DescribeInputDeviceResponse;
import software.amazon.awssdk.services.medialive.model.DescribeInputRequest;
import software.amazon.awssdk.services.medialive.model.DescribeInputResponse;
import software.amazon.awssdk.services.medialive.model.DescribeInputSecurityGroupRequest;
import software.amazon.awssdk.services.medialive.model.DescribeInputSecurityGroupResponse;
import software.amazon.awssdk.services.medialive.model.DescribeMultiplexProgramRequest;
import software.amazon.awssdk.services.medialive.model.DescribeMultiplexProgramResponse;
import software.amazon.awssdk.services.medialive.model.DescribeMultiplexRequest;
import software.amazon.awssdk.services.medialive.model.DescribeMultiplexResponse;
import software.amazon.awssdk.services.medialive.model.DescribeOfferingRequest;
import software.amazon.awssdk.services.medialive.model.DescribeOfferingResponse;
import software.amazon.awssdk.services.medialive.model.DescribeReservationRequest;
import software.amazon.awssdk.services.medialive.model.DescribeReservationResponse;
import software.amazon.awssdk.services.medialive.model.DescribeScheduleRequest;
import software.amazon.awssdk.services.medialive.model.DescribeScheduleResponse;
import software.amazon.awssdk.services.medialive.model.ListChannelsRequest;
import software.amazon.awssdk.services.medialive.model.ListChannelsResponse;
import software.amazon.awssdk.services.medialive.model.ListInputDevicesRequest;
import software.amazon.awssdk.services.medialive.model.ListInputDevicesResponse;
import software.amazon.awssdk.services.medialive.model.ListInputSecurityGroupsRequest;
import software.amazon.awssdk.services.medialive.model.ListInputSecurityGroupsResponse;
import software.amazon.awssdk.services.medialive.model.ListInputsRequest;
import software.amazon.awssdk.services.medialive.model.ListInputsResponse;
import software.amazon.awssdk.services.medialive.model.ListMultiplexProgramsRequest;
import software.amazon.awssdk.services.medialive.model.ListMultiplexProgramsResponse;
import software.amazon.awssdk.services.medialive.model.ListMultiplexesRequest;
import software.amazon.awssdk.services.medialive.model.ListMultiplexesResponse;
import software.amazon.awssdk.services.medialive.model.ListOfferingsRequest;
import software.amazon.awssdk.services.medialive.model.ListOfferingsResponse;
import software.amazon.awssdk.services.medialive.model.ListReservationsRequest;
import software.amazon.awssdk.services.medialive.model.ListReservationsResponse;
import software.amazon.awssdk.services.medialive.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.medialive.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.medialive.model.PurchaseOfferingRequest;
import software.amazon.awssdk.services.medialive.model.PurchaseOfferingResponse;
import software.amazon.awssdk.services.medialive.model.StartChannelRequest;
import software.amazon.awssdk.services.medialive.model.StartChannelResponse;
import software.amazon.awssdk.services.medialive.model.StartMultiplexRequest;
import software.amazon.awssdk.services.medialive.model.StartMultiplexResponse;
import software.amazon.awssdk.services.medialive.model.StopChannelRequest;
import software.amazon.awssdk.services.medialive.model.StopChannelResponse;
import software.amazon.awssdk.services.medialive.model.StopMultiplexRequest;
import software.amazon.awssdk.services.medialive.model.StopMultiplexResponse;
import software.amazon.awssdk.services.medialive.model.UpdateChannelClassRequest;
import software.amazon.awssdk.services.medialive.model.UpdateChannelClassResponse;
import software.amazon.awssdk.services.medialive.model.UpdateChannelRequest;
import software.amazon.awssdk.services.medialive.model.UpdateChannelResponse;
import software.amazon.awssdk.services.medialive.model.UpdateInputDeviceRequest;
import software.amazon.awssdk.services.medialive.model.UpdateInputDeviceResponse;
import software.amazon.awssdk.services.medialive.model.UpdateInputRequest;
import software.amazon.awssdk.services.medialive.model.UpdateInputResponse;
import software.amazon.awssdk.services.medialive.model.UpdateInputSecurityGroupRequest;
import software.amazon.awssdk.services.medialive.model.UpdateInputSecurityGroupResponse;
import software.amazon.awssdk.services.medialive.model.UpdateMultiplexProgramRequest;
import software.amazon.awssdk.services.medialive.model.UpdateMultiplexProgramResponse;
import software.amazon.awssdk.services.medialive.model.UpdateMultiplexRequest;
import software.amazon.awssdk.services.medialive.model.UpdateMultiplexResponse;
import software.amazon.awssdk.services.medialive.model.UpdateReservationRequest;
import software.amazon.awssdk.services.medialive.model.UpdateReservationResponse;
import software.amazon.awssdk.services.medialive.paginators.DescribeSchedulePublisher;
import software.amazon.awssdk.services.medialive.paginators.ListChannelsPublisher;
import software.amazon.awssdk.services.medialive.paginators.ListInputDevicesPublisher;
import software.amazon.awssdk.services.medialive.paginators.ListInputSecurityGroupsPublisher;
import software.amazon.awssdk.services.medialive.paginators.ListInputsPublisher;
import software.amazon.awssdk.services.medialive.paginators.ListMultiplexProgramsPublisher;
import software.amazon.awssdk.services.medialive.paginators.ListMultiplexesPublisher;
import software.amazon.awssdk.services.medialive.paginators.ListOfferingsPublisher;
import software.amazon.awssdk.services.medialive.paginators.ListReservationsPublisher;

/**
 * Service client for accessing MediaLive asynchronously. This can be created using the static {@link #builder()}
 * method.
 *
 * API for AWS Elemental MediaLive
 */
@Generated("software.amazon.awssdk:codegen")
public interface MediaLiveAsyncClient extends SdkClient {
    String SERVICE_NAME = "medialive";

    /**
     * Create a {@link MediaLiveAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static MediaLiveAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link MediaLiveAsyncClient}.
     */
    static MediaLiveAsyncClientBuilder builder() {
        return new DefaultMediaLiveAsyncClientBuilder();
    }

    /**
     * Update a channel schedule
     *
     * @param batchUpdateScheduleRequest
     *        List of actions to create and list of actions to delete.
     * @return A Java Future containing the result of the BatchUpdateSchedule operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException This request was invalid.</li>
     *         <li>UnprocessableEntityException The update schedule request failed validation.</li>
     *         <li>InternalServerErrorException Unexpected internal service error.</li>
     *         <li>ForbiddenException You do not have permission to update the channel schedule.</li>
     *         <li>BadGatewayException Bad Gateway Error</li>
     *         <li>NotFoundException The specified channel id does not exist.</li>
     *         <li>GatewayTimeoutException Gateway Timeout Error</li>
     *         <li>TooManyRequestsException Request limit exceeded on update schedule calls.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.BatchUpdateSchedule
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/BatchUpdateSchedule" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<BatchUpdateScheduleResponse> batchUpdateSchedule(
            BatchUpdateScheduleRequest batchUpdateScheduleRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Update a channel schedule<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchUpdateScheduleRequest.Builder} avoiding the
     * need to create one manually via {@link BatchUpdateScheduleRequest#builder()}
     * </p>
     *
     * @param batchUpdateScheduleRequest
     *        A {@link Consumer} that will call methods on {@link BatchUpdateScheduleRequest.Builder} to create a
     *        request. List of actions to create and list of actions to delete.
     * @return A Java Future containing the result of the BatchUpdateSchedule operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException This request was invalid.</li>
     *         <li>UnprocessableEntityException The update schedule request failed validation.</li>
     *         <li>InternalServerErrorException Unexpected internal service error.</li>
     *         <li>ForbiddenException You do not have permission to update the channel schedule.</li>
     *         <li>BadGatewayException Bad Gateway Error</li>
     *         <li>NotFoundException The specified channel id does not exist.</li>
     *         <li>GatewayTimeoutException Gateway Timeout Error</li>
     *         <li>TooManyRequestsException Request limit exceeded on update schedule calls.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.BatchUpdateSchedule
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/BatchUpdateSchedule" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<BatchUpdateScheduleResponse> batchUpdateSchedule(
            Consumer<BatchUpdateScheduleRequest.Builder> batchUpdateScheduleRequest) {
        return batchUpdateSchedule(BatchUpdateScheduleRequest.builder().applyMutation(batchUpdateScheduleRequest).build());
    }

    /**
     * Creates a new channel
     *
     * @param createChannelRequest
     *        A request to create a channel
     * @return A Java Future containing the result of the CreateChannel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException This request was invalid.</li>
     *         <li>UnprocessableEntityException The Channel failed validation and could not be created.</li>
     *         <li>InternalServerErrorException Unexpected internal service error.</li>
     *         <li>ForbiddenException You do not have permission to create the channel.</li>
     *         <li>BadGatewayException Bad Gateway Error</li>
     *         <li>GatewayTimeoutException Gateway Timeout Error</li>
     *         <li>TooManyRequestsException Request limit exceeded on create channel calls to channel service.</li>
     *         <li>ConflictException The channel is unable to create due to an issue with channel resources.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.CreateChannel
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/CreateChannel" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateChannelResponse> createChannel(CreateChannelRequest createChannelRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Creates a new channel<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateChannelRequest.Builder} avoiding the need to
     * create one manually via {@link CreateChannelRequest#builder()}
     * </p>
     *
     * @param createChannelRequest
     *        A {@link Consumer} that will call methods on {@link CreateChannelRequest.Builder} to create a request. A
     *        request to create a channel
     * @return A Java Future containing the result of the CreateChannel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException This request was invalid.</li>
     *         <li>UnprocessableEntityException The Channel failed validation and could not be created.</li>
     *         <li>InternalServerErrorException Unexpected internal service error.</li>
     *         <li>ForbiddenException You do not have permission to create the channel.</li>
     *         <li>BadGatewayException Bad Gateway Error</li>
     *         <li>GatewayTimeoutException Gateway Timeout Error</li>
     *         <li>TooManyRequestsException Request limit exceeded on create channel calls to channel service.</li>
     *         <li>ConflictException The channel is unable to create due to an issue with channel resources.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.CreateChannel
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/CreateChannel" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateChannelResponse> createChannel(Consumer<CreateChannelRequest.Builder> createChannelRequest) {
        return createChannel(CreateChannelRequest.builder().applyMutation(createChannelRequest).build());
    }

    /**
     * Create an input
     *
     * @param createInputRequest
     *        The name of the input
     * @return A Java Future containing the result of the CreateInput operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException This request was invalid</li>
     *         <li>InternalServerErrorException Internal Service Error</li>
     *         <li>ForbiddenException Access was denied</li>
     *         <li>BadGatewayException Bad Gateway Error</li>
     *         <li>GatewayTimeoutException Gateway Timeout Error</li>
     *         <li>TooManyRequestsException Limit exceeded</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.CreateInput
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/CreateInput" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateInputResponse> createInput(CreateInputRequest createInputRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Create an input<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateInputRequest.Builder} avoiding the need to
     * create one manually via {@link CreateInputRequest#builder()}
     * </p>
     *
     * @param createInputRequest
     *        A {@link Consumer} that will call methods on {@link CreateInputRequest.Builder} to create a request. The
     *        name of the input
     * @return A Java Future containing the result of the CreateInput operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException This request was invalid</li>
     *         <li>InternalServerErrorException Internal Service Error</li>
     *         <li>ForbiddenException Access was denied</li>
     *         <li>BadGatewayException Bad Gateway Error</li>
     *         <li>GatewayTimeoutException Gateway Timeout Error</li>
     *         <li>TooManyRequestsException Limit exceeded</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.CreateInput
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/CreateInput" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateInputResponse> createInput(Consumer<CreateInputRequest.Builder> createInputRequest) {
        return createInput(CreateInputRequest.builder().applyMutation(createInputRequest).build());
    }

    /**
     * Creates a Input Security Group
     *
     * @param createInputSecurityGroupRequest
     *        The IPv4 CIDRs to whitelist for this Input Security Group
     * @return A Java Future containing the result of the CreateInputSecurityGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request to create an Input Security Group was Invalid</li>
     *         <li>InternalServerErrorException Internal Server Error</li>
     *         <li>ForbiddenException The requester does not have permission to create an Input Security Group</li>
     *         <li>BadGatewayException Bad Gateway Error</li>
     *         <li>GatewayTimeoutException Gateway Timeout Error</li>
     *         <li>TooManyRequestsException Limit Exceeded Error</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.CreateInputSecurityGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/CreateInputSecurityGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateInputSecurityGroupResponse> createInputSecurityGroup(
            CreateInputSecurityGroupRequest createInputSecurityGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Creates a Input Security Group<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateInputSecurityGroupRequest.Builder} avoiding
     * the need to create one manually via {@link CreateInputSecurityGroupRequest#builder()}
     * </p>
     *
     * @param createInputSecurityGroupRequest
     *        A {@link Consumer} that will call methods on {@link CreateInputSecurityGroupRequest.Builder} to create a
     *        request. The IPv4 CIDRs to whitelist for this Input Security Group
     * @return A Java Future containing the result of the CreateInputSecurityGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request to create an Input Security Group was Invalid</li>
     *         <li>InternalServerErrorException Internal Server Error</li>
     *         <li>ForbiddenException The requester does not have permission to create an Input Security Group</li>
     *         <li>BadGatewayException Bad Gateway Error</li>
     *         <li>GatewayTimeoutException Gateway Timeout Error</li>
     *         <li>TooManyRequestsException Limit Exceeded Error</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.CreateInputSecurityGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/CreateInputSecurityGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateInputSecurityGroupResponse> createInputSecurityGroup(
            Consumer<CreateInputSecurityGroupRequest.Builder> createInputSecurityGroupRequest) {
        return createInputSecurityGroup(CreateInputSecurityGroupRequest.builder().applyMutation(createInputSecurityGroupRequest)
                .build());
    }

    /**
     * Create a new multiplex.
     *
     * @param createMultiplexRequest
     *        A request to create a multiplex.
     * @return A Java Future containing the result of the CreateMultiplex operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException MediaLive can't process your request because of a problem in the request. Please
     *         check your request form and syntax.</li>
     *         <li>UnprocessableEntityException The Multiplex failed validation and could not be created.</li>
     *         <li>InternalServerErrorException Unexpected internal service error.</li>
     *         <li>ForbiddenException You don't have permission to create the multiplex.</li>
     *         <li>BadGatewayException Bad Gateway Error.</li>
     *         <li>GatewayTimeoutException Gateway Timeout Error.</li>
     *         <li>TooManyRequestsException Request limit exceeded on create multiplex calls to multiplex service.</li>
     *         <li>ConflictException The multiplex is unable to create due to an issue with multiplex resources.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.CreateMultiplex
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/CreateMultiplex" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateMultiplexResponse> createMultiplex(CreateMultiplexRequest createMultiplexRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Create a new multiplex.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateMultiplexRequest.Builder} avoiding the need
     * to create one manually via {@link CreateMultiplexRequest#builder()}
     * </p>
     *
     * @param createMultiplexRequest
     *        A {@link Consumer} that will call methods on {@link CreateMultiplexRequest.Builder} to create a request. A
     *        request to create a multiplex.
     * @return A Java Future containing the result of the CreateMultiplex operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException MediaLive can't process your request because of a problem in the request. Please
     *         check your request form and syntax.</li>
     *         <li>UnprocessableEntityException The Multiplex failed validation and could not be created.</li>
     *         <li>InternalServerErrorException Unexpected internal service error.</li>
     *         <li>ForbiddenException You don't have permission to create the multiplex.</li>
     *         <li>BadGatewayException Bad Gateway Error.</li>
     *         <li>GatewayTimeoutException Gateway Timeout Error.</li>
     *         <li>TooManyRequestsException Request limit exceeded on create multiplex calls to multiplex service.</li>
     *         <li>ConflictException The multiplex is unable to create due to an issue with multiplex resources.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.CreateMultiplex
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/CreateMultiplex" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateMultiplexResponse> createMultiplex(
            Consumer<CreateMultiplexRequest.Builder> createMultiplexRequest) {
        return createMultiplex(CreateMultiplexRequest.builder().applyMutation(createMultiplexRequest).build());
    }

    /**
     * Create a new program in the multiplex.
     *
     * @param createMultiplexProgramRequest
     *        A request to create a program in a multiplex.
     * @return A Java Future containing the result of the CreateMultiplexProgram operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException MediaLive can't process your request because of a problem in the request. Please
     *         check your request form and syntax.</li>
     *         <li>UnprocessableEntityException The Multiplex program failed validation and could not be created.</li>
     *         <li>InternalServerErrorException Unexpected internal service error.</li>
     *         <li>ForbiddenException You do not have permission to create a program.</li>
     *         <li>BadGatewayException Bad Gateway Error.</li>
     *         <li>GatewayTimeoutException Gateway Timeout Error.</li>
     *         <li>TooManyRequestsException Request limit exceeded on create multiplex program calls to multiplex
     *         service.</li>
     *         <li>ConflictException The multiplex program is unable to create due to an issue with multiplex resources.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.CreateMultiplexProgram
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/CreateMultiplexProgram"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateMultiplexProgramResponse> createMultiplexProgram(
            CreateMultiplexProgramRequest createMultiplexProgramRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Create a new program in the multiplex.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateMultiplexProgramRequest.Builder} avoiding the
     * need to create one manually via {@link CreateMultiplexProgramRequest#builder()}
     * </p>
     *
     * @param createMultiplexProgramRequest
     *        A {@link Consumer} that will call methods on {@link CreateMultiplexProgramRequest.Builder} to create a
     *        request. A request to create a program in a multiplex.
     * @return A Java Future containing the result of the CreateMultiplexProgram operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException MediaLive can't process your request because of a problem in the request. Please
     *         check your request form and syntax.</li>
     *         <li>UnprocessableEntityException The Multiplex program failed validation and could not be created.</li>
     *         <li>InternalServerErrorException Unexpected internal service error.</li>
     *         <li>ForbiddenException You do not have permission to create a program.</li>
     *         <li>BadGatewayException Bad Gateway Error.</li>
     *         <li>GatewayTimeoutException Gateway Timeout Error.</li>
     *         <li>TooManyRequestsException Request limit exceeded on create multiplex program calls to multiplex
     *         service.</li>
     *         <li>ConflictException The multiplex program is unable to create due to an issue with multiplex resources.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.CreateMultiplexProgram
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/CreateMultiplexProgram"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateMultiplexProgramResponse> createMultiplexProgram(
            Consumer<CreateMultiplexProgramRequest.Builder> createMultiplexProgramRequest) {
        return createMultiplexProgram(CreateMultiplexProgramRequest.builder().applyMutation(createMultiplexProgramRequest)
                .build());
    }

    /**
     * Create tags for a resource
     *
     * @param createTagsRequest
     *        Placeholder documentation for CreateTagsRequest
     * @return A Java Future containing the result of the CreateTags operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The arn was not found.</li>
     *         <li>BadRequestException This request was invalid</li>
     *         <li>InternalServerErrorException Internal Service Error</li>
     *         <li>ForbiddenException Access was denied</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.CreateTags
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/CreateTags" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateTagsResponse> createTags(CreateTagsRequest createTagsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Create tags for a resource<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateTagsRequest.Builder} avoiding the need to
     * create one manually via {@link CreateTagsRequest#builder()}
     * </p>
     *
     * @param createTagsRequest
     *        A {@link Consumer} that will call methods on {@link CreateTagsRequest.Builder} to create a request.
     *        Placeholder documentation for CreateTagsRequest
     * @return A Java Future containing the result of the CreateTags operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The arn was not found.</li>
     *         <li>BadRequestException This request was invalid</li>
     *         <li>InternalServerErrorException Internal Service Error</li>
     *         <li>ForbiddenException Access was denied</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.CreateTags
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/CreateTags" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateTagsResponse> createTags(Consumer<CreateTagsRequest.Builder> createTagsRequest) {
        return createTags(CreateTagsRequest.builder().applyMutation(createTagsRequest).build());
    }

    /**
     * Starts deletion of channel. The associated outputs are also deleted.
     *
     * @param deleteChannelRequest
     *        Placeholder documentation for DeleteChannelRequest
     * @return A Java Future containing the result of the DeleteChannel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException This request was invalid</li>
     *         <li>InternalServerErrorException Unexpected internal service error.</li>
     *         <li>ForbiddenException You do not have permission to delete the channel.</li>
     *         <li>BadGatewayException Bad Gateway Error</li>
     *         <li>NotFoundException The channel you're requesting to delete does not exist.</li>
     *         <li>GatewayTimeoutException Gateway Timeout Error</li>
     *         <li>TooManyRequestsException Request limit exceeded on delete channel calls to channel service.</li>
     *         <li>ConflictException The channel is unable to delete due to an issue with channel resources.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.DeleteChannel
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DeleteChannel" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteChannelResponse> deleteChannel(DeleteChannelRequest deleteChannelRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Starts deletion of channel. The associated outputs are also deleted.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteChannelRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteChannelRequest#builder()}
     * </p>
     *
     * @param deleteChannelRequest
     *        A {@link Consumer} that will call methods on {@link DeleteChannelRequest.Builder} to create a request.
     *        Placeholder documentation for DeleteChannelRequest
     * @return A Java Future containing the result of the DeleteChannel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException This request was invalid</li>
     *         <li>InternalServerErrorException Unexpected internal service error.</li>
     *         <li>ForbiddenException You do not have permission to delete the channel.</li>
     *         <li>BadGatewayException Bad Gateway Error</li>
     *         <li>NotFoundException The channel you're requesting to delete does not exist.</li>
     *         <li>GatewayTimeoutException Gateway Timeout Error</li>
     *         <li>TooManyRequestsException Request limit exceeded on delete channel calls to channel service.</li>
     *         <li>ConflictException The channel is unable to delete due to an issue with channel resources.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.DeleteChannel
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DeleteChannel" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteChannelResponse> deleteChannel(Consumer<DeleteChannelRequest.Builder> deleteChannelRequest) {
        return deleteChannel(DeleteChannelRequest.builder().applyMutation(deleteChannelRequest).build());
    }

    /**
     * Deletes the input end point
     *
     * @param deleteInputRequest
     *        Placeholder documentation for DeleteInputRequest
     * @return A Java Future containing the result of the DeleteInput operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException This request was invalid</li>
     *         <li>InternalServerErrorException Internal Service Error</li>
     *         <li>ForbiddenException Access was denied</li>
     *         <li>BadGatewayException Bad Gateway Error</li>
     *         <li>NotFoundException Input not found</li>
     *         <li>GatewayTimeoutException Gateway Timeout Error</li>
     *         <li>TooManyRequestsException Limit exceeded</li>
     *         <li>ConflictException Resource conflict</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.DeleteInput
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DeleteInput" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteInputResponse> deleteInput(DeleteInputRequest deleteInputRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Deletes the input end point<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteInputRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteInputRequest#builder()}
     * </p>
     *
     * @param deleteInputRequest
     *        A {@link Consumer} that will call methods on {@link DeleteInputRequest.Builder} to create a request.
     *        Placeholder documentation for DeleteInputRequest
     * @return A Java Future containing the result of the DeleteInput operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException This request was invalid</li>
     *         <li>InternalServerErrorException Internal Service Error</li>
     *         <li>ForbiddenException Access was denied</li>
     *         <li>BadGatewayException Bad Gateway Error</li>
     *         <li>NotFoundException Input not found</li>
     *         <li>GatewayTimeoutException Gateway Timeout Error</li>
     *         <li>TooManyRequestsException Limit exceeded</li>
     *         <li>ConflictException Resource conflict</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.DeleteInput
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DeleteInput" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteInputResponse> deleteInput(Consumer<DeleteInputRequest.Builder> deleteInputRequest) {
        return deleteInput(DeleteInputRequest.builder().applyMutation(deleteInputRequest).build());
    }

    /**
     * Deletes an Input Security Group
     *
     * @param deleteInputSecurityGroupRequest
     *        Placeholder documentation for DeleteInputSecurityGroupRequest
     * @return A Java Future containing the result of the DeleteInputSecurityGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request to delete the Input Security Group was Invalid</li>
     *         <li>InternalServerErrorException Internal Server Error</li>
     *         <li>ForbiddenException The requester does not have permission to delete this Input Security Group</li>
     *         <li>BadGatewayException Bad Gateway Error</li>
     *         <li>NotFoundException Input Security Group not found</li>
     *         <li>GatewayTimeoutException Gateway Timeout Error</li>
     *         <li>TooManyRequestsException Limit Exceeded Error</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.DeleteInputSecurityGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DeleteInputSecurityGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteInputSecurityGroupResponse> deleteInputSecurityGroup(
            DeleteInputSecurityGroupRequest deleteInputSecurityGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Deletes an Input Security Group<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteInputSecurityGroupRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteInputSecurityGroupRequest#builder()}
     * </p>
     *
     * @param deleteInputSecurityGroupRequest
     *        A {@link Consumer} that will call methods on {@link DeleteInputSecurityGroupRequest.Builder} to create a
     *        request. Placeholder documentation for DeleteInputSecurityGroupRequest
     * @return A Java Future containing the result of the DeleteInputSecurityGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request to delete the Input Security Group was Invalid</li>
     *         <li>InternalServerErrorException Internal Server Error</li>
     *         <li>ForbiddenException The requester does not have permission to delete this Input Security Group</li>
     *         <li>BadGatewayException Bad Gateway Error</li>
     *         <li>NotFoundException Input Security Group not found</li>
     *         <li>GatewayTimeoutException Gateway Timeout Error</li>
     *         <li>TooManyRequestsException Limit Exceeded Error</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.DeleteInputSecurityGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DeleteInputSecurityGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteInputSecurityGroupResponse> deleteInputSecurityGroup(
            Consumer<DeleteInputSecurityGroupRequest.Builder> deleteInputSecurityGroupRequest) {
        return deleteInputSecurityGroup(DeleteInputSecurityGroupRequest.builder().applyMutation(deleteInputSecurityGroupRequest)
                .build());
    }

    /**
     * Delete a multiplex. The multiplex must be idle.
     *
     * @param deleteMultiplexRequest
     *        Placeholder documentation for DeleteMultiplexRequest
     * @return A Java Future containing the result of the DeleteMultiplex operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException This request was invalid.</li>
     *         <li>InternalServerErrorException Unexpected internal service error.</li>
     *         <li>ForbiddenException You don't have permission to delete the multiplex.</li>
     *         <li>BadGatewayException Bad Gateway Error.</li>
     *         <li>NotFoundException The multiplex that you are trying to delete doesn’t exist. Check the ID and try
     *         again.</li>
     *         <li>GatewayTimeoutException Gateway Timeout Error.</li>
     *         <li>TooManyRequestsException Request limit exceeded on delete multiplex calls to multiplex service.</li>
     *         <li>ConflictException The multiplex is unable to delete due to an issue with multiplex resources.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.DeleteMultiplex
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DeleteMultiplex" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteMultiplexResponse> deleteMultiplex(DeleteMultiplexRequest deleteMultiplexRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Delete a multiplex. The multiplex must be idle.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteMultiplexRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteMultiplexRequest#builder()}
     * </p>
     *
     * @param deleteMultiplexRequest
     *        A {@link Consumer} that will call methods on {@link DeleteMultiplexRequest.Builder} to create a request.
     *        Placeholder documentation for DeleteMultiplexRequest
     * @return A Java Future containing the result of the DeleteMultiplex operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException This request was invalid.</li>
     *         <li>InternalServerErrorException Unexpected internal service error.</li>
     *         <li>ForbiddenException You don't have permission to delete the multiplex.</li>
     *         <li>BadGatewayException Bad Gateway Error.</li>
     *         <li>NotFoundException The multiplex that you are trying to delete doesn’t exist. Check the ID and try
     *         again.</li>
     *         <li>GatewayTimeoutException Gateway Timeout Error.</li>
     *         <li>TooManyRequestsException Request limit exceeded on delete multiplex calls to multiplex service.</li>
     *         <li>ConflictException The multiplex is unable to delete due to an issue with multiplex resources.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.DeleteMultiplex
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DeleteMultiplex" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteMultiplexResponse> deleteMultiplex(
            Consumer<DeleteMultiplexRequest.Builder> deleteMultiplexRequest) {
        return deleteMultiplex(DeleteMultiplexRequest.builder().applyMutation(deleteMultiplexRequest).build());
    }

    /**
     * Delete a program from a multiplex.
     *
     * @param deleteMultiplexProgramRequest
     *        Placeholder documentation for DeleteMultiplexProgramRequest
     * @return A Java Future containing the result of the DeleteMultiplexProgram operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException This request was invalid.</li>
     *         <li>InternalServerErrorException Unexpected internal service error.</li>
     *         <li>ForbiddenException You don't have permission to delete the multiplex program.</li>
     *         <li>BadGatewayException Bad Gateway Error.</li>
     *         <li>NotFoundException The program that you are trying to delete doesn’t exist. Check the ID and try
     *         again.</li>
     *         <li>GatewayTimeoutException Gateway Timeout Error.</li>
     *         <li>TooManyRequestsException Request limit exceeded on delete multiplex program calls to multiplex
     *         service.</li>
     *         <li>ConflictException The multiplex program is unable to delete due to an issue with multiplex resources.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.DeleteMultiplexProgram
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DeleteMultiplexProgram"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteMultiplexProgramResponse> deleteMultiplexProgram(
            DeleteMultiplexProgramRequest deleteMultiplexProgramRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Delete a program from a multiplex.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteMultiplexProgramRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteMultiplexProgramRequest#builder()}
     * </p>
     *
     * @param deleteMultiplexProgramRequest
     *        A {@link Consumer} that will call methods on {@link DeleteMultiplexProgramRequest.Builder} to create a
     *        request. Placeholder documentation for DeleteMultiplexProgramRequest
     * @return A Java Future containing the result of the DeleteMultiplexProgram operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException This request was invalid.</li>
     *         <li>InternalServerErrorException Unexpected internal service error.</li>
     *         <li>ForbiddenException You don't have permission to delete the multiplex program.</li>
     *         <li>BadGatewayException Bad Gateway Error.</li>
     *         <li>NotFoundException The program that you are trying to delete doesn’t exist. Check the ID and try
     *         again.</li>
     *         <li>GatewayTimeoutException Gateway Timeout Error.</li>
     *         <li>TooManyRequestsException Request limit exceeded on delete multiplex program calls to multiplex
     *         service.</li>
     *         <li>ConflictException The multiplex program is unable to delete due to an issue with multiplex resources.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.DeleteMultiplexProgram
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DeleteMultiplexProgram"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteMultiplexProgramResponse> deleteMultiplexProgram(
            Consumer<DeleteMultiplexProgramRequest.Builder> deleteMultiplexProgramRequest) {
        return deleteMultiplexProgram(DeleteMultiplexProgramRequest.builder().applyMutation(deleteMultiplexProgramRequest)
                .build());
    }

    /**
     * Delete an expired reservation.
     *
     * @param deleteReservationRequest
     *        Placeholder documentation for DeleteReservationRequest
     * @return A Java Future containing the result of the DeleteReservation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException This request was invalid</li>
     *         <li>InternalServerErrorException Internal service error</li>
     *         <li>ForbiddenException You do not have permission to delete reservation</li>
     *         <li>BadGatewayException Bad gateway error</li>
     *         <li>NotFoundException Reservation you're attempting to delete does not exist</li>
     *         <li>GatewayTimeoutException Gateway timeout error</li>
     *         <li>TooManyRequestsException Request limit exceeded on delete reservation request</li>
     *         <li>ConflictException The reservation could not be deleted because it is currently active.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.DeleteReservation
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DeleteReservation" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteReservationResponse> deleteReservation(DeleteReservationRequest deleteReservationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Delete an expired reservation.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteReservationRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteReservationRequest#builder()}
     * </p>
     *
     * @param deleteReservationRequest
     *        A {@link Consumer} that will call methods on {@link DeleteReservationRequest.Builder} to create a request.
     *        Placeholder documentation for DeleteReservationRequest
     * @return A Java Future containing the result of the DeleteReservation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException This request was invalid</li>
     *         <li>InternalServerErrorException Internal service error</li>
     *         <li>ForbiddenException You do not have permission to delete reservation</li>
     *         <li>BadGatewayException Bad gateway error</li>
     *         <li>NotFoundException Reservation you're attempting to delete does not exist</li>
     *         <li>GatewayTimeoutException Gateway timeout error</li>
     *         <li>TooManyRequestsException Request limit exceeded on delete reservation request</li>
     *         <li>ConflictException The reservation could not be deleted because it is currently active.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.DeleteReservation
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DeleteReservation" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteReservationResponse> deleteReservation(
            Consumer<DeleteReservationRequest.Builder> deleteReservationRequest) {
        return deleteReservation(DeleteReservationRequest.builder().applyMutation(deleteReservationRequest).build());
    }

    /**
     * Delete all schedule actions on a channel.
     *
     * @param deleteScheduleRequest
     *        Placeholder documentation for DeleteScheduleRequest
     * @return A Java Future containing the result of the DeleteSchedule operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException This request to delete the schedule on this channel was invalid.</li>
     *         <li>InternalServerErrorException Unexpected internal service error.</li>
     *         <li>ForbiddenException You do not have permission to delete the channel schedule.</li>
     *         <li>BadGatewayException Bad Gateway Error</li>
     *         <li>NotFoundException The specified channel does not exist to have its schedule deleted.</li>
     *         <li>GatewayTimeoutException Gateway Timeout Error</li>
     *         <li>TooManyRequestsException Request limit exceeded on delete schedule calls.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.DeleteSchedule
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DeleteSchedule" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteScheduleResponse> deleteSchedule(DeleteScheduleRequest deleteScheduleRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Delete all schedule actions on a channel.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteScheduleRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteScheduleRequest#builder()}
     * </p>
     *
     * @param deleteScheduleRequest
     *        A {@link Consumer} that will call methods on {@link DeleteScheduleRequest.Builder} to create a request.
     *        Placeholder documentation for DeleteScheduleRequest
     * @return A Java Future containing the result of the DeleteSchedule operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException This request to delete the schedule on this channel was invalid.</li>
     *         <li>InternalServerErrorException Unexpected internal service error.</li>
     *         <li>ForbiddenException You do not have permission to delete the channel schedule.</li>
     *         <li>BadGatewayException Bad Gateway Error</li>
     *         <li>NotFoundException The specified channel does not exist to have its schedule deleted.</li>
     *         <li>GatewayTimeoutException Gateway Timeout Error</li>
     *         <li>TooManyRequestsException Request limit exceeded on delete schedule calls.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.DeleteSchedule
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DeleteSchedule" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteScheduleResponse> deleteSchedule(Consumer<DeleteScheduleRequest.Builder> deleteScheduleRequest) {
        return deleteSchedule(DeleteScheduleRequest.builder().applyMutation(deleteScheduleRequest).build());
    }

    /**
     * Removes tags for a resource
     *
     * @param deleteTagsRequest
     *        Placeholder documentation for DeleteTagsRequest
     * @return A Java Future containing the result of the DeleteTags operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The arn was not found.</li>
     *         <li>BadRequestException This request was invalid</li>
     *         <li>InternalServerErrorException Internal Service Error</li>
     *         <li>ForbiddenException Access was denied</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.DeleteTags
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DeleteTags" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteTagsResponse> deleteTags(DeleteTagsRequest deleteTagsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Removes tags for a resource<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteTagsRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteTagsRequest#builder()}
     * </p>
     *
     * @param deleteTagsRequest
     *        A {@link Consumer} that will call methods on {@link DeleteTagsRequest.Builder} to create a request.
     *        Placeholder documentation for DeleteTagsRequest
     * @return A Java Future containing the result of the DeleteTags operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The arn was not found.</li>
     *         <li>BadRequestException This request was invalid</li>
     *         <li>InternalServerErrorException Internal Service Error</li>
     *         <li>ForbiddenException Access was denied</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.DeleteTags
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DeleteTags" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteTagsResponse> deleteTags(Consumer<DeleteTagsRequest.Builder> deleteTagsRequest) {
        return deleteTags(DeleteTagsRequest.builder().applyMutation(deleteTagsRequest).build());
    }

    /**
     * Gets details about a channel
     *
     * @param describeChannelRequest
     *        Placeholder documentation for DescribeChannelRequest
     * @return A Java Future containing the result of the DescribeChannel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException This request was invalid</li>
     *         <li>InternalServerErrorException Unexpected internal service error.</li>
     *         <li>ForbiddenException You do not have permission to describe the channel.</li>
     *         <li>BadGatewayException Bad Gateway Error</li>
     *         <li>NotFoundException The channel you're requesting to describe does not exist.</li>
     *         <li>GatewayTimeoutException Gateway Timeout Error</li>
     *         <li>TooManyRequestsException Request limit exceeded on describe channel calls to channel service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.DescribeChannel
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DescribeChannel" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeChannelResponse> describeChannel(DescribeChannelRequest describeChannelRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Gets details about a channel<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeChannelRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeChannelRequest#builder()}
     * </p>
     *
     * @param describeChannelRequest
     *        A {@link Consumer} that will call methods on {@link DescribeChannelRequest.Builder} to create a request.
     *        Placeholder documentation for DescribeChannelRequest
     * @return A Java Future containing the result of the DescribeChannel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException This request was invalid</li>
     *         <li>InternalServerErrorException Unexpected internal service error.</li>
     *         <li>ForbiddenException You do not have permission to describe the channel.</li>
     *         <li>BadGatewayException Bad Gateway Error</li>
     *         <li>NotFoundException The channel you're requesting to describe does not exist.</li>
     *         <li>GatewayTimeoutException Gateway Timeout Error</li>
     *         <li>TooManyRequestsException Request limit exceeded on describe channel calls to channel service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.DescribeChannel
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DescribeChannel" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeChannelResponse> describeChannel(
            Consumer<DescribeChannelRequest.Builder> describeChannelRequest) {
        return describeChannel(DescribeChannelRequest.builder().applyMutation(describeChannelRequest).build());
    }

    /**
     * Produces details about an input
     *
     * @param describeInputRequest
     *        Placeholder documentation for DescribeInputRequest
     * @return A Java Future containing the result of the DescribeInput operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException This request was invalid</li>
     *         <li>InternalServerErrorException Internal Service Error</li>
     *         <li>ForbiddenException Access was denied</li>
     *         <li>BadGatewayException Bad Gateway Error</li>
     *         <li>NotFoundException Input not found</li>
     *         <li>GatewayTimeoutException Gateway Timeout Error</li>
     *         <li>TooManyRequestsException Limit exceeded</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.DescribeInput
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DescribeInput" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeInputResponse> describeInput(DescribeInputRequest describeInputRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Produces details about an input<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeInputRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeInputRequest#builder()}
     * </p>
     *
     * @param describeInputRequest
     *        A {@link Consumer} that will call methods on {@link DescribeInputRequest.Builder} to create a request.
     *        Placeholder documentation for DescribeInputRequest
     * @return A Java Future containing the result of the DescribeInput operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException This request was invalid</li>
     *         <li>InternalServerErrorException Internal Service Error</li>
     *         <li>ForbiddenException Access was denied</li>
     *         <li>BadGatewayException Bad Gateway Error</li>
     *         <li>NotFoundException Input not found</li>
     *         <li>GatewayTimeoutException Gateway Timeout Error</li>
     *         <li>TooManyRequestsException Limit exceeded</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.DescribeInput
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DescribeInput" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeInputResponse> describeInput(Consumer<DescribeInputRequest.Builder> describeInputRequest) {
        return describeInput(DescribeInputRequest.builder().applyMutation(describeInputRequest).build());
    }

    /**
     * Gets the details for the input device
     *
     * @param describeInputDeviceRequest
     *        Placeholder documentation for DescribeInputDeviceRequest
     * @return A Java Future containing the result of the DescribeInputDevice operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException This request was invalid.</li>
     *         <li>InternalServerErrorException Unexpected internal service error.</li>
     *         <li>ForbiddenException You do not have permission to describe the input device.</li>
     *         <li>BadGatewayException Bad gateway error.</li>
     *         <li>NotFoundException The input device you're requesting to describe does not exist. Check the ID.</li>
     *         <li>GatewayTimeoutException Gateway timeout error.</li>
     *         <li>TooManyRequestsException Request limit exceeded on describe calls to the input device service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.DescribeInputDevice
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DescribeInputDevice" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeInputDeviceResponse> describeInputDevice(
            DescribeInputDeviceRequest describeInputDeviceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Gets the details for the input device<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeInputDeviceRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeInputDeviceRequest#builder()}
     * </p>
     *
     * @param describeInputDeviceRequest
     *        A {@link Consumer} that will call methods on {@link DescribeInputDeviceRequest.Builder} to create a
     *        request. Placeholder documentation for DescribeInputDeviceRequest
     * @return A Java Future containing the result of the DescribeInputDevice operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException This request was invalid.</li>
     *         <li>InternalServerErrorException Unexpected internal service error.</li>
     *         <li>ForbiddenException You do not have permission to describe the input device.</li>
     *         <li>BadGatewayException Bad gateway error.</li>
     *         <li>NotFoundException The input device you're requesting to describe does not exist. Check the ID.</li>
     *         <li>GatewayTimeoutException Gateway timeout error.</li>
     *         <li>TooManyRequestsException Request limit exceeded on describe calls to the input device service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.DescribeInputDevice
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DescribeInputDevice" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeInputDeviceResponse> describeInputDevice(
            Consumer<DescribeInputDeviceRequest.Builder> describeInputDeviceRequest) {
        return describeInputDevice(DescribeInputDeviceRequest.builder().applyMutation(describeInputDeviceRequest).build());
    }

    /**
     * Produces a summary of an Input Security Group
     *
     * @param describeInputSecurityGroupRequest
     *        Placeholder documentation for DescribeInputSecurityGroupRequest
     * @return A Java Future containing the result of the DescribeInputSecurityGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request to describe an Input Security Group was Invalid</li>
     *         <li>InternalServerErrorException Internal Server Error</li>
     *         <li>ForbiddenException The requester does not have permission to describe this Input Security Group</li>
     *         <li>BadGatewayException Bad Gateway Error</li>
     *         <li>NotFoundException Input Security Group not found</li>
     *         <li>GatewayTimeoutException Gateway Timeout Error</li>
     *         <li>TooManyRequestsException Limit Exceeded Error</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.DescribeInputSecurityGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DescribeInputSecurityGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeInputSecurityGroupResponse> describeInputSecurityGroup(
            DescribeInputSecurityGroupRequest describeInputSecurityGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Produces a summary of an Input Security Group<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeInputSecurityGroupRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeInputSecurityGroupRequest#builder()}
     * </p>
     *
     * @param describeInputSecurityGroupRequest
     *        A {@link Consumer} that will call methods on {@link DescribeInputSecurityGroupRequest.Builder} to create a
     *        request. Placeholder documentation for DescribeInputSecurityGroupRequest
     * @return A Java Future containing the result of the DescribeInputSecurityGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request to describe an Input Security Group was Invalid</li>
     *         <li>InternalServerErrorException Internal Server Error</li>
     *         <li>ForbiddenException The requester does not have permission to describe this Input Security Group</li>
     *         <li>BadGatewayException Bad Gateway Error</li>
     *         <li>NotFoundException Input Security Group not found</li>
     *         <li>GatewayTimeoutException Gateway Timeout Error</li>
     *         <li>TooManyRequestsException Limit Exceeded Error</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.DescribeInputSecurityGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DescribeInputSecurityGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeInputSecurityGroupResponse> describeInputSecurityGroup(
            Consumer<DescribeInputSecurityGroupRequest.Builder> describeInputSecurityGroupRequest) {
        return describeInputSecurityGroup(DescribeInputSecurityGroupRequest.builder()
                .applyMutation(describeInputSecurityGroupRequest).build());
    }

    /**
     * Gets details about a multiplex.
     *
     * @param describeMultiplexRequest
     *        Placeholder documentation for DescribeMultiplexRequest
     * @return A Java Future containing the result of the DescribeMultiplex operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException This request was invalid.</li>
     *         <li>InternalServerErrorException Unexpected internal service error.</li>
     *         <li>ForbiddenException You don't have permission to describe the multiplex.</li>
     *         <li>BadGatewayException Bad Gateway Error.</li>
     *         <li>NotFoundException The multiplex that you are trying to describe doesn’t exist. Check the ID and try
     *         again.</li>
     *         <li>GatewayTimeoutException Gateway Timeout Error.</li>
     *         <li>TooManyRequestsException Request limit exceeded on describe multiplex calls to multiplex service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.DescribeMultiplex
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DescribeMultiplex" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeMultiplexResponse> describeMultiplex(DescribeMultiplexRequest describeMultiplexRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Gets details about a multiplex.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeMultiplexRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeMultiplexRequest#builder()}
     * </p>
     *
     * @param describeMultiplexRequest
     *        A {@link Consumer} that will call methods on {@link DescribeMultiplexRequest.Builder} to create a request.
     *        Placeholder documentation for DescribeMultiplexRequest
     * @return A Java Future containing the result of the DescribeMultiplex operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException This request was invalid.</li>
     *         <li>InternalServerErrorException Unexpected internal service error.</li>
     *         <li>ForbiddenException You don't have permission to describe the multiplex.</li>
     *         <li>BadGatewayException Bad Gateway Error.</li>
     *         <li>NotFoundException The multiplex that you are trying to describe doesn’t exist. Check the ID and try
     *         again.</li>
     *         <li>GatewayTimeoutException Gateway Timeout Error.</li>
     *         <li>TooManyRequestsException Request limit exceeded on describe multiplex calls to multiplex service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.DescribeMultiplex
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DescribeMultiplex" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeMultiplexResponse> describeMultiplex(
            Consumer<DescribeMultiplexRequest.Builder> describeMultiplexRequest) {
        return describeMultiplex(DescribeMultiplexRequest.builder().applyMutation(describeMultiplexRequest).build());
    }

    /**
     * Get the details for a program in a multiplex.
     *
     * @param describeMultiplexProgramRequest
     *        Placeholder documentation for DescribeMultiplexProgramRequest
     * @return A Java Future containing the result of the DescribeMultiplexProgram operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException This request was invalid.</li>
     *         <li>InternalServerErrorException Unexpected internal service error.</li>
     *         <li>ForbiddenException You don't have permission to describe the multiplex program.</li>
     *         <li>BadGatewayException Bad Gateway Error.</li>
     *         <li>NotFoundException MediaLive can't describe the program. The multiplex or the program that you
     *         specified doesn’t exist. Check the IDs and try again.</li>
     *         <li>GatewayTimeoutException Gateway Timeout Error.</li>
     *         <li>TooManyRequestsException Request limit exceeded on describe multiplex program calls to multiplex
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.DescribeMultiplexProgram
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DescribeMultiplexProgram"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeMultiplexProgramResponse> describeMultiplexProgram(
            DescribeMultiplexProgramRequest describeMultiplexProgramRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Get the details for a program in a multiplex.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeMultiplexProgramRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeMultiplexProgramRequest#builder()}
     * </p>
     *
     * @param describeMultiplexProgramRequest
     *        A {@link Consumer} that will call methods on {@link DescribeMultiplexProgramRequest.Builder} to create a
     *        request. Placeholder documentation for DescribeMultiplexProgramRequest
     * @return A Java Future containing the result of the DescribeMultiplexProgram operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException This request was invalid.</li>
     *         <li>InternalServerErrorException Unexpected internal service error.</li>
     *         <li>ForbiddenException You don't have permission to describe the multiplex program.</li>
     *         <li>BadGatewayException Bad Gateway Error.</li>
     *         <li>NotFoundException MediaLive can't describe the program. The multiplex or the program that you
     *         specified doesn’t exist. Check the IDs and try again.</li>
     *         <li>GatewayTimeoutException Gateway Timeout Error.</li>
     *         <li>TooManyRequestsException Request limit exceeded on describe multiplex program calls to multiplex
     *         service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.DescribeMultiplexProgram
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DescribeMultiplexProgram"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeMultiplexProgramResponse> describeMultiplexProgram(
            Consumer<DescribeMultiplexProgramRequest.Builder> describeMultiplexProgramRequest) {
        return describeMultiplexProgram(DescribeMultiplexProgramRequest.builder().applyMutation(describeMultiplexProgramRequest)
                .build());
    }

    /**
     * Get details for an offering.
     *
     * @param describeOfferingRequest
     *        Placeholder documentation for DescribeOfferingRequest
     * @return A Java Future containing the result of the DescribeOffering operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException This request was invalid</li>
     *         <li>InternalServerErrorException Internal service error</li>
     *         <li>ForbiddenException You do not have permission to describe offering</li>
     *         <li>BadGatewayException Bad gateway error</li>
     *         <li>NotFoundException Offering you're attempting to describe does not exist</li>
     *         <li>GatewayTimeoutException Gateway timeout error</li>
     *         <li>TooManyRequestsException Request limit exceeded on describe offering request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.DescribeOffering
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DescribeOffering" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeOfferingResponse> describeOffering(DescribeOfferingRequest describeOfferingRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Get details for an offering.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeOfferingRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeOfferingRequest#builder()}
     * </p>
     *
     * @param describeOfferingRequest
     *        A {@link Consumer} that will call methods on {@link DescribeOfferingRequest.Builder} to create a request.
     *        Placeholder documentation for DescribeOfferingRequest
     * @return A Java Future containing the result of the DescribeOffering operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException This request was invalid</li>
     *         <li>InternalServerErrorException Internal service error</li>
     *         <li>ForbiddenException You do not have permission to describe offering</li>
     *         <li>BadGatewayException Bad gateway error</li>
     *         <li>NotFoundException Offering you're attempting to describe does not exist</li>
     *         <li>GatewayTimeoutException Gateway timeout error</li>
     *         <li>TooManyRequestsException Request limit exceeded on describe offering request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.DescribeOffering
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DescribeOffering" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeOfferingResponse> describeOffering(
            Consumer<DescribeOfferingRequest.Builder> describeOfferingRequest) {
        return describeOffering(DescribeOfferingRequest.builder().applyMutation(describeOfferingRequest).build());
    }

    /**
     * Get details for a reservation.
     *
     * @param describeReservationRequest
     *        Placeholder documentation for DescribeReservationRequest
     * @return A Java Future containing the result of the DescribeReservation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException This request was invalid</li>
     *         <li>InternalServerErrorException Internal service error</li>
     *         <li>ForbiddenException You do not have permission to describe reservation</li>
     *         <li>BadGatewayException Bad gateway error</li>
     *         <li>NotFoundException Reservation you're attempting to describe does not exist</li>
     *         <li>GatewayTimeoutException Gateway timeout error</li>
     *         <li>TooManyRequestsException Request limit exceeded on describe reservation request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.DescribeReservation
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DescribeReservation" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeReservationResponse> describeReservation(
            DescribeReservationRequest describeReservationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Get details for a reservation.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeReservationRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeReservationRequest#builder()}
     * </p>
     *
     * @param describeReservationRequest
     *        A {@link Consumer} that will call methods on {@link DescribeReservationRequest.Builder} to create a
     *        request. Placeholder documentation for DescribeReservationRequest
     * @return A Java Future containing the result of the DescribeReservation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException This request was invalid</li>
     *         <li>InternalServerErrorException Internal service error</li>
     *         <li>ForbiddenException You do not have permission to describe reservation</li>
     *         <li>BadGatewayException Bad gateway error</li>
     *         <li>NotFoundException Reservation you're attempting to describe does not exist</li>
     *         <li>GatewayTimeoutException Gateway timeout error</li>
     *         <li>TooManyRequestsException Request limit exceeded on describe reservation request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.DescribeReservation
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DescribeReservation" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeReservationResponse> describeReservation(
            Consumer<DescribeReservationRequest.Builder> describeReservationRequest) {
        return describeReservation(DescribeReservationRequest.builder().applyMutation(describeReservationRequest).build());
    }

    /**
     * Get a channel schedule
     *
     * @param describeScheduleRequest
     *        Placeholder documentation for DescribeScheduleRequest
     * @return A Java Future containing the result of the DescribeSchedule operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException This request was invalid.</li>
     *         <li>InternalServerErrorException Unexpected internal service error.</li>
     *         <li>ForbiddenException You do not have permission to describe the channel schedule.</li>
     *         <li>BadGatewayException Bad Gateway Error</li>
     *         <li>NotFoundException The channel you're requesting a schedule describe for does not exist.</li>
     *         <li>GatewayTimeoutException Gateway Timeout Error</li>
     *         <li>TooManyRequestsException Request limit exceeded on describe schedule calls.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.DescribeSchedule
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DescribeSchedule" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeScheduleResponse> describeSchedule(DescribeScheduleRequest describeScheduleRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Get a channel schedule<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeScheduleRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeScheduleRequest#builder()}
     * </p>
     *
     * @param describeScheduleRequest
     *        A {@link Consumer} that will call methods on {@link DescribeScheduleRequest.Builder} to create a request.
     *        Placeholder documentation for DescribeScheduleRequest
     * @return A Java Future containing the result of the DescribeSchedule operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException This request was invalid.</li>
     *         <li>InternalServerErrorException Unexpected internal service error.</li>
     *         <li>ForbiddenException You do not have permission to describe the channel schedule.</li>
     *         <li>BadGatewayException Bad Gateway Error</li>
     *         <li>NotFoundException The channel you're requesting a schedule describe for does not exist.</li>
     *         <li>GatewayTimeoutException Gateway Timeout Error</li>
     *         <li>TooManyRequestsException Request limit exceeded on describe schedule calls.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.DescribeSchedule
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DescribeSchedule" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeScheduleResponse> describeSchedule(
            Consumer<DescribeScheduleRequest.Builder> describeScheduleRequest) {
        return describeSchedule(DescribeScheduleRequest.builder().applyMutation(describeScheduleRequest).build());
    }

    /**
     * Get a channel schedule<br/>
     * <p>
     * This is a variant of
     * {@link #describeSchedule(software.amazon.awssdk.services.medialive.model.DescribeScheduleRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.medialive.paginators.DescribeSchedulePublisher publisher = client.describeSchedulePaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.medialive.paginators.DescribeSchedulePublisher publisher = client.describeSchedulePaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.medialive.model.DescribeScheduleResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.medialive.model.DescribeScheduleResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeSchedule(software.amazon.awssdk.services.medialive.model.DescribeScheduleRequest)} operation.</b>
     * </p>
     *
     * @param describeScheduleRequest
     *        Placeholder documentation for DescribeScheduleRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException This request was invalid.</li>
     *         <li>InternalServerErrorException Unexpected internal service error.</li>
     *         <li>ForbiddenException You do not have permission to describe the channel schedule.</li>
     *         <li>BadGatewayException Bad Gateway Error</li>
     *         <li>NotFoundException The channel you're requesting a schedule describe for does not exist.</li>
     *         <li>GatewayTimeoutException Gateway Timeout Error</li>
     *         <li>TooManyRequestsException Request limit exceeded on describe schedule calls.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.DescribeSchedule
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DescribeSchedule" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeSchedulePublisher describeSchedulePaginator(DescribeScheduleRequest describeScheduleRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Get a channel schedule<br/>
     * <p>
     * This is a variant of
     * {@link #describeSchedule(software.amazon.awssdk.services.medialive.model.DescribeScheduleRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.medialive.paginators.DescribeSchedulePublisher publisher = client.describeSchedulePaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.medialive.paginators.DescribeSchedulePublisher publisher = client.describeSchedulePaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.medialive.model.DescribeScheduleResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.medialive.model.DescribeScheduleResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeSchedule(software.amazon.awssdk.services.medialive.model.DescribeScheduleRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeScheduleRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeScheduleRequest#builder()}
     * </p>
     *
     * @param describeScheduleRequest
     *        A {@link Consumer} that will call methods on {@link DescribeScheduleRequest.Builder} to create a request.
     *        Placeholder documentation for DescribeScheduleRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException This request was invalid.</li>
     *         <li>InternalServerErrorException Unexpected internal service error.</li>
     *         <li>ForbiddenException You do not have permission to describe the channel schedule.</li>
     *         <li>BadGatewayException Bad Gateway Error</li>
     *         <li>NotFoundException The channel you're requesting a schedule describe for does not exist.</li>
     *         <li>GatewayTimeoutException Gateway Timeout Error</li>
     *         <li>TooManyRequestsException Request limit exceeded on describe schedule calls.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.DescribeSchedule
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/DescribeSchedule" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeSchedulePublisher describeSchedulePaginator(Consumer<DescribeScheduleRequest.Builder> describeScheduleRequest) {
        return describeSchedulePaginator(DescribeScheduleRequest.builder().applyMutation(describeScheduleRequest).build());
    }

    /**
     * Produces list of channels that have been created
     *
     * @param listChannelsRequest
     *        Placeholder documentation for ListChannelsRequest
     * @return A Java Future containing the result of the ListChannels operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException This request was invalid.</li>
     *         <li>InternalServerErrorException Unexpected internal service error.</li>
     *         <li>ForbiddenException You do not have permission to list channels.</li>
     *         <li>BadGatewayException Bad Gateway Error</li>
     *         <li>GatewayTimeoutException Gateway Timeout Error</li>
     *         <li>TooManyRequestsException Request limit exceeded on list channel calls to channel service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.ListChannels
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListChannels" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListChannelsResponse> listChannels(ListChannelsRequest listChannelsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Produces list of channels that have been created<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListChannelsRequest.Builder} avoiding the need to
     * create one manually via {@link ListChannelsRequest#builder()}
     * </p>
     *
     * @param listChannelsRequest
     *        A {@link Consumer} that will call methods on {@link ListChannelsRequest.Builder} to create a request.
     *        Placeholder documentation for ListChannelsRequest
     * @return A Java Future containing the result of the ListChannels operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException This request was invalid.</li>
     *         <li>InternalServerErrorException Unexpected internal service error.</li>
     *         <li>ForbiddenException You do not have permission to list channels.</li>
     *         <li>BadGatewayException Bad Gateway Error</li>
     *         <li>GatewayTimeoutException Gateway Timeout Error</li>
     *         <li>TooManyRequestsException Request limit exceeded on list channel calls to channel service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.ListChannels
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListChannels" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListChannelsResponse> listChannels(Consumer<ListChannelsRequest.Builder> listChannelsRequest) {
        return listChannels(ListChannelsRequest.builder().applyMutation(listChannelsRequest).build());
    }

    /**
     * Produces list of channels that have been created
     *
     * @return A Java Future containing the result of the ListChannels operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException This request was invalid.</li>
     *         <li>InternalServerErrorException Unexpected internal service error.</li>
     *         <li>ForbiddenException You do not have permission to list channels.</li>
     *         <li>BadGatewayException Bad Gateway Error</li>
     *         <li>GatewayTimeoutException Gateway Timeout Error</li>
     *         <li>TooManyRequestsException Request limit exceeded on list channel calls to channel service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.ListChannels
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListChannels" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListChannelsResponse> listChannels() {
        return listChannels(ListChannelsRequest.builder().build());
    }

    /**
     * Produces list of channels that have been created<br/>
     * <p>
     * This is a variant of {@link #listChannels(software.amazon.awssdk.services.medialive.model.ListChannelsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.medialive.paginators.ListChannelsPublisher publisher = client.listChannelsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.medialive.paginators.ListChannelsPublisher publisher = client.listChannelsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.medialive.model.ListChannelsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.medialive.model.ListChannelsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listChannels(software.amazon.awssdk.services.medialive.model.ListChannelsRequest)} operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException This request was invalid.</li>
     *         <li>InternalServerErrorException Unexpected internal service error.</li>
     *         <li>ForbiddenException You do not have permission to list channels.</li>
     *         <li>BadGatewayException Bad Gateway Error</li>
     *         <li>GatewayTimeoutException Gateway Timeout Error</li>
     *         <li>TooManyRequestsException Request limit exceeded on list channel calls to channel service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.ListChannels
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListChannels" target="_top">AWS API
     *      Documentation</a>
     */
    default ListChannelsPublisher listChannelsPaginator() {
        return listChannelsPaginator(ListChannelsRequest.builder().build());
    }

    /**
     * Produces list of channels that have been created<br/>
     * <p>
     * This is a variant of {@link #listChannels(software.amazon.awssdk.services.medialive.model.ListChannelsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.medialive.paginators.ListChannelsPublisher publisher = client.listChannelsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.medialive.paginators.ListChannelsPublisher publisher = client.listChannelsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.medialive.model.ListChannelsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.medialive.model.ListChannelsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listChannels(software.amazon.awssdk.services.medialive.model.ListChannelsRequest)} operation.</b>
     * </p>
     *
     * @param listChannelsRequest
     *        Placeholder documentation for ListChannelsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException This request was invalid.</li>
     *         <li>InternalServerErrorException Unexpected internal service error.</li>
     *         <li>ForbiddenException You do not have permission to list channels.</li>
     *         <li>BadGatewayException Bad Gateway Error</li>
     *         <li>GatewayTimeoutException Gateway Timeout Error</li>
     *         <li>TooManyRequestsException Request limit exceeded on list channel calls to channel service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.ListChannels
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListChannels" target="_top">AWS API
     *      Documentation</a>
     */
    default ListChannelsPublisher listChannelsPaginator(ListChannelsRequest listChannelsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Produces list of channels that have been created<br/>
     * <p>
     * This is a variant of {@link #listChannels(software.amazon.awssdk.services.medialive.model.ListChannelsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.medialive.paginators.ListChannelsPublisher publisher = client.listChannelsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.medialive.paginators.ListChannelsPublisher publisher = client.listChannelsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.medialive.model.ListChannelsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.medialive.model.ListChannelsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listChannels(software.amazon.awssdk.services.medialive.model.ListChannelsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListChannelsRequest.Builder} avoiding the need to
     * create one manually via {@link ListChannelsRequest#builder()}
     * </p>
     *
     * @param listChannelsRequest
     *        A {@link Consumer} that will call methods on {@link ListChannelsRequest.Builder} to create a request.
     *        Placeholder documentation for ListChannelsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException This request was invalid.</li>
     *         <li>InternalServerErrorException Unexpected internal service error.</li>
     *         <li>ForbiddenException You do not have permission to list channels.</li>
     *         <li>BadGatewayException Bad Gateway Error</li>
     *         <li>GatewayTimeoutException Gateway Timeout Error</li>
     *         <li>TooManyRequestsException Request limit exceeded on list channel calls to channel service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.ListChannels
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListChannels" target="_top">AWS API
     *      Documentation</a>
     */
    default ListChannelsPublisher listChannelsPaginator(Consumer<ListChannelsRequest.Builder> listChannelsRequest) {
        return listChannelsPaginator(ListChannelsRequest.builder().applyMutation(listChannelsRequest).build());
    }

    /**
     * List input devices
     *
     * @param listInputDevicesRequest
     *        Placeholder documentation for ListInputDevicesRequest
     * @return A Java Future containing the result of the ListInputDevices operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException This request was invalid.</li>
     *         <li>InternalServerErrorException Unexpected internal service error.</li>
     *         <li>ForbiddenException You do not have permission to list input devices.</li>
     *         <li>BadGatewayException Bad gateway error.</li>
     *         <li>GatewayTimeoutException Gateway timeout error.</li>
     *         <li>TooManyRequestsException Request limit exceeded on list devices calls to the input device service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.ListInputDevices
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListInputDevices" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListInputDevicesResponse> listInputDevices(ListInputDevicesRequest listInputDevicesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * List input devices<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListInputDevicesRequest.Builder} avoiding the need
     * to create one manually via {@link ListInputDevicesRequest#builder()}
     * </p>
     *
     * @param listInputDevicesRequest
     *        A {@link Consumer} that will call methods on {@link ListInputDevicesRequest.Builder} to create a request.
     *        Placeholder documentation for ListInputDevicesRequest
     * @return A Java Future containing the result of the ListInputDevices operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException This request was invalid.</li>
     *         <li>InternalServerErrorException Unexpected internal service error.</li>
     *         <li>ForbiddenException You do not have permission to list input devices.</li>
     *         <li>BadGatewayException Bad gateway error.</li>
     *         <li>GatewayTimeoutException Gateway timeout error.</li>
     *         <li>TooManyRequestsException Request limit exceeded on list devices calls to the input device service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.ListInputDevices
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListInputDevices" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListInputDevicesResponse> listInputDevices(
            Consumer<ListInputDevicesRequest.Builder> listInputDevicesRequest) {
        return listInputDevices(ListInputDevicesRequest.builder().applyMutation(listInputDevicesRequest).build());
    }

    /**
     * List input devices<br/>
     * <p>
     * This is a variant of
     * {@link #listInputDevices(software.amazon.awssdk.services.medialive.model.ListInputDevicesRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.medialive.paginators.ListInputDevicesPublisher publisher = client.listInputDevicesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.medialive.paginators.ListInputDevicesPublisher publisher = client.listInputDevicesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.medialive.model.ListInputDevicesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.medialive.model.ListInputDevicesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listInputDevices(software.amazon.awssdk.services.medialive.model.ListInputDevicesRequest)} operation.</b>
     * </p>
     *
     * @param listInputDevicesRequest
     *        Placeholder documentation for ListInputDevicesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException This request was invalid.</li>
     *         <li>InternalServerErrorException Unexpected internal service error.</li>
     *         <li>ForbiddenException You do not have permission to list input devices.</li>
     *         <li>BadGatewayException Bad gateway error.</li>
     *         <li>GatewayTimeoutException Gateway timeout error.</li>
     *         <li>TooManyRequestsException Request limit exceeded on list devices calls to the input device service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.ListInputDevices
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListInputDevices" target="_top">AWS API
     *      Documentation</a>
     */
    default ListInputDevicesPublisher listInputDevicesPaginator(ListInputDevicesRequest listInputDevicesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * List input devices<br/>
     * <p>
     * This is a variant of
     * {@link #listInputDevices(software.amazon.awssdk.services.medialive.model.ListInputDevicesRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.medialive.paginators.ListInputDevicesPublisher publisher = client.listInputDevicesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.medialive.paginators.ListInputDevicesPublisher publisher = client.listInputDevicesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.medialive.model.ListInputDevicesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.medialive.model.ListInputDevicesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listInputDevices(software.amazon.awssdk.services.medialive.model.ListInputDevicesRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListInputDevicesRequest.Builder} avoiding the need
     * to create one manually via {@link ListInputDevicesRequest#builder()}
     * </p>
     *
     * @param listInputDevicesRequest
     *        A {@link Consumer} that will call methods on {@link ListInputDevicesRequest.Builder} to create a request.
     *        Placeholder documentation for ListInputDevicesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException This request was invalid.</li>
     *         <li>InternalServerErrorException Unexpected internal service error.</li>
     *         <li>ForbiddenException You do not have permission to list input devices.</li>
     *         <li>BadGatewayException Bad gateway error.</li>
     *         <li>GatewayTimeoutException Gateway timeout error.</li>
     *         <li>TooManyRequestsException Request limit exceeded on list devices calls to the input device service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.ListInputDevices
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListInputDevices" target="_top">AWS API
     *      Documentation</a>
     */
    default ListInputDevicesPublisher listInputDevicesPaginator(Consumer<ListInputDevicesRequest.Builder> listInputDevicesRequest) {
        return listInputDevicesPaginator(ListInputDevicesRequest.builder().applyMutation(listInputDevicesRequest).build());
    }

    /**
     * Produces a list of Input Security Groups for an account
     *
     * @param listInputSecurityGroupsRequest
     *        Placeholder documentation for ListInputSecurityGroupsRequest
     * @return A Java Future containing the result of the ListInputSecurityGroups operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request to list Input Security Groups was invalid</li>
     *         <li>InternalServerErrorException Internal Server Error</li>
     *         <li>ForbiddenException The requester does not have permission to call ListInputSecurityGroups</li>
     *         <li>BadGatewayException Bad Gateway Error</li>
     *         <li>GatewayTimeoutException Gateway Timeout Error</li>
     *         <li>TooManyRequestsException Limit Exceeded Error</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.ListInputSecurityGroups
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListInputSecurityGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListInputSecurityGroupsResponse> listInputSecurityGroups(
            ListInputSecurityGroupsRequest listInputSecurityGroupsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Produces a list of Input Security Groups for an account<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListInputSecurityGroupsRequest.Builder} avoiding
     * the need to create one manually via {@link ListInputSecurityGroupsRequest#builder()}
     * </p>
     *
     * @param listInputSecurityGroupsRequest
     *        A {@link Consumer} that will call methods on {@link ListInputSecurityGroupsRequest.Builder} to create a
     *        request. Placeholder documentation for ListInputSecurityGroupsRequest
     * @return A Java Future containing the result of the ListInputSecurityGroups operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request to list Input Security Groups was invalid</li>
     *         <li>InternalServerErrorException Internal Server Error</li>
     *         <li>ForbiddenException The requester does not have permission to call ListInputSecurityGroups</li>
     *         <li>BadGatewayException Bad Gateway Error</li>
     *         <li>GatewayTimeoutException Gateway Timeout Error</li>
     *         <li>TooManyRequestsException Limit Exceeded Error</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.ListInputSecurityGroups
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListInputSecurityGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListInputSecurityGroupsResponse> listInputSecurityGroups(
            Consumer<ListInputSecurityGroupsRequest.Builder> listInputSecurityGroupsRequest) {
        return listInputSecurityGroups(ListInputSecurityGroupsRequest.builder().applyMutation(listInputSecurityGroupsRequest)
                .build());
    }

    /**
     * Produces a list of Input Security Groups for an account
     *
     * @return A Java Future containing the result of the ListInputSecurityGroups operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request to list Input Security Groups was invalid</li>
     *         <li>InternalServerErrorException Internal Server Error</li>
     *         <li>ForbiddenException The requester does not have permission to call ListInputSecurityGroups</li>
     *         <li>BadGatewayException Bad Gateway Error</li>
     *         <li>GatewayTimeoutException Gateway Timeout Error</li>
     *         <li>TooManyRequestsException Limit Exceeded Error</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.ListInputSecurityGroups
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListInputSecurityGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListInputSecurityGroupsResponse> listInputSecurityGroups() {
        return listInputSecurityGroups(ListInputSecurityGroupsRequest.builder().build());
    }

    /**
     * Produces a list of Input Security Groups for an account<br/>
     * <p>
     * This is a variant of
     * {@link #listInputSecurityGroups(software.amazon.awssdk.services.medialive.model.ListInputSecurityGroupsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.medialive.paginators.ListInputSecurityGroupsPublisher publisher = client.listInputSecurityGroupsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.medialive.paginators.ListInputSecurityGroupsPublisher publisher = client.listInputSecurityGroupsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.medialive.model.ListInputSecurityGroupsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.medialive.model.ListInputSecurityGroupsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listInputSecurityGroups(software.amazon.awssdk.services.medialive.model.ListInputSecurityGroupsRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request to list Input Security Groups was invalid</li>
     *         <li>InternalServerErrorException Internal Server Error</li>
     *         <li>ForbiddenException The requester does not have permission to call ListInputSecurityGroups</li>
     *         <li>BadGatewayException Bad Gateway Error</li>
     *         <li>GatewayTimeoutException Gateway Timeout Error</li>
     *         <li>TooManyRequestsException Limit Exceeded Error</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.ListInputSecurityGroups
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListInputSecurityGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default ListInputSecurityGroupsPublisher listInputSecurityGroupsPaginator() {
        return listInputSecurityGroupsPaginator(ListInputSecurityGroupsRequest.builder().build());
    }

    /**
     * Produces a list of Input Security Groups for an account<br/>
     * <p>
     * This is a variant of
     * {@link #listInputSecurityGroups(software.amazon.awssdk.services.medialive.model.ListInputSecurityGroupsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.medialive.paginators.ListInputSecurityGroupsPublisher publisher = client.listInputSecurityGroupsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.medialive.paginators.ListInputSecurityGroupsPublisher publisher = client.listInputSecurityGroupsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.medialive.model.ListInputSecurityGroupsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.medialive.model.ListInputSecurityGroupsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listInputSecurityGroups(software.amazon.awssdk.services.medialive.model.ListInputSecurityGroupsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listInputSecurityGroupsRequest
     *        Placeholder documentation for ListInputSecurityGroupsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request to list Input Security Groups was invalid</li>
     *         <li>InternalServerErrorException Internal Server Error</li>
     *         <li>ForbiddenException The requester does not have permission to call ListInputSecurityGroups</li>
     *         <li>BadGatewayException Bad Gateway Error</li>
     *         <li>GatewayTimeoutException Gateway Timeout Error</li>
     *         <li>TooManyRequestsException Limit Exceeded Error</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.ListInputSecurityGroups
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListInputSecurityGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default ListInputSecurityGroupsPublisher listInputSecurityGroupsPaginator(
            ListInputSecurityGroupsRequest listInputSecurityGroupsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Produces a list of Input Security Groups for an account<br/>
     * <p>
     * This is a variant of
     * {@link #listInputSecurityGroups(software.amazon.awssdk.services.medialive.model.ListInputSecurityGroupsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.medialive.paginators.ListInputSecurityGroupsPublisher publisher = client.listInputSecurityGroupsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.medialive.paginators.ListInputSecurityGroupsPublisher publisher = client.listInputSecurityGroupsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.medialive.model.ListInputSecurityGroupsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.medialive.model.ListInputSecurityGroupsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listInputSecurityGroups(software.amazon.awssdk.services.medialive.model.ListInputSecurityGroupsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListInputSecurityGroupsRequest.Builder} avoiding
     * the need to create one manually via {@link ListInputSecurityGroupsRequest#builder()}
     * </p>
     *
     * @param listInputSecurityGroupsRequest
     *        A {@link Consumer} that will call methods on {@link ListInputSecurityGroupsRequest.Builder} to create a
     *        request. Placeholder documentation for ListInputSecurityGroupsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request to list Input Security Groups was invalid</li>
     *         <li>InternalServerErrorException Internal Server Error</li>
     *         <li>ForbiddenException The requester does not have permission to call ListInputSecurityGroups</li>
     *         <li>BadGatewayException Bad Gateway Error</li>
     *         <li>GatewayTimeoutException Gateway Timeout Error</li>
     *         <li>TooManyRequestsException Limit Exceeded Error</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.ListInputSecurityGroups
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListInputSecurityGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default ListInputSecurityGroupsPublisher listInputSecurityGroupsPaginator(
            Consumer<ListInputSecurityGroupsRequest.Builder> listInputSecurityGroupsRequest) {
        return listInputSecurityGroupsPaginator(ListInputSecurityGroupsRequest.builder()
                .applyMutation(listInputSecurityGroupsRequest).build());
    }

    /**
     * Produces list of inputs that have been created
     *
     * @param listInputsRequest
     *        Placeholder documentation for ListInputsRequest
     * @return A Java Future containing the result of the ListInputs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException This request was invalid</li>
     *         <li>InternalServerErrorException Internal Service Error</li>
     *         <li>ForbiddenException Access was denied</li>
     *         <li>BadGatewayException Bad Gateway Error</li>
     *         <li>GatewayTimeoutException Gateway Timeout Error</li>
     *         <li>TooManyRequestsException Limit exceeded</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.ListInputs
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListInputs" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListInputsResponse> listInputs(ListInputsRequest listInputsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Produces list of inputs that have been created<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListInputsRequest.Builder} avoiding the need to
     * create one manually via {@link ListInputsRequest#builder()}
     * </p>
     *
     * @param listInputsRequest
     *        A {@link Consumer} that will call methods on {@link ListInputsRequest.Builder} to create a request.
     *        Placeholder documentation for ListInputsRequest
     * @return A Java Future containing the result of the ListInputs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException This request was invalid</li>
     *         <li>InternalServerErrorException Internal Service Error</li>
     *         <li>ForbiddenException Access was denied</li>
     *         <li>BadGatewayException Bad Gateway Error</li>
     *         <li>GatewayTimeoutException Gateway Timeout Error</li>
     *         <li>TooManyRequestsException Limit exceeded</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.ListInputs
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListInputs" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListInputsResponse> listInputs(Consumer<ListInputsRequest.Builder> listInputsRequest) {
        return listInputs(ListInputsRequest.builder().applyMutation(listInputsRequest).build());
    }

    /**
     * Produces list of inputs that have been created
     *
     * @return A Java Future containing the result of the ListInputs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException This request was invalid</li>
     *         <li>InternalServerErrorException Internal Service Error</li>
     *         <li>ForbiddenException Access was denied</li>
     *         <li>BadGatewayException Bad Gateway Error</li>
     *         <li>GatewayTimeoutException Gateway Timeout Error</li>
     *         <li>TooManyRequestsException Limit exceeded</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.ListInputs
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListInputs" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListInputsResponse> listInputs() {
        return listInputs(ListInputsRequest.builder().build());
    }

    /**
     * Produces list of inputs that have been created<br/>
     * <p>
     * This is a variant of {@link #listInputs(software.amazon.awssdk.services.medialive.model.ListInputsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.medialive.paginators.ListInputsPublisher publisher = client.listInputsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.medialive.paginators.ListInputsPublisher publisher = client.listInputsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.medialive.model.ListInputsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.medialive.model.ListInputsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listInputs(software.amazon.awssdk.services.medialive.model.ListInputsRequest)} operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException This request was invalid</li>
     *         <li>InternalServerErrorException Internal Service Error</li>
     *         <li>ForbiddenException Access was denied</li>
     *         <li>BadGatewayException Bad Gateway Error</li>
     *         <li>GatewayTimeoutException Gateway Timeout Error</li>
     *         <li>TooManyRequestsException Limit exceeded</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.ListInputs
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListInputs" target="_top">AWS API
     *      Documentation</a>
     */
    default ListInputsPublisher listInputsPaginator() {
        return listInputsPaginator(ListInputsRequest.builder().build());
    }

    /**
     * Produces list of inputs that have been created<br/>
     * <p>
     * This is a variant of {@link #listInputs(software.amazon.awssdk.services.medialive.model.ListInputsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.medialive.paginators.ListInputsPublisher publisher = client.listInputsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.medialive.paginators.ListInputsPublisher publisher = client.listInputsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.medialive.model.ListInputsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.medialive.model.ListInputsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listInputs(software.amazon.awssdk.services.medialive.model.ListInputsRequest)} operation.</b>
     * </p>
     *
     * @param listInputsRequest
     *        Placeholder documentation for ListInputsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException This request was invalid</li>
     *         <li>InternalServerErrorException Internal Service Error</li>
     *         <li>ForbiddenException Access was denied</li>
     *         <li>BadGatewayException Bad Gateway Error</li>
     *         <li>GatewayTimeoutException Gateway Timeout Error</li>
     *         <li>TooManyRequestsException Limit exceeded</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.ListInputs
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListInputs" target="_top">AWS API
     *      Documentation</a>
     */
    default ListInputsPublisher listInputsPaginator(ListInputsRequest listInputsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Produces list of inputs that have been created<br/>
     * <p>
     * This is a variant of {@link #listInputs(software.amazon.awssdk.services.medialive.model.ListInputsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.medialive.paginators.ListInputsPublisher publisher = client.listInputsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.medialive.paginators.ListInputsPublisher publisher = client.listInputsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.medialive.model.ListInputsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.medialive.model.ListInputsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listInputs(software.amazon.awssdk.services.medialive.model.ListInputsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListInputsRequest.Builder} avoiding the need to
     * create one manually via {@link ListInputsRequest#builder()}
     * </p>
     *
     * @param listInputsRequest
     *        A {@link Consumer} that will call methods on {@link ListInputsRequest.Builder} to create a request.
     *        Placeholder documentation for ListInputsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException This request was invalid</li>
     *         <li>InternalServerErrorException Internal Service Error</li>
     *         <li>ForbiddenException Access was denied</li>
     *         <li>BadGatewayException Bad Gateway Error</li>
     *         <li>GatewayTimeoutException Gateway Timeout Error</li>
     *         <li>TooManyRequestsException Limit exceeded</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.ListInputs
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListInputs" target="_top">AWS API
     *      Documentation</a>
     */
    default ListInputsPublisher listInputsPaginator(Consumer<ListInputsRequest.Builder> listInputsRequest) {
        return listInputsPaginator(ListInputsRequest.builder().applyMutation(listInputsRequest).build());
    }

    /**
     * List the programs that currently exist for a specific multiplex.
     *
     * @param listMultiplexProgramsRequest
     *        Placeholder documentation for ListMultiplexProgramsRequest
     * @return A Java Future containing the result of the ListMultiplexPrograms operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException MediaLive can't process your request because of a problem in the request. Please
     *         check your request form and syntax.</li>
     *         <li>InternalServerErrorException Unexpected internal service error.</li>
     *         <li>ForbiddenException You do not have permission to list multiplex programs.</li>
     *         <li>BadGatewayException Bad Gateway Error.</li>
     *         <li>NotFoundException MediaLive can't provide the list of programs. The multiplex that you specified
     *         doesn’t exist. Check the ID and try again.</li>
     *         <li>GatewayTimeoutException Gateway Timeout Error.</li>
     *         <li>TooManyRequestsException Request limit exceeded on list multiplex calls to multiplex service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.ListMultiplexPrograms
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListMultiplexPrograms"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListMultiplexProgramsResponse> listMultiplexPrograms(
            ListMultiplexProgramsRequest listMultiplexProgramsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * List the programs that currently exist for a specific multiplex.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListMultiplexProgramsRequest.Builder} avoiding the
     * need to create one manually via {@link ListMultiplexProgramsRequest#builder()}
     * </p>
     *
     * @param listMultiplexProgramsRequest
     *        A {@link Consumer} that will call methods on {@link ListMultiplexProgramsRequest.Builder} to create a
     *        request. Placeholder documentation for ListMultiplexProgramsRequest
     * @return A Java Future containing the result of the ListMultiplexPrograms operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException MediaLive can't process your request because of a problem in the request. Please
     *         check your request form and syntax.</li>
     *         <li>InternalServerErrorException Unexpected internal service error.</li>
     *         <li>ForbiddenException You do not have permission to list multiplex programs.</li>
     *         <li>BadGatewayException Bad Gateway Error.</li>
     *         <li>NotFoundException MediaLive can't provide the list of programs. The multiplex that you specified
     *         doesn’t exist. Check the ID and try again.</li>
     *         <li>GatewayTimeoutException Gateway Timeout Error.</li>
     *         <li>TooManyRequestsException Request limit exceeded on list multiplex calls to multiplex service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.ListMultiplexPrograms
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListMultiplexPrograms"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListMultiplexProgramsResponse> listMultiplexPrograms(
            Consumer<ListMultiplexProgramsRequest.Builder> listMultiplexProgramsRequest) {
        return listMultiplexPrograms(ListMultiplexProgramsRequest.builder().applyMutation(listMultiplexProgramsRequest).build());
    }

    /**
     * List the programs that currently exist for a specific multiplex.<br/>
     * <p>
     * This is a variant of
     * {@link #listMultiplexPrograms(software.amazon.awssdk.services.medialive.model.ListMultiplexProgramsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.medialive.paginators.ListMultiplexProgramsPublisher publisher = client.listMultiplexProgramsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.medialive.paginators.ListMultiplexProgramsPublisher publisher = client.listMultiplexProgramsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.medialive.model.ListMultiplexProgramsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.medialive.model.ListMultiplexProgramsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listMultiplexPrograms(software.amazon.awssdk.services.medialive.model.ListMultiplexProgramsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listMultiplexProgramsRequest
     *        Placeholder documentation for ListMultiplexProgramsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException MediaLive can't process your request because of a problem in the request. Please
     *         check your request form and syntax.</li>
     *         <li>InternalServerErrorException Unexpected internal service error.</li>
     *         <li>ForbiddenException You do not have permission to list multiplex programs.</li>
     *         <li>BadGatewayException Bad Gateway Error.</li>
     *         <li>NotFoundException MediaLive can't provide the list of programs. The multiplex that you specified
     *         doesn’t exist. Check the ID and try again.</li>
     *         <li>GatewayTimeoutException Gateway Timeout Error.</li>
     *         <li>TooManyRequestsException Request limit exceeded on list multiplex calls to multiplex service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.ListMultiplexPrograms
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListMultiplexPrograms"
     *      target="_top">AWS API Documentation</a>
     */
    default ListMultiplexProgramsPublisher listMultiplexProgramsPaginator(
            ListMultiplexProgramsRequest listMultiplexProgramsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * List the programs that currently exist for a specific multiplex.<br/>
     * <p>
     * This is a variant of
     * {@link #listMultiplexPrograms(software.amazon.awssdk.services.medialive.model.ListMultiplexProgramsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.medialive.paginators.ListMultiplexProgramsPublisher publisher = client.listMultiplexProgramsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.medialive.paginators.ListMultiplexProgramsPublisher publisher = client.listMultiplexProgramsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.medialive.model.ListMultiplexProgramsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.medialive.model.ListMultiplexProgramsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listMultiplexPrograms(software.amazon.awssdk.services.medialive.model.ListMultiplexProgramsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListMultiplexProgramsRequest.Builder} avoiding the
     * need to create one manually via {@link ListMultiplexProgramsRequest#builder()}
     * </p>
     *
     * @param listMultiplexProgramsRequest
     *        A {@link Consumer} that will call methods on {@link ListMultiplexProgramsRequest.Builder} to create a
     *        request. Placeholder documentation for ListMultiplexProgramsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException MediaLive can't process your request because of a problem in the request. Please
     *         check your request form and syntax.</li>
     *         <li>InternalServerErrorException Unexpected internal service error.</li>
     *         <li>ForbiddenException You do not have permission to list multiplex programs.</li>
     *         <li>BadGatewayException Bad Gateway Error.</li>
     *         <li>NotFoundException MediaLive can't provide the list of programs. The multiplex that you specified
     *         doesn’t exist. Check the ID and try again.</li>
     *         <li>GatewayTimeoutException Gateway Timeout Error.</li>
     *         <li>TooManyRequestsException Request limit exceeded on list multiplex calls to multiplex service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.ListMultiplexPrograms
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListMultiplexPrograms"
     *      target="_top">AWS API Documentation</a>
     */
    default ListMultiplexProgramsPublisher listMultiplexProgramsPaginator(
            Consumer<ListMultiplexProgramsRequest.Builder> listMultiplexProgramsRequest) {
        return listMultiplexProgramsPaginator(ListMultiplexProgramsRequest.builder().applyMutation(listMultiplexProgramsRequest)
                .build());
    }

    /**
     * Retrieve a list of the existing multiplexes.
     *
     * @param listMultiplexesRequest
     *        Placeholder documentation for ListMultiplexesRequest
     * @return A Java Future containing the result of the ListMultiplexes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException MediaLive can't process your request because of a problem in the request. Please
     *         check your request form and syntax.</li>
     *         <li>InternalServerErrorException Unexpected internal service error.</li>
     *         <li>ForbiddenException You don't have permission to list multiplexes.</li>
     *         <li>BadGatewayException Bad Gateway Error.</li>
     *         <li>GatewayTimeoutException Gateway Timeout Error.</li>
     *         <li>TooManyRequestsException Request limit exceeded on list multiplex calls to multiplex service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.ListMultiplexes
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListMultiplexes" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListMultiplexesResponse> listMultiplexes(ListMultiplexesRequest listMultiplexesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Retrieve a list of the existing multiplexes.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListMultiplexesRequest.Builder} avoiding the need
     * to create one manually via {@link ListMultiplexesRequest#builder()}
     * </p>
     *
     * @param listMultiplexesRequest
     *        A {@link Consumer} that will call methods on {@link ListMultiplexesRequest.Builder} to create a request.
     *        Placeholder documentation for ListMultiplexesRequest
     * @return A Java Future containing the result of the ListMultiplexes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException MediaLive can't process your request because of a problem in the request. Please
     *         check your request form and syntax.</li>
     *         <li>InternalServerErrorException Unexpected internal service error.</li>
     *         <li>ForbiddenException You don't have permission to list multiplexes.</li>
     *         <li>BadGatewayException Bad Gateway Error.</li>
     *         <li>GatewayTimeoutException Gateway Timeout Error.</li>
     *         <li>TooManyRequestsException Request limit exceeded on list multiplex calls to multiplex service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.ListMultiplexes
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListMultiplexes" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListMultiplexesResponse> listMultiplexes(
            Consumer<ListMultiplexesRequest.Builder> listMultiplexesRequest) {
        return listMultiplexes(ListMultiplexesRequest.builder().applyMutation(listMultiplexesRequest).build());
    }

    /**
     * Retrieve a list of the existing multiplexes.<br/>
     * <p>
     * This is a variant of
     * {@link #listMultiplexes(software.amazon.awssdk.services.medialive.model.ListMultiplexesRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.medialive.paginators.ListMultiplexesPublisher publisher = client.listMultiplexesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.medialive.paginators.ListMultiplexesPublisher publisher = client.listMultiplexesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.medialive.model.ListMultiplexesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.medialive.model.ListMultiplexesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listMultiplexes(software.amazon.awssdk.services.medialive.model.ListMultiplexesRequest)} operation.</b>
     * </p>
     *
     * @param listMultiplexesRequest
     *        Placeholder documentation for ListMultiplexesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException MediaLive can't process your request because of a problem in the request. Please
     *         check your request form and syntax.</li>
     *         <li>InternalServerErrorException Unexpected internal service error.</li>
     *         <li>ForbiddenException You don't have permission to list multiplexes.</li>
     *         <li>BadGatewayException Bad Gateway Error.</li>
     *         <li>GatewayTimeoutException Gateway Timeout Error.</li>
     *         <li>TooManyRequestsException Request limit exceeded on list multiplex calls to multiplex service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.ListMultiplexes
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListMultiplexes" target="_top">AWS API
     *      Documentation</a>
     */
    default ListMultiplexesPublisher listMultiplexesPaginator(ListMultiplexesRequest listMultiplexesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Retrieve a list of the existing multiplexes.<br/>
     * <p>
     * This is a variant of
     * {@link #listMultiplexes(software.amazon.awssdk.services.medialive.model.ListMultiplexesRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.medialive.paginators.ListMultiplexesPublisher publisher = client.listMultiplexesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.medialive.paginators.ListMultiplexesPublisher publisher = client.listMultiplexesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.medialive.model.ListMultiplexesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.medialive.model.ListMultiplexesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listMultiplexes(software.amazon.awssdk.services.medialive.model.ListMultiplexesRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListMultiplexesRequest.Builder} avoiding the need
     * to create one manually via {@link ListMultiplexesRequest#builder()}
     * </p>
     *
     * @param listMultiplexesRequest
     *        A {@link Consumer} that will call methods on {@link ListMultiplexesRequest.Builder} to create a request.
     *        Placeholder documentation for ListMultiplexesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException MediaLive can't process your request because of a problem in the request. Please
     *         check your request form and syntax.</li>
     *         <li>InternalServerErrorException Unexpected internal service error.</li>
     *         <li>ForbiddenException You don't have permission to list multiplexes.</li>
     *         <li>BadGatewayException Bad Gateway Error.</li>
     *         <li>GatewayTimeoutException Gateway Timeout Error.</li>
     *         <li>TooManyRequestsException Request limit exceeded on list multiplex calls to multiplex service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.ListMultiplexes
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListMultiplexes" target="_top">AWS API
     *      Documentation</a>
     */
    default ListMultiplexesPublisher listMultiplexesPaginator(Consumer<ListMultiplexesRequest.Builder> listMultiplexesRequest) {
        return listMultiplexesPaginator(ListMultiplexesRequest.builder().applyMutation(listMultiplexesRequest).build());
    }

    /**
     * List offerings available for purchase.
     *
     * @param listOfferingsRequest
     *        Placeholder documentation for ListOfferingsRequest
     * @return A Java Future containing the result of the ListOfferings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException This request was invalid</li>
     *         <li>InternalServerErrorException Internal service error</li>
     *         <li>ForbiddenException You do not have permission to list offerings</li>
     *         <li>BadGatewayException Bad gateway error</li>
     *         <li>GatewayTimeoutException Gateway timeout error</li>
     *         <li>TooManyRequestsException Request limit exceeded on list offerings request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.ListOfferings
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListOfferings" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListOfferingsResponse> listOfferings(ListOfferingsRequest listOfferingsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * List offerings available for purchase.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListOfferingsRequest.Builder} avoiding the need to
     * create one manually via {@link ListOfferingsRequest#builder()}
     * </p>
     *
     * @param listOfferingsRequest
     *        A {@link Consumer} that will call methods on {@link ListOfferingsRequest.Builder} to create a request.
     *        Placeholder documentation for ListOfferingsRequest
     * @return A Java Future containing the result of the ListOfferings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException This request was invalid</li>
     *         <li>InternalServerErrorException Internal service error</li>
     *         <li>ForbiddenException You do not have permission to list offerings</li>
     *         <li>BadGatewayException Bad gateway error</li>
     *         <li>GatewayTimeoutException Gateway timeout error</li>
     *         <li>TooManyRequestsException Request limit exceeded on list offerings request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.ListOfferings
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListOfferings" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListOfferingsResponse> listOfferings(Consumer<ListOfferingsRequest.Builder> listOfferingsRequest) {
        return listOfferings(ListOfferingsRequest.builder().applyMutation(listOfferingsRequest).build());
    }

    /**
     * List offerings available for purchase.
     *
     * @return A Java Future containing the result of the ListOfferings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException This request was invalid</li>
     *         <li>InternalServerErrorException Internal service error</li>
     *         <li>ForbiddenException You do not have permission to list offerings</li>
     *         <li>BadGatewayException Bad gateway error</li>
     *         <li>GatewayTimeoutException Gateway timeout error</li>
     *         <li>TooManyRequestsException Request limit exceeded on list offerings request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.ListOfferings
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListOfferings" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListOfferingsResponse> listOfferings() {
        return listOfferings(ListOfferingsRequest.builder().build());
    }

    /**
     * List offerings available for purchase.<br/>
     * <p>
     * This is a variant of {@link #listOfferings(software.amazon.awssdk.services.medialive.model.ListOfferingsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.medialive.paginators.ListOfferingsPublisher publisher = client.listOfferingsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.medialive.paginators.ListOfferingsPublisher publisher = client.listOfferingsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.medialive.model.ListOfferingsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.medialive.model.ListOfferingsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listOfferings(software.amazon.awssdk.services.medialive.model.ListOfferingsRequest)} operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException This request was invalid</li>
     *         <li>InternalServerErrorException Internal service error</li>
     *         <li>ForbiddenException You do not have permission to list offerings</li>
     *         <li>BadGatewayException Bad gateway error</li>
     *         <li>GatewayTimeoutException Gateway timeout error</li>
     *         <li>TooManyRequestsException Request limit exceeded on list offerings request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.ListOfferings
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListOfferings" target="_top">AWS API
     *      Documentation</a>
     */
    default ListOfferingsPublisher listOfferingsPaginator() {
        return listOfferingsPaginator(ListOfferingsRequest.builder().build());
    }

    /**
     * List offerings available for purchase.<br/>
     * <p>
     * This is a variant of {@link #listOfferings(software.amazon.awssdk.services.medialive.model.ListOfferingsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.medialive.paginators.ListOfferingsPublisher publisher = client.listOfferingsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.medialive.paginators.ListOfferingsPublisher publisher = client.listOfferingsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.medialive.model.ListOfferingsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.medialive.model.ListOfferingsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listOfferings(software.amazon.awssdk.services.medialive.model.ListOfferingsRequest)} operation.</b>
     * </p>
     *
     * @param listOfferingsRequest
     *        Placeholder documentation for ListOfferingsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException This request was invalid</li>
     *         <li>InternalServerErrorException Internal service error</li>
     *         <li>ForbiddenException You do not have permission to list offerings</li>
     *         <li>BadGatewayException Bad gateway error</li>
     *         <li>GatewayTimeoutException Gateway timeout error</li>
     *         <li>TooManyRequestsException Request limit exceeded on list offerings request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.ListOfferings
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListOfferings" target="_top">AWS API
     *      Documentation</a>
     */
    default ListOfferingsPublisher listOfferingsPaginator(ListOfferingsRequest listOfferingsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * List offerings available for purchase.<br/>
     * <p>
     * This is a variant of {@link #listOfferings(software.amazon.awssdk.services.medialive.model.ListOfferingsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.medialive.paginators.ListOfferingsPublisher publisher = client.listOfferingsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.medialive.paginators.ListOfferingsPublisher publisher = client.listOfferingsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.medialive.model.ListOfferingsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.medialive.model.ListOfferingsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listOfferings(software.amazon.awssdk.services.medialive.model.ListOfferingsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListOfferingsRequest.Builder} avoiding the need to
     * create one manually via {@link ListOfferingsRequest#builder()}
     * </p>
     *
     * @param listOfferingsRequest
     *        A {@link Consumer} that will call methods on {@link ListOfferingsRequest.Builder} to create a request.
     *        Placeholder documentation for ListOfferingsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException This request was invalid</li>
     *         <li>InternalServerErrorException Internal service error</li>
     *         <li>ForbiddenException You do not have permission to list offerings</li>
     *         <li>BadGatewayException Bad gateway error</li>
     *         <li>GatewayTimeoutException Gateway timeout error</li>
     *         <li>TooManyRequestsException Request limit exceeded on list offerings request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.ListOfferings
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListOfferings" target="_top">AWS API
     *      Documentation</a>
     */
    default ListOfferingsPublisher listOfferingsPaginator(Consumer<ListOfferingsRequest.Builder> listOfferingsRequest) {
        return listOfferingsPaginator(ListOfferingsRequest.builder().applyMutation(listOfferingsRequest).build());
    }

    /**
     * List purchased reservations.
     *
     * @param listReservationsRequest
     *        Placeholder documentation for ListReservationsRequest
     * @return A Java Future containing the result of the ListReservations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException This request was invalid</li>
     *         <li>InternalServerErrorException Internal service error</li>
     *         <li>ForbiddenException You do not have permission to list reservations</li>
     *         <li>BadGatewayException Bad gateway error</li>
     *         <li>GatewayTimeoutException Gateway timeout error</li>
     *         <li>TooManyRequestsException Request limit exceeded on list reservations request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.ListReservations
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListReservations" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListReservationsResponse> listReservations(ListReservationsRequest listReservationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * List purchased reservations.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListReservationsRequest.Builder} avoiding the need
     * to create one manually via {@link ListReservationsRequest#builder()}
     * </p>
     *
     * @param listReservationsRequest
     *        A {@link Consumer} that will call methods on {@link ListReservationsRequest.Builder} to create a request.
     *        Placeholder documentation for ListReservationsRequest
     * @return A Java Future containing the result of the ListReservations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException This request was invalid</li>
     *         <li>InternalServerErrorException Internal service error</li>
     *         <li>ForbiddenException You do not have permission to list reservations</li>
     *         <li>BadGatewayException Bad gateway error</li>
     *         <li>GatewayTimeoutException Gateway timeout error</li>
     *         <li>TooManyRequestsException Request limit exceeded on list reservations request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.ListReservations
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListReservations" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListReservationsResponse> listReservations(
            Consumer<ListReservationsRequest.Builder> listReservationsRequest) {
        return listReservations(ListReservationsRequest.builder().applyMutation(listReservationsRequest).build());
    }

    /**
     * List purchased reservations.
     *
     * @return A Java Future containing the result of the ListReservations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException This request was invalid</li>
     *         <li>InternalServerErrorException Internal service error</li>
     *         <li>ForbiddenException You do not have permission to list reservations</li>
     *         <li>BadGatewayException Bad gateway error</li>
     *         <li>GatewayTimeoutException Gateway timeout error</li>
     *         <li>TooManyRequestsException Request limit exceeded on list reservations request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.ListReservations
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListReservations" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListReservationsResponse> listReservations() {
        return listReservations(ListReservationsRequest.builder().build());
    }

    /**
     * List purchased reservations.<br/>
     * <p>
     * This is a variant of
     * {@link #listReservations(software.amazon.awssdk.services.medialive.model.ListReservationsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.medialive.paginators.ListReservationsPublisher publisher = client.listReservationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.medialive.paginators.ListReservationsPublisher publisher = client.listReservationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.medialive.model.ListReservationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.medialive.model.ListReservationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listReservations(software.amazon.awssdk.services.medialive.model.ListReservationsRequest)} operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException This request was invalid</li>
     *         <li>InternalServerErrorException Internal service error</li>
     *         <li>ForbiddenException You do not have permission to list reservations</li>
     *         <li>BadGatewayException Bad gateway error</li>
     *         <li>GatewayTimeoutException Gateway timeout error</li>
     *         <li>TooManyRequestsException Request limit exceeded on list reservations request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.ListReservations
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListReservations" target="_top">AWS API
     *      Documentation</a>
     */
    default ListReservationsPublisher listReservationsPaginator() {
        return listReservationsPaginator(ListReservationsRequest.builder().build());
    }

    /**
     * List purchased reservations.<br/>
     * <p>
     * This is a variant of
     * {@link #listReservations(software.amazon.awssdk.services.medialive.model.ListReservationsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.medialive.paginators.ListReservationsPublisher publisher = client.listReservationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.medialive.paginators.ListReservationsPublisher publisher = client.listReservationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.medialive.model.ListReservationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.medialive.model.ListReservationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listReservations(software.amazon.awssdk.services.medialive.model.ListReservationsRequest)} operation.</b>
     * </p>
     *
     * @param listReservationsRequest
     *        Placeholder documentation for ListReservationsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException This request was invalid</li>
     *         <li>InternalServerErrorException Internal service error</li>
     *         <li>ForbiddenException You do not have permission to list reservations</li>
     *         <li>BadGatewayException Bad gateway error</li>
     *         <li>GatewayTimeoutException Gateway timeout error</li>
     *         <li>TooManyRequestsException Request limit exceeded on list reservations request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.ListReservations
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListReservations" target="_top">AWS API
     *      Documentation</a>
     */
    default ListReservationsPublisher listReservationsPaginator(ListReservationsRequest listReservationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * List purchased reservations.<br/>
     * <p>
     * This is a variant of
     * {@link #listReservations(software.amazon.awssdk.services.medialive.model.ListReservationsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.medialive.paginators.ListReservationsPublisher publisher = client.listReservationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.medialive.paginators.ListReservationsPublisher publisher = client.listReservationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.medialive.model.ListReservationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.medialive.model.ListReservationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listReservations(software.amazon.awssdk.services.medialive.model.ListReservationsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListReservationsRequest.Builder} avoiding the need
     * to create one manually via {@link ListReservationsRequest#builder()}
     * </p>
     *
     * @param listReservationsRequest
     *        A {@link Consumer} that will call methods on {@link ListReservationsRequest.Builder} to create a request.
     *        Placeholder documentation for ListReservationsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException This request was invalid</li>
     *         <li>InternalServerErrorException Internal service error</li>
     *         <li>ForbiddenException You do not have permission to list reservations</li>
     *         <li>BadGatewayException Bad gateway error</li>
     *         <li>GatewayTimeoutException Gateway timeout error</li>
     *         <li>TooManyRequestsException Request limit exceeded on list reservations request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.ListReservations
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListReservations" target="_top">AWS API
     *      Documentation</a>
     */
    default ListReservationsPublisher listReservationsPaginator(Consumer<ListReservationsRequest.Builder> listReservationsRequest) {
        return listReservationsPaginator(ListReservationsRequest.builder().applyMutation(listReservationsRequest).build());
    }

    /**
     * Produces list of tags that have been created for a resource
     *
     * @param listTagsForResourceRequest
     *        Placeholder documentation for ListTagsForResourceRequest
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The arn was not found</li>
     *         <li>BadRequestException This request was invalid</li>
     *         <li>InternalServerErrorException Internal Service Error</li>
     *         <li>ForbiddenException Access was denied</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.ListTagsForResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListTagsForResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            ListTagsForResourceRequest listTagsForResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Produces list of tags that have been created for a resource<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on {@link ListTagsForResourceRequest.Builder} to create a
     *        request. Placeholder documentation for ListTagsForResourceRequest
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The arn was not found</li>
     *         <li>BadRequestException This request was invalid</li>
     *         <li>InternalServerErrorException Internal Service Error</li>
     *         <li>ForbiddenException Access was denied</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.ListTagsForResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/ListTagsForResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * Purchase an offering and create a reservation.
     *
     * @param purchaseOfferingRequest
     *        Placeholder documentation for PurchaseOfferingRequest
     * @return A Java Future containing the result of the PurchaseOffering operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException This request was invalid</li>
     *         <li>InternalServerErrorException Internal service error</li>
     *         <li>ForbiddenException You do not have permission to purchase the offering</li>
     *         <li>BadGatewayException Bad gateway error</li>
     *         <li>NotFoundException Offering you're attempting to purchase does not exist</li>
     *         <li>GatewayTimeoutException Gateway timeout error</li>
     *         <li>TooManyRequestsException Request limit exceeded on purchase offering request</li>
     *         <li>ConflictException Offering purchase prevented by service resource issue</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.PurchaseOffering
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/PurchaseOffering" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<PurchaseOfferingResponse> purchaseOffering(PurchaseOfferingRequest purchaseOfferingRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Purchase an offering and create a reservation.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PurchaseOfferingRequest.Builder} avoiding the need
     * to create one manually via {@link PurchaseOfferingRequest#builder()}
     * </p>
     *
     * @param purchaseOfferingRequest
     *        A {@link Consumer} that will call methods on {@link PurchaseOfferingRequest.Builder} to create a request.
     *        Placeholder documentation for PurchaseOfferingRequest
     * @return A Java Future containing the result of the PurchaseOffering operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException This request was invalid</li>
     *         <li>InternalServerErrorException Internal service error</li>
     *         <li>ForbiddenException You do not have permission to purchase the offering</li>
     *         <li>BadGatewayException Bad gateway error</li>
     *         <li>NotFoundException Offering you're attempting to purchase does not exist</li>
     *         <li>GatewayTimeoutException Gateway timeout error</li>
     *         <li>TooManyRequestsException Request limit exceeded on purchase offering request</li>
     *         <li>ConflictException Offering purchase prevented by service resource issue</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.PurchaseOffering
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/PurchaseOffering" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<PurchaseOfferingResponse> purchaseOffering(
            Consumer<PurchaseOfferingRequest.Builder> purchaseOfferingRequest) {
        return purchaseOffering(PurchaseOfferingRequest.builder().applyMutation(purchaseOfferingRequest).build());
    }

    /**
     * Starts an existing channel
     *
     * @param startChannelRequest
     *        Placeholder documentation for StartChannelRequest
     * @return A Java Future containing the result of the StartChannel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException This request was invalid.</li>
     *         <li>InternalServerErrorException Unexpected internal service error.</li>
     *         <li>ForbiddenException You do not have permission to start the channel.</li>
     *         <li>BadGatewayException Bad Gateway Error</li>
     *         <li>NotFoundException The channel you're requesting to start does not exist.</li>
     *         <li>GatewayTimeoutException Gateway Timeout Error</li>
     *         <li>TooManyRequestsException Request limit exceeded on start channel calls to channel service.</li>
     *         <li>ConflictException The channel is unable to start due to an issue with channel resources.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.StartChannel
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/StartChannel" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<StartChannelResponse> startChannel(StartChannelRequest startChannelRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Starts an existing channel<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartChannelRequest.Builder} avoiding the need to
     * create one manually via {@link StartChannelRequest#builder()}
     * </p>
     *
     * @param startChannelRequest
     *        A {@link Consumer} that will call methods on {@link StartChannelRequest.Builder} to create a request.
     *        Placeholder documentation for StartChannelRequest
     * @return A Java Future containing the result of the StartChannel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException This request was invalid.</li>
     *         <li>InternalServerErrorException Unexpected internal service error.</li>
     *         <li>ForbiddenException You do not have permission to start the channel.</li>
     *         <li>BadGatewayException Bad Gateway Error</li>
     *         <li>NotFoundException The channel you're requesting to start does not exist.</li>
     *         <li>GatewayTimeoutException Gateway Timeout Error</li>
     *         <li>TooManyRequestsException Request limit exceeded on start channel calls to channel service.</li>
     *         <li>ConflictException The channel is unable to start due to an issue with channel resources.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.StartChannel
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/StartChannel" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<StartChannelResponse> startChannel(Consumer<StartChannelRequest.Builder> startChannelRequest) {
        return startChannel(StartChannelRequest.builder().applyMutation(startChannelRequest).build());
    }

    /**
     * Start (run) the multiplex. Starting the multiplex does not start the channels. You must explicitly start each
     * channel.
     *
     * @param startMultiplexRequest
     *        Placeholder documentation for StartMultiplexRequest
     * @return A Java Future containing the result of the StartMultiplex operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException MediaLive can't process your request because of a problem in the request. Please
     *         check your request form and syntax.</li>
     *         <li>InternalServerErrorException Unexpected internal service error.</li>
     *         <li>ForbiddenException You don't have permission to start the multiplex.</li>
     *         <li>BadGatewayException Bad Gateway Error.</li>
     *         <li>NotFoundException The multiplex that you are trying to start doesn’t exist. Check the ID and try
     *         again.</li>
     *         <li>GatewayTimeoutException Gateway Timeout Error.</li>
     *         <li>TooManyRequestsException Request limit exceeded on start multiplex calls to multiplex service.</li>
     *         <li>ConflictException The multiplex is unable to start due to an issue with multiplex resources.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.StartMultiplex
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/StartMultiplex" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<StartMultiplexResponse> startMultiplex(StartMultiplexRequest startMultiplexRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Start (run) the multiplex. Starting the multiplex does not start the channels. You must explicitly start each
     * channel.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartMultiplexRequest.Builder} avoiding the need to
     * create one manually via {@link StartMultiplexRequest#builder()}
     * </p>
     *
     * @param startMultiplexRequest
     *        A {@link Consumer} that will call methods on {@link StartMultiplexRequest.Builder} to create a request.
     *        Placeholder documentation for StartMultiplexRequest
     * @return A Java Future containing the result of the StartMultiplex operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException MediaLive can't process your request because of a problem in the request. Please
     *         check your request form and syntax.</li>
     *         <li>InternalServerErrorException Unexpected internal service error.</li>
     *         <li>ForbiddenException You don't have permission to start the multiplex.</li>
     *         <li>BadGatewayException Bad Gateway Error.</li>
     *         <li>NotFoundException The multiplex that you are trying to start doesn’t exist. Check the ID and try
     *         again.</li>
     *         <li>GatewayTimeoutException Gateway Timeout Error.</li>
     *         <li>TooManyRequestsException Request limit exceeded on start multiplex calls to multiplex service.</li>
     *         <li>ConflictException The multiplex is unable to start due to an issue with multiplex resources.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.StartMultiplex
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/StartMultiplex" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<StartMultiplexResponse> startMultiplex(Consumer<StartMultiplexRequest.Builder> startMultiplexRequest) {
        return startMultiplex(StartMultiplexRequest.builder().applyMutation(startMultiplexRequest).build());
    }

    /**
     * Stops a running channel
     *
     * @param stopChannelRequest
     *        Placeholder documentation for StopChannelRequest
     * @return A Java Future containing the result of the StopChannel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException This request was invalid.</li>
     *         <li>InternalServerErrorException Unexpected internal service error.</li>
     *         <li>ForbiddenException You do not have permission to stop the channel.</li>
     *         <li>BadGatewayException Bad Gateway Error</li>
     *         <li>NotFoundException The channel you're requesting to stop does not exist.</li>
     *         <li>GatewayTimeoutException Gateway Timeout Error</li>
     *         <li>TooManyRequestsException Request limit exceeded on stop channel calls to channel service.</li>
     *         <li>ConflictException The channel is unable to stop due to an issue with channel resources.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.StopChannel
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/StopChannel" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<StopChannelResponse> stopChannel(StopChannelRequest stopChannelRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Stops a running channel<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StopChannelRequest.Builder} avoiding the need to
     * create one manually via {@link StopChannelRequest#builder()}
     * </p>
     *
     * @param stopChannelRequest
     *        A {@link Consumer} that will call methods on {@link StopChannelRequest.Builder} to create a request.
     *        Placeholder documentation for StopChannelRequest
     * @return A Java Future containing the result of the StopChannel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException This request was invalid.</li>
     *         <li>InternalServerErrorException Unexpected internal service error.</li>
     *         <li>ForbiddenException You do not have permission to stop the channel.</li>
     *         <li>BadGatewayException Bad Gateway Error</li>
     *         <li>NotFoundException The channel you're requesting to stop does not exist.</li>
     *         <li>GatewayTimeoutException Gateway Timeout Error</li>
     *         <li>TooManyRequestsException Request limit exceeded on stop channel calls to channel service.</li>
     *         <li>ConflictException The channel is unable to stop due to an issue with channel resources.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.StopChannel
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/StopChannel" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<StopChannelResponse> stopChannel(Consumer<StopChannelRequest.Builder> stopChannelRequest) {
        return stopChannel(StopChannelRequest.builder().applyMutation(stopChannelRequest).build());
    }

    /**
     * Stops a running multiplex. If the multiplex isn't running, this action has no effect.
     *
     * @param stopMultiplexRequest
     *        Placeholder documentation for StopMultiplexRequest
     * @return A Java Future containing the result of the StopMultiplex operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException MediaLive can't process your request because of a problem in the request. Please
     *         check your request form and syntax.</li>
     *         <li>InternalServerErrorException Unexpected internal service error.</li>
     *         <li>ForbiddenException You don't have permission to stop the multiplex.</li>
     *         <li>BadGatewayException Bad Gateway Error.</li>
     *         <li>NotFoundException The multiplex that you are trying to stop doesn’t exist. Check the ID and try
     *         again.</li>
     *         <li>GatewayTimeoutException Gateway Timeout Error.</li>
     *         <li>TooManyRequestsException Request limit exceeded on stop multiplex calls to multiplex service.</li>
     *         <li>ConflictException The multiplex is unable to stop due to an issue with multiplex resources.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.StopMultiplex
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/StopMultiplex" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<StopMultiplexResponse> stopMultiplex(StopMultiplexRequest stopMultiplexRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Stops a running multiplex. If the multiplex isn't running, this action has no effect.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StopMultiplexRequest.Builder} avoiding the need to
     * create one manually via {@link StopMultiplexRequest#builder()}
     * </p>
     *
     * @param stopMultiplexRequest
     *        A {@link Consumer} that will call methods on {@link StopMultiplexRequest.Builder} to create a request.
     *        Placeholder documentation for StopMultiplexRequest
     * @return A Java Future containing the result of the StopMultiplex operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException MediaLive can't process your request because of a problem in the request. Please
     *         check your request form and syntax.</li>
     *         <li>InternalServerErrorException Unexpected internal service error.</li>
     *         <li>ForbiddenException You don't have permission to stop the multiplex.</li>
     *         <li>BadGatewayException Bad Gateway Error.</li>
     *         <li>NotFoundException The multiplex that you are trying to stop doesn’t exist. Check the ID and try
     *         again.</li>
     *         <li>GatewayTimeoutException Gateway Timeout Error.</li>
     *         <li>TooManyRequestsException Request limit exceeded on stop multiplex calls to multiplex service.</li>
     *         <li>ConflictException The multiplex is unable to stop due to an issue with multiplex resources.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.StopMultiplex
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/StopMultiplex" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<StopMultiplexResponse> stopMultiplex(Consumer<StopMultiplexRequest.Builder> stopMultiplexRequest) {
        return stopMultiplex(StopMultiplexRequest.builder().applyMutation(stopMultiplexRequest).build());
    }

    /**
     * Updates a channel.
     *
     * @param updateChannelRequest
     *        A request to update a channel.
     * @return A Java Future containing the result of the UpdateChannel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException This request was invalid.</li>
     *         <li>UnprocessableEntityException The channel configuration failed validation and could not be updated.</li>
     *         <li>InternalServerErrorException Unexpected internal service error.</li>
     *         <li>ForbiddenException You do not have permission to update the channel.</li>
     *         <li>BadGatewayException Bad Gateway Error</li>
     *         <li>GatewayTimeoutException Gateway Timeout Error</li>
     *         <li>ConflictException The channel is unable to update due to an issue with channel resources.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.UpdateChannel
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/UpdateChannel" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateChannelResponse> updateChannel(UpdateChannelRequest updateChannelRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Updates a channel.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateChannelRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateChannelRequest#builder()}
     * </p>
     *
     * @param updateChannelRequest
     *        A {@link Consumer} that will call methods on {@link UpdateChannelRequest.Builder} to create a request. A
     *        request to update a channel.
     * @return A Java Future containing the result of the UpdateChannel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException This request was invalid.</li>
     *         <li>UnprocessableEntityException The channel configuration failed validation and could not be updated.</li>
     *         <li>InternalServerErrorException Unexpected internal service error.</li>
     *         <li>ForbiddenException You do not have permission to update the channel.</li>
     *         <li>BadGatewayException Bad Gateway Error</li>
     *         <li>GatewayTimeoutException Gateway Timeout Error</li>
     *         <li>ConflictException The channel is unable to update due to an issue with channel resources.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.UpdateChannel
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/UpdateChannel" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateChannelResponse> updateChannel(Consumer<UpdateChannelRequest.Builder> updateChannelRequest) {
        return updateChannel(UpdateChannelRequest.builder().applyMutation(updateChannelRequest).build());
    }

    /**
     * Changes the class of the channel.
     *
     * @param updateChannelClassRequest
     *        Channel class that the channel should be updated to.
     * @return A Java Future containing the result of the UpdateChannelClass operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException This request to update the channel class was invalid.</li>
     *         <li>UnprocessableEntityException The channel configuration failed validation when attempting to update
     *         the channel class.</li>
     *         <li>InternalServerErrorException Unexpected internal service error.</li>
     *         <li>ForbiddenException You do not have permission to update the class of this channel.</li>
     *         <li>BadGatewayException Bad Gateway Error</li>
     *         <li>NotFoundException The channel you're trying to update the class on does not exist.</li>
     *         <li>GatewayTimeoutException Gateway Timeout Error</li>
     *         <li>TooManyRequestsException Request limit exceeded on update channel class calls.</li>
     *         <li>ConflictException The channel class cannot be updated due to an issue with channel resources.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.UpdateChannelClass
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/UpdateChannelClass" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateChannelClassResponse> updateChannelClass(UpdateChannelClassRequest updateChannelClassRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Changes the class of the channel.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateChannelClassRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateChannelClassRequest#builder()}
     * </p>
     *
     * @param updateChannelClassRequest
     *        A {@link Consumer} that will call methods on {@link UpdateChannelClassRequest.Builder} to create a
     *        request. Channel class that the channel should be updated to.
     * @return A Java Future containing the result of the UpdateChannelClass operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException This request to update the channel class was invalid.</li>
     *         <li>UnprocessableEntityException The channel configuration failed validation when attempting to update
     *         the channel class.</li>
     *         <li>InternalServerErrorException Unexpected internal service error.</li>
     *         <li>ForbiddenException You do not have permission to update the class of this channel.</li>
     *         <li>BadGatewayException Bad Gateway Error</li>
     *         <li>NotFoundException The channel you're trying to update the class on does not exist.</li>
     *         <li>GatewayTimeoutException Gateway Timeout Error</li>
     *         <li>TooManyRequestsException Request limit exceeded on update channel class calls.</li>
     *         <li>ConflictException The channel class cannot be updated due to an issue with channel resources.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.UpdateChannelClass
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/UpdateChannelClass" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateChannelClassResponse> updateChannelClass(
            Consumer<UpdateChannelClassRequest.Builder> updateChannelClassRequest) {
        return updateChannelClass(UpdateChannelClassRequest.builder().applyMutation(updateChannelClassRequest).build());
    }

    /**
     * Updates an input.
     *
     * @param updateInputRequest
     *        A request to update an input.
     * @return A Java Future containing the result of the UpdateInput operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException This request to update the input was invalid.</li>
     *         <li>InternalServerErrorException Internal Service Error</li>
     *         <li>ForbiddenException The requester does not have permission to update an input.</li>
     *         <li>BadGatewayException Bad Gateway Error</li>
     *         <li>NotFoundException The input was not found.</li>
     *         <li>GatewayTimeoutException Gateway Timeout Error</li>
     *         <li>ConflictException The input was unable to be updated at this time due to an issue with input
     *         resources.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.UpdateInput
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/UpdateInput" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateInputResponse> updateInput(UpdateInputRequest updateInputRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Updates an input.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateInputRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateInputRequest#builder()}
     * </p>
     *
     * @param updateInputRequest
     *        A {@link Consumer} that will call methods on {@link UpdateInputRequest.Builder} to create a request. A
     *        request to update an input.
     * @return A Java Future containing the result of the UpdateInput operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException This request to update the input was invalid.</li>
     *         <li>InternalServerErrorException Internal Service Error</li>
     *         <li>ForbiddenException The requester does not have permission to update an input.</li>
     *         <li>BadGatewayException Bad Gateway Error</li>
     *         <li>NotFoundException The input was not found.</li>
     *         <li>GatewayTimeoutException Gateway Timeout Error</li>
     *         <li>ConflictException The input was unable to be updated at this time due to an issue with input
     *         resources.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.UpdateInput
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/UpdateInput" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateInputResponse> updateInput(Consumer<UpdateInputRequest.Builder> updateInputRequest) {
        return updateInput(UpdateInputRequest.builder().applyMutation(updateInputRequest).build());
    }

    /**
     * Updates the parameters for the input device.
     *
     * @param updateInputDeviceRequest
     *        A request to update an input device.
     * @return A Java Future containing the result of the UpdateInputDevice operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException This request was invalid.</li>
     *         <li>UnprocessableEntityException Input device failed validation and could not be created.</li>
     *         <li>InternalServerErrorException Unexpected internal service error.</li>
     *         <li>ForbiddenException You do not have permission to update the input device.</li>
     *         <li>BadGatewayException Bad gateway error.</li>
     *         <li>NotFoundException The input device you're requesting to does not exist. Check the ID.</li>
     *         <li>GatewayTimeoutException Gateway timeout error.</li>
     *         <li>TooManyRequestsException Request limit exceeded on update calls to the input device service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.UpdateInputDevice
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/UpdateInputDevice" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateInputDeviceResponse> updateInputDevice(UpdateInputDeviceRequest updateInputDeviceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Updates the parameters for the input device.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateInputDeviceRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateInputDeviceRequest#builder()}
     * </p>
     *
     * @param updateInputDeviceRequest
     *        A {@link Consumer} that will call methods on {@link UpdateInputDeviceRequest.Builder} to create a request.
     *        A request to update an input device.
     * @return A Java Future containing the result of the UpdateInputDevice operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException This request was invalid.</li>
     *         <li>UnprocessableEntityException Input device failed validation and could not be created.</li>
     *         <li>InternalServerErrorException Unexpected internal service error.</li>
     *         <li>ForbiddenException You do not have permission to update the input device.</li>
     *         <li>BadGatewayException Bad gateway error.</li>
     *         <li>NotFoundException The input device you're requesting to does not exist. Check the ID.</li>
     *         <li>GatewayTimeoutException Gateway timeout error.</li>
     *         <li>TooManyRequestsException Request limit exceeded on update calls to the input device service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.UpdateInputDevice
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/UpdateInputDevice" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateInputDeviceResponse> updateInputDevice(
            Consumer<UpdateInputDeviceRequest.Builder> updateInputDeviceRequest) {
        return updateInputDevice(UpdateInputDeviceRequest.builder().applyMutation(updateInputDeviceRequest).build());
    }

    /**
     * Update an Input Security Group's Whilelists.
     *
     * @param updateInputSecurityGroupRequest
     *        The request to update some combination of the Input Security Group name and the IPv4 CIDRs the Input
     *        Security Group should allow.
     * @return A Java Future containing the result of the UpdateInputSecurityGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request to update the Input Security Group was invalid</li>
     *         <li>InternalServerErrorException Internal Server Error</li>
     *         <li>ForbiddenException The requester does not have permission to update an Input Security Group</li>
     *         <li>BadGatewayException Bad Gateway Error</li>
     *         <li>NotFoundException The Input Security Group was not found.</li>
     *         <li>GatewayTimeoutException Gateway Timeout Error</li>
     *         <li>ConflictException The Input Security Group was unable to be updated due to an issue with input
     *         security group resources.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.UpdateInputSecurityGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/UpdateInputSecurityGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateInputSecurityGroupResponse> updateInputSecurityGroup(
            UpdateInputSecurityGroupRequest updateInputSecurityGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Update an Input Security Group's Whilelists.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateInputSecurityGroupRequest.Builder} avoiding
     * the need to create one manually via {@link UpdateInputSecurityGroupRequest#builder()}
     * </p>
     *
     * @param updateInputSecurityGroupRequest
     *        A {@link Consumer} that will call methods on {@link UpdateInputSecurityGroupRequest.Builder} to create a
     *        request. The request to update some combination of the Input Security Group name and the IPv4 CIDRs the
     *        Input Security Group should allow.
     * @return A Java Future containing the result of the UpdateInputSecurityGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request to update the Input Security Group was invalid</li>
     *         <li>InternalServerErrorException Internal Server Error</li>
     *         <li>ForbiddenException The requester does not have permission to update an Input Security Group</li>
     *         <li>BadGatewayException Bad Gateway Error</li>
     *         <li>NotFoundException The Input Security Group was not found.</li>
     *         <li>GatewayTimeoutException Gateway Timeout Error</li>
     *         <li>ConflictException The Input Security Group was unable to be updated due to an issue with input
     *         security group resources.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.UpdateInputSecurityGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/UpdateInputSecurityGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateInputSecurityGroupResponse> updateInputSecurityGroup(
            Consumer<UpdateInputSecurityGroupRequest.Builder> updateInputSecurityGroupRequest) {
        return updateInputSecurityGroup(UpdateInputSecurityGroupRequest.builder().applyMutation(updateInputSecurityGroupRequest)
                .build());
    }

    /**
     * Updates a multiplex.
     *
     * @param updateMultiplexRequest
     *        A request to update a multiplex.
     * @return A Java Future containing the result of the UpdateMultiplex operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException MediaLive can't process your request because of a problem in the request. Please
     *         check your request form and syntax.</li>
     *         <li>UnprocessableEntityException The multiplex configuration failed validation and could not be updated.</li>
     *         <li>InternalServerErrorException Unexpected internal service error.</li>
     *         <li>ForbiddenException You don't have permission to update the multiplex.</li>
     *         <li>BadGatewayException Bad Gateway Error.</li>
     *         <li>NotFoundException The multiplex that you are trying to update doesn’t exist. Check the ID and try
     *         again.</li>
     *         <li>GatewayTimeoutException Gateway Timeout Error.</li>
     *         <li>ConflictException The multiplex is unable to update due to an issue with multiplex resources.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.UpdateMultiplex
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/UpdateMultiplex" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateMultiplexResponse> updateMultiplex(UpdateMultiplexRequest updateMultiplexRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Updates a multiplex.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateMultiplexRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateMultiplexRequest#builder()}
     * </p>
     *
     * @param updateMultiplexRequest
     *        A {@link Consumer} that will call methods on {@link UpdateMultiplexRequest.Builder} to create a request. A
     *        request to update a multiplex.
     * @return A Java Future containing the result of the UpdateMultiplex operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException MediaLive can't process your request because of a problem in the request. Please
     *         check your request form and syntax.</li>
     *         <li>UnprocessableEntityException The multiplex configuration failed validation and could not be updated.</li>
     *         <li>InternalServerErrorException Unexpected internal service error.</li>
     *         <li>ForbiddenException You don't have permission to update the multiplex.</li>
     *         <li>BadGatewayException Bad Gateway Error.</li>
     *         <li>NotFoundException The multiplex that you are trying to update doesn’t exist. Check the ID and try
     *         again.</li>
     *         <li>GatewayTimeoutException Gateway Timeout Error.</li>
     *         <li>ConflictException The multiplex is unable to update due to an issue with multiplex resources.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.UpdateMultiplex
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/UpdateMultiplex" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateMultiplexResponse> updateMultiplex(
            Consumer<UpdateMultiplexRequest.Builder> updateMultiplexRequest) {
        return updateMultiplex(UpdateMultiplexRequest.builder().applyMutation(updateMultiplexRequest).build());
    }

    /**
     * Update a program in a multiplex.
     *
     * @param updateMultiplexProgramRequest
     *        A request to update a program in a multiplex.
     * @return A Java Future containing the result of the UpdateMultiplexProgram operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException MediaLive can't process your request because of a problem in the request. Please
     *         check your request form and syntax.</li>
     *         <li>UnprocessableEntityException The multiplex program failed validation and could not be updated.</li>
     *         <li>InternalServerErrorException Unexpected internal service error.</li>
     *         <li>ForbiddenException You don't have permission to update the multiplex program.</li>
     *         <li>BadGatewayException Bad Gateway Error.</li>
     *         <li>NotFoundException MediaLive can't update the program. The multiplex or the program that you specified
     *         doesn’t exist. Check the IDs and try again.</li>
     *         <li>GatewayTimeoutException Gateway Timeout Error.</li>
     *         <li>ConflictException The multiplex program is unable to update due to an issue with multiplex resources.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.UpdateMultiplexProgram
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/UpdateMultiplexProgram"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateMultiplexProgramResponse> updateMultiplexProgram(
            UpdateMultiplexProgramRequest updateMultiplexProgramRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Update a program in a multiplex.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateMultiplexProgramRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateMultiplexProgramRequest#builder()}
     * </p>
     *
     * @param updateMultiplexProgramRequest
     *        A {@link Consumer} that will call methods on {@link UpdateMultiplexProgramRequest.Builder} to create a
     *        request. A request to update a program in a multiplex.
     * @return A Java Future containing the result of the UpdateMultiplexProgram operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException MediaLive can't process your request because of a problem in the request. Please
     *         check your request form and syntax.</li>
     *         <li>UnprocessableEntityException The multiplex program failed validation and could not be updated.</li>
     *         <li>InternalServerErrorException Unexpected internal service error.</li>
     *         <li>ForbiddenException You don't have permission to update the multiplex program.</li>
     *         <li>BadGatewayException Bad Gateway Error.</li>
     *         <li>NotFoundException MediaLive can't update the program. The multiplex or the program that you specified
     *         doesn’t exist. Check the IDs and try again.</li>
     *         <li>GatewayTimeoutException Gateway Timeout Error.</li>
     *         <li>ConflictException The multiplex program is unable to update due to an issue with multiplex resources.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.UpdateMultiplexProgram
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/UpdateMultiplexProgram"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateMultiplexProgramResponse> updateMultiplexProgram(
            Consumer<UpdateMultiplexProgramRequest.Builder> updateMultiplexProgramRequest) {
        return updateMultiplexProgram(UpdateMultiplexProgramRequest.builder().applyMutation(updateMultiplexProgramRequest)
                .build());
    }

    /**
     * Update reservation.
     *
     * @param updateReservationRequest
     *        Request to update a reservation
     * @return A Java Future containing the result of the UpdateReservation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException This request was invalid</li>
     *         <li>InternalServerErrorException Internal service error</li>
     *         <li>ForbiddenException You do not have permission to update reservation</li>
     *         <li>BadGatewayException Bad gateway error</li>
     *         <li>NotFoundException Reservation not found</li>
     *         <li>GatewayTimeoutException Gateway timeout error</li>
     *         <li>TooManyRequestsException Request limit exceeded</li>
     *         <li>ConflictException The reservation could not be updated</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.UpdateReservation
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/UpdateReservation" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateReservationResponse> updateReservation(UpdateReservationRequest updateReservationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Update reservation.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateReservationRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateReservationRequest#builder()}
     * </p>
     *
     * @param updateReservationRequest
     *        A {@link Consumer} that will call methods on {@link UpdateReservationRequest.Builder} to create a request.
     *        Request to update a reservation
     * @return A Java Future containing the result of the UpdateReservation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException This request was invalid</li>
     *         <li>InternalServerErrorException Internal service error</li>
     *         <li>ForbiddenException You do not have permission to update reservation</li>
     *         <li>BadGatewayException Bad gateway error</li>
     *         <li>NotFoundException Reservation not found</li>
     *         <li>GatewayTimeoutException Gateway timeout error</li>
     *         <li>TooManyRequestsException Request limit exceeded</li>
     *         <li>ConflictException The reservation could not be updated</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MediaLiveException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample MediaLiveAsyncClient.UpdateReservation
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/UpdateReservation" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateReservationResponse> updateReservation(
            Consumer<UpdateReservationRequest.Builder> updateReservationRequest) {
        return updateReservation(UpdateReservationRequest.builder().applyMutation(updateReservationRequest).build());
    }
}
