/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.medialive.model.MediaLiveResponse;
import software.amazon.awssdk.services.medialive.model.MultiplexOutputDestination;
import software.amazon.awssdk.services.medialive.model.MultiplexSettings;
import software.amazon.awssdk.services.medialive.model.MultiplexState;
import software.amazon.awssdk.services.medialive.model.TagsCopier;
import software.amazon.awssdk.services.medialive.model.___listOfMultiplexOutputDestinationCopier;
import software.amazon.awssdk.services.medialive.model.___listOf__stringCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteMultiplexResponse
extends MediaLiveResponse
implements ToCopyableBuilder<Builder, DeleteMultiplexResponse> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DeleteMultiplexResponse.getter(DeleteMultiplexResponse::arn)).setter(DeleteMultiplexResponse.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<List<String>> AVAILABILITY_ZONES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(DeleteMultiplexResponse.getter(DeleteMultiplexResponse::availabilityZones)).setter(DeleteMultiplexResponse.setter(Builder::availabilityZones)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("availabilityZones").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<MultiplexOutputDestination>> DESTINATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(DeleteMultiplexResponse.getter(DeleteMultiplexResponse::destinations)).setter(DeleteMultiplexResponse.setter(Builder::destinations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MultiplexOutputDestination::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DeleteMultiplexResponse.getter(DeleteMultiplexResponse::id)).setter(DeleteMultiplexResponse.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<MultiplexSettings> MULTIPLEX_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(DeleteMultiplexResponse.getter(DeleteMultiplexResponse::multiplexSettings)).setter(DeleteMultiplexResponse.setter(Builder::multiplexSettings)).constructor(MultiplexSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("multiplexSettings").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DeleteMultiplexResponse.getter(DeleteMultiplexResponse::name)).setter(DeleteMultiplexResponse.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<Integer> PIPELINES_RUNNING_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(DeleteMultiplexResponse.getter(DeleteMultiplexResponse::pipelinesRunningCount)).setter(DeleteMultiplexResponse.setter(Builder::pipelinesRunningCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pipelinesRunningCount").build()}).build();
    private static final SdkField<Integer> PROGRAM_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(DeleteMultiplexResponse.getter(DeleteMultiplexResponse::programCount)).setter(DeleteMultiplexResponse.setter(Builder::programCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("programCount").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DeleteMultiplexResponse.getter(DeleteMultiplexResponse::stateAsString)).setter(DeleteMultiplexResponse.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("state").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).getter(DeleteMultiplexResponse.getter(DeleteMultiplexResponse::tags)).setter(DeleteMultiplexResponse.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, AVAILABILITY_ZONES_FIELD, DESTINATIONS_FIELD, ID_FIELD, MULTIPLEX_SETTINGS_FIELD, NAME_FIELD, PIPELINES_RUNNING_COUNT_FIELD, PROGRAM_COUNT_FIELD, STATE_FIELD, TAGS_FIELD));
    private final String arn;
    private final List<String> availabilityZones;
    private final List<MultiplexOutputDestination> destinations;
    private final String id;
    private final MultiplexSettings multiplexSettings;
    private final String name;
    private final Integer pipelinesRunningCount;
    private final Integer programCount;
    private final String state;
    private final Map<String, String> tags;

    private DeleteMultiplexResponse(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.availabilityZones = builder.availabilityZones;
        this.destinations = builder.destinations;
        this.id = builder.id;
        this.multiplexSettings = builder.multiplexSettings;
        this.name = builder.name;
        this.pipelinesRunningCount = builder.pipelinesRunningCount;
        this.programCount = builder.programCount;
        this.state = builder.state;
        this.tags = builder.tags;
    }

    public String arn() {
        return this.arn;
    }

    public boolean hasAvailabilityZones() {
        return this.availabilityZones != null && !(this.availabilityZones instanceof SdkAutoConstructList);
    }

    public List<String> availabilityZones() {
        return this.availabilityZones;
    }

    public boolean hasDestinations() {
        return this.destinations != null && !(this.destinations instanceof SdkAutoConstructList);
    }

    public List<MultiplexOutputDestination> destinations() {
        return this.destinations;
    }

    public String id() {
        return this.id;
    }

    public MultiplexSettings multiplexSettings() {
        return this.multiplexSettings;
    }

    public String name() {
        return this.name;
    }

    public Integer pipelinesRunningCount() {
        return this.pipelinesRunningCount;
    }

    public Integer programCount() {
        return this.programCount;
    }

    public MultiplexState state() {
        return MultiplexState.fromValue(this.state);
    }

    public String stateAsString() {
        return this.state;
    }

    public boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public Map<String, String> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.availabilityZones());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinations());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.multiplexSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.pipelinesRunningCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.programCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.tags());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteMultiplexResponse)) {
            return false;
        }
        DeleteMultiplexResponse other = (DeleteMultiplexResponse)((Object)obj);
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.availabilityZones(), other.availabilityZones()) && Objects.equals(this.destinations(), other.destinations()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.multiplexSettings(), other.multiplexSettings()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.pipelinesRunningCount(), other.pipelinesRunningCount()) && Objects.equals(this.programCount(), other.programCount()) && Objects.equals(this.stateAsString(), other.stateAsString()) && Objects.equals(this.tags(), other.tags());
    }

    public String toString() {
        return ToString.builder((String)"DeleteMultiplexResponse").add("Arn", (Object)this.arn()).add("AvailabilityZones", this.availabilityZones()).add("Destinations", this.destinations()).add("Id", (Object)this.id()).add("MultiplexSettings", (Object)this.multiplexSettings()).add("Name", (Object)this.name()).add("PipelinesRunningCount", (Object)this.pipelinesRunningCount()).add("ProgramCount", (Object)this.programCount()).add("State", (Object)this.stateAsString()).add("Tags", this.tags()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "AvailabilityZones": {
                return Optional.ofNullable(clazz.cast(this.availabilityZones()));
            }
            case "Destinations": {
                return Optional.ofNullable(clazz.cast(this.destinations()));
            }
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "MultiplexSettings": {
                return Optional.ofNullable(clazz.cast(this.multiplexSettings()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "PipelinesRunningCount": {
                return Optional.ofNullable(clazz.cast(this.pipelinesRunningCount()));
            }
            case "ProgramCount": {
                return Optional.ofNullable(clazz.cast(this.programCount()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteMultiplexResponse, T> g) {
        return obj -> g.apply((DeleteMultiplexResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MediaLiveResponse.BuilderImpl
    implements Builder {
        private String arn;
        private List<String> availabilityZones = DefaultSdkAutoConstructList.getInstance();
        private List<MultiplexOutputDestination> destinations = DefaultSdkAutoConstructList.getInstance();
        private String id;
        private MultiplexSettings multiplexSettings;
        private String name;
        private Integer pipelinesRunningCount;
        private Integer programCount;
        private String state;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteMultiplexResponse model) {
            super(model);
            this.arn(model.arn);
            this.availabilityZones(model.availabilityZones);
            this.destinations(model.destinations);
            this.id(model.id);
            this.multiplexSettings(model.multiplexSettings);
            this.name(model.name);
            this.pipelinesRunningCount(model.pipelinesRunningCount);
            this.programCount(model.programCount);
            this.state(model.state);
            this.tags(model.tags);
        }

        public final String getArn() {
            return this.arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final Collection<String> getAvailabilityZones() {
            return this.availabilityZones;
        }

        @Override
        public final Builder availabilityZones(Collection<String> availabilityZones) {
            this.availabilityZones = ___listOf__stringCopier.copy(availabilityZones);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder availabilityZones(String ... availabilityZones) {
            this.availabilityZones(Arrays.asList(availabilityZones));
            return this;
        }

        public final void setAvailabilityZones(Collection<String> availabilityZones) {
            this.availabilityZones = ___listOf__stringCopier.copy(availabilityZones);
        }

        public final Collection<MultiplexOutputDestination.Builder> getDestinations() {
            return this.destinations != null ? (Collection)this.destinations.stream().map(MultiplexOutputDestination::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder destinations(Collection<MultiplexOutputDestination> destinations) {
            this.destinations = ___listOfMultiplexOutputDestinationCopier.copy(destinations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder destinations(MultiplexOutputDestination ... destinations) {
            this.destinations(Arrays.asList(destinations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder destinations(Consumer<MultiplexOutputDestination.Builder> ... destinations) {
            this.destinations(Stream.of(destinations).map(c -> (MultiplexOutputDestination)((MultiplexOutputDestination.Builder)MultiplexOutputDestination.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setDestinations(Collection<MultiplexOutputDestination.BuilderImpl> destinations) {
            this.destinations = ___listOfMultiplexOutputDestinationCopier.copyFromBuilder(destinations);
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final MultiplexSettings.Builder getMultiplexSettings() {
            return this.multiplexSettings != null ? this.multiplexSettings.toBuilder() : null;
        }

        @Override
        public final Builder multiplexSettings(MultiplexSettings multiplexSettings) {
            this.multiplexSettings = multiplexSettings;
            return this;
        }

        public final void setMultiplexSettings(MultiplexSettings.BuilderImpl multiplexSettings) {
            this.multiplexSettings = multiplexSettings != null ? multiplexSettings.build() : null;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Integer getPipelinesRunningCount() {
            return this.pipelinesRunningCount;
        }

        @Override
        public final Builder pipelinesRunningCount(Integer pipelinesRunningCount) {
            this.pipelinesRunningCount = pipelinesRunningCount;
            return this;
        }

        public final void setPipelinesRunningCount(Integer pipelinesRunningCount) {
            this.pipelinesRunningCount = pipelinesRunningCount;
        }

        public final Integer getProgramCount() {
            return this.programCount;
        }

        @Override
        public final Builder programCount(Integer programCount) {
            this.programCount = programCount;
            return this;
        }

        public final void setProgramCount(Integer programCount) {
            this.programCount = programCount;
        }

        public final String getStateAsString() {
            return this.state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(MultiplexState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final Map<String, String> getTags() {
            return this.tags;
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        @Override
        public DeleteMultiplexResponse build() {
            return new DeleteMultiplexResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends MediaLiveResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DeleteMultiplexResponse> {
        public Builder arn(String var1);

        public Builder availabilityZones(Collection<String> var1);

        public Builder availabilityZones(String ... var1);

        public Builder destinations(Collection<MultiplexOutputDestination> var1);

        public Builder destinations(MultiplexOutputDestination ... var1);

        public Builder destinations(Consumer<MultiplexOutputDestination.Builder> ... var1);

        public Builder id(String var1);

        public Builder multiplexSettings(MultiplexSettings var1);

        default public Builder multiplexSettings(Consumer<MultiplexSettings.Builder> multiplexSettings) {
            return this.multiplexSettings((MultiplexSettings)((MultiplexSettings.Builder)MultiplexSettings.builder().applyMutation(multiplexSettings)).build());
        }

        public Builder name(String var1);

        public Builder pipelinesRunningCount(Integer var1);

        public Builder programCount(Integer var1);

        public Builder state(String var1);

        public Builder state(MultiplexState var1);

        public Builder tags(Map<String, String> var1);
    }
}

