/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * A request to update a program in a multiplex.
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateMultiplexProgramRequest extends MediaLiveRequest implements
        ToCopyableBuilder<UpdateMultiplexProgramRequest.Builder, UpdateMultiplexProgramRequest> {
    private static final SdkField<String> MULTIPLEX_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateMultiplexProgramRequest::multiplexId)).setter(setter(Builder::multiplexId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("multiplexId").build()).build();

    private static final SdkField<MultiplexProgramSettings> MULTIPLEX_PROGRAM_SETTINGS_FIELD = SdkField
            .<MultiplexProgramSettings> builder(MarshallingType.SDK_POJO)
            .getter(getter(UpdateMultiplexProgramRequest::multiplexProgramSettings))
            .setter(setter(Builder::multiplexProgramSettings)).constructor(MultiplexProgramSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("multiplexProgramSettings").build())
            .build();

    private static final SdkField<String> PROGRAM_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateMultiplexProgramRequest::programName)).setter(setter(Builder::programName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("programName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MULTIPLEX_ID_FIELD,
            MULTIPLEX_PROGRAM_SETTINGS_FIELD, PROGRAM_NAME_FIELD));

    private final String multiplexId;

    private final MultiplexProgramSettings multiplexProgramSettings;

    private final String programName;

    private UpdateMultiplexProgramRequest(BuilderImpl builder) {
        super(builder);
        this.multiplexId = builder.multiplexId;
        this.multiplexProgramSettings = builder.multiplexProgramSettings;
        this.programName = builder.programName;
    }

    /**
     * The ID of the multiplex of the program to update.
     * 
     * @return The ID of the multiplex of the program to update.
     */
    public String multiplexId() {
        return multiplexId;
    }

    /**
     * The new settings for a multiplex program.
     * 
     * @return The new settings for a multiplex program.
     */
    public MultiplexProgramSettings multiplexProgramSettings() {
        return multiplexProgramSettings;
    }

    /**
     * The name of the program to update.
     * 
     * @return The name of the program to update.
     */
    public String programName() {
        return programName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(multiplexId());
        hashCode = 31 * hashCode + Objects.hashCode(multiplexProgramSettings());
        hashCode = 31 * hashCode + Objects.hashCode(programName());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateMultiplexProgramRequest)) {
            return false;
        }
        UpdateMultiplexProgramRequest other = (UpdateMultiplexProgramRequest) obj;
        return Objects.equals(multiplexId(), other.multiplexId())
                && Objects.equals(multiplexProgramSettings(), other.multiplexProgramSettings())
                && Objects.equals(programName(), other.programName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("UpdateMultiplexProgramRequest").add("MultiplexId", multiplexId())
                .add("MultiplexProgramSettings", multiplexProgramSettings()).add("ProgramName", programName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MultiplexId":
            return Optional.ofNullable(clazz.cast(multiplexId()));
        case "MultiplexProgramSettings":
            return Optional.ofNullable(clazz.cast(multiplexProgramSettings()));
        case "ProgramName":
            return Optional.ofNullable(clazz.cast(programName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateMultiplexProgramRequest, T> g) {
        return obj -> g.apply((UpdateMultiplexProgramRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MediaLiveRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateMultiplexProgramRequest> {
        /**
         * The ID of the multiplex of the program to update.
         * 
         * @param multiplexId
         *        The ID of the multiplex of the program to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder multiplexId(String multiplexId);

        /**
         * The new settings for a multiplex program.
         * 
         * @param multiplexProgramSettings
         *        The new settings for a multiplex program.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder multiplexProgramSettings(MultiplexProgramSettings multiplexProgramSettings);

        /**
         * The new settings for a multiplex program. This is a convenience that creates an instance of the
         * {@link MultiplexProgramSettings.Builder} avoiding the need to create one manually via
         * {@link MultiplexProgramSettings#builder()}.
         *
         * When the {@link Consumer} completes, {@link MultiplexProgramSettings.Builder#build()} is called immediately
         * and its result is passed to {@link #multiplexProgramSettings(MultiplexProgramSettings)}.
         * 
         * @param multiplexProgramSettings
         *        a consumer that will call methods on {@link MultiplexProgramSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #multiplexProgramSettings(MultiplexProgramSettings)
         */
        default Builder multiplexProgramSettings(Consumer<MultiplexProgramSettings.Builder> multiplexProgramSettings) {
            return multiplexProgramSettings(MultiplexProgramSettings.builder().applyMutation(multiplexProgramSettings).build());
        }

        /**
         * The name of the program to update.
         * 
         * @param programName
         *        The name of the program to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder programName(String programName);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends MediaLiveRequest.BuilderImpl implements Builder {
        private String multiplexId;

        private MultiplexProgramSettings multiplexProgramSettings;

        private String programName;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateMultiplexProgramRequest model) {
            super(model);
            multiplexId(model.multiplexId);
            multiplexProgramSettings(model.multiplexProgramSettings);
            programName(model.programName);
        }

        public final String getMultiplexId() {
            return multiplexId;
        }

        @Override
        public final Builder multiplexId(String multiplexId) {
            this.multiplexId = multiplexId;
            return this;
        }

        public final void setMultiplexId(String multiplexId) {
            this.multiplexId = multiplexId;
        }

        public final MultiplexProgramSettings.Builder getMultiplexProgramSettings() {
            return multiplexProgramSettings != null ? multiplexProgramSettings.toBuilder() : null;
        }

        @Override
        public final Builder multiplexProgramSettings(MultiplexProgramSettings multiplexProgramSettings) {
            this.multiplexProgramSettings = multiplexProgramSettings;
            return this;
        }

        public final void setMultiplexProgramSettings(MultiplexProgramSettings.BuilderImpl multiplexProgramSettings) {
            this.multiplexProgramSettings = multiplexProgramSettings != null ? multiplexProgramSettings.build() : null;
        }

        public final String getProgramName() {
            return programName;
        }

        @Override
        public final Builder programName(String programName) {
            this.programName = programName;
            return this;
        }

        public final void setProgramName(String programName) {
            this.programName = programName;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateMultiplexProgramRequest build() {
            return new UpdateMultiplexProgramRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
