/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Settings for the action to activate a static image.
 */
@Generated("software.amazon.awssdk:codegen")
public final class StaticImageActivateScheduleActionSettings implements SdkPojo, Serializable,
        ToCopyableBuilder<StaticImageActivateScheduleActionSettings.Builder, StaticImageActivateScheduleActionSettings> {
    private static final SdkField<Integer> DURATION_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(StaticImageActivateScheduleActionSettings::duration)).setter(setter(Builder::duration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("duration").build()).build();

    private static final SdkField<Integer> FADE_IN_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(StaticImageActivateScheduleActionSettings::fadeIn)).setter(setter(Builder::fadeIn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fadeIn").build()).build();

    private static final SdkField<Integer> FADE_OUT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(StaticImageActivateScheduleActionSettings::fadeOut)).setter(setter(Builder::fadeOut))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fadeOut").build()).build();

    private static final SdkField<Integer> HEIGHT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(StaticImageActivateScheduleActionSettings::height)).setter(setter(Builder::height))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("height").build()).build();

    private static final SdkField<InputLocation> IMAGE_FIELD = SdkField.<InputLocation> builder(MarshallingType.SDK_POJO)
            .getter(getter(StaticImageActivateScheduleActionSettings::image)).setter(setter(Builder::image))
            .constructor(InputLocation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("image").build()).build();

    private static final SdkField<Integer> IMAGEX_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(StaticImageActivateScheduleActionSettings::imageX)).setter(setter(Builder::imageX))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imageX").build()).build();

    private static final SdkField<Integer> IMAGEY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(StaticImageActivateScheduleActionSettings::imageY)).setter(setter(Builder::imageY))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imageY").build()).build();

    private static final SdkField<Integer> LAYER_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(StaticImageActivateScheduleActionSettings::layer)).setter(setter(Builder::layer))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("layer").build()).build();

    private static final SdkField<Integer> OPACITY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(StaticImageActivateScheduleActionSettings::opacity)).setter(setter(Builder::opacity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("opacity").build()).build();

    private static final SdkField<Integer> WIDTH_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(StaticImageActivateScheduleActionSettings::width)).setter(setter(Builder::width))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("width").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DURATION_FIELD, FADE_IN_FIELD,
            FADE_OUT_FIELD, HEIGHT_FIELD, IMAGE_FIELD, IMAGEX_FIELD, IMAGEY_FIELD, LAYER_FIELD, OPACITY_FIELD, WIDTH_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer duration;

    private final Integer fadeIn;

    private final Integer fadeOut;

    private final Integer height;

    private final InputLocation image;

    private final Integer imageX;

    private final Integer imageY;

    private final Integer layer;

    private final Integer opacity;

    private final Integer width;

    private StaticImageActivateScheduleActionSettings(BuilderImpl builder) {
        this.duration = builder.duration;
        this.fadeIn = builder.fadeIn;
        this.fadeOut = builder.fadeOut;
        this.height = builder.height;
        this.image = builder.image;
        this.imageX = builder.imageX;
        this.imageY = builder.imageY;
        this.layer = builder.layer;
        this.opacity = builder.opacity;
        this.width = builder.width;
    }

    /**
     * The duration in milliseconds for the image to remain on the video. If omitted or set to 0 the duration is
     * unlimited and the image will remain until it is explicitly deactivated.
     * 
     * @return The duration in milliseconds for the image to remain on the video. If omitted or set to 0 the duration is
     *         unlimited and the image will remain until it is explicitly deactivated.
     */
    public Integer duration() {
        return duration;
    }

    /**
     * The time in milliseconds for the image to fade in. The fade-in starts at the start time of the overlay. Default
     * is 0 (no fade-in).
     * 
     * @return The time in milliseconds for the image to fade in. The fade-in starts at the start time of the overlay.
     *         Default is 0 (no fade-in).
     */
    public Integer fadeIn() {
        return fadeIn;
    }

    /**
     * Applies only if a duration is specified. The time in milliseconds for the image to fade out. The fade-out starts
     * when the duration time is hit, so it effectively extends the duration. Default is 0 (no fade-out).
     * 
     * @return Applies only if a duration is specified. The time in milliseconds for the image to fade out. The fade-out
     *         starts when the duration time is hit, so it effectively extends the duration. Default is 0 (no fade-out).
     */
    public Integer fadeOut() {
        return fadeOut;
    }

    /**
     * The height of the image when inserted into the video, in pixels. The overlay will be scaled up or down to the
     * specified height. Leave blank to use the native height of the overlay.
     * 
     * @return The height of the image when inserted into the video, in pixels. The overlay will be scaled up or down to
     *         the specified height. Leave blank to use the native height of the overlay.
     */
    public Integer height() {
        return height;
    }

    /**
     * The location and filename of the image file to overlay on the video. The file must be a 32-bit BMP, PNG, or TGA
     * file, and must not be larger (in pixels) than the input video.
     * 
     * @return The location and filename of the image file to overlay on the video. The file must be a 32-bit BMP, PNG,
     *         or TGA file, and must not be larger (in pixels) than the input video.
     */
    public InputLocation image() {
        return image;
    }

    /**
     * Placement of the left edge of the overlay relative to the left edge of the video frame, in pixels. 0 (the
     * default) is the left edge of the frame. If the placement causes the overlay to extend beyond the right edge of
     * the underlying video, then the overlay is cropped on the right.
     * 
     * @return Placement of the left edge of the overlay relative to the left edge of the video frame, in pixels. 0 (the
     *         default) is the left edge of the frame. If the placement causes the overlay to extend beyond the right
     *         edge of the underlying video, then the overlay is cropped on the right.
     */
    public Integer imageX() {
        return imageX;
    }

    /**
     * Placement of the top edge of the overlay relative to the top edge of the video frame, in pixels. 0 (the default)
     * is the top edge of the frame. If the placement causes the overlay to extend beyond the bottom edge of the
     * underlying video, then the overlay is cropped on the bottom.
     * 
     * @return Placement of the top edge of the overlay relative to the top edge of the video frame, in pixels. 0 (the
     *         default) is the top edge of the frame. If the placement causes the overlay to extend beyond the bottom
     *         edge of the underlying video, then the overlay is cropped on the bottom.
     */
    public Integer imageY() {
        return imageY;
    }

    /**
     * The number of the layer, 0 to 7. There are 8 layers that can be overlaid on the video, each layer with a
     * different image. The layers are in Z order, which means that overlays with higher values of layer are inserted on
     * top of overlays with lower values of layer. Default is 0.
     * 
     * @return The number of the layer, 0 to 7. There are 8 layers that can be overlaid on the video, each layer with a
     *         different image. The layers are in Z order, which means that overlays with higher values of layer are
     *         inserted on top of overlays with lower values of layer. Default is 0.
     */
    public Integer layer() {
        return layer;
    }

    /**
     * Opacity of image where 0 is transparent and 100 is fully opaque. Default is 100.
     * 
     * @return Opacity of image where 0 is transparent and 100 is fully opaque. Default is 100.
     */
    public Integer opacity() {
        return opacity;
    }

    /**
     * The width of the image when inserted into the video, in pixels. The overlay will be scaled up or down to the
     * specified width. Leave blank to use the native width of the overlay.
     * 
     * @return The width of the image when inserted into the video, in pixels. The overlay will be scaled up or down to
     *         the specified width. Leave blank to use the native width of the overlay.
     */
    public Integer width() {
        return width;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(duration());
        hashCode = 31 * hashCode + Objects.hashCode(fadeIn());
        hashCode = 31 * hashCode + Objects.hashCode(fadeOut());
        hashCode = 31 * hashCode + Objects.hashCode(height());
        hashCode = 31 * hashCode + Objects.hashCode(image());
        hashCode = 31 * hashCode + Objects.hashCode(imageX());
        hashCode = 31 * hashCode + Objects.hashCode(imageY());
        hashCode = 31 * hashCode + Objects.hashCode(layer());
        hashCode = 31 * hashCode + Objects.hashCode(opacity());
        hashCode = 31 * hashCode + Objects.hashCode(width());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StaticImageActivateScheduleActionSettings)) {
            return false;
        }
        StaticImageActivateScheduleActionSettings other = (StaticImageActivateScheduleActionSettings) obj;
        return Objects.equals(duration(), other.duration()) && Objects.equals(fadeIn(), other.fadeIn())
                && Objects.equals(fadeOut(), other.fadeOut()) && Objects.equals(height(), other.height())
                && Objects.equals(image(), other.image()) && Objects.equals(imageX(), other.imageX())
                && Objects.equals(imageY(), other.imageY()) && Objects.equals(layer(), other.layer())
                && Objects.equals(opacity(), other.opacity()) && Objects.equals(width(), other.width());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("StaticImageActivateScheduleActionSettings").add("Duration", duration()).add("FadeIn", fadeIn())
                .add("FadeOut", fadeOut()).add("Height", height()).add("Image", image()).add("ImageX", imageX())
                .add("ImageY", imageY()).add("Layer", layer()).add("Opacity", opacity()).add("Width", width()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Duration":
            return Optional.ofNullable(clazz.cast(duration()));
        case "FadeIn":
            return Optional.ofNullable(clazz.cast(fadeIn()));
        case "FadeOut":
            return Optional.ofNullable(clazz.cast(fadeOut()));
        case "Height":
            return Optional.ofNullable(clazz.cast(height()));
        case "Image":
            return Optional.ofNullable(clazz.cast(image()));
        case "ImageX":
            return Optional.ofNullable(clazz.cast(imageX()));
        case "ImageY":
            return Optional.ofNullable(clazz.cast(imageY()));
        case "Layer":
            return Optional.ofNullable(clazz.cast(layer()));
        case "Opacity":
            return Optional.ofNullable(clazz.cast(opacity()));
        case "Width":
            return Optional.ofNullable(clazz.cast(width()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StaticImageActivateScheduleActionSettings, T> g) {
        return obj -> g.apply((StaticImageActivateScheduleActionSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, StaticImageActivateScheduleActionSettings> {
        /**
         * The duration in milliseconds for the image to remain on the video. If omitted or set to 0 the duration is
         * unlimited and the image will remain until it is explicitly deactivated.
         * 
         * @param duration
         *        The duration in milliseconds for the image to remain on the video. If omitted or set to 0 the duration
         *        is unlimited and the image will remain until it is explicitly deactivated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder duration(Integer duration);

        /**
         * The time in milliseconds for the image to fade in. The fade-in starts at the start time of the overlay.
         * Default is 0 (no fade-in).
         * 
         * @param fadeIn
         *        The time in milliseconds for the image to fade in. The fade-in starts at the start time of the
         *        overlay. Default is 0 (no fade-in).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fadeIn(Integer fadeIn);

        /**
         * Applies only if a duration is specified. The time in milliseconds for the image to fade out. The fade-out
         * starts when the duration time is hit, so it effectively extends the duration. Default is 0 (no fade-out).
         * 
         * @param fadeOut
         *        Applies only if a duration is specified. The time in milliseconds for the image to fade out. The
         *        fade-out starts when the duration time is hit, so it effectively extends the duration. Default is 0
         *        (no fade-out).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fadeOut(Integer fadeOut);

        /**
         * The height of the image when inserted into the video, in pixels. The overlay will be scaled up or down to the
         * specified height. Leave blank to use the native height of the overlay.
         * 
         * @param height
         *        The height of the image when inserted into the video, in pixels. The overlay will be scaled up or down
         *        to the specified height. Leave blank to use the native height of the overlay.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder height(Integer height);

        /**
         * The location and filename of the image file to overlay on the video. The file must be a 32-bit BMP, PNG, or
         * TGA file, and must not be larger (in pixels) than the input video.
         * 
         * @param image
         *        The location and filename of the image file to overlay on the video. The file must be a 32-bit BMP,
         *        PNG, or TGA file, and must not be larger (in pixels) than the input video.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder image(InputLocation image);

        /**
         * The location and filename of the image file to overlay on the video. The file must be a 32-bit BMP, PNG, or
         * TGA file, and must not be larger (in pixels) than the input video. This is a convenience that creates an
         * instance of the {@link InputLocation.Builder} avoiding the need to create one manually via
         * {@link InputLocation#builder()}.
         *
         * When the {@link Consumer} completes, {@link InputLocation.Builder#build()} is called immediately and its
         * result is passed to {@link #image(InputLocation)}.
         * 
         * @param image
         *        a consumer that will call methods on {@link InputLocation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #image(InputLocation)
         */
        default Builder image(Consumer<InputLocation.Builder> image) {
            return image(InputLocation.builder().applyMutation(image).build());
        }

        /**
         * Placement of the left edge of the overlay relative to the left edge of the video frame, in pixels. 0 (the
         * default) is the left edge of the frame. If the placement causes the overlay to extend beyond the right edge
         * of the underlying video, then the overlay is cropped on the right.
         * 
         * @param imageX
         *        Placement of the left edge of the overlay relative to the left edge of the video frame, in pixels. 0
         *        (the default) is the left edge of the frame. If the placement causes the overlay to extend beyond the
         *        right edge of the underlying video, then the overlay is cropped on the right.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageX(Integer imageX);

        /**
         * Placement of the top edge of the overlay relative to the top edge of the video frame, in pixels. 0 (the
         * default) is the top edge of the frame. If the placement causes the overlay to extend beyond the bottom edge
         * of the underlying video, then the overlay is cropped on the bottom.
         * 
         * @param imageY
         *        Placement of the top edge of the overlay relative to the top edge of the video frame, in pixels. 0
         *        (the default) is the top edge of the frame. If the placement causes the overlay to extend beyond the
         *        bottom edge of the underlying video, then the overlay is cropped on the bottom.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageY(Integer imageY);

        /**
         * The number of the layer, 0 to 7. There are 8 layers that can be overlaid on the video, each layer with a
         * different image. The layers are in Z order, which means that overlays with higher values of layer are
         * inserted on top of overlays with lower values of layer. Default is 0.
         * 
         * @param layer
         *        The number of the layer, 0 to 7. There are 8 layers that can be overlaid on the video, each layer with
         *        a different image. The layers are in Z order, which means that overlays with higher values of layer
         *        are inserted on top of overlays with lower values of layer. Default is 0.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder layer(Integer layer);

        /**
         * Opacity of image where 0 is transparent and 100 is fully opaque. Default is 100.
         * 
         * @param opacity
         *        Opacity of image where 0 is transparent and 100 is fully opaque. Default is 100.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder opacity(Integer opacity);

        /**
         * The width of the image when inserted into the video, in pixels. The overlay will be scaled up or down to the
         * specified width. Leave blank to use the native width of the overlay.
         * 
         * @param width
         *        The width of the image when inserted into the video, in pixels. The overlay will be scaled up or down
         *        to the specified width. Leave blank to use the native width of the overlay.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder width(Integer width);
    }

    static final class BuilderImpl implements Builder {
        private Integer duration;

        private Integer fadeIn;

        private Integer fadeOut;

        private Integer height;

        private InputLocation image;

        private Integer imageX;

        private Integer imageY;

        private Integer layer;

        private Integer opacity;

        private Integer width;

        private BuilderImpl() {
        }

        private BuilderImpl(StaticImageActivateScheduleActionSettings model) {
            duration(model.duration);
            fadeIn(model.fadeIn);
            fadeOut(model.fadeOut);
            height(model.height);
            image(model.image);
            imageX(model.imageX);
            imageY(model.imageY);
            layer(model.layer);
            opacity(model.opacity);
            width(model.width);
        }

        public final Integer getDuration() {
            return duration;
        }

        @Override
        public final Builder duration(Integer duration) {
            this.duration = duration;
            return this;
        }

        public final void setDuration(Integer duration) {
            this.duration = duration;
        }

        public final Integer getFadeIn() {
            return fadeIn;
        }

        @Override
        public final Builder fadeIn(Integer fadeIn) {
            this.fadeIn = fadeIn;
            return this;
        }

        public final void setFadeIn(Integer fadeIn) {
            this.fadeIn = fadeIn;
        }

        public final Integer getFadeOut() {
            return fadeOut;
        }

        @Override
        public final Builder fadeOut(Integer fadeOut) {
            this.fadeOut = fadeOut;
            return this;
        }

        public final void setFadeOut(Integer fadeOut) {
            this.fadeOut = fadeOut;
        }

        public final Integer getHeight() {
            return height;
        }

        @Override
        public final Builder height(Integer height) {
            this.height = height;
            return this;
        }

        public final void setHeight(Integer height) {
            this.height = height;
        }

        public final InputLocation.Builder getImage() {
            return image != null ? image.toBuilder() : null;
        }

        @Override
        public final Builder image(InputLocation image) {
            this.image = image;
            return this;
        }

        public final void setImage(InputLocation.BuilderImpl image) {
            this.image = image != null ? image.build() : null;
        }

        public final Integer getImageX() {
            return imageX;
        }

        @Override
        public final Builder imageX(Integer imageX) {
            this.imageX = imageX;
            return this;
        }

        public final void setImageX(Integer imageX) {
            this.imageX = imageX;
        }

        public final Integer getImageY() {
            return imageY;
        }

        @Override
        public final Builder imageY(Integer imageY) {
            this.imageY = imageY;
            return this;
        }

        public final void setImageY(Integer imageY) {
            this.imageY = imageY;
        }

        public final Integer getLayer() {
            return layer;
        }

        @Override
        public final Builder layer(Integer layer) {
            this.layer = layer;
            return this;
        }

        public final void setLayer(Integer layer) {
            this.layer = layer;
        }

        public final Integer getOpacity() {
            return opacity;
        }

        @Override
        public final Builder opacity(Integer opacity) {
            this.opacity = opacity;
            return this;
        }

        public final void setOpacity(Integer opacity) {
            this.opacity = opacity;
        }

        public final Integer getWidth() {
            return width;
        }

        @Override
        public final Builder width(Integer width) {
            this.width = width;
            return this;
        }

        public final void setWidth(Integer width) {
            this.width = width;
        }

        @Override
        public StaticImageActivateScheduleActionSettings build() {
            return new StaticImageActivateScheduleActionSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
