/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Standard Hls Settings
 */
@Generated("software.amazon.awssdk:codegen")
public final class StandardHlsSettings implements SdkPojo, Serializable,
        ToCopyableBuilder<StandardHlsSettings.Builder, StandardHlsSettings> {
    private static final SdkField<String> AUDIO_RENDITION_SETS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(StandardHlsSettings::audioRenditionSets)).setter(setter(Builder::audioRenditionSets))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("audioRenditionSets").build())
            .build();

    private static final SdkField<M3u8Settings> M3_U8_SETTINGS_FIELD = SdkField.<M3u8Settings> builder(MarshallingType.SDK_POJO)
            .getter(getter(StandardHlsSettings::m3u8Settings)).setter(setter(Builder::m3u8Settings))
            .constructor(M3u8Settings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("m3u8Settings").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUDIO_RENDITION_SETS_FIELD,
            M3_U8_SETTINGS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String audioRenditionSets;

    private final M3u8Settings m3u8Settings;

    private StandardHlsSettings(BuilderImpl builder) {
        this.audioRenditionSets = builder.audioRenditionSets;
        this.m3u8Settings = builder.m3u8Settings;
    }

    /**
     * List all the audio groups that are used with the video output stream. Input all the audio GROUP-IDs that are
     * associated to the video, separate by ','.
     * 
     * @return List all the audio groups that are used with the video output stream. Input all the audio GROUP-IDs that
     *         are associated to the video, separate by ','.
     */
    public String audioRenditionSets() {
        return audioRenditionSets;
    }

    /**
     * Returns the value of the M3u8Settings property for this object.
     * 
     * @return The value of the M3u8Settings property for this object.
     */
    public M3u8Settings m3u8Settings() {
        return m3u8Settings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(audioRenditionSets());
        hashCode = 31 * hashCode + Objects.hashCode(m3u8Settings());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StandardHlsSettings)) {
            return false;
        }
        StandardHlsSettings other = (StandardHlsSettings) obj;
        return Objects.equals(audioRenditionSets(), other.audioRenditionSets())
                && Objects.equals(m3u8Settings(), other.m3u8Settings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("StandardHlsSettings").add("AudioRenditionSets", audioRenditionSets())
                .add("M3u8Settings", m3u8Settings()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AudioRenditionSets":
            return Optional.ofNullable(clazz.cast(audioRenditionSets()));
        case "M3u8Settings":
            return Optional.ofNullable(clazz.cast(m3u8Settings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StandardHlsSettings, T> g) {
        return obj -> g.apply((StandardHlsSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, StandardHlsSettings> {
        /**
         * List all the audio groups that are used with the video output stream. Input all the audio GROUP-IDs that are
         * associated to the video, separate by ','.
         * 
         * @param audioRenditionSets
         *        List all the audio groups that are used with the video output stream. Input all the audio GROUP-IDs
         *        that are associated to the video, separate by ','.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder audioRenditionSets(String audioRenditionSets);

        /**
         * Sets the value of the M3u8Settings property for this object.
         *
         * @param m3u8Settings
         *        The new value for the M3u8Settings property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder m3u8Settings(M3u8Settings m3u8Settings);

        /**
         * Sets the value of the M3u8Settings property for this object.
         *
         * This is a convenience that creates an instance of the {@link M3u8Settings.Builder} avoiding the need to
         * create one manually via {@link M3u8Settings#builder()}.
         *
         * When the {@link Consumer} completes, {@link M3u8Settings.Builder#build()} is called immediately and its
         * result is passed to {@link #m3u8Settings(M3u8Settings)}.
         * 
         * @param m3u8Settings
         *        a consumer that will call methods on {@link M3u8Settings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #m3u8Settings(M3u8Settings)
         */
        default Builder m3u8Settings(Consumer<M3u8Settings.Builder> m3u8Settings) {
            return m3u8Settings(M3u8Settings.builder().applyMutation(m3u8Settings).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String audioRenditionSets;

        private M3u8Settings m3u8Settings;

        private BuilderImpl() {
        }

        private BuilderImpl(StandardHlsSettings model) {
            audioRenditionSets(model.audioRenditionSets);
            m3u8Settings(model.m3u8Settings);
        }

        public final String getAudioRenditionSets() {
            return audioRenditionSets;
        }

        @Override
        public final Builder audioRenditionSets(String audioRenditionSets) {
            this.audioRenditionSets = audioRenditionSets;
            return this;
        }

        public final void setAudioRenditionSets(String audioRenditionSets) {
            this.audioRenditionSets = audioRenditionSets;
        }

        public final M3u8Settings.Builder getM3u8Settings() {
            return m3u8Settings != null ? m3u8Settings.toBuilder() : null;
        }

        @Override
        public final Builder m3u8Settings(M3u8Settings m3u8Settings) {
            this.m3u8Settings = m3u8Settings;
            return this;
        }

        public final void setM3u8Settings(M3u8Settings.BuilderImpl m3u8Settings) {
            this.m3u8Settings = m3u8Settings != null ? m3u8Settings.build() : null;
        }

        @Override
        public StandardHlsSettings build() {
            return new StandardHlsSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
