/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Settings to specify when an action should occur. Only one of the options must be selected.
 */
@Generated("software.amazon.awssdk:codegen")
public final class ScheduleActionStartSettings implements SdkPojo, Serializable,
        ToCopyableBuilder<ScheduleActionStartSettings.Builder, ScheduleActionStartSettings> {
    private static final SdkField<FixedModeScheduleActionStartSettings> FIXED_MODE_SCHEDULE_ACTION_START_SETTINGS_FIELD = SdkField
            .<FixedModeScheduleActionStartSettings> builder(MarshallingType.SDK_POJO)
            .getter(getter(ScheduleActionStartSettings::fixedModeScheduleActionStartSettings))
            .setter(setter(Builder::fixedModeScheduleActionStartSettings))
            .constructor(FixedModeScheduleActionStartSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("fixedModeScheduleActionStartSettings").build()).build();

    private static final SdkField<FollowModeScheduleActionStartSettings> FOLLOW_MODE_SCHEDULE_ACTION_START_SETTINGS_FIELD = SdkField
            .<FollowModeScheduleActionStartSettings> builder(MarshallingType.SDK_POJO)
            .getter(getter(ScheduleActionStartSettings::followModeScheduleActionStartSettings))
            .setter(setter(Builder::followModeScheduleActionStartSettings))
            .constructor(FollowModeScheduleActionStartSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("followModeScheduleActionStartSettings").build()).build();

    private static final SdkField<ImmediateModeScheduleActionStartSettings> IMMEDIATE_MODE_SCHEDULE_ACTION_START_SETTINGS_FIELD = SdkField
            .<ImmediateModeScheduleActionStartSettings> builder(MarshallingType.SDK_POJO)
            .getter(getter(ScheduleActionStartSettings::immediateModeScheduleActionStartSettings))
            .setter(setter(Builder::immediateModeScheduleActionStartSettings))
            .constructor(ImmediateModeScheduleActionStartSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("immediateModeScheduleActionStartSettings").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            FIXED_MODE_SCHEDULE_ACTION_START_SETTINGS_FIELD, FOLLOW_MODE_SCHEDULE_ACTION_START_SETTINGS_FIELD,
            IMMEDIATE_MODE_SCHEDULE_ACTION_START_SETTINGS_FIELD));

    private static final long serialVersionUID = 1L;

    private final FixedModeScheduleActionStartSettings fixedModeScheduleActionStartSettings;

    private final FollowModeScheduleActionStartSettings followModeScheduleActionStartSettings;

    private final ImmediateModeScheduleActionStartSettings immediateModeScheduleActionStartSettings;

    private ScheduleActionStartSettings(BuilderImpl builder) {
        this.fixedModeScheduleActionStartSettings = builder.fixedModeScheduleActionStartSettings;
        this.followModeScheduleActionStartSettings = builder.followModeScheduleActionStartSettings;
        this.immediateModeScheduleActionStartSettings = builder.immediateModeScheduleActionStartSettings;
    }

    /**
     * Option for specifying the start time for an action.
     * 
     * @return Option for specifying the start time for an action.
     */
    public FixedModeScheduleActionStartSettings fixedModeScheduleActionStartSettings() {
        return fixedModeScheduleActionStartSettings;
    }

    /**
     * Option for specifying an action as relative to another action.
     * 
     * @return Option for specifying an action as relative to another action.
     */
    public FollowModeScheduleActionStartSettings followModeScheduleActionStartSettings() {
        return followModeScheduleActionStartSettings;
    }

    /**
     * Option for specifying an action that should be applied immediately.
     * 
     * @return Option for specifying an action that should be applied immediately.
     */
    public ImmediateModeScheduleActionStartSettings immediateModeScheduleActionStartSettings() {
        return immediateModeScheduleActionStartSettings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(fixedModeScheduleActionStartSettings());
        hashCode = 31 * hashCode + Objects.hashCode(followModeScheduleActionStartSettings());
        hashCode = 31 * hashCode + Objects.hashCode(immediateModeScheduleActionStartSettings());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ScheduleActionStartSettings)) {
            return false;
        }
        ScheduleActionStartSettings other = (ScheduleActionStartSettings) obj;
        return Objects.equals(fixedModeScheduleActionStartSettings(), other.fixedModeScheduleActionStartSettings())
                && Objects.equals(followModeScheduleActionStartSettings(), other.followModeScheduleActionStartSettings())
                && Objects.equals(immediateModeScheduleActionStartSettings(), other.immediateModeScheduleActionStartSettings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ScheduleActionStartSettings")
                .add("FixedModeScheduleActionStartSettings", fixedModeScheduleActionStartSettings())
                .add("FollowModeScheduleActionStartSettings", followModeScheduleActionStartSettings())
                .add("ImmediateModeScheduleActionStartSettings", immediateModeScheduleActionStartSettings()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FixedModeScheduleActionStartSettings":
            return Optional.ofNullable(clazz.cast(fixedModeScheduleActionStartSettings()));
        case "FollowModeScheduleActionStartSettings":
            return Optional.ofNullable(clazz.cast(followModeScheduleActionStartSettings()));
        case "ImmediateModeScheduleActionStartSettings":
            return Optional.ofNullable(clazz.cast(immediateModeScheduleActionStartSettings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ScheduleActionStartSettings, T> g) {
        return obj -> g.apply((ScheduleActionStartSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ScheduleActionStartSettings> {
        /**
         * Option for specifying the start time for an action.
         * 
         * @param fixedModeScheduleActionStartSettings
         *        Option for specifying the start time for an action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fixedModeScheduleActionStartSettings(FixedModeScheduleActionStartSettings fixedModeScheduleActionStartSettings);

        /**
         * Option for specifying the start time for an action. This is a convenience that creates an instance of the
         * {@link FixedModeScheduleActionStartSettings.Builder} avoiding the need to create one manually via
         * {@link FixedModeScheduleActionStartSettings#builder()}.
         *
         * When the {@link Consumer} completes, {@link FixedModeScheduleActionStartSettings.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #fixedModeScheduleActionStartSettings(FixedModeScheduleActionStartSettings)}.
         * 
         * @param fixedModeScheduleActionStartSettings
         *        a consumer that will call methods on {@link FixedModeScheduleActionStartSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #fixedModeScheduleActionStartSettings(FixedModeScheduleActionStartSettings)
         */
        default Builder fixedModeScheduleActionStartSettings(
                Consumer<FixedModeScheduleActionStartSettings.Builder> fixedModeScheduleActionStartSettings) {
            return fixedModeScheduleActionStartSettings(FixedModeScheduleActionStartSettings.builder()
                    .applyMutation(fixedModeScheduleActionStartSettings).build());
        }

        /**
         * Option for specifying an action as relative to another action.
         * 
         * @param followModeScheduleActionStartSettings
         *        Option for specifying an action as relative to another action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder followModeScheduleActionStartSettings(FollowModeScheduleActionStartSettings followModeScheduleActionStartSettings);

        /**
         * Option for specifying an action as relative to another action. This is a convenience that creates an instance
         * of the {@link FollowModeScheduleActionStartSettings.Builder} avoiding the need to create one manually via
         * {@link FollowModeScheduleActionStartSettings#builder()}.
         *
         * When the {@link Consumer} completes, {@link FollowModeScheduleActionStartSettings.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #followModeScheduleActionStartSettings(FollowModeScheduleActionStartSettings)}.
         * 
         * @param followModeScheduleActionStartSettings
         *        a consumer that will call methods on {@link FollowModeScheduleActionStartSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #followModeScheduleActionStartSettings(FollowModeScheduleActionStartSettings)
         */
        default Builder followModeScheduleActionStartSettings(
                Consumer<FollowModeScheduleActionStartSettings.Builder> followModeScheduleActionStartSettings) {
            return followModeScheduleActionStartSettings(FollowModeScheduleActionStartSettings.builder()
                    .applyMutation(followModeScheduleActionStartSettings).build());
        }

        /**
         * Option for specifying an action that should be applied immediately.
         * 
         * @param immediateModeScheduleActionStartSettings
         *        Option for specifying an action that should be applied immediately.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder immediateModeScheduleActionStartSettings(
                ImmediateModeScheduleActionStartSettings immediateModeScheduleActionStartSettings);

        /**
         * Option for specifying an action that should be applied immediately. This is a convenience that creates an
         * instance of the {@link ImmediateModeScheduleActionStartSettings.Builder} avoiding the need to create one
         * manually via {@link ImmediateModeScheduleActionStartSettings#builder()}.
         *
         * When the {@link Consumer} completes, {@link ImmediateModeScheduleActionStartSettings.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #immediateModeScheduleActionStartSettings(ImmediateModeScheduleActionStartSettings)}.
         * 
         * @param immediateModeScheduleActionStartSettings
         *        a consumer that will call methods on {@link ImmediateModeScheduleActionStartSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #immediateModeScheduleActionStartSettings(ImmediateModeScheduleActionStartSettings)
         */
        default Builder immediateModeScheduleActionStartSettings(
                Consumer<ImmediateModeScheduleActionStartSettings.Builder> immediateModeScheduleActionStartSettings) {
            return immediateModeScheduleActionStartSettings(ImmediateModeScheduleActionStartSettings.builder()
                    .applyMutation(immediateModeScheduleActionStartSettings).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private FixedModeScheduleActionStartSettings fixedModeScheduleActionStartSettings;

        private FollowModeScheduleActionStartSettings followModeScheduleActionStartSettings;

        private ImmediateModeScheduleActionStartSettings immediateModeScheduleActionStartSettings;

        private BuilderImpl() {
        }

        private BuilderImpl(ScheduleActionStartSettings model) {
            fixedModeScheduleActionStartSettings(model.fixedModeScheduleActionStartSettings);
            followModeScheduleActionStartSettings(model.followModeScheduleActionStartSettings);
            immediateModeScheduleActionStartSettings(model.immediateModeScheduleActionStartSettings);
        }

        public final FixedModeScheduleActionStartSettings.Builder getFixedModeScheduleActionStartSettings() {
            return fixedModeScheduleActionStartSettings != null ? fixedModeScheduleActionStartSettings.toBuilder() : null;
        }

        @Override
        public final Builder fixedModeScheduleActionStartSettings(
                FixedModeScheduleActionStartSettings fixedModeScheduleActionStartSettings) {
            this.fixedModeScheduleActionStartSettings = fixedModeScheduleActionStartSettings;
            return this;
        }

        public final void setFixedModeScheduleActionStartSettings(
                FixedModeScheduleActionStartSettings.BuilderImpl fixedModeScheduleActionStartSettings) {
            this.fixedModeScheduleActionStartSettings = fixedModeScheduleActionStartSettings != null ? fixedModeScheduleActionStartSettings
                    .build() : null;
        }

        public final FollowModeScheduleActionStartSettings.Builder getFollowModeScheduleActionStartSettings() {
            return followModeScheduleActionStartSettings != null ? followModeScheduleActionStartSettings.toBuilder() : null;
        }

        @Override
        public final Builder followModeScheduleActionStartSettings(
                FollowModeScheduleActionStartSettings followModeScheduleActionStartSettings) {
            this.followModeScheduleActionStartSettings = followModeScheduleActionStartSettings;
            return this;
        }

        public final void setFollowModeScheduleActionStartSettings(
                FollowModeScheduleActionStartSettings.BuilderImpl followModeScheduleActionStartSettings) {
            this.followModeScheduleActionStartSettings = followModeScheduleActionStartSettings != null ? followModeScheduleActionStartSettings
                    .build() : null;
        }

        public final ImmediateModeScheduleActionStartSettings.Builder getImmediateModeScheduleActionStartSettings() {
            return immediateModeScheduleActionStartSettings != null ? immediateModeScheduleActionStartSettings.toBuilder() : null;
        }

        @Override
        public final Builder immediateModeScheduleActionStartSettings(
                ImmediateModeScheduleActionStartSettings immediateModeScheduleActionStartSettings) {
            this.immediateModeScheduleActionStartSettings = immediateModeScheduleActionStartSettings;
            return this;
        }

        public final void setImmediateModeScheduleActionStartSettings(
                ImmediateModeScheduleActionStartSettings.BuilderImpl immediateModeScheduleActionStartSettings) {
            this.immediateModeScheduleActionStartSettings = immediateModeScheduleActionStartSettings != null ? immediateModeScheduleActionStartSettings
                    .build() : null;
        }

        @Override
        public ScheduleActionStartSettings build() {
            return new ScheduleActionStartSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
