/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Remix Settings
 */
@Generated("software.amazon.awssdk:codegen")
public final class RemixSettings implements SdkPojo, Serializable, ToCopyableBuilder<RemixSettings.Builder, RemixSettings> {
    private static final SdkField<List<AudioChannelMapping>> CHANNEL_MAPPINGS_FIELD = SdkField
            .<List<AudioChannelMapping>> builder(MarshallingType.LIST)
            .getter(getter(RemixSettings::channelMappings))
            .setter(setter(Builder::channelMappings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("channelMappings").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AudioChannelMapping> builder(MarshallingType.SDK_POJO)
                                            .constructor(AudioChannelMapping::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> CHANNELS_IN_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(RemixSettings::channelsIn)).setter(setter(Builder::channelsIn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("channelsIn").build()).build();

    private static final SdkField<Integer> CHANNELS_OUT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(RemixSettings::channelsOut)).setter(setter(Builder::channelsOut))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("channelsOut").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHANNEL_MAPPINGS_FIELD,
            CHANNELS_IN_FIELD, CHANNELS_OUT_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<AudioChannelMapping> channelMappings;

    private final Integer channelsIn;

    private final Integer channelsOut;

    private RemixSettings(BuilderImpl builder) {
        this.channelMappings = builder.channelMappings;
        this.channelsIn = builder.channelsIn;
        this.channelsOut = builder.channelsOut;
    }

    /**
     * Returns true if the ChannelMappings property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasChannelMappings() {
        return channelMappings != null && !(channelMappings instanceof SdkAutoConstructList);
    }

    /**
     * Mapping of input channels to output channels, with appropriate gain adjustments.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasChannelMappings()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Mapping of input channels to output channels, with appropriate gain adjustments.
     */
    public List<AudioChannelMapping> channelMappings() {
        return channelMappings;
    }

    /**
     * Number of input channels to be used.
     * 
     * @return Number of input channels to be used.
     */
    public Integer channelsIn() {
        return channelsIn;
    }

    /**
     * Number of output channels to be produced. Valid values: 1, 2, 4, 6, 8
     * 
     * @return Number of output channels to be produced. Valid values: 1, 2, 4, 6, 8
     */
    public Integer channelsOut() {
        return channelsOut;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(channelMappings());
        hashCode = 31 * hashCode + Objects.hashCode(channelsIn());
        hashCode = 31 * hashCode + Objects.hashCode(channelsOut());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RemixSettings)) {
            return false;
        }
        RemixSettings other = (RemixSettings) obj;
        return Objects.equals(channelMappings(), other.channelMappings()) && Objects.equals(channelsIn(), other.channelsIn())
                && Objects.equals(channelsOut(), other.channelsOut());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("RemixSettings").add("ChannelMappings", channelMappings()).add("ChannelsIn", channelsIn())
                .add("ChannelsOut", channelsOut()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ChannelMappings":
            return Optional.ofNullable(clazz.cast(channelMappings()));
        case "ChannelsIn":
            return Optional.ofNullable(clazz.cast(channelsIn()));
        case "ChannelsOut":
            return Optional.ofNullable(clazz.cast(channelsOut()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RemixSettings, T> g) {
        return obj -> g.apply((RemixSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RemixSettings> {
        /**
         * Mapping of input channels to output channels, with appropriate gain adjustments.
         * 
         * @param channelMappings
         *        Mapping of input channels to output channels, with appropriate gain adjustments.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder channelMappings(Collection<AudioChannelMapping> channelMappings);

        /**
         * Mapping of input channels to output channels, with appropriate gain adjustments.
         * 
         * @param channelMappings
         *        Mapping of input channels to output channels, with appropriate gain adjustments.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder channelMappings(AudioChannelMapping... channelMappings);

        /**
         * Mapping of input channels to output channels, with appropriate gain adjustments. This is a convenience that
         * creates an instance of the {@link List<AudioChannelMapping>.Builder} avoiding the need to create one manually
         * via {@link List<AudioChannelMapping>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<AudioChannelMapping>.Builder#build()} is called immediately
         * and its result is passed to {@link #channelMappings(List<AudioChannelMapping>)}.
         * 
         * @param channelMappings
         *        a consumer that will call methods on {@link List<AudioChannelMapping>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #channelMappings(List<AudioChannelMapping>)
         */
        Builder channelMappings(Consumer<AudioChannelMapping.Builder>... channelMappings);

        /**
         * Number of input channels to be used.
         * 
         * @param channelsIn
         *        Number of input channels to be used.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder channelsIn(Integer channelsIn);

        /**
         * Number of output channels to be produced. Valid values: 1, 2, 4, 6, 8
         * 
         * @param channelsOut
         *        Number of output channels to be produced. Valid values: 1, 2, 4, 6, 8
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder channelsOut(Integer channelsOut);
    }

    static final class BuilderImpl implements Builder {
        private List<AudioChannelMapping> channelMappings = DefaultSdkAutoConstructList.getInstance();

        private Integer channelsIn;

        private Integer channelsOut;

        private BuilderImpl() {
        }

        private BuilderImpl(RemixSettings model) {
            channelMappings(model.channelMappings);
            channelsIn(model.channelsIn);
            channelsOut(model.channelsOut);
        }

        public final Collection<AudioChannelMapping.Builder> getChannelMappings() {
            return channelMappings != null ? channelMappings.stream().map(AudioChannelMapping::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder channelMappings(Collection<AudioChannelMapping> channelMappings) {
            this.channelMappings = ___listOfAudioChannelMappingCopier.copy(channelMappings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder channelMappings(AudioChannelMapping... channelMappings) {
            channelMappings(Arrays.asList(channelMappings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder channelMappings(Consumer<AudioChannelMapping.Builder>... channelMappings) {
            channelMappings(Stream.of(channelMappings).map(c -> AudioChannelMapping.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setChannelMappings(Collection<AudioChannelMapping.BuilderImpl> channelMappings) {
            this.channelMappings = ___listOfAudioChannelMappingCopier.copyFromBuilder(channelMappings);
        }

        public final Integer getChannelsIn() {
            return channelsIn;
        }

        @Override
        public final Builder channelsIn(Integer channelsIn) {
            this.channelsIn = channelsIn;
            return this;
        }

        public final void setChannelsIn(Integer channelsIn) {
            this.channelsIn = channelsIn;
        }

        public final Integer getChannelsOut() {
            return channelsOut;
        }

        @Override
        public final Builder channelsOut(Integer channelsOut) {
            this.channelsOut = channelsOut;
            return this;
        }

        public final void setChannelsOut(Integer channelsOut) {
            this.channelsOut = channelsOut;
        }

        @Override
        public RemixSettings build() {
            return new RemixSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
