/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Output Settings
 */
@Generated("software.amazon.awssdk:codegen")
public final class OutputSettings implements SdkPojo, Serializable, ToCopyableBuilder<OutputSettings.Builder, OutputSettings> {
    private static final SdkField<ArchiveOutputSettings> ARCHIVE_OUTPUT_SETTINGS_FIELD = SdkField
            .<ArchiveOutputSettings> builder(MarshallingType.SDK_POJO).getter(getter(OutputSettings::archiveOutputSettings))
            .setter(setter(Builder::archiveOutputSettings)).constructor(ArchiveOutputSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("archiveOutputSettings").build())
            .build();

    private static final SdkField<FrameCaptureOutputSettings> FRAME_CAPTURE_OUTPUT_SETTINGS_FIELD = SdkField
            .<FrameCaptureOutputSettings> builder(MarshallingType.SDK_POJO)
            .getter(getter(OutputSettings::frameCaptureOutputSettings))
            .setter(setter(Builder::frameCaptureOutputSettings))
            .constructor(FrameCaptureOutputSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("frameCaptureOutputSettings").build())
            .build();

    private static final SdkField<HlsOutputSettings> HLS_OUTPUT_SETTINGS_FIELD = SdkField
            .<HlsOutputSettings> builder(MarshallingType.SDK_POJO).getter(getter(OutputSettings::hlsOutputSettings))
            .setter(setter(Builder::hlsOutputSettings)).constructor(HlsOutputSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hlsOutputSettings").build()).build();

    private static final SdkField<MediaPackageOutputSettings> MEDIA_PACKAGE_OUTPUT_SETTINGS_FIELD = SdkField
            .<MediaPackageOutputSettings> builder(MarshallingType.SDK_POJO)
            .getter(getter(OutputSettings::mediaPackageOutputSettings))
            .setter(setter(Builder::mediaPackageOutputSettings))
            .constructor(MediaPackageOutputSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mediaPackageOutputSettings").build())
            .build();

    private static final SdkField<MsSmoothOutputSettings> MS_SMOOTH_OUTPUT_SETTINGS_FIELD = SdkField
            .<MsSmoothOutputSettings> builder(MarshallingType.SDK_POJO).getter(getter(OutputSettings::msSmoothOutputSettings))
            .setter(setter(Builder::msSmoothOutputSettings)).constructor(MsSmoothOutputSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("msSmoothOutputSettings").build())
            .build();

    private static final SdkField<MultiplexOutputSettings> MULTIPLEX_OUTPUT_SETTINGS_FIELD = SdkField
            .<MultiplexOutputSettings> builder(MarshallingType.SDK_POJO).getter(getter(OutputSettings::multiplexOutputSettings))
            .setter(setter(Builder::multiplexOutputSettings)).constructor(MultiplexOutputSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("multiplexOutputSettings").build())
            .build();

    private static final SdkField<RtmpOutputSettings> RTMP_OUTPUT_SETTINGS_FIELD = SdkField
            .<RtmpOutputSettings> builder(MarshallingType.SDK_POJO).getter(getter(OutputSettings::rtmpOutputSettings))
            .setter(setter(Builder::rtmpOutputSettings)).constructor(RtmpOutputSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rtmpOutputSettings").build())
            .build();

    private static final SdkField<UdpOutputSettings> UDP_OUTPUT_SETTINGS_FIELD = SdkField
            .<UdpOutputSettings> builder(MarshallingType.SDK_POJO).getter(getter(OutputSettings::udpOutputSettings))
            .setter(setter(Builder::udpOutputSettings)).constructor(UdpOutputSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("udpOutputSettings").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARCHIVE_OUTPUT_SETTINGS_FIELD,
            FRAME_CAPTURE_OUTPUT_SETTINGS_FIELD, HLS_OUTPUT_SETTINGS_FIELD, MEDIA_PACKAGE_OUTPUT_SETTINGS_FIELD,
            MS_SMOOTH_OUTPUT_SETTINGS_FIELD, MULTIPLEX_OUTPUT_SETTINGS_FIELD, RTMP_OUTPUT_SETTINGS_FIELD,
            UDP_OUTPUT_SETTINGS_FIELD));

    private static final long serialVersionUID = 1L;

    private final ArchiveOutputSettings archiveOutputSettings;

    private final FrameCaptureOutputSettings frameCaptureOutputSettings;

    private final HlsOutputSettings hlsOutputSettings;

    private final MediaPackageOutputSettings mediaPackageOutputSettings;

    private final MsSmoothOutputSettings msSmoothOutputSettings;

    private final MultiplexOutputSettings multiplexOutputSettings;

    private final RtmpOutputSettings rtmpOutputSettings;

    private final UdpOutputSettings udpOutputSettings;

    private OutputSettings(BuilderImpl builder) {
        this.archiveOutputSettings = builder.archiveOutputSettings;
        this.frameCaptureOutputSettings = builder.frameCaptureOutputSettings;
        this.hlsOutputSettings = builder.hlsOutputSettings;
        this.mediaPackageOutputSettings = builder.mediaPackageOutputSettings;
        this.msSmoothOutputSettings = builder.msSmoothOutputSettings;
        this.multiplexOutputSettings = builder.multiplexOutputSettings;
        this.rtmpOutputSettings = builder.rtmpOutputSettings;
        this.udpOutputSettings = builder.udpOutputSettings;
    }

    /**
     * Returns the value of the ArchiveOutputSettings property for this object.
     * 
     * @return The value of the ArchiveOutputSettings property for this object.
     */
    public ArchiveOutputSettings archiveOutputSettings() {
        return archiveOutputSettings;
    }

    /**
     * Returns the value of the FrameCaptureOutputSettings property for this object.
     * 
     * @return The value of the FrameCaptureOutputSettings property for this object.
     */
    public FrameCaptureOutputSettings frameCaptureOutputSettings() {
        return frameCaptureOutputSettings;
    }

    /**
     * Returns the value of the HlsOutputSettings property for this object.
     * 
     * @return The value of the HlsOutputSettings property for this object.
     */
    public HlsOutputSettings hlsOutputSettings() {
        return hlsOutputSettings;
    }

    /**
     * Returns the value of the MediaPackageOutputSettings property for this object.
     * 
     * @return The value of the MediaPackageOutputSettings property for this object.
     */
    public MediaPackageOutputSettings mediaPackageOutputSettings() {
        return mediaPackageOutputSettings;
    }

    /**
     * Returns the value of the MsSmoothOutputSettings property for this object.
     * 
     * @return The value of the MsSmoothOutputSettings property for this object.
     */
    public MsSmoothOutputSettings msSmoothOutputSettings() {
        return msSmoothOutputSettings;
    }

    /**
     * Returns the value of the MultiplexOutputSettings property for this object.
     * 
     * @return The value of the MultiplexOutputSettings property for this object.
     */
    public MultiplexOutputSettings multiplexOutputSettings() {
        return multiplexOutputSettings;
    }

    /**
     * Returns the value of the RtmpOutputSettings property for this object.
     * 
     * @return The value of the RtmpOutputSettings property for this object.
     */
    public RtmpOutputSettings rtmpOutputSettings() {
        return rtmpOutputSettings;
    }

    /**
     * Returns the value of the UdpOutputSettings property for this object.
     * 
     * @return The value of the UdpOutputSettings property for this object.
     */
    public UdpOutputSettings udpOutputSettings() {
        return udpOutputSettings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(archiveOutputSettings());
        hashCode = 31 * hashCode + Objects.hashCode(frameCaptureOutputSettings());
        hashCode = 31 * hashCode + Objects.hashCode(hlsOutputSettings());
        hashCode = 31 * hashCode + Objects.hashCode(mediaPackageOutputSettings());
        hashCode = 31 * hashCode + Objects.hashCode(msSmoothOutputSettings());
        hashCode = 31 * hashCode + Objects.hashCode(multiplexOutputSettings());
        hashCode = 31 * hashCode + Objects.hashCode(rtmpOutputSettings());
        hashCode = 31 * hashCode + Objects.hashCode(udpOutputSettings());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OutputSettings)) {
            return false;
        }
        OutputSettings other = (OutputSettings) obj;
        return Objects.equals(archiveOutputSettings(), other.archiveOutputSettings())
                && Objects.equals(frameCaptureOutputSettings(), other.frameCaptureOutputSettings())
                && Objects.equals(hlsOutputSettings(), other.hlsOutputSettings())
                && Objects.equals(mediaPackageOutputSettings(), other.mediaPackageOutputSettings())
                && Objects.equals(msSmoothOutputSettings(), other.msSmoothOutputSettings())
                && Objects.equals(multiplexOutputSettings(), other.multiplexOutputSettings())
                && Objects.equals(rtmpOutputSettings(), other.rtmpOutputSettings())
                && Objects.equals(udpOutputSettings(), other.udpOutputSettings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("OutputSettings").add("ArchiveOutputSettings", archiveOutputSettings())
                .add("FrameCaptureOutputSettings", frameCaptureOutputSettings()).add("HlsOutputSettings", hlsOutputSettings())
                .add("MediaPackageOutputSettings", mediaPackageOutputSettings())
                .add("MsSmoothOutputSettings", msSmoothOutputSettings())
                .add("MultiplexOutputSettings", multiplexOutputSettings()).add("RtmpOutputSettings", rtmpOutputSettings())
                .add("UdpOutputSettings", udpOutputSettings()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ArchiveOutputSettings":
            return Optional.ofNullable(clazz.cast(archiveOutputSettings()));
        case "FrameCaptureOutputSettings":
            return Optional.ofNullable(clazz.cast(frameCaptureOutputSettings()));
        case "HlsOutputSettings":
            return Optional.ofNullable(clazz.cast(hlsOutputSettings()));
        case "MediaPackageOutputSettings":
            return Optional.ofNullable(clazz.cast(mediaPackageOutputSettings()));
        case "MsSmoothOutputSettings":
            return Optional.ofNullable(clazz.cast(msSmoothOutputSettings()));
        case "MultiplexOutputSettings":
            return Optional.ofNullable(clazz.cast(multiplexOutputSettings()));
        case "RtmpOutputSettings":
            return Optional.ofNullable(clazz.cast(rtmpOutputSettings()));
        case "UdpOutputSettings":
            return Optional.ofNullable(clazz.cast(udpOutputSettings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<OutputSettings, T> g) {
        return obj -> g.apply((OutputSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, OutputSettings> {
        /**
         * Sets the value of the ArchiveOutputSettings property for this object.
         *
         * @param archiveOutputSettings
         *        The new value for the ArchiveOutputSettings property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder archiveOutputSettings(ArchiveOutputSettings archiveOutputSettings);

        /**
         * Sets the value of the ArchiveOutputSettings property for this object.
         *
         * This is a convenience that creates an instance of the {@link ArchiveOutputSettings.Builder} avoiding the need
         * to create one manually via {@link ArchiveOutputSettings#builder()}.
         *
         * When the {@link Consumer} completes, {@link ArchiveOutputSettings.Builder#build()} is called immediately and
         * its result is passed to {@link #archiveOutputSettings(ArchiveOutputSettings)}.
         * 
         * @param archiveOutputSettings
         *        a consumer that will call methods on {@link ArchiveOutputSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #archiveOutputSettings(ArchiveOutputSettings)
         */
        default Builder archiveOutputSettings(Consumer<ArchiveOutputSettings.Builder> archiveOutputSettings) {
            return archiveOutputSettings(ArchiveOutputSettings.builder().applyMutation(archiveOutputSettings).build());
        }

        /**
         * Sets the value of the FrameCaptureOutputSettings property for this object.
         *
         * @param frameCaptureOutputSettings
         *        The new value for the FrameCaptureOutputSettings property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder frameCaptureOutputSettings(FrameCaptureOutputSettings frameCaptureOutputSettings);

        /**
         * Sets the value of the FrameCaptureOutputSettings property for this object.
         *
         * This is a convenience that creates an instance of the {@link FrameCaptureOutputSettings.Builder} avoiding the
         * need to create one manually via {@link FrameCaptureOutputSettings#builder()}.
         *
         * When the {@link Consumer} completes, {@link FrameCaptureOutputSettings.Builder#build()} is called immediately
         * and its result is passed to {@link #frameCaptureOutputSettings(FrameCaptureOutputSettings)}.
         * 
         * @param frameCaptureOutputSettings
         *        a consumer that will call methods on {@link FrameCaptureOutputSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #frameCaptureOutputSettings(FrameCaptureOutputSettings)
         */
        default Builder frameCaptureOutputSettings(Consumer<FrameCaptureOutputSettings.Builder> frameCaptureOutputSettings) {
            return frameCaptureOutputSettings(FrameCaptureOutputSettings.builder().applyMutation(frameCaptureOutputSettings)
                    .build());
        }

        /**
         * Sets the value of the HlsOutputSettings property for this object.
         *
         * @param hlsOutputSettings
         *        The new value for the HlsOutputSettings property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hlsOutputSettings(HlsOutputSettings hlsOutputSettings);

        /**
         * Sets the value of the HlsOutputSettings property for this object.
         *
         * This is a convenience that creates an instance of the {@link HlsOutputSettings.Builder} avoiding the need to
         * create one manually via {@link HlsOutputSettings#builder()}.
         *
         * When the {@link Consumer} completes, {@link HlsOutputSettings.Builder#build()} is called immediately and its
         * result is passed to {@link #hlsOutputSettings(HlsOutputSettings)}.
         * 
         * @param hlsOutputSettings
         *        a consumer that will call methods on {@link HlsOutputSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #hlsOutputSettings(HlsOutputSettings)
         */
        default Builder hlsOutputSettings(Consumer<HlsOutputSettings.Builder> hlsOutputSettings) {
            return hlsOutputSettings(HlsOutputSettings.builder().applyMutation(hlsOutputSettings).build());
        }

        /**
         * Sets the value of the MediaPackageOutputSettings property for this object.
         *
         * @param mediaPackageOutputSettings
         *        The new value for the MediaPackageOutputSettings property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mediaPackageOutputSettings(MediaPackageOutputSettings mediaPackageOutputSettings);

        /**
         * Sets the value of the MediaPackageOutputSettings property for this object.
         *
         * This is a convenience that creates an instance of the {@link MediaPackageOutputSettings.Builder} avoiding the
         * need to create one manually via {@link MediaPackageOutputSettings#builder()}.
         *
         * When the {@link Consumer} completes, {@link MediaPackageOutputSettings.Builder#build()} is called immediately
         * and its result is passed to {@link #mediaPackageOutputSettings(MediaPackageOutputSettings)}.
         * 
         * @param mediaPackageOutputSettings
         *        a consumer that will call methods on {@link MediaPackageOutputSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #mediaPackageOutputSettings(MediaPackageOutputSettings)
         */
        default Builder mediaPackageOutputSettings(Consumer<MediaPackageOutputSettings.Builder> mediaPackageOutputSettings) {
            return mediaPackageOutputSettings(MediaPackageOutputSettings.builder().applyMutation(mediaPackageOutputSettings)
                    .build());
        }

        /**
         * Sets the value of the MsSmoothOutputSettings property for this object.
         *
         * @param msSmoothOutputSettings
         *        The new value for the MsSmoothOutputSettings property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder msSmoothOutputSettings(MsSmoothOutputSettings msSmoothOutputSettings);

        /**
         * Sets the value of the MsSmoothOutputSettings property for this object.
         *
         * This is a convenience that creates an instance of the {@link MsSmoothOutputSettings.Builder} avoiding the
         * need to create one manually via {@link MsSmoothOutputSettings#builder()}.
         *
         * When the {@link Consumer} completes, {@link MsSmoothOutputSettings.Builder#build()} is called immediately and
         * its result is passed to {@link #msSmoothOutputSettings(MsSmoothOutputSettings)}.
         * 
         * @param msSmoothOutputSettings
         *        a consumer that will call methods on {@link MsSmoothOutputSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #msSmoothOutputSettings(MsSmoothOutputSettings)
         */
        default Builder msSmoothOutputSettings(Consumer<MsSmoothOutputSettings.Builder> msSmoothOutputSettings) {
            return msSmoothOutputSettings(MsSmoothOutputSettings.builder().applyMutation(msSmoothOutputSettings).build());
        }

        /**
         * Sets the value of the MultiplexOutputSettings property for this object.
         *
         * @param multiplexOutputSettings
         *        The new value for the MultiplexOutputSettings property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder multiplexOutputSettings(MultiplexOutputSettings multiplexOutputSettings);

        /**
         * Sets the value of the MultiplexOutputSettings property for this object.
         *
         * This is a convenience that creates an instance of the {@link MultiplexOutputSettings.Builder} avoiding the
         * need to create one manually via {@link MultiplexOutputSettings#builder()}.
         *
         * When the {@link Consumer} completes, {@link MultiplexOutputSettings.Builder#build()} is called immediately
         * and its result is passed to {@link #multiplexOutputSettings(MultiplexOutputSettings)}.
         * 
         * @param multiplexOutputSettings
         *        a consumer that will call methods on {@link MultiplexOutputSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #multiplexOutputSettings(MultiplexOutputSettings)
         */
        default Builder multiplexOutputSettings(Consumer<MultiplexOutputSettings.Builder> multiplexOutputSettings) {
            return multiplexOutputSettings(MultiplexOutputSettings.builder().applyMutation(multiplexOutputSettings).build());
        }

        /**
         * Sets the value of the RtmpOutputSettings property for this object.
         *
         * @param rtmpOutputSettings
         *        The new value for the RtmpOutputSettings property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rtmpOutputSettings(RtmpOutputSettings rtmpOutputSettings);

        /**
         * Sets the value of the RtmpOutputSettings property for this object.
         *
         * This is a convenience that creates an instance of the {@link RtmpOutputSettings.Builder} avoiding the need to
         * create one manually via {@link RtmpOutputSettings#builder()}.
         *
         * When the {@link Consumer} completes, {@link RtmpOutputSettings.Builder#build()} is called immediately and its
         * result is passed to {@link #rtmpOutputSettings(RtmpOutputSettings)}.
         * 
         * @param rtmpOutputSettings
         *        a consumer that will call methods on {@link RtmpOutputSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #rtmpOutputSettings(RtmpOutputSettings)
         */
        default Builder rtmpOutputSettings(Consumer<RtmpOutputSettings.Builder> rtmpOutputSettings) {
            return rtmpOutputSettings(RtmpOutputSettings.builder().applyMutation(rtmpOutputSettings).build());
        }

        /**
         * Sets the value of the UdpOutputSettings property for this object.
         *
         * @param udpOutputSettings
         *        The new value for the UdpOutputSettings property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder udpOutputSettings(UdpOutputSettings udpOutputSettings);

        /**
         * Sets the value of the UdpOutputSettings property for this object.
         *
         * This is a convenience that creates an instance of the {@link UdpOutputSettings.Builder} avoiding the need to
         * create one manually via {@link UdpOutputSettings#builder()}.
         *
         * When the {@link Consumer} completes, {@link UdpOutputSettings.Builder#build()} is called immediately and its
         * result is passed to {@link #udpOutputSettings(UdpOutputSettings)}.
         * 
         * @param udpOutputSettings
         *        a consumer that will call methods on {@link UdpOutputSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #udpOutputSettings(UdpOutputSettings)
         */
        default Builder udpOutputSettings(Consumer<UdpOutputSettings.Builder> udpOutputSettings) {
            return udpOutputSettings(UdpOutputSettings.builder().applyMutation(udpOutputSettings).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private ArchiveOutputSettings archiveOutputSettings;

        private FrameCaptureOutputSettings frameCaptureOutputSettings;

        private HlsOutputSettings hlsOutputSettings;

        private MediaPackageOutputSettings mediaPackageOutputSettings;

        private MsSmoothOutputSettings msSmoothOutputSettings;

        private MultiplexOutputSettings multiplexOutputSettings;

        private RtmpOutputSettings rtmpOutputSettings;

        private UdpOutputSettings udpOutputSettings;

        private BuilderImpl() {
        }

        private BuilderImpl(OutputSettings model) {
            archiveOutputSettings(model.archiveOutputSettings);
            frameCaptureOutputSettings(model.frameCaptureOutputSettings);
            hlsOutputSettings(model.hlsOutputSettings);
            mediaPackageOutputSettings(model.mediaPackageOutputSettings);
            msSmoothOutputSettings(model.msSmoothOutputSettings);
            multiplexOutputSettings(model.multiplexOutputSettings);
            rtmpOutputSettings(model.rtmpOutputSettings);
            udpOutputSettings(model.udpOutputSettings);
        }

        public final ArchiveOutputSettings.Builder getArchiveOutputSettings() {
            return archiveOutputSettings != null ? archiveOutputSettings.toBuilder() : null;
        }

        @Override
        public final Builder archiveOutputSettings(ArchiveOutputSettings archiveOutputSettings) {
            this.archiveOutputSettings = archiveOutputSettings;
            return this;
        }

        public final void setArchiveOutputSettings(ArchiveOutputSettings.BuilderImpl archiveOutputSettings) {
            this.archiveOutputSettings = archiveOutputSettings != null ? archiveOutputSettings.build() : null;
        }

        public final FrameCaptureOutputSettings.Builder getFrameCaptureOutputSettings() {
            return frameCaptureOutputSettings != null ? frameCaptureOutputSettings.toBuilder() : null;
        }

        @Override
        public final Builder frameCaptureOutputSettings(FrameCaptureOutputSettings frameCaptureOutputSettings) {
            this.frameCaptureOutputSettings = frameCaptureOutputSettings;
            return this;
        }

        public final void setFrameCaptureOutputSettings(FrameCaptureOutputSettings.BuilderImpl frameCaptureOutputSettings) {
            this.frameCaptureOutputSettings = frameCaptureOutputSettings != null ? frameCaptureOutputSettings.build() : null;
        }

        public final HlsOutputSettings.Builder getHlsOutputSettings() {
            return hlsOutputSettings != null ? hlsOutputSettings.toBuilder() : null;
        }

        @Override
        public final Builder hlsOutputSettings(HlsOutputSettings hlsOutputSettings) {
            this.hlsOutputSettings = hlsOutputSettings;
            return this;
        }

        public final void setHlsOutputSettings(HlsOutputSettings.BuilderImpl hlsOutputSettings) {
            this.hlsOutputSettings = hlsOutputSettings != null ? hlsOutputSettings.build() : null;
        }

        public final MediaPackageOutputSettings.Builder getMediaPackageOutputSettings() {
            return mediaPackageOutputSettings != null ? mediaPackageOutputSettings.toBuilder() : null;
        }

        @Override
        public final Builder mediaPackageOutputSettings(MediaPackageOutputSettings mediaPackageOutputSettings) {
            this.mediaPackageOutputSettings = mediaPackageOutputSettings;
            return this;
        }

        public final void setMediaPackageOutputSettings(MediaPackageOutputSettings.BuilderImpl mediaPackageOutputSettings) {
            this.mediaPackageOutputSettings = mediaPackageOutputSettings != null ? mediaPackageOutputSettings.build() : null;
        }

        public final MsSmoothOutputSettings.Builder getMsSmoothOutputSettings() {
            return msSmoothOutputSettings != null ? msSmoothOutputSettings.toBuilder() : null;
        }

        @Override
        public final Builder msSmoothOutputSettings(MsSmoothOutputSettings msSmoothOutputSettings) {
            this.msSmoothOutputSettings = msSmoothOutputSettings;
            return this;
        }

        public final void setMsSmoothOutputSettings(MsSmoothOutputSettings.BuilderImpl msSmoothOutputSettings) {
            this.msSmoothOutputSettings = msSmoothOutputSettings != null ? msSmoothOutputSettings.build() : null;
        }

        public final MultiplexOutputSettings.Builder getMultiplexOutputSettings() {
            return multiplexOutputSettings != null ? multiplexOutputSettings.toBuilder() : null;
        }

        @Override
        public final Builder multiplexOutputSettings(MultiplexOutputSettings multiplexOutputSettings) {
            this.multiplexOutputSettings = multiplexOutputSettings;
            return this;
        }

        public final void setMultiplexOutputSettings(MultiplexOutputSettings.BuilderImpl multiplexOutputSettings) {
            this.multiplexOutputSettings = multiplexOutputSettings != null ? multiplexOutputSettings.build() : null;
        }

        public final RtmpOutputSettings.Builder getRtmpOutputSettings() {
            return rtmpOutputSettings != null ? rtmpOutputSettings.toBuilder() : null;
        }

        @Override
        public final Builder rtmpOutputSettings(RtmpOutputSettings rtmpOutputSettings) {
            this.rtmpOutputSettings = rtmpOutputSettings;
            return this;
        }

        public final void setRtmpOutputSettings(RtmpOutputSettings.BuilderImpl rtmpOutputSettings) {
            this.rtmpOutputSettings = rtmpOutputSettings != null ? rtmpOutputSettings.build() : null;
        }

        public final UdpOutputSettings.Builder getUdpOutputSettings() {
            return udpOutputSettings != null ? udpOutputSettings.toBuilder() : null;
        }

        @Override
        public final Builder udpOutputSettings(UdpOutputSettings udpOutputSettings) {
            this.udpOutputSettings = udpOutputSettings;
            return this;
        }

        public final void setUdpOutputSettings(UdpOutputSettings.BuilderImpl udpOutputSettings) {
            this.udpOutputSettings = udpOutputSettings != null ? udpOutputSettings.build() : null;
        }

        @Override
        public OutputSettings build() {
            return new OutputSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
