/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Network source to transcode. Must be accessible to the Elemental Live node that is running the live event through a
 * network connection.
 */
@Generated("software.amazon.awssdk:codegen")
public final class NetworkInputSettings implements SdkPojo, Serializable,
        ToCopyableBuilder<NetworkInputSettings.Builder, NetworkInputSettings> {
    private static final SdkField<HlsInputSettings> HLS_INPUT_SETTINGS_FIELD = SdkField
            .<HlsInputSettings> builder(MarshallingType.SDK_POJO).getter(getter(NetworkInputSettings::hlsInputSettings))
            .setter(setter(Builder::hlsInputSettings)).constructor(HlsInputSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hlsInputSettings").build()).build();

    private static final SdkField<String> SERVER_VALIDATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(NetworkInputSettings::serverValidationAsString)).setter(setter(Builder::serverValidation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serverValidation").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HLS_INPUT_SETTINGS_FIELD,
            SERVER_VALIDATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final HlsInputSettings hlsInputSettings;

    private final String serverValidation;

    private NetworkInputSettings(BuilderImpl builder) {
        this.hlsInputSettings = builder.hlsInputSettings;
        this.serverValidation = builder.serverValidation;
    }

    /**
     * Specifies HLS input settings when the uri is for a HLS manifest.
     * 
     * @return Specifies HLS input settings when the uri is for a HLS manifest.
     */
    public HlsInputSettings hlsInputSettings() {
        return hlsInputSettings;
    }

    /**
     * Check HTTPS server certificates. When set to checkCryptographyOnly, cryptography in the certificate will be
     * checked, but not the server's name. Certain subdomains (notably S3 buckets that use dots in the bucket name) do
     * not strictly match the corresponding certificate's wildcard pattern and would otherwise cause the event to error.
     * This setting is ignored for protocols that do not use https.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #serverValidation}
     * will return {@link NetworkInputServerValidation#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #serverValidationAsString}.
     * </p>
     * 
     * @return Check HTTPS server certificates. When set to checkCryptographyOnly, cryptography in the certificate will
     *         be checked, but not the server's name. Certain subdomains (notably S3 buckets that use dots in the bucket
     *         name) do not strictly match the corresponding certificate's wildcard pattern and would otherwise cause
     *         the event to error. This setting is ignored for protocols that do not use https.
     * @see NetworkInputServerValidation
     */
    public NetworkInputServerValidation serverValidation() {
        return NetworkInputServerValidation.fromValue(serverValidation);
    }

    /**
     * Check HTTPS server certificates. When set to checkCryptographyOnly, cryptography in the certificate will be
     * checked, but not the server's name. Certain subdomains (notably S3 buckets that use dots in the bucket name) do
     * not strictly match the corresponding certificate's wildcard pattern and would otherwise cause the event to error.
     * This setting is ignored for protocols that do not use https.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #serverValidation}
     * will return {@link NetworkInputServerValidation#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #serverValidationAsString}.
     * </p>
     * 
     * @return Check HTTPS server certificates. When set to checkCryptographyOnly, cryptography in the certificate will
     *         be checked, but not the server's name. Certain subdomains (notably S3 buckets that use dots in the bucket
     *         name) do not strictly match the corresponding certificate's wildcard pattern and would otherwise cause
     *         the event to error. This setting is ignored for protocols that do not use https.
     * @see NetworkInputServerValidation
     */
    public String serverValidationAsString() {
        return serverValidation;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hlsInputSettings());
        hashCode = 31 * hashCode + Objects.hashCode(serverValidationAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NetworkInputSettings)) {
            return false;
        }
        NetworkInputSettings other = (NetworkInputSettings) obj;
        return Objects.equals(hlsInputSettings(), other.hlsInputSettings())
                && Objects.equals(serverValidationAsString(), other.serverValidationAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("NetworkInputSettings").add("HlsInputSettings", hlsInputSettings())
                .add("ServerValidation", serverValidationAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "HlsInputSettings":
            return Optional.ofNullable(clazz.cast(hlsInputSettings()));
        case "ServerValidation":
            return Optional.ofNullable(clazz.cast(serverValidationAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<NetworkInputSettings, T> g) {
        return obj -> g.apply((NetworkInputSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, NetworkInputSettings> {
        /**
         * Specifies HLS input settings when the uri is for a HLS manifest.
         * 
         * @param hlsInputSettings
         *        Specifies HLS input settings when the uri is for a HLS manifest.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hlsInputSettings(HlsInputSettings hlsInputSettings);

        /**
         * Specifies HLS input settings when the uri is for a HLS manifest. This is a convenience that creates an
         * instance of the {@link HlsInputSettings.Builder} avoiding the need to create one manually via
         * {@link HlsInputSettings#builder()}.
         *
         * When the {@link Consumer} completes, {@link HlsInputSettings.Builder#build()} is called immediately and its
         * result is passed to {@link #hlsInputSettings(HlsInputSettings)}.
         * 
         * @param hlsInputSettings
         *        a consumer that will call methods on {@link HlsInputSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #hlsInputSettings(HlsInputSettings)
         */
        default Builder hlsInputSettings(Consumer<HlsInputSettings.Builder> hlsInputSettings) {
            return hlsInputSettings(HlsInputSettings.builder().applyMutation(hlsInputSettings).build());
        }

        /**
         * Check HTTPS server certificates. When set to checkCryptographyOnly, cryptography in the certificate will be
         * checked, but not the server's name. Certain subdomains (notably S3 buckets that use dots in the bucket name)
         * do not strictly match the corresponding certificate's wildcard pattern and would otherwise cause the event to
         * error. This setting is ignored for protocols that do not use https.
         * 
         * @param serverValidation
         *        Check HTTPS server certificates. When set to checkCryptographyOnly, cryptography in the certificate
         *        will be checked, but not the server's name. Certain subdomains (notably S3 buckets that use dots in
         *        the bucket name) do not strictly match the corresponding certificate's wildcard pattern and would
         *        otherwise cause the event to error. This setting is ignored for protocols that do not use https.
         * @see NetworkInputServerValidation
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NetworkInputServerValidation
         */
        Builder serverValidation(String serverValidation);

        /**
         * Check HTTPS server certificates. When set to checkCryptographyOnly, cryptography in the certificate will be
         * checked, but not the server's name. Certain subdomains (notably S3 buckets that use dots in the bucket name)
         * do not strictly match the corresponding certificate's wildcard pattern and would otherwise cause the event to
         * error. This setting is ignored for protocols that do not use https.
         * 
         * @param serverValidation
         *        Check HTTPS server certificates. When set to checkCryptographyOnly, cryptography in the certificate
         *        will be checked, but not the server's name. Certain subdomains (notably S3 buckets that use dots in
         *        the bucket name) do not strictly match the corresponding certificate's wildcard pattern and would
         *        otherwise cause the event to error. This setting is ignored for protocols that do not use https.
         * @see NetworkInputServerValidation
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NetworkInputServerValidation
         */
        Builder serverValidation(NetworkInputServerValidation serverValidation);
    }

    static final class BuilderImpl implements Builder {
        private HlsInputSettings hlsInputSettings;

        private String serverValidation;

        private BuilderImpl() {
        }

        private BuilderImpl(NetworkInputSettings model) {
            hlsInputSettings(model.hlsInputSettings);
            serverValidation(model.serverValidation);
        }

        public final HlsInputSettings.Builder getHlsInputSettings() {
            return hlsInputSettings != null ? hlsInputSettings.toBuilder() : null;
        }

        @Override
        public final Builder hlsInputSettings(HlsInputSettings hlsInputSettings) {
            this.hlsInputSettings = hlsInputSettings;
            return this;
        }

        public final void setHlsInputSettings(HlsInputSettings.BuilderImpl hlsInputSettings) {
            this.hlsInputSettings = hlsInputSettings != null ? hlsInputSettings.build() : null;
        }

        public final String getServerValidationAsString() {
            return serverValidation;
        }

        @Override
        public final Builder serverValidation(String serverValidation) {
            this.serverValidation = serverValidation;
            return this;
        }

        @Override
        public final Builder serverValidation(NetworkInputServerValidation serverValidation) {
            this.serverValidation(serverValidation == null ? null : serverValidation.toString());
            return this;
        }

        public final void setServerValidation(String serverValidation) {
            this.serverValidation = serverValidation;
        }

        @Override
        public NetworkInputSettings build() {
            return new NetworkInputSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
