/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Contains configuration for a Multiplex event
 */
@Generated("software.amazon.awssdk:codegen")
public final class MultiplexSettings implements SdkPojo, Serializable,
        ToCopyableBuilder<MultiplexSettings.Builder, MultiplexSettings> {
    private static final SdkField<Integer> MAXIMUM_VIDEO_BUFFER_DELAY_MILLISECONDS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(MultiplexSettings::maximumVideoBufferDelayMilliseconds))
            .setter(setter(Builder::maximumVideoBufferDelayMilliseconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("maximumVideoBufferDelayMilliseconds").build()).build();

    private static final SdkField<Integer> TRANSPORT_STREAM_BITRATE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(MultiplexSettings::transportStreamBitrate)).setter(setter(Builder::transportStreamBitrate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("transportStreamBitrate").build())
            .build();

    private static final SdkField<Integer> TRANSPORT_STREAM_ID_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(MultiplexSettings::transportStreamId)).setter(setter(Builder::transportStreamId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("transportStreamId").build()).build();

    private static final SdkField<Integer> TRANSPORT_STREAM_RESERVED_BITRATE_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(MultiplexSettings::transportStreamReservedBitrate))
            .setter(setter(Builder::transportStreamReservedBitrate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("transportStreamReservedBitrate")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            MAXIMUM_VIDEO_BUFFER_DELAY_MILLISECONDS_FIELD, TRANSPORT_STREAM_BITRATE_FIELD, TRANSPORT_STREAM_ID_FIELD,
            TRANSPORT_STREAM_RESERVED_BITRATE_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer maximumVideoBufferDelayMilliseconds;

    private final Integer transportStreamBitrate;

    private final Integer transportStreamId;

    private final Integer transportStreamReservedBitrate;

    private MultiplexSettings(BuilderImpl builder) {
        this.maximumVideoBufferDelayMilliseconds = builder.maximumVideoBufferDelayMilliseconds;
        this.transportStreamBitrate = builder.transportStreamBitrate;
        this.transportStreamId = builder.transportStreamId;
        this.transportStreamReservedBitrate = builder.transportStreamReservedBitrate;
    }

    /**
     * Maximum video buffer delay in milliseconds.
     * 
     * @return Maximum video buffer delay in milliseconds.
     */
    public Integer maximumVideoBufferDelayMilliseconds() {
        return maximumVideoBufferDelayMilliseconds;
    }

    /**
     * Transport stream bit rate.
     * 
     * @return Transport stream bit rate.
     */
    public Integer transportStreamBitrate() {
        return transportStreamBitrate;
    }

    /**
     * Transport stream ID.
     * 
     * @return Transport stream ID.
     */
    public Integer transportStreamId() {
        return transportStreamId;
    }

    /**
     * Transport stream reserved bit rate.
     * 
     * @return Transport stream reserved bit rate.
     */
    public Integer transportStreamReservedBitrate() {
        return transportStreamReservedBitrate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(maximumVideoBufferDelayMilliseconds());
        hashCode = 31 * hashCode + Objects.hashCode(transportStreamBitrate());
        hashCode = 31 * hashCode + Objects.hashCode(transportStreamId());
        hashCode = 31 * hashCode + Objects.hashCode(transportStreamReservedBitrate());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MultiplexSettings)) {
            return false;
        }
        MultiplexSettings other = (MultiplexSettings) obj;
        return Objects.equals(maximumVideoBufferDelayMilliseconds(), other.maximumVideoBufferDelayMilliseconds())
                && Objects.equals(transportStreamBitrate(), other.transportStreamBitrate())
                && Objects.equals(transportStreamId(), other.transportStreamId())
                && Objects.equals(transportStreamReservedBitrate(), other.transportStreamReservedBitrate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("MultiplexSettings")
                .add("MaximumVideoBufferDelayMilliseconds", maximumVideoBufferDelayMilliseconds())
                .add("TransportStreamBitrate", transportStreamBitrate()).add("TransportStreamId", transportStreamId())
                .add("TransportStreamReservedBitrate", transportStreamReservedBitrate()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MaximumVideoBufferDelayMilliseconds":
            return Optional.ofNullable(clazz.cast(maximumVideoBufferDelayMilliseconds()));
        case "TransportStreamBitrate":
            return Optional.ofNullable(clazz.cast(transportStreamBitrate()));
        case "TransportStreamId":
            return Optional.ofNullable(clazz.cast(transportStreamId()));
        case "TransportStreamReservedBitrate":
            return Optional.ofNullable(clazz.cast(transportStreamReservedBitrate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MultiplexSettings, T> g) {
        return obj -> g.apply((MultiplexSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MultiplexSettings> {
        /**
         * Maximum video buffer delay in milliseconds.
         * 
         * @param maximumVideoBufferDelayMilliseconds
         *        Maximum video buffer delay in milliseconds.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maximumVideoBufferDelayMilliseconds(Integer maximumVideoBufferDelayMilliseconds);

        /**
         * Transport stream bit rate.
         * 
         * @param transportStreamBitrate
         *        Transport stream bit rate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transportStreamBitrate(Integer transportStreamBitrate);

        /**
         * Transport stream ID.
         * 
         * @param transportStreamId
         *        Transport stream ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transportStreamId(Integer transportStreamId);

        /**
         * Transport stream reserved bit rate.
         * 
         * @param transportStreamReservedBitrate
         *        Transport stream reserved bit rate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transportStreamReservedBitrate(Integer transportStreamReservedBitrate);
    }

    static final class BuilderImpl implements Builder {
        private Integer maximumVideoBufferDelayMilliseconds;

        private Integer transportStreamBitrate;

        private Integer transportStreamId;

        private Integer transportStreamReservedBitrate;

        private BuilderImpl() {
        }

        private BuilderImpl(MultiplexSettings model) {
            maximumVideoBufferDelayMilliseconds(model.maximumVideoBufferDelayMilliseconds);
            transportStreamBitrate(model.transportStreamBitrate);
            transportStreamId(model.transportStreamId);
            transportStreamReservedBitrate(model.transportStreamReservedBitrate);
        }

        public final Integer getMaximumVideoBufferDelayMilliseconds() {
            return maximumVideoBufferDelayMilliseconds;
        }

        @Override
        public final Builder maximumVideoBufferDelayMilliseconds(Integer maximumVideoBufferDelayMilliseconds) {
            this.maximumVideoBufferDelayMilliseconds = maximumVideoBufferDelayMilliseconds;
            return this;
        }

        public final void setMaximumVideoBufferDelayMilliseconds(Integer maximumVideoBufferDelayMilliseconds) {
            this.maximumVideoBufferDelayMilliseconds = maximumVideoBufferDelayMilliseconds;
        }

        public final Integer getTransportStreamBitrate() {
            return transportStreamBitrate;
        }

        @Override
        public final Builder transportStreamBitrate(Integer transportStreamBitrate) {
            this.transportStreamBitrate = transportStreamBitrate;
            return this;
        }

        public final void setTransportStreamBitrate(Integer transportStreamBitrate) {
            this.transportStreamBitrate = transportStreamBitrate;
        }

        public final Integer getTransportStreamId() {
            return transportStreamId;
        }

        @Override
        public final Builder transportStreamId(Integer transportStreamId) {
            this.transportStreamId = transportStreamId;
            return this;
        }

        public final void setTransportStreamId(Integer transportStreamId) {
            this.transportStreamId = transportStreamId;
        }

        public final Integer getTransportStreamReservedBitrate() {
            return transportStreamReservedBitrate;
        }

        @Override
        public final Builder transportStreamReservedBitrate(Integer transportStreamReservedBitrate) {
            this.transportStreamReservedBitrate = transportStreamReservedBitrate;
            return this;
        }

        public final void setTransportStreamReservedBitrate(Integer transportStreamReservedBitrate) {
            this.transportStreamReservedBitrate = transportStreamReservedBitrate;
        }

        @Override
        public MultiplexSettings build() {
            return new MultiplexSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
