/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Multiplex Program Input Destination Settings for outputting a Channel to a Multiplex
 */
@Generated("software.amazon.awssdk:codegen")
public final class MultiplexProgramChannelDestinationSettings implements SdkPojo, Serializable,
        ToCopyableBuilder<MultiplexProgramChannelDestinationSettings.Builder, MultiplexProgramChannelDestinationSettings> {
    private static final SdkField<String> MULTIPLEX_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(MultiplexProgramChannelDestinationSettings::multiplexId)).setter(setter(Builder::multiplexId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("multiplexId").build()).build();

    private static final SdkField<String> PROGRAM_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(MultiplexProgramChannelDestinationSettings::programName)).setter(setter(Builder::programName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("programName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MULTIPLEX_ID_FIELD,
            PROGRAM_NAME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String multiplexId;

    private final String programName;

    private MultiplexProgramChannelDestinationSettings(BuilderImpl builder) {
        this.multiplexId = builder.multiplexId;
        this.programName = builder.programName;
    }

    /**
     * The ID of the Multiplex that the encoder is providing output to. You do not need to specify the individual inputs
     * to the Multiplex; MediaLive will handle the connection of the two MediaLive pipelines to the two Multiplex
     * instances. The Multiplex must be in the same region as the Channel.
     * 
     * @return The ID of the Multiplex that the encoder is providing output to. You do not need to specify the
     *         individual inputs to the Multiplex; MediaLive will handle the connection of the two MediaLive pipelines
     *         to the two Multiplex instances. The Multiplex must be in the same region as the Channel.
     */
    public String multiplexId() {
        return multiplexId;
    }

    /**
     * The program name of the Multiplex program that the encoder is providing output to.
     * 
     * @return The program name of the Multiplex program that the encoder is providing output to.
     */
    public String programName() {
        return programName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(multiplexId());
        hashCode = 31 * hashCode + Objects.hashCode(programName());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MultiplexProgramChannelDestinationSettings)) {
            return false;
        }
        MultiplexProgramChannelDestinationSettings other = (MultiplexProgramChannelDestinationSettings) obj;
        return Objects.equals(multiplexId(), other.multiplexId()) && Objects.equals(programName(), other.programName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("MultiplexProgramChannelDestinationSettings").add("MultiplexId", multiplexId())
                .add("ProgramName", programName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MultiplexId":
            return Optional.ofNullable(clazz.cast(multiplexId()));
        case "ProgramName":
            return Optional.ofNullable(clazz.cast(programName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MultiplexProgramChannelDestinationSettings, T> g) {
        return obj -> g.apply((MultiplexProgramChannelDestinationSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MultiplexProgramChannelDestinationSettings> {
        /**
         * The ID of the Multiplex that the encoder is providing output to. You do not need to specify the individual
         * inputs to the Multiplex; MediaLive will handle the connection of the two MediaLive pipelines to the two
         * Multiplex instances. The Multiplex must be in the same region as the Channel.
         * 
         * @param multiplexId
         *        The ID of the Multiplex that the encoder is providing output to. You do not need to specify the
         *        individual inputs to the Multiplex; MediaLive will handle the connection of the two MediaLive
         *        pipelines to the two Multiplex instances. The Multiplex must be in the same region as the Channel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder multiplexId(String multiplexId);

        /**
         * The program name of the Multiplex program that the encoder is providing output to.
         * 
         * @param programName
         *        The program name of the Multiplex program that the encoder is providing output to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder programName(String programName);
    }

    static final class BuilderImpl implements Builder {
        private String multiplexId;

        private String programName;

        private BuilderImpl() {
        }

        private BuilderImpl(MultiplexProgramChannelDestinationSettings model) {
            multiplexId(model.multiplexId);
            programName(model.programName);
        }

        public final String getMultiplexId() {
            return multiplexId;
        }

        @Override
        public final Builder multiplexId(String multiplexId) {
            this.multiplexId = multiplexId;
            return this;
        }

        public final void setMultiplexId(String multiplexId) {
            this.multiplexId = multiplexId;
        }

        public final String getProgramName() {
            return programName;
        }

        @Override
        public final Builder programName(String programName) {
            this.programName = programName;
            return this;
        }

        public final void setProgramName(String programName) {
            this.programName = programName;
        }

        @Override
        public MultiplexProgramChannelDestinationSettings build() {
            return new MultiplexProgramChannelDestinationSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
