/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Multiplex MediaConnect output destination settings.
 */
@Generated("software.amazon.awssdk:codegen")
public final class MultiplexMediaConnectOutputDestinationSettings implements SdkPojo, Serializable,
        ToCopyableBuilder<MultiplexMediaConnectOutputDestinationSettings.Builder, MultiplexMediaConnectOutputDestinationSettings> {
    private static final SdkField<String> ENTITLEMENT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(MultiplexMediaConnectOutputDestinationSettings::entitlementArn))
            .setter(setter(Builder::entitlementArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("entitlementArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENTITLEMENT_ARN_FIELD));

    private static final long serialVersionUID = 1L;

    private final String entitlementArn;

    private MultiplexMediaConnectOutputDestinationSettings(BuilderImpl builder) {
        this.entitlementArn = builder.entitlementArn;
    }

    /**
     * The MediaConnect entitlement ARN available as a Flow source.
     * 
     * @return The MediaConnect entitlement ARN available as a Flow source.
     */
    public String entitlementArn() {
        return entitlementArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(entitlementArn());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MultiplexMediaConnectOutputDestinationSettings)) {
            return false;
        }
        MultiplexMediaConnectOutputDestinationSettings other = (MultiplexMediaConnectOutputDestinationSettings) obj;
        return Objects.equals(entitlementArn(), other.entitlementArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("MultiplexMediaConnectOutputDestinationSettings").add("EntitlementArn", entitlementArn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EntitlementArn":
            return Optional.ofNullable(clazz.cast(entitlementArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MultiplexMediaConnectOutputDestinationSettings, T> g) {
        return obj -> g.apply((MultiplexMediaConnectOutputDestinationSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MultiplexMediaConnectOutputDestinationSettings> {
        /**
         * The MediaConnect entitlement ARN available as a Flow source.
         * 
         * @param entitlementArn
         *        The MediaConnect entitlement ARN available as a Flow source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entitlementArn(String entitlementArn);
    }

    static final class BuilderImpl implements Builder {
        private String entitlementArn;

        private BuilderImpl() {
        }

        private BuilderImpl(MultiplexMediaConnectOutputDestinationSettings model) {
            entitlementArn(model.entitlementArn);
        }

        public final String getEntitlementArn() {
            return entitlementArn;
        }

        @Override
        public final Builder entitlementArn(String entitlementArn) {
            this.entitlementArn = entitlementArn;
            return this;
        }

        public final void setEntitlementArn(String entitlementArn) {
            this.entitlementArn = entitlementArn;
        }

        @Override
        public MultiplexMediaConnectOutputDestinationSettings build() {
            return new MultiplexMediaConnectOutputDestinationSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
