/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Mp2 Settings
 */
@Generated("software.amazon.awssdk:codegen")
public final class Mp2Settings implements SdkPojo, Serializable, ToCopyableBuilder<Mp2Settings.Builder, Mp2Settings> {
    private static final SdkField<Double> BITRATE_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .getter(getter(Mp2Settings::bitrate)).setter(setter(Builder::bitrate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bitrate").build()).build();

    private static final SdkField<String> CODING_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Mp2Settings::codingModeAsString)).setter(setter(Builder::codingMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("codingMode").build()).build();

    private static final SdkField<Double> SAMPLE_RATE_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .getter(getter(Mp2Settings::sampleRate)).setter(setter(Builder::sampleRate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sampleRate").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BITRATE_FIELD,
            CODING_MODE_FIELD, SAMPLE_RATE_FIELD));

    private static final long serialVersionUID = 1L;

    private final Double bitrate;

    private final String codingMode;

    private final Double sampleRate;

    private Mp2Settings(BuilderImpl builder) {
        this.bitrate = builder.bitrate;
        this.codingMode = builder.codingMode;
        this.sampleRate = builder.sampleRate;
    }

    /**
     * Average bitrate in bits/second.
     * 
     * @return Average bitrate in bits/second.
     */
    public Double bitrate() {
        return bitrate;
    }

    /**
     * The MPEG2 Audio coding mode. Valid values are codingMode10 (for mono) or codingMode20 (for stereo).
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #codingMode} will
     * return {@link Mp2CodingMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #codingModeAsString}.
     * </p>
     * 
     * @return The MPEG2 Audio coding mode. Valid values are codingMode10 (for mono) or codingMode20 (for stereo).
     * @see Mp2CodingMode
     */
    public Mp2CodingMode codingMode() {
        return Mp2CodingMode.fromValue(codingMode);
    }

    /**
     * The MPEG2 Audio coding mode. Valid values are codingMode10 (for mono) or codingMode20 (for stereo).
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #codingMode} will
     * return {@link Mp2CodingMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #codingModeAsString}.
     * </p>
     * 
     * @return The MPEG2 Audio coding mode. Valid values are codingMode10 (for mono) or codingMode20 (for stereo).
     * @see Mp2CodingMode
     */
    public String codingModeAsString() {
        return codingMode;
    }

    /**
     * Sample rate in Hz.
     * 
     * @return Sample rate in Hz.
     */
    public Double sampleRate() {
        return sampleRate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(bitrate());
        hashCode = 31 * hashCode + Objects.hashCode(codingModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(sampleRate());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Mp2Settings)) {
            return false;
        }
        Mp2Settings other = (Mp2Settings) obj;
        return Objects.equals(bitrate(), other.bitrate()) && Objects.equals(codingModeAsString(), other.codingModeAsString())
                && Objects.equals(sampleRate(), other.sampleRate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("Mp2Settings").add("Bitrate", bitrate()).add("CodingMode", codingModeAsString())
                .add("SampleRate", sampleRate()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Bitrate":
            return Optional.ofNullable(clazz.cast(bitrate()));
        case "CodingMode":
            return Optional.ofNullable(clazz.cast(codingModeAsString()));
        case "SampleRate":
            return Optional.ofNullable(clazz.cast(sampleRate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Mp2Settings, T> g) {
        return obj -> g.apply((Mp2Settings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Mp2Settings> {
        /**
         * Average bitrate in bits/second.
         * 
         * @param bitrate
         *        Average bitrate in bits/second.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bitrate(Double bitrate);

        /**
         * The MPEG2 Audio coding mode. Valid values are codingMode10 (for mono) or codingMode20 (for stereo).
         * 
         * @param codingMode
         *        The MPEG2 Audio coding mode. Valid values are codingMode10 (for mono) or codingMode20 (for stereo).
         * @see Mp2CodingMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Mp2CodingMode
         */
        Builder codingMode(String codingMode);

        /**
         * The MPEG2 Audio coding mode. Valid values are codingMode10 (for mono) or codingMode20 (for stereo).
         * 
         * @param codingMode
         *        The MPEG2 Audio coding mode. Valid values are codingMode10 (for mono) or codingMode20 (for stereo).
         * @see Mp2CodingMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Mp2CodingMode
         */
        Builder codingMode(Mp2CodingMode codingMode);

        /**
         * Sample rate in Hz.
         * 
         * @param sampleRate
         *        Sample rate in Hz.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sampleRate(Double sampleRate);
    }

    static final class BuilderImpl implements Builder {
        private Double bitrate;

        private String codingMode;

        private Double sampleRate;

        private BuilderImpl() {
        }

        private BuilderImpl(Mp2Settings model) {
            bitrate(model.bitrate);
            codingMode(model.codingMode);
            sampleRate(model.sampleRate);
        }

        public final Double getBitrate() {
            return bitrate;
        }

        @Override
        public final Builder bitrate(Double bitrate) {
            this.bitrate = bitrate;
            return this;
        }

        public final void setBitrate(Double bitrate) {
            this.bitrate = bitrate;
        }

        public final String getCodingModeAsString() {
            return codingMode;
        }

        @Override
        public final Builder codingMode(String codingMode) {
            this.codingMode = codingMode;
            return this;
        }

        @Override
        public final Builder codingMode(Mp2CodingMode codingMode) {
            this.codingMode(codingMode == null ? null : codingMode.toString());
            return this;
        }

        public final void setCodingMode(String codingMode) {
            this.codingMode = codingMode;
        }

        public final Double getSampleRate() {
            return sampleRate;
        }

        @Override
        public final Builder sampleRate(Double sampleRate) {
            this.sampleRate = sampleRate;
            return this;
        }

        public final void setSampleRate(Double sampleRate) {
            this.sampleRate = sampleRate;
        }

        @Override
        public Mp2Settings build() {
            return new Mp2Settings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
