/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * The settings for a PUSH type input.
 */
@Generated("software.amazon.awssdk:codegen")
public final class InputDestination implements SdkPojo, Serializable,
        ToCopyableBuilder<InputDestination.Builder, InputDestination> {
    private static final SdkField<String> IP_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(InputDestination::ip)).setter(setter(Builder::ip))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ip").build()).build();

    private static final SdkField<String> PORT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(InputDestination::port)).setter(setter(Builder::port))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("port").build()).build();

    private static final SdkField<String> URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(InputDestination::url)).setter(setter(Builder::url))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("url").build()).build();

    private static final SdkField<InputDestinationVpc> VPC_FIELD = SdkField
            .<InputDestinationVpc> builder(MarshallingType.SDK_POJO).getter(getter(InputDestination::vpc))
            .setter(setter(Builder::vpc)).constructor(InputDestinationVpc::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vpc").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IP_FIELD, PORT_FIELD,
            URL_FIELD, VPC_FIELD));

    private static final long serialVersionUID = 1L;

    private final String ip;

    private final String port;

    private final String url;

    private final InputDestinationVpc vpc;

    private InputDestination(BuilderImpl builder) {
        this.ip = builder.ip;
        this.port = builder.port;
        this.url = builder.url;
        this.vpc = builder.vpc;
    }

    /**
     * The system-generated static IP address of endpoint. It remains fixed for the lifetime of the input.
     *
     * @return The system-generated static IP address of endpoint. It remains fixed for the lifetime of the input.
     */
    public String ip() {
        return ip;
    }

    /**
     * The port number for the input.
     * 
     * @return The port number for the input.
     */
    public String port() {
        return port;
    }

    /**
     * This represents the endpoint that the customer stream will be pushed to.
     *
     * @return This represents the endpoint that the customer stream will be pushed to.
     */
    public String url() {
        return url;
    }

    /**
     * Returns the value of the Vpc property for this object.
     * 
     * @return The value of the Vpc property for this object.
     */
    public InputDestinationVpc vpc() {
        return vpc;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(ip());
        hashCode = 31 * hashCode + Objects.hashCode(port());
        hashCode = 31 * hashCode + Objects.hashCode(url());
        hashCode = 31 * hashCode + Objects.hashCode(vpc());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InputDestination)) {
            return false;
        }
        InputDestination other = (InputDestination) obj;
        return Objects.equals(ip(), other.ip()) && Objects.equals(port(), other.port()) && Objects.equals(url(), other.url())
                && Objects.equals(vpc(), other.vpc());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("InputDestination").add("Ip", ip()).add("Port", port()).add("Url", url()).add("Vpc", vpc())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Ip":
            return Optional.ofNullable(clazz.cast(ip()));
        case "Port":
            return Optional.ofNullable(clazz.cast(port()));
        case "Url":
            return Optional.ofNullable(clazz.cast(url()));
        case "Vpc":
            return Optional.ofNullable(clazz.cast(vpc()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InputDestination, T> g) {
        return obj -> g.apply((InputDestination) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InputDestination> {
        /**
         * The system-generated static IP address of endpoint. It remains fixed for the lifetime of the input.
         *
         * @param ip
         *        The system-generated static IP address of endpoint. It remains fixed for the lifetime of the input.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ip(String ip);

        /**
         * The port number for the input.
         * 
         * @param port
         *        The port number for the input.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder port(String port);

        /**
         * This represents the endpoint that the customer stream will be pushed to.
         *
         * @param url
         *        This represents the endpoint that the customer stream will be pushed to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder url(String url);

        /**
         * Sets the value of the Vpc property for this object.
         *
         * @param vpc
         *        The new value for the Vpc property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpc(InputDestinationVpc vpc);

        /**
         * Sets the value of the Vpc property for this object.
         *
         * This is a convenience that creates an instance of the {@link InputDestinationVpc.Builder} avoiding the need
         * to create one manually via {@link InputDestinationVpc#builder()}.
         *
         * When the {@link Consumer} completes, {@link InputDestinationVpc.Builder#build()} is called immediately and
         * its result is passed to {@link #vpc(InputDestinationVpc)}.
         * 
         * @param vpc
         *        a consumer that will call methods on {@link InputDestinationVpc.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vpc(InputDestinationVpc)
         */
        default Builder vpc(Consumer<InputDestinationVpc.Builder> vpc) {
            return vpc(InputDestinationVpc.builder().applyMutation(vpc).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String ip;

        private String port;

        private String url;

        private InputDestinationVpc vpc;

        private BuilderImpl() {
        }

        private BuilderImpl(InputDestination model) {
            ip(model.ip);
            port(model.port);
            url(model.url);
            vpc(model.vpc);
        }

        public final String getIp() {
            return ip;
        }

        @Override
        public final Builder ip(String ip) {
            this.ip = ip;
            return this;
        }

        public final void setIp(String ip) {
            this.ip = ip;
        }

        public final String getPort() {
            return port;
        }

        @Override
        public final Builder port(String port) {
            this.port = port;
            return this;
        }

        public final void setPort(String port) {
            this.port = port;
        }

        public final String getUrl() {
            return url;
        }

        @Override
        public final Builder url(String url) {
            this.url = url;
            return this;
        }

        public final void setUrl(String url) {
            this.url = url;
        }

        public final InputDestinationVpc.Builder getVpc() {
            return vpc != null ? vpc.toBuilder() : null;
        }

        @Override
        public final Builder vpc(InputDestinationVpc vpc) {
            this.vpc = vpc;
            return this;
        }

        public final void setVpc(InputDestinationVpc.BuilderImpl vpc) {
            this.vpc = vpc != null ? vpc.build() : null;
        }

        @Override
        public InputDestination build() {
            return new InputDestination(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
