/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Hls Media Store Settings
 */
@Generated("software.amazon.awssdk:codegen")
public final class HlsMediaStoreSettings implements SdkPojo, Serializable,
        ToCopyableBuilder<HlsMediaStoreSettings.Builder, HlsMediaStoreSettings> {
    private static final SdkField<Integer> CONNECTION_RETRY_INTERVAL_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(HlsMediaStoreSettings::connectionRetryInterval)).setter(setter(Builder::connectionRetryInterval))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectionRetryInterval").build())
            .build();

    private static final SdkField<Integer> FILECACHE_DURATION_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(HlsMediaStoreSettings::filecacheDuration)).setter(setter(Builder::filecacheDuration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filecacheDuration").build()).build();

    private static final SdkField<String> MEDIA_STORE_STORAGE_CLASS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(HlsMediaStoreSettings::mediaStoreStorageClassAsString))
            .setter(setter(Builder::mediaStoreStorageClass))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mediaStoreStorageClass").build())
            .build();

    private static final SdkField<Integer> NUM_RETRIES_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(HlsMediaStoreSettings::numRetries)).setter(setter(Builder::numRetries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("numRetries").build()).build();

    private static final SdkField<Integer> RESTART_DELAY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(HlsMediaStoreSettings::restartDelay)).setter(setter(Builder::restartDelay))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("restartDelay").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            CONNECTION_RETRY_INTERVAL_FIELD, FILECACHE_DURATION_FIELD, MEDIA_STORE_STORAGE_CLASS_FIELD, NUM_RETRIES_FIELD,
            RESTART_DELAY_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer connectionRetryInterval;

    private final Integer filecacheDuration;

    private final String mediaStoreStorageClass;

    private final Integer numRetries;

    private final Integer restartDelay;

    private HlsMediaStoreSettings(BuilderImpl builder) {
        this.connectionRetryInterval = builder.connectionRetryInterval;
        this.filecacheDuration = builder.filecacheDuration;
        this.mediaStoreStorageClass = builder.mediaStoreStorageClass;
        this.numRetries = builder.numRetries;
        this.restartDelay = builder.restartDelay;
    }

    /**
     * Number of seconds to wait before retrying connection to the CDN if the connection is lost.
     * 
     * @return Number of seconds to wait before retrying connection to the CDN if the connection is lost.
     */
    public Integer connectionRetryInterval() {
        return connectionRetryInterval;
    }

    /**
     * Size in seconds of file cache for streaming outputs.
     * 
     * @return Size in seconds of file cache for streaming outputs.
     */
    public Integer filecacheDuration() {
        return filecacheDuration;
    }

    /**
     * When set to temporal, output files are stored in non-persistent memory for faster reading and writing.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #mediaStoreStorageClass} will return {@link HlsMediaStoreStorageClass#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #mediaStoreStorageClassAsString}.
     * </p>
     * 
     * @return When set to temporal, output files are stored in non-persistent memory for faster reading and writing.
     * @see HlsMediaStoreStorageClass
     */
    public HlsMediaStoreStorageClass mediaStoreStorageClass() {
        return HlsMediaStoreStorageClass.fromValue(mediaStoreStorageClass);
    }

    /**
     * When set to temporal, output files are stored in non-persistent memory for faster reading and writing.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #mediaStoreStorageClass} will return {@link HlsMediaStoreStorageClass#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #mediaStoreStorageClassAsString}.
     * </p>
     * 
     * @return When set to temporal, output files are stored in non-persistent memory for faster reading and writing.
     * @see HlsMediaStoreStorageClass
     */
    public String mediaStoreStorageClassAsString() {
        return mediaStoreStorageClass;
    }

    /**
     * Number of retry attempts that will be made before the Live Event is put into an error state.
     * 
     * @return Number of retry attempts that will be made before the Live Event is put into an error state.
     */
    public Integer numRetries() {
        return numRetries;
    }

    /**
     * If a streaming output fails, number of seconds to wait until a restart is initiated. A value of 0 means never
     * restart.
     * 
     * @return If a streaming output fails, number of seconds to wait until a restart is initiated. A value of 0 means
     *         never restart.
     */
    public Integer restartDelay() {
        return restartDelay;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(connectionRetryInterval());
        hashCode = 31 * hashCode + Objects.hashCode(filecacheDuration());
        hashCode = 31 * hashCode + Objects.hashCode(mediaStoreStorageClassAsString());
        hashCode = 31 * hashCode + Objects.hashCode(numRetries());
        hashCode = 31 * hashCode + Objects.hashCode(restartDelay());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HlsMediaStoreSettings)) {
            return false;
        }
        HlsMediaStoreSettings other = (HlsMediaStoreSettings) obj;
        return Objects.equals(connectionRetryInterval(), other.connectionRetryInterval())
                && Objects.equals(filecacheDuration(), other.filecacheDuration())
                && Objects.equals(mediaStoreStorageClassAsString(), other.mediaStoreStorageClassAsString())
                && Objects.equals(numRetries(), other.numRetries()) && Objects.equals(restartDelay(), other.restartDelay());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("HlsMediaStoreSettings").add("ConnectionRetryInterval", connectionRetryInterval())
                .add("FilecacheDuration", filecacheDuration()).add("MediaStoreStorageClass", mediaStoreStorageClassAsString())
                .add("NumRetries", numRetries()).add("RestartDelay", restartDelay()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ConnectionRetryInterval":
            return Optional.ofNullable(clazz.cast(connectionRetryInterval()));
        case "FilecacheDuration":
            return Optional.ofNullable(clazz.cast(filecacheDuration()));
        case "MediaStoreStorageClass":
            return Optional.ofNullable(clazz.cast(mediaStoreStorageClassAsString()));
        case "NumRetries":
            return Optional.ofNullable(clazz.cast(numRetries()));
        case "RestartDelay":
            return Optional.ofNullable(clazz.cast(restartDelay()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<HlsMediaStoreSettings, T> g) {
        return obj -> g.apply((HlsMediaStoreSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, HlsMediaStoreSettings> {
        /**
         * Number of seconds to wait before retrying connection to the CDN if the connection is lost.
         * 
         * @param connectionRetryInterval
         *        Number of seconds to wait before retrying connection to the CDN if the connection is lost.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectionRetryInterval(Integer connectionRetryInterval);

        /**
         * Size in seconds of file cache for streaming outputs.
         * 
         * @param filecacheDuration
         *        Size in seconds of file cache for streaming outputs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filecacheDuration(Integer filecacheDuration);

        /**
         * When set to temporal, output files are stored in non-persistent memory for faster reading and writing.
         * 
         * @param mediaStoreStorageClass
         *        When set to temporal, output files are stored in non-persistent memory for faster reading and writing.
         * @see HlsMediaStoreStorageClass
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HlsMediaStoreStorageClass
         */
        Builder mediaStoreStorageClass(String mediaStoreStorageClass);

        /**
         * When set to temporal, output files are stored in non-persistent memory for faster reading and writing.
         * 
         * @param mediaStoreStorageClass
         *        When set to temporal, output files are stored in non-persistent memory for faster reading and writing.
         * @see HlsMediaStoreStorageClass
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HlsMediaStoreStorageClass
         */
        Builder mediaStoreStorageClass(HlsMediaStoreStorageClass mediaStoreStorageClass);

        /**
         * Number of retry attempts that will be made before the Live Event is put into an error state.
         * 
         * @param numRetries
         *        Number of retry attempts that will be made before the Live Event is put into an error state.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numRetries(Integer numRetries);

        /**
         * If a streaming output fails, number of seconds to wait until a restart is initiated. A value of 0 means never
         * restart.
         * 
         * @param restartDelay
         *        If a streaming output fails, number of seconds to wait until a restart is initiated. A value of 0
         *        means never restart.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder restartDelay(Integer restartDelay);
    }

    static final class BuilderImpl implements Builder {
        private Integer connectionRetryInterval;

        private Integer filecacheDuration;

        private String mediaStoreStorageClass;

        private Integer numRetries;

        private Integer restartDelay;

        private BuilderImpl() {
        }

        private BuilderImpl(HlsMediaStoreSettings model) {
            connectionRetryInterval(model.connectionRetryInterval);
            filecacheDuration(model.filecacheDuration);
            mediaStoreStorageClass(model.mediaStoreStorageClass);
            numRetries(model.numRetries);
            restartDelay(model.restartDelay);
        }

        public final Integer getConnectionRetryInterval() {
            return connectionRetryInterval;
        }

        @Override
        public final Builder connectionRetryInterval(Integer connectionRetryInterval) {
            this.connectionRetryInterval = connectionRetryInterval;
            return this;
        }

        public final void setConnectionRetryInterval(Integer connectionRetryInterval) {
            this.connectionRetryInterval = connectionRetryInterval;
        }

        public final Integer getFilecacheDuration() {
            return filecacheDuration;
        }

        @Override
        public final Builder filecacheDuration(Integer filecacheDuration) {
            this.filecacheDuration = filecacheDuration;
            return this;
        }

        public final void setFilecacheDuration(Integer filecacheDuration) {
            this.filecacheDuration = filecacheDuration;
        }

        public final String getMediaStoreStorageClassAsString() {
            return mediaStoreStorageClass;
        }

        @Override
        public final Builder mediaStoreStorageClass(String mediaStoreStorageClass) {
            this.mediaStoreStorageClass = mediaStoreStorageClass;
            return this;
        }

        @Override
        public final Builder mediaStoreStorageClass(HlsMediaStoreStorageClass mediaStoreStorageClass) {
            this.mediaStoreStorageClass(mediaStoreStorageClass == null ? null : mediaStoreStorageClass.toString());
            return this;
        }

        public final void setMediaStoreStorageClass(String mediaStoreStorageClass) {
            this.mediaStoreStorageClass = mediaStoreStorageClass;
        }

        public final Integer getNumRetries() {
            return numRetries;
        }

        @Override
        public final Builder numRetries(Integer numRetries) {
            this.numRetries = numRetries;
            return this;
        }

        public final void setNumRetries(Integer numRetries) {
            this.numRetries = numRetries;
        }

        public final Integer getRestartDelay() {
            return restartDelay;
        }

        @Override
        public final Builder restartDelay(Integer restartDelay) {
            this.restartDelay = restartDelay;
            return this;
        }

        public final void setRestartDelay(Integer restartDelay) {
            this.restartDelay = restartDelay;
        }

        @Override
        public HlsMediaStoreSettings build() {
            return new HlsMediaStoreSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
