/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Hls Cdn Settings
 */
@Generated("software.amazon.awssdk:codegen")
public final class HlsCdnSettings implements SdkPojo, Serializable, ToCopyableBuilder<HlsCdnSettings.Builder, HlsCdnSettings> {
    private static final SdkField<HlsAkamaiSettings> HLS_AKAMAI_SETTINGS_FIELD = SdkField
            .<HlsAkamaiSettings> builder(MarshallingType.SDK_POJO).getter(getter(HlsCdnSettings::hlsAkamaiSettings))
            .setter(setter(Builder::hlsAkamaiSettings)).constructor(HlsAkamaiSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hlsAkamaiSettings").build()).build();

    private static final SdkField<HlsBasicPutSettings> HLS_BASIC_PUT_SETTINGS_FIELD = SdkField
            .<HlsBasicPutSettings> builder(MarshallingType.SDK_POJO).getter(getter(HlsCdnSettings::hlsBasicPutSettings))
            .setter(setter(Builder::hlsBasicPutSettings)).constructor(HlsBasicPutSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hlsBasicPutSettings").build())
            .build();

    private static final SdkField<HlsMediaStoreSettings> HLS_MEDIA_STORE_SETTINGS_FIELD = SdkField
            .<HlsMediaStoreSettings> builder(MarshallingType.SDK_POJO).getter(getter(HlsCdnSettings::hlsMediaStoreSettings))
            .setter(setter(Builder::hlsMediaStoreSettings)).constructor(HlsMediaStoreSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hlsMediaStoreSettings").build())
            .build();

    private static final SdkField<HlsWebdavSettings> HLS_WEBDAV_SETTINGS_FIELD = SdkField
            .<HlsWebdavSettings> builder(MarshallingType.SDK_POJO).getter(getter(HlsCdnSettings::hlsWebdavSettings))
            .setter(setter(Builder::hlsWebdavSettings)).constructor(HlsWebdavSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hlsWebdavSettings").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HLS_AKAMAI_SETTINGS_FIELD,
            HLS_BASIC_PUT_SETTINGS_FIELD, HLS_MEDIA_STORE_SETTINGS_FIELD, HLS_WEBDAV_SETTINGS_FIELD));

    private static final long serialVersionUID = 1L;

    private final HlsAkamaiSettings hlsAkamaiSettings;

    private final HlsBasicPutSettings hlsBasicPutSettings;

    private final HlsMediaStoreSettings hlsMediaStoreSettings;

    private final HlsWebdavSettings hlsWebdavSettings;

    private HlsCdnSettings(BuilderImpl builder) {
        this.hlsAkamaiSettings = builder.hlsAkamaiSettings;
        this.hlsBasicPutSettings = builder.hlsBasicPutSettings;
        this.hlsMediaStoreSettings = builder.hlsMediaStoreSettings;
        this.hlsWebdavSettings = builder.hlsWebdavSettings;
    }

    /**
     * Returns the value of the HlsAkamaiSettings property for this object.
     * 
     * @return The value of the HlsAkamaiSettings property for this object.
     */
    public HlsAkamaiSettings hlsAkamaiSettings() {
        return hlsAkamaiSettings;
    }

    /**
     * Returns the value of the HlsBasicPutSettings property for this object.
     * 
     * @return The value of the HlsBasicPutSettings property for this object.
     */
    public HlsBasicPutSettings hlsBasicPutSettings() {
        return hlsBasicPutSettings;
    }

    /**
     * Returns the value of the HlsMediaStoreSettings property for this object.
     * 
     * @return The value of the HlsMediaStoreSettings property for this object.
     */
    public HlsMediaStoreSettings hlsMediaStoreSettings() {
        return hlsMediaStoreSettings;
    }

    /**
     * Returns the value of the HlsWebdavSettings property for this object.
     * 
     * @return The value of the HlsWebdavSettings property for this object.
     */
    public HlsWebdavSettings hlsWebdavSettings() {
        return hlsWebdavSettings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hlsAkamaiSettings());
        hashCode = 31 * hashCode + Objects.hashCode(hlsBasicPutSettings());
        hashCode = 31 * hashCode + Objects.hashCode(hlsMediaStoreSettings());
        hashCode = 31 * hashCode + Objects.hashCode(hlsWebdavSettings());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HlsCdnSettings)) {
            return false;
        }
        HlsCdnSettings other = (HlsCdnSettings) obj;
        return Objects.equals(hlsAkamaiSettings(), other.hlsAkamaiSettings())
                && Objects.equals(hlsBasicPutSettings(), other.hlsBasicPutSettings())
                && Objects.equals(hlsMediaStoreSettings(), other.hlsMediaStoreSettings())
                && Objects.equals(hlsWebdavSettings(), other.hlsWebdavSettings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("HlsCdnSettings").add("HlsAkamaiSettings", hlsAkamaiSettings())
                .add("HlsBasicPutSettings", hlsBasicPutSettings()).add("HlsMediaStoreSettings", hlsMediaStoreSettings())
                .add("HlsWebdavSettings", hlsWebdavSettings()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "HlsAkamaiSettings":
            return Optional.ofNullable(clazz.cast(hlsAkamaiSettings()));
        case "HlsBasicPutSettings":
            return Optional.ofNullable(clazz.cast(hlsBasicPutSettings()));
        case "HlsMediaStoreSettings":
            return Optional.ofNullable(clazz.cast(hlsMediaStoreSettings()));
        case "HlsWebdavSettings":
            return Optional.ofNullable(clazz.cast(hlsWebdavSettings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<HlsCdnSettings, T> g) {
        return obj -> g.apply((HlsCdnSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, HlsCdnSettings> {
        /**
         * Sets the value of the HlsAkamaiSettings property for this object.
         *
         * @param hlsAkamaiSettings
         *        The new value for the HlsAkamaiSettings property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hlsAkamaiSettings(HlsAkamaiSettings hlsAkamaiSettings);

        /**
         * Sets the value of the HlsAkamaiSettings property for this object.
         *
         * This is a convenience that creates an instance of the {@link HlsAkamaiSettings.Builder} avoiding the need to
         * create one manually via {@link HlsAkamaiSettings#builder()}.
         *
         * When the {@link Consumer} completes, {@link HlsAkamaiSettings.Builder#build()} is called immediately and its
         * result is passed to {@link #hlsAkamaiSettings(HlsAkamaiSettings)}.
         * 
         * @param hlsAkamaiSettings
         *        a consumer that will call methods on {@link HlsAkamaiSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #hlsAkamaiSettings(HlsAkamaiSettings)
         */
        default Builder hlsAkamaiSettings(Consumer<HlsAkamaiSettings.Builder> hlsAkamaiSettings) {
            return hlsAkamaiSettings(HlsAkamaiSettings.builder().applyMutation(hlsAkamaiSettings).build());
        }

        /**
         * Sets the value of the HlsBasicPutSettings property for this object.
         *
         * @param hlsBasicPutSettings
         *        The new value for the HlsBasicPutSettings property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hlsBasicPutSettings(HlsBasicPutSettings hlsBasicPutSettings);

        /**
         * Sets the value of the HlsBasicPutSettings property for this object.
         *
         * This is a convenience that creates an instance of the {@link HlsBasicPutSettings.Builder} avoiding the need
         * to create one manually via {@link HlsBasicPutSettings#builder()}.
         *
         * When the {@link Consumer} completes, {@link HlsBasicPutSettings.Builder#build()} is called immediately and
         * its result is passed to {@link #hlsBasicPutSettings(HlsBasicPutSettings)}.
         * 
         * @param hlsBasicPutSettings
         *        a consumer that will call methods on {@link HlsBasicPutSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #hlsBasicPutSettings(HlsBasicPutSettings)
         */
        default Builder hlsBasicPutSettings(Consumer<HlsBasicPutSettings.Builder> hlsBasicPutSettings) {
            return hlsBasicPutSettings(HlsBasicPutSettings.builder().applyMutation(hlsBasicPutSettings).build());
        }

        /**
         * Sets the value of the HlsMediaStoreSettings property for this object.
         *
         * @param hlsMediaStoreSettings
         *        The new value for the HlsMediaStoreSettings property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hlsMediaStoreSettings(HlsMediaStoreSettings hlsMediaStoreSettings);

        /**
         * Sets the value of the HlsMediaStoreSettings property for this object.
         *
         * This is a convenience that creates an instance of the {@link HlsMediaStoreSettings.Builder} avoiding the need
         * to create one manually via {@link HlsMediaStoreSettings#builder()}.
         *
         * When the {@link Consumer} completes, {@link HlsMediaStoreSettings.Builder#build()} is called immediately and
         * its result is passed to {@link #hlsMediaStoreSettings(HlsMediaStoreSettings)}.
         * 
         * @param hlsMediaStoreSettings
         *        a consumer that will call methods on {@link HlsMediaStoreSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #hlsMediaStoreSettings(HlsMediaStoreSettings)
         */
        default Builder hlsMediaStoreSettings(Consumer<HlsMediaStoreSettings.Builder> hlsMediaStoreSettings) {
            return hlsMediaStoreSettings(HlsMediaStoreSettings.builder().applyMutation(hlsMediaStoreSettings).build());
        }

        /**
         * Sets the value of the HlsWebdavSettings property for this object.
         *
         * @param hlsWebdavSettings
         *        The new value for the HlsWebdavSettings property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hlsWebdavSettings(HlsWebdavSettings hlsWebdavSettings);

        /**
         * Sets the value of the HlsWebdavSettings property for this object.
         *
         * This is a convenience that creates an instance of the {@link HlsWebdavSettings.Builder} avoiding the need to
         * create one manually via {@link HlsWebdavSettings#builder()}.
         *
         * When the {@link Consumer} completes, {@link HlsWebdavSettings.Builder#build()} is called immediately and its
         * result is passed to {@link #hlsWebdavSettings(HlsWebdavSettings)}.
         * 
         * @param hlsWebdavSettings
         *        a consumer that will call methods on {@link HlsWebdavSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #hlsWebdavSettings(HlsWebdavSettings)
         */
        default Builder hlsWebdavSettings(Consumer<HlsWebdavSettings.Builder> hlsWebdavSettings) {
            return hlsWebdavSettings(HlsWebdavSettings.builder().applyMutation(hlsWebdavSettings).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private HlsAkamaiSettings hlsAkamaiSettings;

        private HlsBasicPutSettings hlsBasicPutSettings;

        private HlsMediaStoreSettings hlsMediaStoreSettings;

        private HlsWebdavSettings hlsWebdavSettings;

        private BuilderImpl() {
        }

        private BuilderImpl(HlsCdnSettings model) {
            hlsAkamaiSettings(model.hlsAkamaiSettings);
            hlsBasicPutSettings(model.hlsBasicPutSettings);
            hlsMediaStoreSettings(model.hlsMediaStoreSettings);
            hlsWebdavSettings(model.hlsWebdavSettings);
        }

        public final HlsAkamaiSettings.Builder getHlsAkamaiSettings() {
            return hlsAkamaiSettings != null ? hlsAkamaiSettings.toBuilder() : null;
        }

        @Override
        public final Builder hlsAkamaiSettings(HlsAkamaiSettings hlsAkamaiSettings) {
            this.hlsAkamaiSettings = hlsAkamaiSettings;
            return this;
        }

        public final void setHlsAkamaiSettings(HlsAkamaiSettings.BuilderImpl hlsAkamaiSettings) {
            this.hlsAkamaiSettings = hlsAkamaiSettings != null ? hlsAkamaiSettings.build() : null;
        }

        public final HlsBasicPutSettings.Builder getHlsBasicPutSettings() {
            return hlsBasicPutSettings != null ? hlsBasicPutSettings.toBuilder() : null;
        }

        @Override
        public final Builder hlsBasicPutSettings(HlsBasicPutSettings hlsBasicPutSettings) {
            this.hlsBasicPutSettings = hlsBasicPutSettings;
            return this;
        }

        public final void setHlsBasicPutSettings(HlsBasicPutSettings.BuilderImpl hlsBasicPutSettings) {
            this.hlsBasicPutSettings = hlsBasicPutSettings != null ? hlsBasicPutSettings.build() : null;
        }

        public final HlsMediaStoreSettings.Builder getHlsMediaStoreSettings() {
            return hlsMediaStoreSettings != null ? hlsMediaStoreSettings.toBuilder() : null;
        }

        @Override
        public final Builder hlsMediaStoreSettings(HlsMediaStoreSettings hlsMediaStoreSettings) {
            this.hlsMediaStoreSettings = hlsMediaStoreSettings;
            return this;
        }

        public final void setHlsMediaStoreSettings(HlsMediaStoreSettings.BuilderImpl hlsMediaStoreSettings) {
            this.hlsMediaStoreSettings = hlsMediaStoreSettings != null ? hlsMediaStoreSettings.build() : null;
        }

        public final HlsWebdavSettings.Builder getHlsWebdavSettings() {
            return hlsWebdavSettings != null ? hlsWebdavSettings.toBuilder() : null;
        }

        @Override
        public final Builder hlsWebdavSettings(HlsWebdavSettings hlsWebdavSettings) {
            this.hlsWebdavSettings = hlsWebdavSettings;
            return this;
        }

        public final void setHlsWebdavSettings(HlsWebdavSettings.BuilderImpl hlsWebdavSettings) {
            this.hlsWebdavSettings = hlsWebdavSettings != null ? hlsWebdavSettings.build() : null;
        }

        @Override
        public HlsCdnSettings build() {
            return new HlsCdnSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
