/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Global Configuration
 */
@Generated("software.amazon.awssdk:codegen")
public final class GlobalConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<GlobalConfiguration.Builder, GlobalConfiguration> {
    private static final SdkField<Integer> INITIAL_AUDIO_GAIN_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(GlobalConfiguration::initialAudioGain)).setter(setter(Builder::initialAudioGain))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("initialAudioGain").build()).build();

    private static final SdkField<String> INPUT_END_ACTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GlobalConfiguration::inputEndActionAsString)).setter(setter(Builder::inputEndAction))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputEndAction").build()).build();

    private static final SdkField<InputLossBehavior> INPUT_LOSS_BEHAVIOR_FIELD = SdkField
            .<InputLossBehavior> builder(MarshallingType.SDK_POJO).getter(getter(GlobalConfiguration::inputLossBehavior))
            .setter(setter(Builder::inputLossBehavior)).constructor(InputLossBehavior::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputLossBehavior").build()).build();

    private static final SdkField<String> OUTPUT_LOCKING_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GlobalConfiguration::outputLockingModeAsString)).setter(setter(Builder::outputLockingMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputLockingMode").build()).build();

    private static final SdkField<String> OUTPUT_TIMING_SOURCE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GlobalConfiguration::outputTimingSourceAsString)).setter(setter(Builder::outputTimingSource))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputTimingSource").build())
            .build();

    private static final SdkField<String> SUPPORT_LOW_FRAMERATE_INPUTS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GlobalConfiguration::supportLowFramerateInputsAsString))
            .setter(setter(Builder::supportLowFramerateInputs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("supportLowFramerateInputs").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INITIAL_AUDIO_GAIN_FIELD,
            INPUT_END_ACTION_FIELD, INPUT_LOSS_BEHAVIOR_FIELD, OUTPUT_LOCKING_MODE_FIELD, OUTPUT_TIMING_SOURCE_FIELD,
            SUPPORT_LOW_FRAMERATE_INPUTS_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer initialAudioGain;

    private final String inputEndAction;

    private final InputLossBehavior inputLossBehavior;

    private final String outputLockingMode;

    private final String outputTimingSource;

    private final String supportLowFramerateInputs;

    private GlobalConfiguration(BuilderImpl builder) {
        this.initialAudioGain = builder.initialAudioGain;
        this.inputEndAction = builder.inputEndAction;
        this.inputLossBehavior = builder.inputLossBehavior;
        this.outputLockingMode = builder.outputLockingMode;
        this.outputTimingSource = builder.outputTimingSource;
        this.supportLowFramerateInputs = builder.supportLowFramerateInputs;
    }

    /**
     * Value to set the initial audio gain for the Live Event.
     * 
     * @return Value to set the initial audio gain for the Live Event.
     */
    public Integer initialAudioGain() {
        return initialAudioGain;
    }

    /**
     * Indicates the action to take when the current input completes (e.g. end-of-file). When switchAndLoopInputs is
     * configured the encoder will restart at the beginning of the first input. When "none" is configured the encoder
     * will transcode either black, a solid color, or a user specified slate images per the "Input Loss Behavior"
     * configuration until the next input switch occurs (which is controlled through the Channel Schedule API).
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #inputEndAction}
     * will return {@link GlobalConfigurationInputEndAction#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #inputEndActionAsString}.
     * </p>
     * 
     * @return Indicates the action to take when the current input completes (e.g. end-of-file). When
     *         switchAndLoopInputs is configured the encoder will restart at the beginning of the first input. When
     *         "none" is configured the encoder will transcode either black, a solid color, or a user specified slate
     *         images per the "Input Loss Behavior" configuration until the next input switch occurs (which is
     *         controlled through the Channel Schedule API).
     * @see GlobalConfigurationInputEndAction
     */
    public GlobalConfigurationInputEndAction inputEndAction() {
        return GlobalConfigurationInputEndAction.fromValue(inputEndAction);
    }

    /**
     * Indicates the action to take when the current input completes (e.g. end-of-file). When switchAndLoopInputs is
     * configured the encoder will restart at the beginning of the first input. When "none" is configured the encoder
     * will transcode either black, a solid color, or a user specified slate images per the "Input Loss Behavior"
     * configuration until the next input switch occurs (which is controlled through the Channel Schedule API).
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #inputEndAction}
     * will return {@link GlobalConfigurationInputEndAction#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #inputEndActionAsString}.
     * </p>
     * 
     * @return Indicates the action to take when the current input completes (e.g. end-of-file). When
     *         switchAndLoopInputs is configured the encoder will restart at the beginning of the first input. When
     *         "none" is configured the encoder will transcode either black, a solid color, or a user specified slate
     *         images per the "Input Loss Behavior" configuration until the next input switch occurs (which is
     *         controlled through the Channel Schedule API).
     * @see GlobalConfigurationInputEndAction
     */
    public String inputEndActionAsString() {
        return inputEndAction;
    }

    /**
     * Settings for system actions when input is lost.
     * 
     * @return Settings for system actions when input is lost.
     */
    public InputLossBehavior inputLossBehavior() {
        return inputLossBehavior;
    }

    /**
     * Indicates how MediaLive pipelines are synchronized.
     *
     * PIPELINELOCKING - MediaLive will attempt to synchronize the output of each pipeline to the other. EPOCHLOCKING -
     * MediaLive will attempt to synchronize the output of each pipeline to the Unix epoch.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #outputLockingMode}
     * will return {@link GlobalConfigurationOutputLockingMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #outputLockingModeAsString}.
     * </p>
     * 
     * @return Indicates how MediaLive pipelines are synchronized.
     *
     *         PIPELINELOCKING - MediaLive will attempt to synchronize the output of each pipeline to the other.
     *         EPOCHLOCKING - MediaLive will attempt to synchronize the output of each pipeline to the Unix epoch.
     * @see GlobalConfigurationOutputLockingMode
     */
    public GlobalConfigurationOutputLockingMode outputLockingMode() {
        return GlobalConfigurationOutputLockingMode.fromValue(outputLockingMode);
    }

    /**
     * Indicates how MediaLive pipelines are synchronized.
     *
     * PIPELINELOCKING - MediaLive will attempt to synchronize the output of each pipeline to the other. EPOCHLOCKING -
     * MediaLive will attempt to synchronize the output of each pipeline to the Unix epoch.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #outputLockingMode}
     * will return {@link GlobalConfigurationOutputLockingMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #outputLockingModeAsString}.
     * </p>
     * 
     * @return Indicates how MediaLive pipelines are synchronized.
     *
     *         PIPELINELOCKING - MediaLive will attempt to synchronize the output of each pipeline to the other.
     *         EPOCHLOCKING - MediaLive will attempt to synchronize the output of each pipeline to the Unix epoch.
     * @see GlobalConfigurationOutputLockingMode
     */
    public String outputLockingModeAsString() {
        return outputLockingMode;
    }

    /**
     * Indicates whether the rate of frames emitted by the Live encoder should be paced by its system clock (which
     * optionally may be locked to another source via NTP) or should be locked to the clock of the source that is
     * providing the input stream.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #outputTimingSource} will return {@link GlobalConfigurationOutputTimingSource#UNKNOWN_TO_SDK_VERSION}. The
     * raw value returned by the service is available from {@link #outputTimingSourceAsString}.
     * </p>
     * 
     * @return Indicates whether the rate of frames emitted by the Live encoder should be paced by its system clock
     *         (which optionally may be locked to another source via NTP) or should be locked to the clock of the source
     *         that is providing the input stream.
     * @see GlobalConfigurationOutputTimingSource
     */
    public GlobalConfigurationOutputTimingSource outputTimingSource() {
        return GlobalConfigurationOutputTimingSource.fromValue(outputTimingSource);
    }

    /**
     * Indicates whether the rate of frames emitted by the Live encoder should be paced by its system clock (which
     * optionally may be locked to another source via NTP) or should be locked to the clock of the source that is
     * providing the input stream.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #outputTimingSource} will return {@link GlobalConfigurationOutputTimingSource#UNKNOWN_TO_SDK_VERSION}. The
     * raw value returned by the service is available from {@link #outputTimingSourceAsString}.
     * </p>
     * 
     * @return Indicates whether the rate of frames emitted by the Live encoder should be paced by its system clock
     *         (which optionally may be locked to another source via NTP) or should be locked to the clock of the source
     *         that is providing the input stream.
     * @see GlobalConfigurationOutputTimingSource
     */
    public String outputTimingSourceAsString() {
        return outputTimingSource;
    }

    /**
     * Adjusts video input buffer for streams with very low video framerates. This is commonly set to enabled for music
     * channels with less than one video frame per second.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #supportLowFramerateInputs} will return
     * {@link GlobalConfigurationLowFramerateInputs#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #supportLowFramerateInputsAsString}.
     * </p>
     * 
     * @return Adjusts video input buffer for streams with very low video framerates. This is commonly set to enabled
     *         for music channels with less than one video frame per second.
     * @see GlobalConfigurationLowFramerateInputs
     */
    public GlobalConfigurationLowFramerateInputs supportLowFramerateInputs() {
        return GlobalConfigurationLowFramerateInputs.fromValue(supportLowFramerateInputs);
    }

    /**
     * Adjusts video input buffer for streams with very low video framerates. This is commonly set to enabled for music
     * channels with less than one video frame per second.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #supportLowFramerateInputs} will return
     * {@link GlobalConfigurationLowFramerateInputs#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #supportLowFramerateInputsAsString}.
     * </p>
     * 
     * @return Adjusts video input buffer for streams with very low video framerates. This is commonly set to enabled
     *         for music channels with less than one video frame per second.
     * @see GlobalConfigurationLowFramerateInputs
     */
    public String supportLowFramerateInputsAsString() {
        return supportLowFramerateInputs;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(initialAudioGain());
        hashCode = 31 * hashCode + Objects.hashCode(inputEndActionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(inputLossBehavior());
        hashCode = 31 * hashCode + Objects.hashCode(outputLockingModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(outputTimingSourceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(supportLowFramerateInputsAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GlobalConfiguration)) {
            return false;
        }
        GlobalConfiguration other = (GlobalConfiguration) obj;
        return Objects.equals(initialAudioGain(), other.initialAudioGain())
                && Objects.equals(inputEndActionAsString(), other.inputEndActionAsString())
                && Objects.equals(inputLossBehavior(), other.inputLossBehavior())
                && Objects.equals(outputLockingModeAsString(), other.outputLockingModeAsString())
                && Objects.equals(outputTimingSourceAsString(), other.outputTimingSourceAsString())
                && Objects.equals(supportLowFramerateInputsAsString(), other.supportLowFramerateInputsAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GlobalConfiguration").add("InitialAudioGain", initialAudioGain())
                .add("InputEndAction", inputEndActionAsString()).add("InputLossBehavior", inputLossBehavior())
                .add("OutputLockingMode", outputLockingModeAsString()).add("OutputTimingSource", outputTimingSourceAsString())
                .add("SupportLowFramerateInputs", supportLowFramerateInputsAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InitialAudioGain":
            return Optional.ofNullable(clazz.cast(initialAudioGain()));
        case "InputEndAction":
            return Optional.ofNullable(clazz.cast(inputEndActionAsString()));
        case "InputLossBehavior":
            return Optional.ofNullable(clazz.cast(inputLossBehavior()));
        case "OutputLockingMode":
            return Optional.ofNullable(clazz.cast(outputLockingModeAsString()));
        case "OutputTimingSource":
            return Optional.ofNullable(clazz.cast(outputTimingSourceAsString()));
        case "SupportLowFramerateInputs":
            return Optional.ofNullable(clazz.cast(supportLowFramerateInputsAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GlobalConfiguration, T> g) {
        return obj -> g.apply((GlobalConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, GlobalConfiguration> {
        /**
         * Value to set the initial audio gain for the Live Event.
         * 
         * @param initialAudioGain
         *        Value to set the initial audio gain for the Live Event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder initialAudioGain(Integer initialAudioGain);

        /**
         * Indicates the action to take when the current input completes (e.g. end-of-file). When switchAndLoopInputs is
         * configured the encoder will restart at the beginning of the first input. When "none" is configured the
         * encoder will transcode either black, a solid color, or a user specified slate images per the
         * "Input Loss Behavior" configuration until the next input switch occurs (which is controlled through the
         * Channel Schedule API).
         * 
         * @param inputEndAction
         *        Indicates the action to take when the current input completes (e.g. end-of-file). When
         *        switchAndLoopInputs is configured the encoder will restart at the beginning of the first input. When
         *        "none" is configured the encoder will transcode either black, a solid color, or a user specified slate
         *        images per the "Input Loss Behavior" configuration until the next input switch occurs (which is
         *        controlled through the Channel Schedule API).
         * @see GlobalConfigurationInputEndAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GlobalConfigurationInputEndAction
         */
        Builder inputEndAction(String inputEndAction);

        /**
         * Indicates the action to take when the current input completes (e.g. end-of-file). When switchAndLoopInputs is
         * configured the encoder will restart at the beginning of the first input. When "none" is configured the
         * encoder will transcode either black, a solid color, or a user specified slate images per the
         * "Input Loss Behavior" configuration until the next input switch occurs (which is controlled through the
         * Channel Schedule API).
         * 
         * @param inputEndAction
         *        Indicates the action to take when the current input completes (e.g. end-of-file). When
         *        switchAndLoopInputs is configured the encoder will restart at the beginning of the first input. When
         *        "none" is configured the encoder will transcode either black, a solid color, or a user specified slate
         *        images per the "Input Loss Behavior" configuration until the next input switch occurs (which is
         *        controlled through the Channel Schedule API).
         * @see GlobalConfigurationInputEndAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GlobalConfigurationInputEndAction
         */
        Builder inputEndAction(GlobalConfigurationInputEndAction inputEndAction);

        /**
         * Settings for system actions when input is lost.
         * 
         * @param inputLossBehavior
         *        Settings for system actions when input is lost.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputLossBehavior(InputLossBehavior inputLossBehavior);

        /**
         * Settings for system actions when input is lost. This is a convenience that creates an instance of the
         * {@link InputLossBehavior.Builder} avoiding the need to create one manually via
         * {@link InputLossBehavior#builder()}.
         *
         * When the {@link Consumer} completes, {@link InputLossBehavior.Builder#build()} is called immediately and its
         * result is passed to {@link #inputLossBehavior(InputLossBehavior)}.
         * 
         * @param inputLossBehavior
         *        a consumer that will call methods on {@link InputLossBehavior.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #inputLossBehavior(InputLossBehavior)
         */
        default Builder inputLossBehavior(Consumer<InputLossBehavior.Builder> inputLossBehavior) {
            return inputLossBehavior(InputLossBehavior.builder().applyMutation(inputLossBehavior).build());
        }

        /**
         * Indicates how MediaLive pipelines are synchronized.
         *
         * PIPELINELOCKING - MediaLive will attempt to synchronize the output of each pipeline to the other.
         * EPOCHLOCKING - MediaLive will attempt to synchronize the output of each pipeline to the Unix epoch.
         * 
         * @param outputLockingMode
         *        Indicates how MediaLive pipelines are synchronized.
         *
         *        PIPELINELOCKING - MediaLive will attempt to synchronize the output of each pipeline to the other.
         *        EPOCHLOCKING - MediaLive will attempt to synchronize the output of each pipeline to the Unix epoch.
         * @see GlobalConfigurationOutputLockingMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GlobalConfigurationOutputLockingMode
         */
        Builder outputLockingMode(String outputLockingMode);

        /**
         * Indicates how MediaLive pipelines are synchronized.
         *
         * PIPELINELOCKING - MediaLive will attempt to synchronize the output of each pipeline to the other.
         * EPOCHLOCKING - MediaLive will attempt to synchronize the output of each pipeline to the Unix epoch.
         * 
         * @param outputLockingMode
         *        Indicates how MediaLive pipelines are synchronized.
         *
         *        PIPELINELOCKING - MediaLive will attempt to synchronize the output of each pipeline to the other.
         *        EPOCHLOCKING - MediaLive will attempt to synchronize the output of each pipeline to the Unix epoch.
         * @see GlobalConfigurationOutputLockingMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GlobalConfigurationOutputLockingMode
         */
        Builder outputLockingMode(GlobalConfigurationOutputLockingMode outputLockingMode);

        /**
         * Indicates whether the rate of frames emitted by the Live encoder should be paced by its system clock (which
         * optionally may be locked to another source via NTP) or should be locked to the clock of the source that is
         * providing the input stream.
         * 
         * @param outputTimingSource
         *        Indicates whether the rate of frames emitted by the Live encoder should be paced by its system clock
         *        (which optionally may be locked to another source via NTP) or should be locked to the clock of the
         *        source that is providing the input stream.
         * @see GlobalConfigurationOutputTimingSource
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GlobalConfigurationOutputTimingSource
         */
        Builder outputTimingSource(String outputTimingSource);

        /**
         * Indicates whether the rate of frames emitted by the Live encoder should be paced by its system clock (which
         * optionally may be locked to another source via NTP) or should be locked to the clock of the source that is
         * providing the input stream.
         * 
         * @param outputTimingSource
         *        Indicates whether the rate of frames emitted by the Live encoder should be paced by its system clock
         *        (which optionally may be locked to another source via NTP) or should be locked to the clock of the
         *        source that is providing the input stream.
         * @see GlobalConfigurationOutputTimingSource
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GlobalConfigurationOutputTimingSource
         */
        Builder outputTimingSource(GlobalConfigurationOutputTimingSource outputTimingSource);

        /**
         * Adjusts video input buffer for streams with very low video framerates. This is commonly set to enabled for
         * music channels with less than one video frame per second.
         * 
         * @param supportLowFramerateInputs
         *        Adjusts video input buffer for streams with very low video framerates. This is commonly set to enabled
         *        for music channels with less than one video frame per second.
         * @see GlobalConfigurationLowFramerateInputs
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GlobalConfigurationLowFramerateInputs
         */
        Builder supportLowFramerateInputs(String supportLowFramerateInputs);

        /**
         * Adjusts video input buffer for streams with very low video framerates. This is commonly set to enabled for
         * music channels with less than one video frame per second.
         * 
         * @param supportLowFramerateInputs
         *        Adjusts video input buffer for streams with very low video framerates. This is commonly set to enabled
         *        for music channels with less than one video frame per second.
         * @see GlobalConfigurationLowFramerateInputs
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GlobalConfigurationLowFramerateInputs
         */
        Builder supportLowFramerateInputs(GlobalConfigurationLowFramerateInputs supportLowFramerateInputs);
    }

    static final class BuilderImpl implements Builder {
        private Integer initialAudioGain;

        private String inputEndAction;

        private InputLossBehavior inputLossBehavior;

        private String outputLockingMode;

        private String outputTimingSource;

        private String supportLowFramerateInputs;

        private BuilderImpl() {
        }

        private BuilderImpl(GlobalConfiguration model) {
            initialAudioGain(model.initialAudioGain);
            inputEndAction(model.inputEndAction);
            inputLossBehavior(model.inputLossBehavior);
            outputLockingMode(model.outputLockingMode);
            outputTimingSource(model.outputTimingSource);
            supportLowFramerateInputs(model.supportLowFramerateInputs);
        }

        public final Integer getInitialAudioGain() {
            return initialAudioGain;
        }

        @Override
        public final Builder initialAudioGain(Integer initialAudioGain) {
            this.initialAudioGain = initialAudioGain;
            return this;
        }

        public final void setInitialAudioGain(Integer initialAudioGain) {
            this.initialAudioGain = initialAudioGain;
        }

        public final String getInputEndActionAsString() {
            return inputEndAction;
        }

        @Override
        public final Builder inputEndAction(String inputEndAction) {
            this.inputEndAction = inputEndAction;
            return this;
        }

        @Override
        public final Builder inputEndAction(GlobalConfigurationInputEndAction inputEndAction) {
            this.inputEndAction(inputEndAction == null ? null : inputEndAction.toString());
            return this;
        }

        public final void setInputEndAction(String inputEndAction) {
            this.inputEndAction = inputEndAction;
        }

        public final InputLossBehavior.Builder getInputLossBehavior() {
            return inputLossBehavior != null ? inputLossBehavior.toBuilder() : null;
        }

        @Override
        public final Builder inputLossBehavior(InputLossBehavior inputLossBehavior) {
            this.inputLossBehavior = inputLossBehavior;
            return this;
        }

        public final void setInputLossBehavior(InputLossBehavior.BuilderImpl inputLossBehavior) {
            this.inputLossBehavior = inputLossBehavior != null ? inputLossBehavior.build() : null;
        }

        public final String getOutputLockingModeAsString() {
            return outputLockingMode;
        }

        @Override
        public final Builder outputLockingMode(String outputLockingMode) {
            this.outputLockingMode = outputLockingMode;
            return this;
        }

        @Override
        public final Builder outputLockingMode(GlobalConfigurationOutputLockingMode outputLockingMode) {
            this.outputLockingMode(outputLockingMode == null ? null : outputLockingMode.toString());
            return this;
        }

        public final void setOutputLockingMode(String outputLockingMode) {
            this.outputLockingMode = outputLockingMode;
        }

        public final String getOutputTimingSourceAsString() {
            return outputTimingSource;
        }

        @Override
        public final Builder outputTimingSource(String outputTimingSource) {
            this.outputTimingSource = outputTimingSource;
            return this;
        }

        @Override
        public final Builder outputTimingSource(GlobalConfigurationOutputTimingSource outputTimingSource) {
            this.outputTimingSource(outputTimingSource == null ? null : outputTimingSource.toString());
            return this;
        }

        public final void setOutputTimingSource(String outputTimingSource) {
            this.outputTimingSource = outputTimingSource;
        }

        public final String getSupportLowFramerateInputsAsString() {
            return supportLowFramerateInputs;
        }

        @Override
        public final Builder supportLowFramerateInputs(String supportLowFramerateInputs) {
            this.supportLowFramerateInputs = supportLowFramerateInputs;
            return this;
        }

        @Override
        public final Builder supportLowFramerateInputs(GlobalConfigurationLowFramerateInputs supportLowFramerateInputs) {
            this.supportLowFramerateInputs(supportLowFramerateInputs == null ? null : supportLowFramerateInputs.toString());
            return this;
        }

        public final void setSupportLowFramerateInputs(String supportLowFramerateInputs) {
            this.supportLowFramerateInputs = supportLowFramerateInputs;
        }

        @Override
        public GlobalConfiguration build() {
            return new GlobalConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
