/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Frame Capture Group Settings
 */
@Generated("software.amazon.awssdk:codegen")
public final class FrameCaptureGroupSettings implements SdkPojo, Serializable,
        ToCopyableBuilder<FrameCaptureGroupSettings.Builder, FrameCaptureGroupSettings> {
    private static final SdkField<OutputLocationRef> DESTINATION_FIELD = SdkField
            .<OutputLocationRef> builder(MarshallingType.SDK_POJO).getter(getter(FrameCaptureGroupSettings::destination))
            .setter(setter(Builder::destination)).constructor(OutputLocationRef::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destination").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESTINATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final OutputLocationRef destination;

    private FrameCaptureGroupSettings(BuilderImpl builder) {
        this.destination = builder.destination;
    }

    /**
     * The destination for the frame capture files. Either the URI for an Amazon S3 bucket and object, plus a file name
     * prefix (for example, s3ssl://sportsDelivery/highlights/20180820/curling_) or the URI for a MediaStore container,
     * plus a file name prefix (for example, mediastoressl://sportsDelivery/20180820/curling_). The final file names
     * consist of the prefix from the destination field (for example, "curling_") + name modifier + the counter (5
     * digits, starting from 00001) + extension (which is always .jpg). For example, curlingLow.00001.jpg
     * 
     * @return The destination for the frame capture files. Either the URI for an Amazon S3 bucket and object, plus a
     *         file name prefix (for example, s3ssl://sportsDelivery/highlights/20180820/curling_) or the URI for a
     *         MediaStore container, plus a file name prefix (for example,
     *         mediastoressl://sportsDelivery/20180820/curling_). The final file names consist of the prefix from the
     *         destination field (for example, "curling_") + name modifier + the counter (5 digits, starting from 00001)
     *         + extension (which is always .jpg). For example, curlingLow.00001.jpg
     */
    public OutputLocationRef destination() {
        return destination;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(destination());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FrameCaptureGroupSettings)) {
            return false;
        }
        FrameCaptureGroupSettings other = (FrameCaptureGroupSettings) obj;
        return Objects.equals(destination(), other.destination());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("FrameCaptureGroupSettings").add("Destination", destination()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Destination":
            return Optional.ofNullable(clazz.cast(destination()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FrameCaptureGroupSettings, T> g) {
        return obj -> g.apply((FrameCaptureGroupSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FrameCaptureGroupSettings> {
        /**
         * The destination for the frame capture files. Either the URI for an Amazon S3 bucket and object, plus a file
         * name prefix (for example, s3ssl://sportsDelivery/highlights/20180820/curling_) or the URI for a MediaStore
         * container, plus a file name prefix (for example, mediastoressl://sportsDelivery/20180820/curling_). The final
         * file names consist of the prefix from the destination field (for example, "curling_") + name modifier + the
         * counter (5 digits, starting from 00001) + extension (which is always .jpg). For example, curlingLow.00001.jpg
         * 
         * @param destination
         *        The destination for the frame capture files. Either the URI for an Amazon S3 bucket and object, plus a
         *        file name prefix (for example, s3ssl://sportsDelivery/highlights/20180820/curling_) or the URI for a
         *        MediaStore container, plus a file name prefix (for example,
         *        mediastoressl://sportsDelivery/20180820/curling_). The final file names consist of the prefix from the
         *        destination field (for example, "curling_") + name modifier + the counter (5 digits, starting from
         *        00001) + extension (which is always .jpg). For example, curlingLow.00001.jpg
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destination(OutputLocationRef destination);

        /**
         * The destination for the frame capture files. Either the URI for an Amazon S3 bucket and object, plus a file
         * name prefix (for example, s3ssl://sportsDelivery/highlights/20180820/curling_) or the URI for a MediaStore
         * container, plus a file name prefix (for example, mediastoressl://sportsDelivery/20180820/curling_). The final
         * file names consist of the prefix from the destination field (for example, "curling_") + name modifier + the
         * counter (5 digits, starting from 00001) + extension (which is always .jpg). For example, curlingLow.00001.jpg
         * This is a convenience that creates an instance of the {@link OutputLocationRef.Builder} avoiding the need to
         * create one manually via {@link OutputLocationRef#builder()}.
         *
         * When the {@link Consumer} completes, {@link OutputLocationRef.Builder#build()} is called immediately and its
         * result is passed to {@link #destination(OutputLocationRef)}.
         * 
         * @param destination
         *        a consumer that will call methods on {@link OutputLocationRef.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #destination(OutputLocationRef)
         */
        default Builder destination(Consumer<OutputLocationRef.Builder> destination) {
            return destination(OutputLocationRef.builder().applyMutation(destination).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private OutputLocationRef destination;

        private BuilderImpl() {
        }

        private BuilderImpl(FrameCaptureGroupSettings model) {
            destination(model.destination);
        }

        public final OutputLocationRef.Builder getDestination() {
            return destination != null ? destination.toBuilder() : null;
        }

        @Override
        public final Builder destination(OutputLocationRef destination) {
            this.destination = destination;
            return this;
        }

        public final void setDestination(OutputLocationRef.BuilderImpl destination) {
            this.destination = destination != null ? destination.build() : null;
        }

        @Override
        public FrameCaptureGroupSettings build() {
            return new FrameCaptureGroupSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
