/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Settings to specify if an action follows another.
 */
@Generated("software.amazon.awssdk:codegen")
public final class FollowModeScheduleActionStartSettings implements SdkPojo, Serializable,
        ToCopyableBuilder<FollowModeScheduleActionStartSettings.Builder, FollowModeScheduleActionStartSettings> {
    private static final SdkField<String> FOLLOW_POINT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(FollowModeScheduleActionStartSettings::followPointAsString)).setter(setter(Builder::followPoint))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("followPoint").build()).build();

    private static final SdkField<String> REFERENCE_ACTION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(FollowModeScheduleActionStartSettings::referenceActionName))
            .setter(setter(Builder::referenceActionName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("referenceActionName").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FOLLOW_POINT_FIELD,
            REFERENCE_ACTION_NAME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String followPoint;

    private final String referenceActionName;

    private FollowModeScheduleActionStartSettings(BuilderImpl builder) {
        this.followPoint = builder.followPoint;
        this.referenceActionName = builder.referenceActionName;
    }

    /**
     * Identifies whether this action starts relative to the start or relative to the end of the reference action.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #followPoint} will
     * return {@link FollowPoint#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #followPointAsString}.
     * </p>
     * 
     * @return Identifies whether this action starts relative to the start or relative to the end of the reference
     *         action.
     * @see FollowPoint
     */
    public FollowPoint followPoint() {
        return FollowPoint.fromValue(followPoint);
    }

    /**
     * Identifies whether this action starts relative to the start or relative to the end of the reference action.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #followPoint} will
     * return {@link FollowPoint#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #followPointAsString}.
     * </p>
     * 
     * @return Identifies whether this action starts relative to the start or relative to the end of the reference
     *         action.
     * @see FollowPoint
     */
    public String followPointAsString() {
        return followPoint;
    }

    /**
     * The action name of another action that this one refers to.
     * 
     * @return The action name of another action that this one refers to.
     */
    public String referenceActionName() {
        return referenceActionName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(followPointAsString());
        hashCode = 31 * hashCode + Objects.hashCode(referenceActionName());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FollowModeScheduleActionStartSettings)) {
            return false;
        }
        FollowModeScheduleActionStartSettings other = (FollowModeScheduleActionStartSettings) obj;
        return Objects.equals(followPointAsString(), other.followPointAsString())
                && Objects.equals(referenceActionName(), other.referenceActionName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("FollowModeScheduleActionStartSettings").add("FollowPoint", followPointAsString())
                .add("ReferenceActionName", referenceActionName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FollowPoint":
            return Optional.ofNullable(clazz.cast(followPointAsString()));
        case "ReferenceActionName":
            return Optional.ofNullable(clazz.cast(referenceActionName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FollowModeScheduleActionStartSettings, T> g) {
        return obj -> g.apply((FollowModeScheduleActionStartSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FollowModeScheduleActionStartSettings> {
        /**
         * Identifies whether this action starts relative to the start or relative to the end of the reference action.
         * 
         * @param followPoint
         *        Identifies whether this action starts relative to the start or relative to the end of the reference
         *        action.
         * @see FollowPoint
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FollowPoint
         */
        Builder followPoint(String followPoint);

        /**
         * Identifies whether this action starts relative to the start or relative to the end of the reference action.
         * 
         * @param followPoint
         *        Identifies whether this action starts relative to the start or relative to the end of the reference
         *        action.
         * @see FollowPoint
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FollowPoint
         */
        Builder followPoint(FollowPoint followPoint);

        /**
         * The action name of another action that this one refers to.
         * 
         * @param referenceActionName
         *        The action name of another action that this one refers to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder referenceActionName(String referenceActionName);
    }

    static final class BuilderImpl implements Builder {
        private String followPoint;

        private String referenceActionName;

        private BuilderImpl() {
        }

        private BuilderImpl(FollowModeScheduleActionStartSettings model) {
            followPoint(model.followPoint);
            referenceActionName(model.referenceActionName);
        }

        public final String getFollowPointAsString() {
            return followPoint;
        }

        @Override
        public final Builder followPoint(String followPoint) {
            this.followPoint = followPoint;
            return this;
        }

        @Override
        public final Builder followPoint(FollowPoint followPoint) {
            this.followPoint(followPoint == null ? null : followPoint.toString());
            return this;
        }

        public final void setFollowPoint(String followPoint) {
            this.followPoint = followPoint;
        }

        public final String getReferenceActionName() {
            return referenceActionName;
        }

        @Override
        public final Builder referenceActionName(String referenceActionName) {
            this.referenceActionName = referenceActionName;
            return this;
        }

        public final void setReferenceActionName(String referenceActionName) {
            this.referenceActionName = referenceActionName;
        }

        @Override
        public FollowModeScheduleActionStartSettings build() {
            return new FollowModeScheduleActionStartSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
