/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Fmp4 Hls Settings
 */
@Generated("software.amazon.awssdk:codegen")
public final class Fmp4HlsSettings implements SdkPojo, Serializable, ToCopyableBuilder<Fmp4HlsSettings.Builder, Fmp4HlsSettings> {
    private static final SdkField<String> AUDIO_RENDITION_SETS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Fmp4HlsSettings::audioRenditionSets)).setter(setter(Builder::audioRenditionSets))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("audioRenditionSets").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUDIO_RENDITION_SETS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String audioRenditionSets;

    private Fmp4HlsSettings(BuilderImpl builder) {
        this.audioRenditionSets = builder.audioRenditionSets;
    }

    /**
     * List all the audio groups that are used with the video output stream. Input all the audio GROUP-IDs that are
     * associated to the video, separate by ','.
     * 
     * @return List all the audio groups that are used with the video output stream. Input all the audio GROUP-IDs that
     *         are associated to the video, separate by ','.
     */
    public String audioRenditionSets() {
        return audioRenditionSets;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(audioRenditionSets());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Fmp4HlsSettings)) {
            return false;
        }
        Fmp4HlsSettings other = (Fmp4HlsSettings) obj;
        return Objects.equals(audioRenditionSets(), other.audioRenditionSets());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("Fmp4HlsSettings").add("AudioRenditionSets", audioRenditionSets()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AudioRenditionSets":
            return Optional.ofNullable(clazz.cast(audioRenditionSets()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Fmp4HlsSettings, T> g) {
        return obj -> g.apply((Fmp4HlsSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Fmp4HlsSettings> {
        /**
         * List all the audio groups that are used with the video output stream. Input all the audio GROUP-IDs that are
         * associated to the video, separate by ','.
         * 
         * @param audioRenditionSets
         *        List all the audio groups that are used with the video output stream. Input all the audio GROUP-IDs
         *        that are associated to the video, separate by ','.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder audioRenditionSets(String audioRenditionSets);
    }

    static final class BuilderImpl implements Builder {
        private String audioRenditionSets;

        private BuilderImpl() {
        }

        private BuilderImpl(Fmp4HlsSettings model) {
            audioRenditionSets(model.audioRenditionSets);
        }

        public final String getAudioRenditionSets() {
            return audioRenditionSets;
        }

        @Override
        public final Builder audioRenditionSets(String audioRenditionSets) {
            this.audioRenditionSets = audioRenditionSets;
            return this;
        }

        public final void setAudioRenditionSets(String audioRenditionSets) {
            this.audioRenditionSets = audioRenditionSets;
        }

        @Override
        public Fmp4HlsSettings build() {
            return new Fmp4HlsSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
