/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Dvb Sub Destination Settings
 */
@Generated("software.amazon.awssdk:codegen")
public final class DvbSubDestinationSettings implements SdkPojo, Serializable,
        ToCopyableBuilder<DvbSubDestinationSettings.Builder, DvbSubDestinationSettings> {
    private static final SdkField<String> ALIGNMENT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DvbSubDestinationSettings::alignmentAsString)).setter(setter(Builder::alignment))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("alignment").build()).build();

    private static final SdkField<String> BACKGROUND_COLOR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DvbSubDestinationSettings::backgroundColorAsString)).setter(setter(Builder::backgroundColor))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("backgroundColor").build()).build();

    private static final SdkField<Integer> BACKGROUND_OPACITY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(DvbSubDestinationSettings::backgroundOpacity)).setter(setter(Builder::backgroundOpacity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("backgroundOpacity").build()).build();

    private static final SdkField<InputLocation> FONT_FIELD = SdkField.<InputLocation> builder(MarshallingType.SDK_POJO)
            .getter(getter(DvbSubDestinationSettings::font)).setter(setter(Builder::font)).constructor(InputLocation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("font").build()).build();

    private static final SdkField<String> FONT_COLOR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DvbSubDestinationSettings::fontColorAsString)).setter(setter(Builder::fontColor))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fontColor").build()).build();

    private static final SdkField<Integer> FONT_OPACITY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(DvbSubDestinationSettings::fontOpacity)).setter(setter(Builder::fontOpacity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fontOpacity").build()).build();

    private static final SdkField<Integer> FONT_RESOLUTION_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(DvbSubDestinationSettings::fontResolution)).setter(setter(Builder::fontResolution))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fontResolution").build()).build();

    private static final SdkField<String> FONT_SIZE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DvbSubDestinationSettings::fontSize)).setter(setter(Builder::fontSize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fontSize").build()).build();

    private static final SdkField<String> OUTLINE_COLOR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DvbSubDestinationSettings::outlineColorAsString)).setter(setter(Builder::outlineColor))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outlineColor").build()).build();

    private static final SdkField<Integer> OUTLINE_SIZE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(DvbSubDestinationSettings::outlineSize)).setter(setter(Builder::outlineSize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outlineSize").build()).build();

    private static final SdkField<String> SHADOW_COLOR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DvbSubDestinationSettings::shadowColorAsString)).setter(setter(Builder::shadowColor))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("shadowColor").build()).build();

    private static final SdkField<Integer> SHADOW_OPACITY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(DvbSubDestinationSettings::shadowOpacity)).setter(setter(Builder::shadowOpacity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("shadowOpacity").build()).build();

    private static final SdkField<Integer> SHADOW_X_OFFSET_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(DvbSubDestinationSettings::shadowXOffset)).setter(setter(Builder::shadowXOffset))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("shadowXOffset").build()).build();

    private static final SdkField<Integer> SHADOW_Y_OFFSET_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(DvbSubDestinationSettings::shadowYOffset)).setter(setter(Builder::shadowYOffset))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("shadowYOffset").build()).build();

    private static final SdkField<String> TELETEXT_GRID_CONTROL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DvbSubDestinationSettings::teletextGridControlAsString)).setter(setter(Builder::teletextGridControl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("teletextGridControl").build())
            .build();

    private static final SdkField<Integer> X_POSITION_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(DvbSubDestinationSettings::xPosition)).setter(setter(Builder::xPosition))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("xPosition").build()).build();

    private static final SdkField<Integer> Y_POSITION_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(DvbSubDestinationSettings::yPosition)).setter(setter(Builder::yPosition))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("yPosition").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALIGNMENT_FIELD,
            BACKGROUND_COLOR_FIELD, BACKGROUND_OPACITY_FIELD, FONT_FIELD, FONT_COLOR_FIELD, FONT_OPACITY_FIELD,
            FONT_RESOLUTION_FIELD, FONT_SIZE_FIELD, OUTLINE_COLOR_FIELD, OUTLINE_SIZE_FIELD, SHADOW_COLOR_FIELD,
            SHADOW_OPACITY_FIELD, SHADOW_X_OFFSET_FIELD, SHADOW_Y_OFFSET_FIELD, TELETEXT_GRID_CONTROL_FIELD, X_POSITION_FIELD,
            Y_POSITION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String alignment;

    private final String backgroundColor;

    private final Integer backgroundOpacity;

    private final InputLocation font;

    private final String fontColor;

    private final Integer fontOpacity;

    private final Integer fontResolution;

    private final String fontSize;

    private final String outlineColor;

    private final Integer outlineSize;

    private final String shadowColor;

    private final Integer shadowOpacity;

    private final Integer shadowXOffset;

    private final Integer shadowYOffset;

    private final String teletextGridControl;

    private final Integer xPosition;

    private final Integer yPosition;

    private DvbSubDestinationSettings(BuilderImpl builder) {
        this.alignment = builder.alignment;
        this.backgroundColor = builder.backgroundColor;
        this.backgroundOpacity = builder.backgroundOpacity;
        this.font = builder.font;
        this.fontColor = builder.fontColor;
        this.fontOpacity = builder.fontOpacity;
        this.fontResolution = builder.fontResolution;
        this.fontSize = builder.fontSize;
        this.outlineColor = builder.outlineColor;
        this.outlineSize = builder.outlineSize;
        this.shadowColor = builder.shadowColor;
        this.shadowOpacity = builder.shadowOpacity;
        this.shadowXOffset = builder.shadowXOffset;
        this.shadowYOffset = builder.shadowYOffset;
        this.teletextGridControl = builder.teletextGridControl;
        this.xPosition = builder.xPosition;
        this.yPosition = builder.yPosition;
    }

    /**
     * If no explicit xPosition or yPosition is provided, setting alignment to centered will place the captions at the
     * bottom center of the output. Similarly, setting a left alignment will align captions to the bottom left of the
     * output. If x and y positions are given in conjunction with the alignment parameter, the font will be justified
     * (either left or centered) relative to those coordinates. Selecting "smart" justification will left-justify live
     * subtitles and center-justify pre-recorded subtitles. This option is not valid for source captions that are STL or
     * 608/embedded. These source settings are already pre-defined by the caption stream. All burn-in and DVB-Sub font
     * settings must match.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #alignment} will
     * return {@link DvbSubDestinationAlignment#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #alignmentAsString}.
     * </p>
     * 
     * @return If no explicit xPosition or yPosition is provided, setting alignment to centered will place the captions
     *         at the bottom center of the output. Similarly, setting a left alignment will align captions to the bottom
     *         left of the output. If x and y positions are given in conjunction with the alignment parameter, the font
     *         will be justified (either left or centered) relative to those coordinates. Selecting "smart"
     *         justification will left-justify live subtitles and center-justify pre-recorded subtitles. This option is
     *         not valid for source captions that are STL or 608/embedded. These source settings are already pre-defined
     *         by the caption stream. All burn-in and DVB-Sub font settings must match.
     * @see DvbSubDestinationAlignment
     */
    public DvbSubDestinationAlignment alignment() {
        return DvbSubDestinationAlignment.fromValue(alignment);
    }

    /**
     * If no explicit xPosition or yPosition is provided, setting alignment to centered will place the captions at the
     * bottom center of the output. Similarly, setting a left alignment will align captions to the bottom left of the
     * output. If x and y positions are given in conjunction with the alignment parameter, the font will be justified
     * (either left or centered) relative to those coordinates. Selecting "smart" justification will left-justify live
     * subtitles and center-justify pre-recorded subtitles. This option is not valid for source captions that are STL or
     * 608/embedded. These source settings are already pre-defined by the caption stream. All burn-in and DVB-Sub font
     * settings must match.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #alignment} will
     * return {@link DvbSubDestinationAlignment#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #alignmentAsString}.
     * </p>
     * 
     * @return If no explicit xPosition or yPosition is provided, setting alignment to centered will place the captions
     *         at the bottom center of the output. Similarly, setting a left alignment will align captions to the bottom
     *         left of the output. If x and y positions are given in conjunction with the alignment parameter, the font
     *         will be justified (either left or centered) relative to those coordinates. Selecting "smart"
     *         justification will left-justify live subtitles and center-justify pre-recorded subtitles. This option is
     *         not valid for source captions that are STL or 608/embedded. These source settings are already pre-defined
     *         by the caption stream. All burn-in and DVB-Sub font settings must match.
     * @see DvbSubDestinationAlignment
     */
    public String alignmentAsString() {
        return alignment;
    }

    /**
     * Specifies the color of the rectangle behind the captions. All burn-in and DVB-Sub font settings must match.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #backgroundColor}
     * will return {@link DvbSubDestinationBackgroundColor#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #backgroundColorAsString}.
     * </p>
     * 
     * @return Specifies the color of the rectangle behind the captions. All burn-in and DVB-Sub font settings must
     *         match.
     * @see DvbSubDestinationBackgroundColor
     */
    public DvbSubDestinationBackgroundColor backgroundColor() {
        return DvbSubDestinationBackgroundColor.fromValue(backgroundColor);
    }

    /**
     * Specifies the color of the rectangle behind the captions. All burn-in and DVB-Sub font settings must match.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #backgroundColor}
     * will return {@link DvbSubDestinationBackgroundColor#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #backgroundColorAsString}.
     * </p>
     * 
     * @return Specifies the color of the rectangle behind the captions. All burn-in and DVB-Sub font settings must
     *         match.
     * @see DvbSubDestinationBackgroundColor
     */
    public String backgroundColorAsString() {
        return backgroundColor;
    }

    /**
     * Specifies the opacity of the background rectangle. 255 is opaque; 0 is transparent. Leaving this parameter blank
     * is equivalent to setting it to 0 (transparent). All burn-in and DVB-Sub font settings must match.
     * 
     * @return Specifies the opacity of the background rectangle. 255 is opaque; 0 is transparent. Leaving this
     *         parameter blank is equivalent to setting it to 0 (transparent). All burn-in and DVB-Sub font settings
     *         must match.
     */
    public Integer backgroundOpacity() {
        return backgroundOpacity;
    }

    /**
     * External font file used for caption burn-in. File extension must be 'ttf' or 'tte'. Although the user can select
     * output fonts for many different types of input captions, embedded, STL and teletext sources use a strict grid
     * system. Using external fonts with these caption sources could cause unexpected display of proportional fonts. All
     * burn-in and DVB-Sub font settings must match.
     * 
     * @return External font file used for caption burn-in. File extension must be 'ttf' or 'tte'. Although the user can
     *         select output fonts for many different types of input captions, embedded, STL and teletext sources use a
     *         strict grid system. Using external fonts with these caption sources could cause unexpected display of
     *         proportional fonts. All burn-in and DVB-Sub font settings must match.
     */
    public InputLocation font() {
        return font;
    }

    /**
     * Specifies the color of the burned-in captions. This option is not valid for source captions that are STL,
     * 608/embedded or teletext. These source settings are already pre-defined by the caption stream. All burn-in and
     * DVB-Sub font settings must match.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #fontColor} will
     * return {@link DvbSubDestinationFontColor#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #fontColorAsString}.
     * </p>
     * 
     * @return Specifies the color of the burned-in captions. This option is not valid for source captions that are STL,
     *         608/embedded or teletext. These source settings are already pre-defined by the caption stream. All
     *         burn-in and DVB-Sub font settings must match.
     * @see DvbSubDestinationFontColor
     */
    public DvbSubDestinationFontColor fontColor() {
        return DvbSubDestinationFontColor.fromValue(fontColor);
    }

    /**
     * Specifies the color of the burned-in captions. This option is not valid for source captions that are STL,
     * 608/embedded or teletext. These source settings are already pre-defined by the caption stream. All burn-in and
     * DVB-Sub font settings must match.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #fontColor} will
     * return {@link DvbSubDestinationFontColor#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #fontColorAsString}.
     * </p>
     * 
     * @return Specifies the color of the burned-in captions. This option is not valid for source captions that are STL,
     *         608/embedded or teletext. These source settings are already pre-defined by the caption stream. All
     *         burn-in and DVB-Sub font settings must match.
     * @see DvbSubDestinationFontColor
     */
    public String fontColorAsString() {
        return fontColor;
    }

    /**
     * Specifies the opacity of the burned-in captions. 255 is opaque; 0 is transparent. All burn-in and DVB-Sub font
     * settings must match.
     * 
     * @return Specifies the opacity of the burned-in captions. 255 is opaque; 0 is transparent. All burn-in and DVB-Sub
     *         font settings must match.
     */
    public Integer fontOpacity() {
        return fontOpacity;
    }

    /**
     * Font resolution in DPI (dots per inch); default is 96 dpi. All burn-in and DVB-Sub font settings must match.
     * 
     * @return Font resolution in DPI (dots per inch); default is 96 dpi. All burn-in and DVB-Sub font settings must
     *         match.
     */
    public Integer fontResolution() {
        return fontResolution;
    }

    /**
     * When set to auto fontSize will scale depending on the size of the output. Giving a positive integer will specify
     * the exact font size in points. All burn-in and DVB-Sub font settings must match.
     * 
     * @return When set to auto fontSize will scale depending on the size of the output. Giving a positive integer will
     *         specify the exact font size in points. All burn-in and DVB-Sub font settings must match.
     */
    public String fontSize() {
        return fontSize;
    }

    /**
     * Specifies font outline color. This option is not valid for source captions that are either 608/embedded or
     * teletext. These source settings are already pre-defined by the caption stream. All burn-in and DVB-Sub font
     * settings must match.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #outlineColor} will
     * return {@link DvbSubDestinationOutlineColor#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #outlineColorAsString}.
     * </p>
     * 
     * @return Specifies font outline color. This option is not valid for source captions that are either 608/embedded
     *         or teletext. These source settings are already pre-defined by the caption stream. All burn-in and DVB-Sub
     *         font settings must match.
     * @see DvbSubDestinationOutlineColor
     */
    public DvbSubDestinationOutlineColor outlineColor() {
        return DvbSubDestinationOutlineColor.fromValue(outlineColor);
    }

    /**
     * Specifies font outline color. This option is not valid for source captions that are either 608/embedded or
     * teletext. These source settings are already pre-defined by the caption stream. All burn-in and DVB-Sub font
     * settings must match.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #outlineColor} will
     * return {@link DvbSubDestinationOutlineColor#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #outlineColorAsString}.
     * </p>
     * 
     * @return Specifies font outline color. This option is not valid for source captions that are either 608/embedded
     *         or teletext. These source settings are already pre-defined by the caption stream. All burn-in and DVB-Sub
     *         font settings must match.
     * @see DvbSubDestinationOutlineColor
     */
    public String outlineColorAsString() {
        return outlineColor;
    }

    /**
     * Specifies font outline size in pixels. This option is not valid for source captions that are either 608/embedded
     * or teletext. These source settings are already pre-defined by the caption stream. All burn-in and DVB-Sub font
     * settings must match.
     * 
     * @return Specifies font outline size in pixels. This option is not valid for source captions that are either
     *         608/embedded or teletext. These source settings are already pre-defined by the caption stream. All
     *         burn-in and DVB-Sub font settings must match.
     */
    public Integer outlineSize() {
        return outlineSize;
    }

    /**
     * Specifies the color of the shadow cast by the captions. All burn-in and DVB-Sub font settings must match.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #shadowColor} will
     * return {@link DvbSubDestinationShadowColor#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #shadowColorAsString}.
     * </p>
     * 
     * @return Specifies the color of the shadow cast by the captions. All burn-in and DVB-Sub font settings must match.
     * @see DvbSubDestinationShadowColor
     */
    public DvbSubDestinationShadowColor shadowColor() {
        return DvbSubDestinationShadowColor.fromValue(shadowColor);
    }

    /**
     * Specifies the color of the shadow cast by the captions. All burn-in and DVB-Sub font settings must match.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #shadowColor} will
     * return {@link DvbSubDestinationShadowColor#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #shadowColorAsString}.
     * </p>
     * 
     * @return Specifies the color of the shadow cast by the captions. All burn-in and DVB-Sub font settings must match.
     * @see DvbSubDestinationShadowColor
     */
    public String shadowColorAsString() {
        return shadowColor;
    }

    /**
     * Specifies the opacity of the shadow. 255 is opaque; 0 is transparent. Leaving this parameter blank is equivalent
     * to setting it to 0 (transparent). All burn-in and DVB-Sub font settings must match.
     * 
     * @return Specifies the opacity of the shadow. 255 is opaque; 0 is transparent. Leaving this parameter blank is
     *         equivalent to setting it to 0 (transparent). All burn-in and DVB-Sub font settings must match.
     */
    public Integer shadowOpacity() {
        return shadowOpacity;
    }

    /**
     * Specifies the horizontal offset of the shadow relative to the captions in pixels. A value of -2 would result in a
     * shadow offset 2 pixels to the left. All burn-in and DVB-Sub font settings must match.
     * 
     * @return Specifies the horizontal offset of the shadow relative to the captions in pixels. A value of -2 would
     *         result in a shadow offset 2 pixels to the left. All burn-in and DVB-Sub font settings must match.
     */
    public Integer shadowXOffset() {
        return shadowXOffset;
    }

    /**
     * Specifies the vertical offset of the shadow relative to the captions in pixels. A value of -2 would result in a
     * shadow offset 2 pixels above the text. All burn-in and DVB-Sub font settings must match.
     * 
     * @return Specifies the vertical offset of the shadow relative to the captions in pixels. A value of -2 would
     *         result in a shadow offset 2 pixels above the text. All burn-in and DVB-Sub font settings must match.
     */
    public Integer shadowYOffset() {
        return shadowYOffset;
    }

    /**
     * Controls whether a fixed grid size will be used to generate the output subtitles bitmap. Only applicable for
     * Teletext inputs and DVB-Sub/Burn-in outputs.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #teletextGridControl} will return {@link DvbSubDestinationTeletextGridControl#UNKNOWN_TO_SDK_VERSION}. The
     * raw value returned by the service is available from {@link #teletextGridControlAsString}.
     * </p>
     * 
     * @return Controls whether a fixed grid size will be used to generate the output subtitles bitmap. Only applicable
     *         for Teletext inputs and DVB-Sub/Burn-in outputs.
     * @see DvbSubDestinationTeletextGridControl
     */
    public DvbSubDestinationTeletextGridControl teletextGridControl() {
        return DvbSubDestinationTeletextGridControl.fromValue(teletextGridControl);
    }

    /**
     * Controls whether a fixed grid size will be used to generate the output subtitles bitmap. Only applicable for
     * Teletext inputs and DVB-Sub/Burn-in outputs.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #teletextGridControl} will return {@link DvbSubDestinationTeletextGridControl#UNKNOWN_TO_SDK_VERSION}. The
     * raw value returned by the service is available from {@link #teletextGridControlAsString}.
     * </p>
     * 
     * @return Controls whether a fixed grid size will be used to generate the output subtitles bitmap. Only applicable
     *         for Teletext inputs and DVB-Sub/Burn-in outputs.
     * @see DvbSubDestinationTeletextGridControl
     */
    public String teletextGridControlAsString() {
        return teletextGridControl;
    }

    /**
     * Specifies the horizontal position of the caption relative to the left side of the output in pixels. A value of 10
     * would result in the captions starting 10 pixels from the left of the output. If no explicit xPosition is
     * provided, the horizontal caption position will be determined by the alignment parameter. This option is not valid
     * for source captions that are STL, 608/embedded or teletext. These source settings are already pre-defined by the
     * caption stream. All burn-in and DVB-Sub font settings must match.
     * 
     * @return Specifies the horizontal position of the caption relative to the left side of the output in pixels. A
     *         value of 10 would result in the captions starting 10 pixels from the left of the output. If no explicit
     *         xPosition is provided, the horizontal caption position will be determined by the alignment parameter.
     *         This option is not valid for source captions that are STL, 608/embedded or teletext. These source
     *         settings are already pre-defined by the caption stream. All burn-in and DVB-Sub font settings must match.
     */
    public Integer xPosition() {
        return xPosition;
    }

    /**
     * Specifies the vertical position of the caption relative to the top of the output in pixels. A value of 10 would
     * result in the captions starting 10 pixels from the top of the output. If no explicit yPosition is provided, the
     * caption will be positioned towards the bottom of the output. This option is not valid for source captions that
     * are STL, 608/embedded or teletext. These source settings are already pre-defined by the caption stream. All
     * burn-in and DVB-Sub font settings must match.
     * 
     * @return Specifies the vertical position of the caption relative to the top of the output in pixels. A value of 10
     *         would result in the captions starting 10 pixels from the top of the output. If no explicit yPosition is
     *         provided, the caption will be positioned towards the bottom of the output. This option is not valid for
     *         source captions that are STL, 608/embedded or teletext. These source settings are already pre-defined by
     *         the caption stream. All burn-in and DVB-Sub font settings must match.
     */
    public Integer yPosition() {
        return yPosition;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(alignmentAsString());
        hashCode = 31 * hashCode + Objects.hashCode(backgroundColorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(backgroundOpacity());
        hashCode = 31 * hashCode + Objects.hashCode(font());
        hashCode = 31 * hashCode + Objects.hashCode(fontColorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(fontOpacity());
        hashCode = 31 * hashCode + Objects.hashCode(fontResolution());
        hashCode = 31 * hashCode + Objects.hashCode(fontSize());
        hashCode = 31 * hashCode + Objects.hashCode(outlineColorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(outlineSize());
        hashCode = 31 * hashCode + Objects.hashCode(shadowColorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(shadowOpacity());
        hashCode = 31 * hashCode + Objects.hashCode(shadowXOffset());
        hashCode = 31 * hashCode + Objects.hashCode(shadowYOffset());
        hashCode = 31 * hashCode + Objects.hashCode(teletextGridControlAsString());
        hashCode = 31 * hashCode + Objects.hashCode(xPosition());
        hashCode = 31 * hashCode + Objects.hashCode(yPosition());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DvbSubDestinationSettings)) {
            return false;
        }
        DvbSubDestinationSettings other = (DvbSubDestinationSettings) obj;
        return Objects.equals(alignmentAsString(), other.alignmentAsString())
                && Objects.equals(backgroundColorAsString(), other.backgroundColorAsString())
                && Objects.equals(backgroundOpacity(), other.backgroundOpacity()) && Objects.equals(font(), other.font())
                && Objects.equals(fontColorAsString(), other.fontColorAsString())
                && Objects.equals(fontOpacity(), other.fontOpacity()) && Objects.equals(fontResolution(), other.fontResolution())
                && Objects.equals(fontSize(), other.fontSize())
                && Objects.equals(outlineColorAsString(), other.outlineColorAsString())
                && Objects.equals(outlineSize(), other.outlineSize())
                && Objects.equals(shadowColorAsString(), other.shadowColorAsString())
                && Objects.equals(shadowOpacity(), other.shadowOpacity())
                && Objects.equals(shadowXOffset(), other.shadowXOffset())
                && Objects.equals(shadowYOffset(), other.shadowYOffset())
                && Objects.equals(teletextGridControlAsString(), other.teletextGridControlAsString())
                && Objects.equals(xPosition(), other.xPosition()) && Objects.equals(yPosition(), other.yPosition());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DvbSubDestinationSettings").add("Alignment", alignmentAsString())
                .add("BackgroundColor", backgroundColorAsString()).add("BackgroundOpacity", backgroundOpacity())
                .add("Font", font()).add("FontColor", fontColorAsString()).add("FontOpacity", fontOpacity())
                .add("FontResolution", fontResolution()).add("FontSize", fontSize()).add("OutlineColor", outlineColorAsString())
                .add("OutlineSize", outlineSize()).add("ShadowColor", shadowColorAsString())
                .add("ShadowOpacity", shadowOpacity()).add("ShadowXOffset", shadowXOffset())
                .add("ShadowYOffset", shadowYOffset()).add("TeletextGridControl", teletextGridControlAsString())
                .add("XPosition", xPosition()).add("YPosition", yPosition()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Alignment":
            return Optional.ofNullable(clazz.cast(alignmentAsString()));
        case "BackgroundColor":
            return Optional.ofNullable(clazz.cast(backgroundColorAsString()));
        case "BackgroundOpacity":
            return Optional.ofNullable(clazz.cast(backgroundOpacity()));
        case "Font":
            return Optional.ofNullable(clazz.cast(font()));
        case "FontColor":
            return Optional.ofNullable(clazz.cast(fontColorAsString()));
        case "FontOpacity":
            return Optional.ofNullable(clazz.cast(fontOpacity()));
        case "FontResolution":
            return Optional.ofNullable(clazz.cast(fontResolution()));
        case "FontSize":
            return Optional.ofNullable(clazz.cast(fontSize()));
        case "OutlineColor":
            return Optional.ofNullable(clazz.cast(outlineColorAsString()));
        case "OutlineSize":
            return Optional.ofNullable(clazz.cast(outlineSize()));
        case "ShadowColor":
            return Optional.ofNullable(clazz.cast(shadowColorAsString()));
        case "ShadowOpacity":
            return Optional.ofNullable(clazz.cast(shadowOpacity()));
        case "ShadowXOffset":
            return Optional.ofNullable(clazz.cast(shadowXOffset()));
        case "ShadowYOffset":
            return Optional.ofNullable(clazz.cast(shadowYOffset()));
        case "TeletextGridControl":
            return Optional.ofNullable(clazz.cast(teletextGridControlAsString()));
        case "XPosition":
            return Optional.ofNullable(clazz.cast(xPosition()));
        case "YPosition":
            return Optional.ofNullable(clazz.cast(yPosition()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DvbSubDestinationSettings, T> g) {
        return obj -> g.apply((DvbSubDestinationSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DvbSubDestinationSettings> {
        /**
         * If no explicit xPosition or yPosition is provided, setting alignment to centered will place the captions at
         * the bottom center of the output. Similarly, setting a left alignment will align captions to the bottom left
         * of the output. If x and y positions are given in conjunction with the alignment parameter, the font will be
         * justified (either left or centered) relative to those coordinates. Selecting "smart" justification will
         * left-justify live subtitles and center-justify pre-recorded subtitles. This option is not valid for source
         * captions that are STL or 608/embedded. These source settings are already pre-defined by the caption stream.
         * All burn-in and DVB-Sub font settings must match.
         * 
         * @param alignment
         *        If no explicit xPosition or yPosition is provided, setting alignment to centered will place the
         *        captions at the bottom center of the output. Similarly, setting a left alignment will align captions
         *        to the bottom left of the output. If x and y positions are given in conjunction with the alignment
         *        parameter, the font will be justified (either left or centered) relative to those coordinates.
         *        Selecting "smart" justification will left-justify live subtitles and center-justify pre-recorded
         *        subtitles. This option is not valid for source captions that are STL or 608/embedded. These source
         *        settings are already pre-defined by the caption stream. All burn-in and DVB-Sub font settings must
         *        match.
         * @see DvbSubDestinationAlignment
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DvbSubDestinationAlignment
         */
        Builder alignment(String alignment);

        /**
         * If no explicit xPosition or yPosition is provided, setting alignment to centered will place the captions at
         * the bottom center of the output. Similarly, setting a left alignment will align captions to the bottom left
         * of the output. If x and y positions are given in conjunction with the alignment parameter, the font will be
         * justified (either left or centered) relative to those coordinates. Selecting "smart" justification will
         * left-justify live subtitles and center-justify pre-recorded subtitles. This option is not valid for source
         * captions that are STL or 608/embedded. These source settings are already pre-defined by the caption stream.
         * All burn-in and DVB-Sub font settings must match.
         * 
         * @param alignment
         *        If no explicit xPosition or yPosition is provided, setting alignment to centered will place the
         *        captions at the bottom center of the output. Similarly, setting a left alignment will align captions
         *        to the bottom left of the output. If x and y positions are given in conjunction with the alignment
         *        parameter, the font will be justified (either left or centered) relative to those coordinates.
         *        Selecting "smart" justification will left-justify live subtitles and center-justify pre-recorded
         *        subtitles. This option is not valid for source captions that are STL or 608/embedded. These source
         *        settings are already pre-defined by the caption stream. All burn-in and DVB-Sub font settings must
         *        match.
         * @see DvbSubDestinationAlignment
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DvbSubDestinationAlignment
         */
        Builder alignment(DvbSubDestinationAlignment alignment);

        /**
         * Specifies the color of the rectangle behind the captions. All burn-in and DVB-Sub font settings must match.
         * 
         * @param backgroundColor
         *        Specifies the color of the rectangle behind the captions. All burn-in and DVB-Sub font settings must
         *        match.
         * @see DvbSubDestinationBackgroundColor
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DvbSubDestinationBackgroundColor
         */
        Builder backgroundColor(String backgroundColor);

        /**
         * Specifies the color of the rectangle behind the captions. All burn-in and DVB-Sub font settings must match.
         * 
         * @param backgroundColor
         *        Specifies the color of the rectangle behind the captions. All burn-in and DVB-Sub font settings must
         *        match.
         * @see DvbSubDestinationBackgroundColor
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DvbSubDestinationBackgroundColor
         */
        Builder backgroundColor(DvbSubDestinationBackgroundColor backgroundColor);

        /**
         * Specifies the opacity of the background rectangle. 255 is opaque; 0 is transparent. Leaving this parameter
         * blank is equivalent to setting it to 0 (transparent). All burn-in and DVB-Sub font settings must match.
         * 
         * @param backgroundOpacity
         *        Specifies the opacity of the background rectangle. 255 is opaque; 0 is transparent. Leaving this
         *        parameter blank is equivalent to setting it to 0 (transparent). All burn-in and DVB-Sub font settings
         *        must match.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder backgroundOpacity(Integer backgroundOpacity);

        /**
         * External font file used for caption burn-in. File extension must be 'ttf' or 'tte'. Although the user can
         * select output fonts for many different types of input captions, embedded, STL and teletext sources use a
         * strict grid system. Using external fonts with these caption sources could cause unexpected display of
         * proportional fonts. All burn-in and DVB-Sub font settings must match.
         * 
         * @param font
         *        External font file used for caption burn-in. File extension must be 'ttf' or 'tte'. Although the user
         *        can select output fonts for many different types of input captions, embedded, STL and teletext sources
         *        use a strict grid system. Using external fonts with these caption sources could cause unexpected
         *        display of proportional fonts. All burn-in and DVB-Sub font settings must match.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder font(InputLocation font);

        /**
         * External font file used for caption burn-in. File extension must be 'ttf' or 'tte'. Although the user can
         * select output fonts for many different types of input captions, embedded, STL and teletext sources use a
         * strict grid system. Using external fonts with these caption sources could cause unexpected display of
         * proportional fonts. All burn-in and DVB-Sub font settings must match. This is a convenience that creates an
         * instance of the {@link InputLocation.Builder} avoiding the need to create one manually via
         * {@link InputLocation#builder()}.
         *
         * When the {@link Consumer} completes, {@link InputLocation.Builder#build()} is called immediately and its
         * result is passed to {@link #font(InputLocation)}.
         * 
         * @param font
         *        a consumer that will call methods on {@link InputLocation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #font(InputLocation)
         */
        default Builder font(Consumer<InputLocation.Builder> font) {
            return font(InputLocation.builder().applyMutation(font).build());
        }

        /**
         * Specifies the color of the burned-in captions. This option is not valid for source captions that are STL,
         * 608/embedded or teletext. These source settings are already pre-defined by the caption stream. All burn-in
         * and DVB-Sub font settings must match.
         * 
         * @param fontColor
         *        Specifies the color of the burned-in captions. This option is not valid for source captions that are
         *        STL, 608/embedded or teletext. These source settings are already pre-defined by the caption stream.
         *        All burn-in and DVB-Sub font settings must match.
         * @see DvbSubDestinationFontColor
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DvbSubDestinationFontColor
         */
        Builder fontColor(String fontColor);

        /**
         * Specifies the color of the burned-in captions. This option is not valid for source captions that are STL,
         * 608/embedded or teletext. These source settings are already pre-defined by the caption stream. All burn-in
         * and DVB-Sub font settings must match.
         * 
         * @param fontColor
         *        Specifies the color of the burned-in captions. This option is not valid for source captions that are
         *        STL, 608/embedded or teletext. These source settings are already pre-defined by the caption stream.
         *        All burn-in and DVB-Sub font settings must match.
         * @see DvbSubDestinationFontColor
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DvbSubDestinationFontColor
         */
        Builder fontColor(DvbSubDestinationFontColor fontColor);

        /**
         * Specifies the opacity of the burned-in captions. 255 is opaque; 0 is transparent. All burn-in and DVB-Sub
         * font settings must match.
         * 
         * @param fontOpacity
         *        Specifies the opacity of the burned-in captions. 255 is opaque; 0 is transparent. All burn-in and
         *        DVB-Sub font settings must match.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fontOpacity(Integer fontOpacity);

        /**
         * Font resolution in DPI (dots per inch); default is 96 dpi. All burn-in and DVB-Sub font settings must match.
         * 
         * @param fontResolution
         *        Font resolution in DPI (dots per inch); default is 96 dpi. All burn-in and DVB-Sub font settings must
         *        match.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fontResolution(Integer fontResolution);

        /**
         * When set to auto fontSize will scale depending on the size of the output. Giving a positive integer will
         * specify the exact font size in points. All burn-in and DVB-Sub font settings must match.
         * 
         * @param fontSize
         *        When set to auto fontSize will scale depending on the size of the output. Giving a positive integer
         *        will specify the exact font size in points. All burn-in and DVB-Sub font settings must match.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fontSize(String fontSize);

        /**
         * Specifies font outline color. This option is not valid for source captions that are either 608/embedded or
         * teletext. These source settings are already pre-defined by the caption stream. All burn-in and DVB-Sub font
         * settings must match.
         * 
         * @param outlineColor
         *        Specifies font outline color. This option is not valid for source captions that are either
         *        608/embedded or teletext. These source settings are already pre-defined by the caption stream. All
         *        burn-in and DVB-Sub font settings must match.
         * @see DvbSubDestinationOutlineColor
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DvbSubDestinationOutlineColor
         */
        Builder outlineColor(String outlineColor);

        /**
         * Specifies font outline color. This option is not valid for source captions that are either 608/embedded or
         * teletext. These source settings are already pre-defined by the caption stream. All burn-in and DVB-Sub font
         * settings must match.
         * 
         * @param outlineColor
         *        Specifies font outline color. This option is not valid for source captions that are either
         *        608/embedded or teletext. These source settings are already pre-defined by the caption stream. All
         *        burn-in and DVB-Sub font settings must match.
         * @see DvbSubDestinationOutlineColor
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DvbSubDestinationOutlineColor
         */
        Builder outlineColor(DvbSubDestinationOutlineColor outlineColor);

        /**
         * Specifies font outline size in pixels. This option is not valid for source captions that are either
         * 608/embedded or teletext. These source settings are already pre-defined by the caption stream. All burn-in
         * and DVB-Sub font settings must match.
         * 
         * @param outlineSize
         *        Specifies font outline size in pixels. This option is not valid for source captions that are either
         *        608/embedded or teletext. These source settings are already pre-defined by the caption stream. All
         *        burn-in and DVB-Sub font settings must match.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outlineSize(Integer outlineSize);

        /**
         * Specifies the color of the shadow cast by the captions. All burn-in and DVB-Sub font settings must match.
         * 
         * @param shadowColor
         *        Specifies the color of the shadow cast by the captions. All burn-in and DVB-Sub font settings must
         *        match.
         * @see DvbSubDestinationShadowColor
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DvbSubDestinationShadowColor
         */
        Builder shadowColor(String shadowColor);

        /**
         * Specifies the color of the shadow cast by the captions. All burn-in and DVB-Sub font settings must match.
         * 
         * @param shadowColor
         *        Specifies the color of the shadow cast by the captions. All burn-in and DVB-Sub font settings must
         *        match.
         * @see DvbSubDestinationShadowColor
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DvbSubDestinationShadowColor
         */
        Builder shadowColor(DvbSubDestinationShadowColor shadowColor);

        /**
         * Specifies the opacity of the shadow. 255 is opaque; 0 is transparent. Leaving this parameter blank is
         * equivalent to setting it to 0 (transparent). All burn-in and DVB-Sub font settings must match.
         * 
         * @param shadowOpacity
         *        Specifies the opacity of the shadow. 255 is opaque; 0 is transparent. Leaving this parameter blank is
         *        equivalent to setting it to 0 (transparent). All burn-in and DVB-Sub font settings must match.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder shadowOpacity(Integer shadowOpacity);

        /**
         * Specifies the horizontal offset of the shadow relative to the captions in pixels. A value of -2 would result
         * in a shadow offset 2 pixels to the left. All burn-in and DVB-Sub font settings must match.
         * 
         * @param shadowXOffset
         *        Specifies the horizontal offset of the shadow relative to the captions in pixels. A value of -2 would
         *        result in a shadow offset 2 pixels to the left. All burn-in and DVB-Sub font settings must match.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder shadowXOffset(Integer shadowXOffset);

        /**
         * Specifies the vertical offset of the shadow relative to the captions in pixels. A value of -2 would result in
         * a shadow offset 2 pixels above the text. All burn-in and DVB-Sub font settings must match.
         * 
         * @param shadowYOffset
         *        Specifies the vertical offset of the shadow relative to the captions in pixels. A value of -2 would
         *        result in a shadow offset 2 pixels above the text. All burn-in and DVB-Sub font settings must match.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder shadowYOffset(Integer shadowYOffset);

        /**
         * Controls whether a fixed grid size will be used to generate the output subtitles bitmap. Only applicable for
         * Teletext inputs and DVB-Sub/Burn-in outputs.
         * 
         * @param teletextGridControl
         *        Controls whether a fixed grid size will be used to generate the output subtitles bitmap. Only
         *        applicable for Teletext inputs and DVB-Sub/Burn-in outputs.
         * @see DvbSubDestinationTeletextGridControl
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DvbSubDestinationTeletextGridControl
         */
        Builder teletextGridControl(String teletextGridControl);

        /**
         * Controls whether a fixed grid size will be used to generate the output subtitles bitmap. Only applicable for
         * Teletext inputs and DVB-Sub/Burn-in outputs.
         * 
         * @param teletextGridControl
         *        Controls whether a fixed grid size will be used to generate the output subtitles bitmap. Only
         *        applicable for Teletext inputs and DVB-Sub/Burn-in outputs.
         * @see DvbSubDestinationTeletextGridControl
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DvbSubDestinationTeletextGridControl
         */
        Builder teletextGridControl(DvbSubDestinationTeletextGridControl teletextGridControl);

        /**
         * Specifies the horizontal position of the caption relative to the left side of the output in pixels. A value
         * of 10 would result in the captions starting 10 pixels from the left of the output. If no explicit xPosition
         * is provided, the horizontal caption position will be determined by the alignment parameter. This option is
         * not valid for source captions that are STL, 608/embedded or teletext. These source settings are already
         * pre-defined by the caption stream. All burn-in and DVB-Sub font settings must match.
         * 
         * @param xPosition
         *        Specifies the horizontal position of the caption relative to the left side of the output in pixels. A
         *        value of 10 would result in the captions starting 10 pixels from the left of the output. If no
         *        explicit xPosition is provided, the horizontal caption position will be determined by the alignment
         *        parameter. This option is not valid for source captions that are STL, 608/embedded or teletext. These
         *        source settings are already pre-defined by the caption stream. All burn-in and DVB-Sub font settings
         *        must match.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder xPosition(Integer xPosition);

        /**
         * Specifies the vertical position of the caption relative to the top of the output in pixels. A value of 10
         * would result in the captions starting 10 pixels from the top of the output. If no explicit yPosition is
         * provided, the caption will be positioned towards the bottom of the output. This option is not valid for
         * source captions that are STL, 608/embedded or teletext. These source settings are already pre-defined by the
         * caption stream. All burn-in and DVB-Sub font settings must match.
         * 
         * @param yPosition
         *        Specifies the vertical position of the caption relative to the top of the output in pixels. A value of
         *        10 would result in the captions starting 10 pixels from the top of the output. If no explicit
         *        yPosition is provided, the caption will be positioned towards the bottom of the output. This option is
         *        not valid for source captions that are STL, 608/embedded or teletext. These source settings are
         *        already pre-defined by the caption stream. All burn-in and DVB-Sub font settings must match.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder yPosition(Integer yPosition);
    }

    static final class BuilderImpl implements Builder {
        private String alignment;

        private String backgroundColor;

        private Integer backgroundOpacity;

        private InputLocation font;

        private String fontColor;

        private Integer fontOpacity;

        private Integer fontResolution;

        private String fontSize;

        private String outlineColor;

        private Integer outlineSize;

        private String shadowColor;

        private Integer shadowOpacity;

        private Integer shadowXOffset;

        private Integer shadowYOffset;

        private String teletextGridControl;

        private Integer xPosition;

        private Integer yPosition;

        private BuilderImpl() {
        }

        private BuilderImpl(DvbSubDestinationSettings model) {
            alignment(model.alignment);
            backgroundColor(model.backgroundColor);
            backgroundOpacity(model.backgroundOpacity);
            font(model.font);
            fontColor(model.fontColor);
            fontOpacity(model.fontOpacity);
            fontResolution(model.fontResolution);
            fontSize(model.fontSize);
            outlineColor(model.outlineColor);
            outlineSize(model.outlineSize);
            shadowColor(model.shadowColor);
            shadowOpacity(model.shadowOpacity);
            shadowXOffset(model.shadowXOffset);
            shadowYOffset(model.shadowYOffset);
            teletextGridControl(model.teletextGridControl);
            xPosition(model.xPosition);
            yPosition(model.yPosition);
        }

        public final String getAlignmentAsString() {
            return alignment;
        }

        @Override
        public final Builder alignment(String alignment) {
            this.alignment = alignment;
            return this;
        }

        @Override
        public final Builder alignment(DvbSubDestinationAlignment alignment) {
            this.alignment(alignment == null ? null : alignment.toString());
            return this;
        }

        public final void setAlignment(String alignment) {
            this.alignment = alignment;
        }

        public final String getBackgroundColorAsString() {
            return backgroundColor;
        }

        @Override
        public final Builder backgroundColor(String backgroundColor) {
            this.backgroundColor = backgroundColor;
            return this;
        }

        @Override
        public final Builder backgroundColor(DvbSubDestinationBackgroundColor backgroundColor) {
            this.backgroundColor(backgroundColor == null ? null : backgroundColor.toString());
            return this;
        }

        public final void setBackgroundColor(String backgroundColor) {
            this.backgroundColor = backgroundColor;
        }

        public final Integer getBackgroundOpacity() {
            return backgroundOpacity;
        }

        @Override
        public final Builder backgroundOpacity(Integer backgroundOpacity) {
            this.backgroundOpacity = backgroundOpacity;
            return this;
        }

        public final void setBackgroundOpacity(Integer backgroundOpacity) {
            this.backgroundOpacity = backgroundOpacity;
        }

        public final InputLocation.Builder getFont() {
            return font != null ? font.toBuilder() : null;
        }

        @Override
        public final Builder font(InputLocation font) {
            this.font = font;
            return this;
        }

        public final void setFont(InputLocation.BuilderImpl font) {
            this.font = font != null ? font.build() : null;
        }

        public final String getFontColorAsString() {
            return fontColor;
        }

        @Override
        public final Builder fontColor(String fontColor) {
            this.fontColor = fontColor;
            return this;
        }

        @Override
        public final Builder fontColor(DvbSubDestinationFontColor fontColor) {
            this.fontColor(fontColor == null ? null : fontColor.toString());
            return this;
        }

        public final void setFontColor(String fontColor) {
            this.fontColor = fontColor;
        }

        public final Integer getFontOpacity() {
            return fontOpacity;
        }

        @Override
        public final Builder fontOpacity(Integer fontOpacity) {
            this.fontOpacity = fontOpacity;
            return this;
        }

        public final void setFontOpacity(Integer fontOpacity) {
            this.fontOpacity = fontOpacity;
        }

        public final Integer getFontResolution() {
            return fontResolution;
        }

        @Override
        public final Builder fontResolution(Integer fontResolution) {
            this.fontResolution = fontResolution;
            return this;
        }

        public final void setFontResolution(Integer fontResolution) {
            this.fontResolution = fontResolution;
        }

        public final String getFontSize() {
            return fontSize;
        }

        @Override
        public final Builder fontSize(String fontSize) {
            this.fontSize = fontSize;
            return this;
        }

        public final void setFontSize(String fontSize) {
            this.fontSize = fontSize;
        }

        public final String getOutlineColorAsString() {
            return outlineColor;
        }

        @Override
        public final Builder outlineColor(String outlineColor) {
            this.outlineColor = outlineColor;
            return this;
        }

        @Override
        public final Builder outlineColor(DvbSubDestinationOutlineColor outlineColor) {
            this.outlineColor(outlineColor == null ? null : outlineColor.toString());
            return this;
        }

        public final void setOutlineColor(String outlineColor) {
            this.outlineColor = outlineColor;
        }

        public final Integer getOutlineSize() {
            return outlineSize;
        }

        @Override
        public final Builder outlineSize(Integer outlineSize) {
            this.outlineSize = outlineSize;
            return this;
        }

        public final void setOutlineSize(Integer outlineSize) {
            this.outlineSize = outlineSize;
        }

        public final String getShadowColorAsString() {
            return shadowColor;
        }

        @Override
        public final Builder shadowColor(String shadowColor) {
            this.shadowColor = shadowColor;
            return this;
        }

        @Override
        public final Builder shadowColor(DvbSubDestinationShadowColor shadowColor) {
            this.shadowColor(shadowColor == null ? null : shadowColor.toString());
            return this;
        }

        public final void setShadowColor(String shadowColor) {
            this.shadowColor = shadowColor;
        }

        public final Integer getShadowOpacity() {
            return shadowOpacity;
        }

        @Override
        public final Builder shadowOpacity(Integer shadowOpacity) {
            this.shadowOpacity = shadowOpacity;
            return this;
        }

        public final void setShadowOpacity(Integer shadowOpacity) {
            this.shadowOpacity = shadowOpacity;
        }

        public final Integer getShadowXOffset() {
            return shadowXOffset;
        }

        @Override
        public final Builder shadowXOffset(Integer shadowXOffset) {
            this.shadowXOffset = shadowXOffset;
            return this;
        }

        public final void setShadowXOffset(Integer shadowXOffset) {
            this.shadowXOffset = shadowXOffset;
        }

        public final Integer getShadowYOffset() {
            return shadowYOffset;
        }

        @Override
        public final Builder shadowYOffset(Integer shadowYOffset) {
            this.shadowYOffset = shadowYOffset;
            return this;
        }

        public final void setShadowYOffset(Integer shadowYOffset) {
            this.shadowYOffset = shadowYOffset;
        }

        public final String getTeletextGridControlAsString() {
            return teletextGridControl;
        }

        @Override
        public final Builder teletextGridControl(String teletextGridControl) {
            this.teletextGridControl = teletextGridControl;
            return this;
        }

        @Override
        public final Builder teletextGridControl(DvbSubDestinationTeletextGridControl teletextGridControl) {
            this.teletextGridControl(teletextGridControl == null ? null : teletextGridControl.toString());
            return this;
        }

        public final void setTeletextGridControl(String teletextGridControl) {
            this.teletextGridControl = teletextGridControl;
        }

        public final Integer getXPosition() {
            return xPosition;
        }

        @Override
        public final Builder xPosition(Integer xPosition) {
            this.xPosition = xPosition;
            return this;
        }

        public final void setXPosition(Integer xPosition) {
            this.xPosition = xPosition;
        }

        public final Integer getYPosition() {
            return yPosition;
        }

        @Override
        public final Builder yPosition(Integer yPosition) {
            this.yPosition = yPosition;
            return this;
        }

        public final void setYPosition(Integer yPosition) {
            this.yPosition = yPosition;
        }

        @Override
        public DvbSubDestinationSettings build() {
            return new DvbSubDestinationSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
