/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * DVB Network Information Table (NIT)
 */
@Generated("software.amazon.awssdk:codegen")
public final class DvbNitSettings implements SdkPojo, Serializable, ToCopyableBuilder<DvbNitSettings.Builder, DvbNitSettings> {
    private static final SdkField<Integer> NETWORK_ID_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(DvbNitSettings::networkId)).setter(setter(Builder::networkId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("networkId").build()).build();

    private static final SdkField<String> NETWORK_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DvbNitSettings::networkName)).setter(setter(Builder::networkName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("networkName").build()).build();

    private static final SdkField<Integer> REP_INTERVAL_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(DvbNitSettings::repInterval)).setter(setter(Builder::repInterval))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("repInterval").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NETWORK_ID_FIELD,
            NETWORK_NAME_FIELD, REP_INTERVAL_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer networkId;

    private final String networkName;

    private final Integer repInterval;

    private DvbNitSettings(BuilderImpl builder) {
        this.networkId = builder.networkId;
        this.networkName = builder.networkName;
        this.repInterval = builder.repInterval;
    }

    /**
     * The numeric value placed in the Network Information Table (NIT).
     * 
     * @return The numeric value placed in the Network Information Table (NIT).
     */
    public Integer networkId() {
        return networkId;
    }

    /**
     * The network name text placed in the networkNameDescriptor inside the Network Information Table. Maximum length is
     * 256 characters.
     * 
     * @return The network name text placed in the networkNameDescriptor inside the Network Information Table. Maximum
     *         length is 256 characters.
     */
    public String networkName() {
        return networkName;
    }

    /**
     * The number of milliseconds between instances of this table in the output transport stream.
     * 
     * @return The number of milliseconds between instances of this table in the output transport stream.
     */
    public Integer repInterval() {
        return repInterval;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(networkId());
        hashCode = 31 * hashCode + Objects.hashCode(networkName());
        hashCode = 31 * hashCode + Objects.hashCode(repInterval());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DvbNitSettings)) {
            return false;
        }
        DvbNitSettings other = (DvbNitSettings) obj;
        return Objects.equals(networkId(), other.networkId()) && Objects.equals(networkName(), other.networkName())
                && Objects.equals(repInterval(), other.repInterval());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DvbNitSettings").add("NetworkId", networkId()).add("NetworkName", networkName())
                .add("RepInterval", repInterval()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NetworkId":
            return Optional.ofNullable(clazz.cast(networkId()));
        case "NetworkName":
            return Optional.ofNullable(clazz.cast(networkName()));
        case "RepInterval":
            return Optional.ofNullable(clazz.cast(repInterval()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DvbNitSettings, T> g) {
        return obj -> g.apply((DvbNitSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DvbNitSettings> {
        /**
         * The numeric value placed in the Network Information Table (NIT).
         * 
         * @param networkId
         *        The numeric value placed in the Network Information Table (NIT).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkId(Integer networkId);

        /**
         * The network name text placed in the networkNameDescriptor inside the Network Information Table. Maximum
         * length is 256 characters.
         * 
         * @param networkName
         *        The network name text placed in the networkNameDescriptor inside the Network Information Table.
         *        Maximum length is 256 characters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkName(String networkName);

        /**
         * The number of milliseconds between instances of this table in the output transport stream.
         * 
         * @param repInterval
         *        The number of milliseconds between instances of this table in the output transport stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder repInterval(Integer repInterval);
    }

    static final class BuilderImpl implements Builder {
        private Integer networkId;

        private String networkName;

        private Integer repInterval;

        private BuilderImpl() {
        }

        private BuilderImpl(DvbNitSettings model) {
            networkId(model.networkId);
            networkName(model.networkName);
            repInterval(model.repInterval);
        }

        public final Integer getNetworkId() {
            return networkId;
        }

        @Override
        public final Builder networkId(Integer networkId) {
            this.networkId = networkId;
            return this;
        }

        public final void setNetworkId(Integer networkId) {
            this.networkId = networkId;
        }

        public final String getNetworkName() {
            return networkName;
        }

        @Override
        public final Builder networkName(String networkName) {
            this.networkName = networkName;
            return this;
        }

        public final void setNetworkName(String networkName) {
            this.networkName = networkName;
        }

        public final Integer getRepInterval() {
            return repInterval;
        }

        @Override
        public final Builder repInterval(Integer repInterval) {
            this.repInterval = repInterval;
            return this;
        }

        public final void setRepInterval(Integer repInterval) {
            this.repInterval = repInterval;
        }

        @Override
        public DvbNitSettings build() {
            return new DvbNitSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
