/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Placeholder documentation for DescribeInputSecurityGroupResponse
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeInputSecurityGroupResponse extends MediaLiveResponse implements
        ToCopyableBuilder<DescribeInputSecurityGroupResponse.Builder, DescribeInputSecurityGroupResponse> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeInputSecurityGroupResponse::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeInputSecurityGroupResponse::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<List<String>> INPUTS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(DescribeInputSecurityGroupResponse::inputs))
            .setter(setter(Builder::inputs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputs").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeInputSecurityGroupResponse::stateAsString)).setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("state").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .getter(getter(DescribeInputSecurityGroupResponse::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<List<InputWhitelistRule>> WHITELIST_RULES_FIELD = SdkField
            .<List<InputWhitelistRule>> builder(MarshallingType.LIST)
            .getter(getter(DescribeInputSecurityGroupResponse::whitelistRules))
            .setter(setter(Builder::whitelistRules))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("whitelistRules").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<InputWhitelistRule> builder(MarshallingType.SDK_POJO)
                                            .constructor(InputWhitelistRule::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, ID_FIELD,
            INPUTS_FIELD, STATE_FIELD, TAGS_FIELD, WHITELIST_RULES_FIELD));

    private final String arn;

    private final String id;

    private final List<String> inputs;

    private final String state;

    private final Map<String, String> tags;

    private final List<InputWhitelistRule> whitelistRules;

    private DescribeInputSecurityGroupResponse(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.id = builder.id;
        this.inputs = builder.inputs;
        this.state = builder.state;
        this.tags = builder.tags;
        this.whitelistRules = builder.whitelistRules;
    }

    /**
     * Unique ARN of Input Security Group
     * 
     * @return Unique ARN of Input Security Group
     */
    public String arn() {
        return arn;
    }

    /**
     * The Id of the Input Security Group
     * 
     * @return The Id of the Input Security Group
     */
    public String id() {
        return id;
    }

    /**
     * Returns true if the Inputs property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasInputs() {
        return inputs != null && !(inputs instanceof SdkAutoConstructList);
    }

    /**
     * The list of inputs currently using this Input Security Group.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasInputs()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The list of inputs currently using this Input Security Group.
     */
    public List<String> inputs() {
        return inputs;
    }

    /**
     * The current state of the Input Security Group.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link InputSecurityGroupState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The current state of the Input Security Group.
     * @see InputSecurityGroupState
     */
    public InputSecurityGroupState state() {
        return InputSecurityGroupState.fromValue(state);
    }

    /**
     * The current state of the Input Security Group.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link InputSecurityGroupState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The current state of the Input Security Group.
     * @see InputSecurityGroupState
     */
    public String stateAsString() {
        return state;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * A collection of key-value pairs.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A collection of key-value pairs.
     */
    public Map<String, String> tags() {
        return tags;
    }

    /**
     * Returns true if the WhitelistRules property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasWhitelistRules() {
        return whitelistRules != null && !(whitelistRules instanceof SdkAutoConstructList);
    }

    /**
     * Whitelist rules and their sync status
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasWhitelistRules()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Whitelist rules and their sync status
     */
    public List<InputWhitelistRule> whitelistRules() {
        return whitelistRules;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(inputs());
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(tags());
        hashCode = 31 * hashCode + Objects.hashCode(whitelistRules());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeInputSecurityGroupResponse)) {
            return false;
        }
        DescribeInputSecurityGroupResponse other = (DescribeInputSecurityGroupResponse) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(id(), other.id()) && Objects.equals(inputs(), other.inputs())
                && Objects.equals(stateAsString(), other.stateAsString()) && Objects.equals(tags(), other.tags())
                && Objects.equals(whitelistRules(), other.whitelistRules());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeInputSecurityGroupResponse").add("Arn", arn()).add("Id", id()).add("Inputs", inputs())
                .add("State", stateAsString()).add("Tags", tags()).add("WhitelistRules", whitelistRules()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "Inputs":
            return Optional.ofNullable(clazz.cast(inputs()));
        case "State":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "WhitelistRules":
            return Optional.ofNullable(clazz.cast(whitelistRules()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeInputSecurityGroupResponse, T> g) {
        return obj -> g.apply((DescribeInputSecurityGroupResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MediaLiveResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeInputSecurityGroupResponse> {
        /**
         * Unique ARN of Input Security Group
         * 
         * @param arn
         *        Unique ARN of Input Security Group
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * The Id of the Input Security Group
         * 
         * @param id
         *        The Id of the Input Security Group
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * The list of inputs currently using this Input Security Group.
         * 
         * @param inputs
         *        The list of inputs currently using this Input Security Group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputs(Collection<String> inputs);

        /**
         * The list of inputs currently using this Input Security Group.
         * 
         * @param inputs
         *        The list of inputs currently using this Input Security Group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputs(String... inputs);

        /**
         * The current state of the Input Security Group.
         * 
         * @param state
         *        The current state of the Input Security Group.
         * @see InputSecurityGroupState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InputSecurityGroupState
         */
        Builder state(String state);

        /**
         * The current state of the Input Security Group.
         * 
         * @param state
         *        The current state of the Input Security Group.
         * @see InputSecurityGroupState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InputSecurityGroupState
         */
        Builder state(InputSecurityGroupState state);

        /**
         * A collection of key-value pairs.
         * 
         * @param tags
         *        A collection of key-value pairs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * Whitelist rules and their sync status
         * 
         * @param whitelistRules
         *        Whitelist rules and their sync status
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder whitelistRules(Collection<InputWhitelistRule> whitelistRules);

        /**
         * Whitelist rules and their sync status
         * 
         * @param whitelistRules
         *        Whitelist rules and their sync status
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder whitelistRules(InputWhitelistRule... whitelistRules);

        /**
         * Whitelist rules and their sync status This is a convenience that creates an instance of the {@link List
         * <InputWhitelistRule>.Builder} avoiding the need to create one manually via {@link List
         * <InputWhitelistRule>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<InputWhitelistRule>.Builder#build()} is called immediately
         * and its result is passed to {@link #whitelistRules(List<InputWhitelistRule>)}.
         * 
         * @param whitelistRules
         *        a consumer that will call methods on {@link List<InputWhitelistRule>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #whitelistRules(List<InputWhitelistRule>)
         */
        Builder whitelistRules(Consumer<InputWhitelistRule.Builder>... whitelistRules);
    }

    static final class BuilderImpl extends MediaLiveResponse.BuilderImpl implements Builder {
        private String arn;

        private String id;

        private List<String> inputs = DefaultSdkAutoConstructList.getInstance();

        private String state;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private List<InputWhitelistRule> whitelistRules = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeInputSecurityGroupResponse model) {
            super(model);
            arn(model.arn);
            id(model.id);
            inputs(model.inputs);
            state(model.state);
            tags(model.tags);
            whitelistRules(model.whitelistRules);
        }

        public final String getArn() {
            return arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getId() {
            return id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final Collection<String> getInputs() {
            return inputs;
        }

        @Override
        public final Builder inputs(Collection<String> inputs) {
            this.inputs = ___listOf__stringCopier.copy(inputs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputs(String... inputs) {
            inputs(Arrays.asList(inputs));
            return this;
        }

        public final void setInputs(Collection<String> inputs) {
            this.inputs = ___listOf__stringCopier.copy(inputs);
        }

        public final String getStateAsString() {
            return state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(InputSecurityGroupState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final Map<String, String> getTags() {
            return tags;
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        public final Collection<InputWhitelistRule.Builder> getWhitelistRules() {
            return whitelistRules != null ? whitelistRules.stream().map(InputWhitelistRule::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder whitelistRules(Collection<InputWhitelistRule> whitelistRules) {
            this.whitelistRules = ___listOfInputWhitelistRuleCopier.copy(whitelistRules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder whitelistRules(InputWhitelistRule... whitelistRules) {
            whitelistRules(Arrays.asList(whitelistRules));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder whitelistRules(Consumer<InputWhitelistRule.Builder>... whitelistRules) {
            whitelistRules(Stream.of(whitelistRules).map(c -> InputWhitelistRule.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setWhitelistRules(Collection<InputWhitelistRule.BuilderImpl> whitelistRules) {
            this.whitelistRules = ___listOfInputWhitelistRuleCopier.copyFromBuilder(whitelistRules);
        }

        @Override
        public DescribeInputSecurityGroupResponse build() {
            return new DescribeInputSecurityGroupResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
