/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Placeholder documentation for BatchUpdateScheduleResponse
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchUpdateScheduleResponse extends MediaLiveResponse implements
        ToCopyableBuilder<BatchUpdateScheduleResponse.Builder, BatchUpdateScheduleResponse> {
    private static final SdkField<BatchScheduleActionCreateResult> CREATES_FIELD = SdkField
            .<BatchScheduleActionCreateResult> builder(MarshallingType.SDK_POJO)
            .getter(getter(BatchUpdateScheduleResponse::creates)).setter(setter(Builder::creates))
            .constructor(BatchScheduleActionCreateResult::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creates").build()).build();

    private static final SdkField<BatchScheduleActionDeleteResult> DELETES_FIELD = SdkField
            .<BatchScheduleActionDeleteResult> builder(MarshallingType.SDK_POJO)
            .getter(getter(BatchUpdateScheduleResponse::deletes)).setter(setter(Builder::deletes))
            .constructor(BatchScheduleActionDeleteResult::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deletes").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATES_FIELD, DELETES_FIELD));

    private final BatchScheduleActionCreateResult creates;

    private final BatchScheduleActionDeleteResult deletes;

    private BatchUpdateScheduleResponse(BuilderImpl builder) {
        super(builder);
        this.creates = builder.creates;
        this.deletes = builder.deletes;
    }

    /**
     * Schedule actions created in the schedule.
     * 
     * @return Schedule actions created in the schedule.
     */
    public BatchScheduleActionCreateResult creates() {
        return creates;
    }

    /**
     * Schedule actions deleted from the schedule.
     * 
     * @return Schedule actions deleted from the schedule.
     */
    public BatchScheduleActionDeleteResult deletes() {
        return deletes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(creates());
        hashCode = 31 * hashCode + Objects.hashCode(deletes());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchUpdateScheduleResponse)) {
            return false;
        }
        BatchUpdateScheduleResponse other = (BatchUpdateScheduleResponse) obj;
        return Objects.equals(creates(), other.creates()) && Objects.equals(deletes(), other.deletes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("BatchUpdateScheduleResponse").add("Creates", creates()).add("Deletes", deletes()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Creates":
            return Optional.ofNullable(clazz.cast(creates()));
        case "Deletes":
            return Optional.ofNullable(clazz.cast(deletes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchUpdateScheduleResponse, T> g) {
        return obj -> g.apply((BatchUpdateScheduleResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MediaLiveResponse.Builder, SdkPojo, CopyableBuilder<Builder, BatchUpdateScheduleResponse> {
        /**
         * Schedule actions created in the schedule.
         * 
         * @param creates
         *        Schedule actions created in the schedule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creates(BatchScheduleActionCreateResult creates);

        /**
         * Schedule actions created in the schedule. This is a convenience that creates an instance of the
         * {@link BatchScheduleActionCreateResult.Builder} avoiding the need to create one manually via
         * {@link BatchScheduleActionCreateResult#builder()}.
         *
         * When the {@link Consumer} completes, {@link BatchScheduleActionCreateResult.Builder#build()} is called
         * immediately and its result is passed to {@link #creates(BatchScheduleActionCreateResult)}.
         * 
         * @param creates
         *        a consumer that will call methods on {@link BatchScheduleActionCreateResult.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #creates(BatchScheduleActionCreateResult)
         */
        default Builder creates(Consumer<BatchScheduleActionCreateResult.Builder> creates) {
            return creates(BatchScheduleActionCreateResult.builder().applyMutation(creates).build());
        }

        /**
         * Schedule actions deleted from the schedule.
         * 
         * @param deletes
         *        Schedule actions deleted from the schedule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deletes(BatchScheduleActionDeleteResult deletes);

        /**
         * Schedule actions deleted from the schedule. This is a convenience that creates an instance of the
         * {@link BatchScheduleActionDeleteResult.Builder} avoiding the need to create one manually via
         * {@link BatchScheduleActionDeleteResult#builder()}.
         *
         * When the {@link Consumer} completes, {@link BatchScheduleActionDeleteResult.Builder#build()} is called
         * immediately and its result is passed to {@link #deletes(BatchScheduleActionDeleteResult)}.
         * 
         * @param deletes
         *        a consumer that will call methods on {@link BatchScheduleActionDeleteResult.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #deletes(BatchScheduleActionDeleteResult)
         */
        default Builder deletes(Consumer<BatchScheduleActionDeleteResult.Builder> deletes) {
            return deletes(BatchScheduleActionDeleteResult.builder().applyMutation(deletes).build());
        }
    }

    static final class BuilderImpl extends MediaLiveResponse.BuilderImpl implements Builder {
        private BatchScheduleActionCreateResult creates;

        private BatchScheduleActionDeleteResult deletes;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchUpdateScheduleResponse model) {
            super(model);
            creates(model.creates);
            deletes(model.deletes);
        }

        public final BatchScheduleActionCreateResult.Builder getCreates() {
            return creates != null ? creates.toBuilder() : null;
        }

        @Override
        public final Builder creates(BatchScheduleActionCreateResult creates) {
            this.creates = creates;
            return this;
        }

        public final void setCreates(BatchScheduleActionCreateResult.BuilderImpl creates) {
            this.creates = creates != null ? creates.build() : null;
        }

        public final BatchScheduleActionDeleteResult.Builder getDeletes() {
            return deletes != null ? deletes.toBuilder() : null;
        }

        @Override
        public final Builder deletes(BatchScheduleActionDeleteResult deletes) {
            this.deletes = deletes;
            return this;
        }

        public final void setDeletes(BatchScheduleActionDeleteResult.BuilderImpl deletes) {
            this.deletes = deletes != null ? deletes.build() : null;
        }

        @Override
        public BatchUpdateScheduleResponse build() {
            return new BatchUpdateScheduleResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
