/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * List of actions that have been deleted from the schedule.
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchScheduleActionDeleteResult implements SdkPojo, Serializable,
        ToCopyableBuilder<BatchScheduleActionDeleteResult.Builder, BatchScheduleActionDeleteResult> {
    private static final SdkField<List<ScheduleAction>> SCHEDULE_ACTIONS_FIELD = SdkField
            .<List<ScheduleAction>> builder(MarshallingType.LIST)
            .getter(getter(BatchScheduleActionDeleteResult::scheduleActions))
            .setter(setter(Builder::scheduleActions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scheduleActions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ScheduleAction> builder(MarshallingType.SDK_POJO)
                                            .constructor(ScheduleAction::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCHEDULE_ACTIONS_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<ScheduleAction> scheduleActions;

    private BatchScheduleActionDeleteResult(BuilderImpl builder) {
        this.scheduleActions = builder.scheduleActions;
    }

    /**
     * Returns true if the ScheduleActions property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasScheduleActions() {
        return scheduleActions != null && !(scheduleActions instanceof SdkAutoConstructList);
    }

    /**
     * List of actions that have been deleted from the schedule.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasScheduleActions()} to see if a value was sent in this field.
     * </p>
     * 
     * @return List of actions that have been deleted from the schedule.
     */
    public List<ScheduleAction> scheduleActions() {
        return scheduleActions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(scheduleActions());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchScheduleActionDeleteResult)) {
            return false;
        }
        BatchScheduleActionDeleteResult other = (BatchScheduleActionDeleteResult) obj;
        return Objects.equals(scheduleActions(), other.scheduleActions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("BatchScheduleActionDeleteResult").add("ScheduleActions", scheduleActions()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ScheduleActions":
            return Optional.ofNullable(clazz.cast(scheduleActions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchScheduleActionDeleteResult, T> g) {
        return obj -> g.apply((BatchScheduleActionDeleteResult) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BatchScheduleActionDeleteResult> {
        /**
         * List of actions that have been deleted from the schedule.
         * 
         * @param scheduleActions
         *        List of actions that have been deleted from the schedule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scheduleActions(Collection<ScheduleAction> scheduleActions);

        /**
         * List of actions that have been deleted from the schedule.
         * 
         * @param scheduleActions
         *        List of actions that have been deleted from the schedule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scheduleActions(ScheduleAction... scheduleActions);

        /**
         * List of actions that have been deleted from the schedule. This is a convenience that creates an instance of
         * the {@link List<ScheduleAction>.Builder} avoiding the need to create one manually via {@link List
         * <ScheduleAction>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ScheduleAction>.Builder#build()} is called immediately and
         * its result is passed to {@link #scheduleActions(List<ScheduleAction>)}.
         * 
         * @param scheduleActions
         *        a consumer that will call methods on {@link List<ScheduleAction>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #scheduleActions(List<ScheduleAction>)
         */
        Builder scheduleActions(Consumer<ScheduleAction.Builder>... scheduleActions);
    }

    static final class BuilderImpl implements Builder {
        private List<ScheduleAction> scheduleActions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchScheduleActionDeleteResult model) {
            scheduleActions(model.scheduleActions);
        }

        public final Collection<ScheduleAction.Builder> getScheduleActions() {
            return scheduleActions != null ? scheduleActions.stream().map(ScheduleAction::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder scheduleActions(Collection<ScheduleAction> scheduleActions) {
            this.scheduleActions = ___listOfScheduleActionCopier.copy(scheduleActions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scheduleActions(ScheduleAction... scheduleActions) {
            scheduleActions(Arrays.asList(scheduleActions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scheduleActions(Consumer<ScheduleAction.Builder>... scheduleActions) {
            scheduleActions(Stream.of(scheduleActions).map(c -> ScheduleAction.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setScheduleActions(Collection<ScheduleAction.BuilderImpl> scheduleActions) {
            this.scheduleActions = ___listOfScheduleActionCopier.copyFromBuilder(scheduleActions);
        }

        @Override
        public BatchScheduleActionDeleteResult build() {
            return new BatchScheduleActionDeleteResult(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
