/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Avail Settings
 */
@Generated("software.amazon.awssdk:codegen")
public final class AvailSettings implements SdkPojo, Serializable, ToCopyableBuilder<AvailSettings.Builder, AvailSettings> {
    private static final SdkField<Scte35SpliceInsert> SCTE35_SPLICE_INSERT_FIELD = SdkField
            .<Scte35SpliceInsert> builder(MarshallingType.SDK_POJO).getter(getter(AvailSettings::scte35SpliceInsert))
            .setter(setter(Builder::scte35SpliceInsert)).constructor(Scte35SpliceInsert::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scte35SpliceInsert").build())
            .build();

    private static final SdkField<Scte35TimeSignalApos> SCTE35_TIME_SIGNAL_APOS_FIELD = SdkField
            .<Scte35TimeSignalApos> builder(MarshallingType.SDK_POJO).getter(getter(AvailSettings::scte35TimeSignalApos))
            .setter(setter(Builder::scte35TimeSignalApos)).constructor(Scte35TimeSignalApos::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scte35TimeSignalApos").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCTE35_SPLICE_INSERT_FIELD,
            SCTE35_TIME_SIGNAL_APOS_FIELD));

    private static final long serialVersionUID = 1L;

    private final Scte35SpliceInsert scte35SpliceInsert;

    private final Scte35TimeSignalApos scte35TimeSignalApos;

    private AvailSettings(BuilderImpl builder) {
        this.scte35SpliceInsert = builder.scte35SpliceInsert;
        this.scte35TimeSignalApos = builder.scte35TimeSignalApos;
    }

    /**
     * Returns the value of the Scte35SpliceInsert property for this object.
     * 
     * @return The value of the Scte35SpliceInsert property for this object.
     */
    public Scte35SpliceInsert scte35SpliceInsert() {
        return scte35SpliceInsert;
    }

    /**
     * Returns the value of the Scte35TimeSignalApos property for this object.
     * 
     * @return The value of the Scte35TimeSignalApos property for this object.
     */
    public Scte35TimeSignalApos scte35TimeSignalApos() {
        return scte35TimeSignalApos;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(scte35SpliceInsert());
        hashCode = 31 * hashCode + Objects.hashCode(scte35TimeSignalApos());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AvailSettings)) {
            return false;
        }
        AvailSettings other = (AvailSettings) obj;
        return Objects.equals(scte35SpliceInsert(), other.scte35SpliceInsert())
                && Objects.equals(scte35TimeSignalApos(), other.scte35TimeSignalApos());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("AvailSettings").add("Scte35SpliceInsert", scte35SpliceInsert())
                .add("Scte35TimeSignalApos", scte35TimeSignalApos()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Scte35SpliceInsert":
            return Optional.ofNullable(clazz.cast(scte35SpliceInsert()));
        case "Scte35TimeSignalApos":
            return Optional.ofNullable(clazz.cast(scte35TimeSignalApos()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AvailSettings, T> g) {
        return obj -> g.apply((AvailSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AvailSettings> {
        /**
         * Sets the value of the Scte35SpliceInsert property for this object.
         *
         * @param scte35SpliceInsert
         *        The new value for the Scte35SpliceInsert property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scte35SpliceInsert(Scte35SpliceInsert scte35SpliceInsert);

        /**
         * Sets the value of the Scte35SpliceInsert property for this object.
         *
         * This is a convenience that creates an instance of the {@link Scte35SpliceInsert.Builder} avoiding the need to
         * create one manually via {@link Scte35SpliceInsert#builder()}.
         *
         * When the {@link Consumer} completes, {@link Scte35SpliceInsert.Builder#build()} is called immediately and its
         * result is passed to {@link #scte35SpliceInsert(Scte35SpliceInsert)}.
         * 
         * @param scte35SpliceInsert
         *        a consumer that will call methods on {@link Scte35SpliceInsert.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #scte35SpliceInsert(Scte35SpliceInsert)
         */
        default Builder scte35SpliceInsert(Consumer<Scte35SpliceInsert.Builder> scte35SpliceInsert) {
            return scte35SpliceInsert(Scte35SpliceInsert.builder().applyMutation(scte35SpliceInsert).build());
        }

        /**
         * Sets the value of the Scte35TimeSignalApos property for this object.
         *
         * @param scte35TimeSignalApos
         *        The new value for the Scte35TimeSignalApos property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scte35TimeSignalApos(Scte35TimeSignalApos scte35TimeSignalApos);

        /**
         * Sets the value of the Scte35TimeSignalApos property for this object.
         *
         * This is a convenience that creates an instance of the {@link Scte35TimeSignalApos.Builder} avoiding the need
         * to create one manually via {@link Scte35TimeSignalApos#builder()}.
         *
         * When the {@link Consumer} completes, {@link Scte35TimeSignalApos.Builder#build()} is called immediately and
         * its result is passed to {@link #scte35TimeSignalApos(Scte35TimeSignalApos)}.
         * 
         * @param scte35TimeSignalApos
         *        a consumer that will call methods on {@link Scte35TimeSignalApos.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #scte35TimeSignalApos(Scte35TimeSignalApos)
         */
        default Builder scte35TimeSignalApos(Consumer<Scte35TimeSignalApos.Builder> scte35TimeSignalApos) {
            return scte35TimeSignalApos(Scte35TimeSignalApos.builder().applyMutation(scte35TimeSignalApos).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Scte35SpliceInsert scte35SpliceInsert;

        private Scte35TimeSignalApos scte35TimeSignalApos;

        private BuilderImpl() {
        }

        private BuilderImpl(AvailSettings model) {
            scte35SpliceInsert(model.scte35SpliceInsert);
            scte35TimeSignalApos(model.scte35TimeSignalApos);
        }

        public final Scte35SpliceInsert.Builder getScte35SpliceInsert() {
            return scte35SpliceInsert != null ? scte35SpliceInsert.toBuilder() : null;
        }

        @Override
        public final Builder scte35SpliceInsert(Scte35SpliceInsert scte35SpliceInsert) {
            this.scte35SpliceInsert = scte35SpliceInsert;
            return this;
        }

        public final void setScte35SpliceInsert(Scte35SpliceInsert.BuilderImpl scte35SpliceInsert) {
            this.scte35SpliceInsert = scte35SpliceInsert != null ? scte35SpliceInsert.build() : null;
        }

        public final Scte35TimeSignalApos.Builder getScte35TimeSignalApos() {
            return scte35TimeSignalApos != null ? scte35TimeSignalApos.toBuilder() : null;
        }

        @Override
        public final Builder scte35TimeSignalApos(Scte35TimeSignalApos scte35TimeSignalApos) {
            this.scte35TimeSignalApos = scte35TimeSignalApos;
            return this;
        }

        public final void setScte35TimeSignalApos(Scte35TimeSignalApos.BuilderImpl scte35TimeSignalApos) {
            this.scte35TimeSignalApos = scte35TimeSignalApos != null ? scte35TimeSignalApos.build() : null;
        }

        @Override
        public AvailSettings build() {
            return new AvailSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
