/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Audio Codec Settings
 */
@Generated("software.amazon.awssdk:codegen")
public final class AudioCodecSettings implements SdkPojo, Serializable,
        ToCopyableBuilder<AudioCodecSettings.Builder, AudioCodecSettings> {
    private static final SdkField<AacSettings> AAC_SETTINGS_FIELD = SdkField.<AacSettings> builder(MarshallingType.SDK_POJO)
            .getter(getter(AudioCodecSettings::aacSettings)).setter(setter(Builder::aacSettings))
            .constructor(AacSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("aacSettings").build()).build();

    private static final SdkField<Ac3Settings> AC3_SETTINGS_FIELD = SdkField.<Ac3Settings> builder(MarshallingType.SDK_POJO)
            .getter(getter(AudioCodecSettings::ac3Settings)).setter(setter(Builder::ac3Settings))
            .constructor(Ac3Settings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ac3Settings").build()).build();

    private static final SdkField<Eac3Settings> EAC3_SETTINGS_FIELD = SdkField.<Eac3Settings> builder(MarshallingType.SDK_POJO)
            .getter(getter(AudioCodecSettings::eac3Settings)).setter(setter(Builder::eac3Settings))
            .constructor(Eac3Settings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eac3Settings").build()).build();

    private static final SdkField<Mp2Settings> MP2_SETTINGS_FIELD = SdkField.<Mp2Settings> builder(MarshallingType.SDK_POJO)
            .getter(getter(AudioCodecSettings::mp2Settings)).setter(setter(Builder::mp2Settings))
            .constructor(Mp2Settings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mp2Settings").build()).build();

    private static final SdkField<PassThroughSettings> PASS_THROUGH_SETTINGS_FIELD = SdkField
            .<PassThroughSettings> builder(MarshallingType.SDK_POJO).getter(getter(AudioCodecSettings::passThroughSettings))
            .setter(setter(Builder::passThroughSettings)).constructor(PassThroughSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("passThroughSettings").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AAC_SETTINGS_FIELD,
            AC3_SETTINGS_FIELD, EAC3_SETTINGS_FIELD, MP2_SETTINGS_FIELD, PASS_THROUGH_SETTINGS_FIELD));

    private static final long serialVersionUID = 1L;

    private final AacSettings aacSettings;

    private final Ac3Settings ac3Settings;

    private final Eac3Settings eac3Settings;

    private final Mp2Settings mp2Settings;

    private final PassThroughSettings passThroughSettings;

    private AudioCodecSettings(BuilderImpl builder) {
        this.aacSettings = builder.aacSettings;
        this.ac3Settings = builder.ac3Settings;
        this.eac3Settings = builder.eac3Settings;
        this.mp2Settings = builder.mp2Settings;
        this.passThroughSettings = builder.passThroughSettings;
    }

    /**
     * Returns the value of the AacSettings property for this object.
     * 
     * @return The value of the AacSettings property for this object.
     */
    public AacSettings aacSettings() {
        return aacSettings;
    }

    /**
     * Returns the value of the Ac3Settings property for this object.
     * 
     * @return The value of the Ac3Settings property for this object.
     */
    public Ac3Settings ac3Settings() {
        return ac3Settings;
    }

    /**
     * Returns the value of the Eac3Settings property for this object.
     * 
     * @return The value of the Eac3Settings property for this object.
     */
    public Eac3Settings eac3Settings() {
        return eac3Settings;
    }

    /**
     * Returns the value of the Mp2Settings property for this object.
     * 
     * @return The value of the Mp2Settings property for this object.
     */
    public Mp2Settings mp2Settings() {
        return mp2Settings;
    }

    /**
     * Returns the value of the PassThroughSettings property for this object.
     * 
     * @return The value of the PassThroughSettings property for this object.
     */
    public PassThroughSettings passThroughSettings() {
        return passThroughSettings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(aacSettings());
        hashCode = 31 * hashCode + Objects.hashCode(ac3Settings());
        hashCode = 31 * hashCode + Objects.hashCode(eac3Settings());
        hashCode = 31 * hashCode + Objects.hashCode(mp2Settings());
        hashCode = 31 * hashCode + Objects.hashCode(passThroughSettings());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AudioCodecSettings)) {
            return false;
        }
        AudioCodecSettings other = (AudioCodecSettings) obj;
        return Objects.equals(aacSettings(), other.aacSettings()) && Objects.equals(ac3Settings(), other.ac3Settings())
                && Objects.equals(eac3Settings(), other.eac3Settings()) && Objects.equals(mp2Settings(), other.mp2Settings())
                && Objects.equals(passThroughSettings(), other.passThroughSettings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("AudioCodecSettings").add("AacSettings", aacSettings()).add("Ac3Settings", ac3Settings())
                .add("Eac3Settings", eac3Settings()).add("Mp2Settings", mp2Settings())
                .add("PassThroughSettings", passThroughSettings()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AacSettings":
            return Optional.ofNullable(clazz.cast(aacSettings()));
        case "Ac3Settings":
            return Optional.ofNullable(clazz.cast(ac3Settings()));
        case "Eac3Settings":
            return Optional.ofNullable(clazz.cast(eac3Settings()));
        case "Mp2Settings":
            return Optional.ofNullable(clazz.cast(mp2Settings()));
        case "PassThroughSettings":
            return Optional.ofNullable(clazz.cast(passThroughSettings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AudioCodecSettings, T> g) {
        return obj -> g.apply((AudioCodecSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AudioCodecSettings> {
        /**
         * Sets the value of the AacSettings property for this object.
         *
         * @param aacSettings
         *        The new value for the AacSettings property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder aacSettings(AacSettings aacSettings);

        /**
         * Sets the value of the AacSettings property for this object.
         *
         * This is a convenience that creates an instance of the {@link AacSettings.Builder} avoiding the need to create
         * one manually via {@link AacSettings#builder()}.
         *
         * When the {@link Consumer} completes, {@link AacSettings.Builder#build()} is called immediately and its result
         * is passed to {@link #aacSettings(AacSettings)}.
         * 
         * @param aacSettings
         *        a consumer that will call methods on {@link AacSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #aacSettings(AacSettings)
         */
        default Builder aacSettings(Consumer<AacSettings.Builder> aacSettings) {
            return aacSettings(AacSettings.builder().applyMutation(aacSettings).build());
        }

        /**
         * Sets the value of the Ac3Settings property for this object.
         *
         * @param ac3Settings
         *        The new value for the Ac3Settings property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ac3Settings(Ac3Settings ac3Settings);

        /**
         * Sets the value of the Ac3Settings property for this object.
         *
         * This is a convenience that creates an instance of the {@link Ac3Settings.Builder} avoiding the need to create
         * one manually via {@link Ac3Settings#builder()}.
         *
         * When the {@link Consumer} completes, {@link Ac3Settings.Builder#build()} is called immediately and its result
         * is passed to {@link #ac3Settings(Ac3Settings)}.
         * 
         * @param ac3Settings
         *        a consumer that will call methods on {@link Ac3Settings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ac3Settings(Ac3Settings)
         */
        default Builder ac3Settings(Consumer<Ac3Settings.Builder> ac3Settings) {
            return ac3Settings(Ac3Settings.builder().applyMutation(ac3Settings).build());
        }

        /**
         * Sets the value of the Eac3Settings property for this object.
         *
         * @param eac3Settings
         *        The new value for the Eac3Settings property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eac3Settings(Eac3Settings eac3Settings);

        /**
         * Sets the value of the Eac3Settings property for this object.
         *
         * This is a convenience that creates an instance of the {@link Eac3Settings.Builder} avoiding the need to
         * create one manually via {@link Eac3Settings#builder()}.
         *
         * When the {@link Consumer} completes, {@link Eac3Settings.Builder#build()} is called immediately and its
         * result is passed to {@link #eac3Settings(Eac3Settings)}.
         * 
         * @param eac3Settings
         *        a consumer that will call methods on {@link Eac3Settings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #eac3Settings(Eac3Settings)
         */
        default Builder eac3Settings(Consumer<Eac3Settings.Builder> eac3Settings) {
            return eac3Settings(Eac3Settings.builder().applyMutation(eac3Settings).build());
        }

        /**
         * Sets the value of the Mp2Settings property for this object.
         *
         * @param mp2Settings
         *        The new value for the Mp2Settings property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mp2Settings(Mp2Settings mp2Settings);

        /**
         * Sets the value of the Mp2Settings property for this object.
         *
         * This is a convenience that creates an instance of the {@link Mp2Settings.Builder} avoiding the need to create
         * one manually via {@link Mp2Settings#builder()}.
         *
         * When the {@link Consumer} completes, {@link Mp2Settings.Builder#build()} is called immediately and its result
         * is passed to {@link #mp2Settings(Mp2Settings)}.
         * 
         * @param mp2Settings
         *        a consumer that will call methods on {@link Mp2Settings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #mp2Settings(Mp2Settings)
         */
        default Builder mp2Settings(Consumer<Mp2Settings.Builder> mp2Settings) {
            return mp2Settings(Mp2Settings.builder().applyMutation(mp2Settings).build());
        }

        /**
         * Sets the value of the PassThroughSettings property for this object.
         *
         * @param passThroughSettings
         *        The new value for the PassThroughSettings property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder passThroughSettings(PassThroughSettings passThroughSettings);

        /**
         * Sets the value of the PassThroughSettings property for this object.
         *
         * This is a convenience that creates an instance of the {@link PassThroughSettings.Builder} avoiding the need
         * to create one manually via {@link PassThroughSettings#builder()}.
         *
         * When the {@link Consumer} completes, {@link PassThroughSettings.Builder#build()} is called immediately and
         * its result is passed to {@link #passThroughSettings(PassThroughSettings)}.
         * 
         * @param passThroughSettings
         *        a consumer that will call methods on {@link PassThroughSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #passThroughSettings(PassThroughSettings)
         */
        default Builder passThroughSettings(Consumer<PassThroughSettings.Builder> passThroughSettings) {
            return passThroughSettings(PassThroughSettings.builder().applyMutation(passThroughSettings).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private AacSettings aacSettings;

        private Ac3Settings ac3Settings;

        private Eac3Settings eac3Settings;

        private Mp2Settings mp2Settings;

        private PassThroughSettings passThroughSettings;

        private BuilderImpl() {
        }

        private BuilderImpl(AudioCodecSettings model) {
            aacSettings(model.aacSettings);
            ac3Settings(model.ac3Settings);
            eac3Settings(model.eac3Settings);
            mp2Settings(model.mp2Settings);
            passThroughSettings(model.passThroughSettings);
        }

        public final AacSettings.Builder getAacSettings() {
            return aacSettings != null ? aacSettings.toBuilder() : null;
        }

        @Override
        public final Builder aacSettings(AacSettings aacSettings) {
            this.aacSettings = aacSettings;
            return this;
        }

        public final void setAacSettings(AacSettings.BuilderImpl aacSettings) {
            this.aacSettings = aacSettings != null ? aacSettings.build() : null;
        }

        public final Ac3Settings.Builder getAc3Settings() {
            return ac3Settings != null ? ac3Settings.toBuilder() : null;
        }

        @Override
        public final Builder ac3Settings(Ac3Settings ac3Settings) {
            this.ac3Settings = ac3Settings;
            return this;
        }

        public final void setAc3Settings(Ac3Settings.BuilderImpl ac3Settings) {
            this.ac3Settings = ac3Settings != null ? ac3Settings.build() : null;
        }

        public final Eac3Settings.Builder getEac3Settings() {
            return eac3Settings != null ? eac3Settings.toBuilder() : null;
        }

        @Override
        public final Builder eac3Settings(Eac3Settings eac3Settings) {
            this.eac3Settings = eac3Settings;
            return this;
        }

        public final void setEac3Settings(Eac3Settings.BuilderImpl eac3Settings) {
            this.eac3Settings = eac3Settings != null ? eac3Settings.build() : null;
        }

        public final Mp2Settings.Builder getMp2Settings() {
            return mp2Settings != null ? mp2Settings.toBuilder() : null;
        }

        @Override
        public final Builder mp2Settings(Mp2Settings mp2Settings) {
            this.mp2Settings = mp2Settings;
            return this;
        }

        public final void setMp2Settings(Mp2Settings.BuilderImpl mp2Settings) {
            this.mp2Settings = mp2Settings != null ? mp2Settings.build() : null;
        }

        public final PassThroughSettings.Builder getPassThroughSettings() {
            return passThroughSettings != null ? passThroughSettings.toBuilder() : null;
        }

        @Override
        public final Builder passThroughSettings(PassThroughSettings passThroughSettings) {
            this.passThroughSettings = passThroughSettings;
            return this;
        }

        public final void setPassThroughSettings(PassThroughSettings.BuilderImpl passThroughSettings) {
            this.passThroughSettings = passThroughSettings != null ? passThroughSettings.build() : null;
        }

        @Override
        public AudioCodecSettings build() {
            return new AudioCodecSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
