/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Archive Output Settings
 */
@Generated("software.amazon.awssdk:codegen")
public final class ArchiveOutputSettings implements SdkPojo, Serializable,
        ToCopyableBuilder<ArchiveOutputSettings.Builder, ArchiveOutputSettings> {
    private static final SdkField<ArchiveContainerSettings> CONTAINER_SETTINGS_FIELD = SdkField
            .<ArchiveContainerSettings> builder(MarshallingType.SDK_POJO)
            .getter(getter(ArchiveOutputSettings::containerSettings)).setter(setter(Builder::containerSettings))
            .constructor(ArchiveContainerSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("containerSettings").build()).build();

    private static final SdkField<String> EXTENSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ArchiveOutputSettings::extension)).setter(setter(Builder::extension))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("extension").build()).build();

    private static final SdkField<String> NAME_MODIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ArchiveOutputSettings::nameModifier)).setter(setter(Builder::nameModifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nameModifier").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTAINER_SETTINGS_FIELD,
            EXTENSION_FIELD, NAME_MODIFIER_FIELD));

    private static final long serialVersionUID = 1L;

    private final ArchiveContainerSettings containerSettings;

    private final String extension;

    private final String nameModifier;

    private ArchiveOutputSettings(BuilderImpl builder) {
        this.containerSettings = builder.containerSettings;
        this.extension = builder.extension;
        this.nameModifier = builder.nameModifier;
    }

    /**
     * Settings specific to the container type of the file.
     * 
     * @return Settings specific to the container type of the file.
     */
    public ArchiveContainerSettings containerSettings() {
        return containerSettings;
    }

    /**
     * Output file extension. If excluded, this will be auto-selected from the container type.
     * 
     * @return Output file extension. If excluded, this will be auto-selected from the container type.
     */
    public String extension() {
        return extension;
    }

    /**
     * String concatenated to the end of the destination filename. Required for multiple outputs of the same type.
     * 
     * @return String concatenated to the end of the destination filename. Required for multiple outputs of the same
     *         type.
     */
    public String nameModifier() {
        return nameModifier;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(containerSettings());
        hashCode = 31 * hashCode + Objects.hashCode(extension());
        hashCode = 31 * hashCode + Objects.hashCode(nameModifier());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ArchiveOutputSettings)) {
            return false;
        }
        ArchiveOutputSettings other = (ArchiveOutputSettings) obj;
        return Objects.equals(containerSettings(), other.containerSettings()) && Objects.equals(extension(), other.extension())
                && Objects.equals(nameModifier(), other.nameModifier());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ArchiveOutputSettings").add("ContainerSettings", containerSettings())
                .add("Extension", extension()).add("NameModifier", nameModifier()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ContainerSettings":
            return Optional.ofNullable(clazz.cast(containerSettings()));
        case "Extension":
            return Optional.ofNullable(clazz.cast(extension()));
        case "NameModifier":
            return Optional.ofNullable(clazz.cast(nameModifier()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ArchiveOutputSettings, T> g) {
        return obj -> g.apply((ArchiveOutputSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ArchiveOutputSettings> {
        /**
         * Settings specific to the container type of the file.
         * 
         * @param containerSettings
         *        Settings specific to the container type of the file.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder containerSettings(ArchiveContainerSettings containerSettings);

        /**
         * Settings specific to the container type of the file. This is a convenience that creates an instance of the
         * {@link ArchiveContainerSettings.Builder} avoiding the need to create one manually via
         * {@link ArchiveContainerSettings#builder()}.
         *
         * When the {@link Consumer} completes, {@link ArchiveContainerSettings.Builder#build()} is called immediately
         * and its result is passed to {@link #containerSettings(ArchiveContainerSettings)}.
         * 
         * @param containerSettings
         *        a consumer that will call methods on {@link ArchiveContainerSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #containerSettings(ArchiveContainerSettings)
         */
        default Builder containerSettings(Consumer<ArchiveContainerSettings.Builder> containerSettings) {
            return containerSettings(ArchiveContainerSettings.builder().applyMutation(containerSettings).build());
        }

        /**
         * Output file extension. If excluded, this will be auto-selected from the container type.
         * 
         * @param extension
         *        Output file extension. If excluded, this will be auto-selected from the container type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder extension(String extension);

        /**
         * String concatenated to the end of the destination filename. Required for multiple outputs of the same type.
         * 
         * @param nameModifier
         *        String concatenated to the end of the destination filename. Required for multiple outputs of the same
         *        type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nameModifier(String nameModifier);
    }

    static final class BuilderImpl implements Builder {
        private ArchiveContainerSettings containerSettings;

        private String extension;

        private String nameModifier;

        private BuilderImpl() {
        }

        private BuilderImpl(ArchiveOutputSettings model) {
            containerSettings(model.containerSettings);
            extension(model.extension);
            nameModifier(model.nameModifier);
        }

        public final ArchiveContainerSettings.Builder getContainerSettings() {
            return containerSettings != null ? containerSettings.toBuilder() : null;
        }

        @Override
        public final Builder containerSettings(ArchiveContainerSettings containerSettings) {
            this.containerSettings = containerSettings;
            return this;
        }

        public final void setContainerSettings(ArchiveContainerSettings.BuilderImpl containerSettings) {
            this.containerSettings = containerSettings != null ? containerSettings.build() : null;
        }

        public final String getExtension() {
            return extension;
        }

        @Override
        public final Builder extension(String extension) {
            this.extension = extension;
            return this;
        }

        public final void setExtension(String extension) {
            this.extension = extension;
        }

        public final String getNameModifier() {
            return nameModifier;
        }

        @Override
        public final Builder nameModifier(String nameModifier) {
            this.nameModifier = nameModifier;
            return this;
        }

        public final void setNameModifier(String nameModifier) {
            this.nameModifier = nameModifier;
        }

        @Override
        public ArchiveOutputSettings build() {
            return new ArchiveOutputSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
