/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.medialive.model.EncoderSettings;
import software.amazon.awssdk.services.medialive.model.InputAttachment;
import software.amazon.awssdk.services.medialive.model.InputSpecification;
import software.amazon.awssdk.services.medialive.model.LogLevel;
import software.amazon.awssdk.services.medialive.model.MediaLiveRequest;
import software.amazon.awssdk.services.medialive.model.OutputDestination;
import software.amazon.awssdk.services.medialive.model.___listOfInputAttachmentCopier;
import software.amazon.awssdk.services.medialive.model.___listOfOutputDestinationCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateChannelRequest
extends MediaLiveRequest
implements ToCopyableBuilder<Builder, UpdateChannelRequest> {
    private static final SdkField<String> CHANNEL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateChannelRequest.getter(UpdateChannelRequest::channelId)).setter(UpdateChannelRequest.setter(Builder::channelId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("channelId").build()}).build();
    private static final SdkField<List<OutputDestination>> DESTINATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(UpdateChannelRequest.getter(UpdateChannelRequest::destinations)).setter(UpdateChannelRequest.setter(Builder::destinations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(OutputDestination::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<EncoderSettings> ENCODER_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(UpdateChannelRequest.getter(UpdateChannelRequest::encoderSettings)).setter(UpdateChannelRequest.setter(Builder::encoderSettings)).constructor(EncoderSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("encoderSettings").build()}).build();
    private static final SdkField<List<InputAttachment>> INPUT_ATTACHMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(UpdateChannelRequest.getter(UpdateChannelRequest::inputAttachments)).setter(UpdateChannelRequest.setter(Builder::inputAttachments)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputAttachments").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(InputAttachment::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<InputSpecification> INPUT_SPECIFICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(UpdateChannelRequest.getter(UpdateChannelRequest::inputSpecification)).setter(UpdateChannelRequest.setter(Builder::inputSpecification)).constructor(InputSpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputSpecification").build()}).build();
    private static final SdkField<String> LOG_LEVEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateChannelRequest.getter(UpdateChannelRequest::logLevelAsString)).setter(UpdateChannelRequest.setter(Builder::logLevel)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logLevel").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateChannelRequest.getter(UpdateChannelRequest::name)).setter(UpdateChannelRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateChannelRequest.getter(UpdateChannelRequest::roleArn)).setter(UpdateChannelRequest.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHANNEL_ID_FIELD, DESTINATIONS_FIELD, ENCODER_SETTINGS_FIELD, INPUT_ATTACHMENTS_FIELD, INPUT_SPECIFICATION_FIELD, LOG_LEVEL_FIELD, NAME_FIELD, ROLE_ARN_FIELD));
    private final String channelId;
    private final List<OutputDestination> destinations;
    private final EncoderSettings encoderSettings;
    private final List<InputAttachment> inputAttachments;
    private final InputSpecification inputSpecification;
    private final String logLevel;
    private final String name;
    private final String roleArn;

    private UpdateChannelRequest(BuilderImpl builder) {
        super(builder);
        this.channelId = builder.channelId;
        this.destinations = builder.destinations;
        this.encoderSettings = builder.encoderSettings;
        this.inputAttachments = builder.inputAttachments;
        this.inputSpecification = builder.inputSpecification;
        this.logLevel = builder.logLevel;
        this.name = builder.name;
        this.roleArn = builder.roleArn;
    }

    public String channelId() {
        return this.channelId;
    }

    public boolean hasDestinations() {
        return this.destinations != null && !(this.destinations instanceof SdkAutoConstructList);
    }

    public List<OutputDestination> destinations() {
        return this.destinations;
    }

    public EncoderSettings encoderSettings() {
        return this.encoderSettings;
    }

    public boolean hasInputAttachments() {
        return this.inputAttachments != null && !(this.inputAttachments instanceof SdkAutoConstructList);
    }

    public List<InputAttachment> inputAttachments() {
        return this.inputAttachments;
    }

    public InputSpecification inputSpecification() {
        return this.inputSpecification;
    }

    public LogLevel logLevel() {
        return LogLevel.fromValue(this.logLevel);
    }

    public String logLevelAsString() {
        return this.logLevel;
    }

    public String name() {
        return this.name;
    }

    public String roleArn() {
        return this.roleArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.channelId());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinations());
        hashCode = 31 * hashCode + Objects.hashCode(this.encoderSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.inputAttachments());
        hashCode = 31 * hashCode + Objects.hashCode(this.inputSpecification());
        hashCode = 31 * hashCode + Objects.hashCode(this.logLevelAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateChannelRequest)) {
            return false;
        }
        UpdateChannelRequest other = (UpdateChannelRequest)((Object)obj);
        return Objects.equals(this.channelId(), other.channelId()) && Objects.equals(this.destinations(), other.destinations()) && Objects.equals(this.encoderSettings(), other.encoderSettings()) && Objects.equals(this.inputAttachments(), other.inputAttachments()) && Objects.equals(this.inputSpecification(), other.inputSpecification()) && Objects.equals(this.logLevelAsString(), other.logLevelAsString()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.roleArn(), other.roleArn());
    }

    public String toString() {
        return ToString.builder((String)"UpdateChannelRequest").add("ChannelId", (Object)this.channelId()).add("Destinations", this.destinations()).add("EncoderSettings", (Object)this.encoderSettings()).add("InputAttachments", this.inputAttachments()).add("InputSpecification", (Object)this.inputSpecification()).add("LogLevel", (Object)this.logLevelAsString()).add("Name", (Object)this.name()).add("RoleArn", (Object)this.roleArn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ChannelId": {
                return Optional.ofNullable(clazz.cast(this.channelId()));
            }
            case "Destinations": {
                return Optional.ofNullable(clazz.cast(this.destinations()));
            }
            case "EncoderSettings": {
                return Optional.ofNullable(clazz.cast(this.encoderSettings()));
            }
            case "InputAttachments": {
                return Optional.ofNullable(clazz.cast(this.inputAttachments()));
            }
            case "InputSpecification": {
                return Optional.ofNullable(clazz.cast(this.inputSpecification()));
            }
            case "LogLevel": {
                return Optional.ofNullable(clazz.cast(this.logLevelAsString()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "RoleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateChannelRequest, T> g) {
        return obj -> g.apply((UpdateChannelRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MediaLiveRequest.BuilderImpl
    implements Builder {
        private String channelId;
        private List<OutputDestination> destinations = DefaultSdkAutoConstructList.getInstance();
        private EncoderSettings encoderSettings;
        private List<InputAttachment> inputAttachments = DefaultSdkAutoConstructList.getInstance();
        private InputSpecification inputSpecification;
        private String logLevel;
        private String name;
        private String roleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateChannelRequest model) {
            super(model);
            this.channelId(model.channelId);
            this.destinations(model.destinations);
            this.encoderSettings(model.encoderSettings);
            this.inputAttachments(model.inputAttachments);
            this.inputSpecification(model.inputSpecification);
            this.logLevel(model.logLevel);
            this.name(model.name);
            this.roleArn(model.roleArn);
        }

        public final String getChannelId() {
            return this.channelId;
        }

        @Override
        public final Builder channelId(String channelId) {
            this.channelId = channelId;
            return this;
        }

        public final void setChannelId(String channelId) {
            this.channelId = channelId;
        }

        public final Collection<OutputDestination.Builder> getDestinations() {
            return this.destinations != null ? (Collection)this.destinations.stream().map(OutputDestination::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder destinations(Collection<OutputDestination> destinations) {
            this.destinations = ___listOfOutputDestinationCopier.copy(destinations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder destinations(OutputDestination ... destinations) {
            this.destinations(Arrays.asList(destinations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder destinations(Consumer<OutputDestination.Builder> ... destinations) {
            this.destinations(Stream.of(destinations).map(c -> (OutputDestination)((OutputDestination.Builder)OutputDestination.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setDestinations(Collection<OutputDestination.BuilderImpl> destinations) {
            this.destinations = ___listOfOutputDestinationCopier.copyFromBuilder(destinations);
        }

        public final EncoderSettings.Builder getEncoderSettings() {
            return this.encoderSettings != null ? this.encoderSettings.toBuilder() : null;
        }

        @Override
        public final Builder encoderSettings(EncoderSettings encoderSettings) {
            this.encoderSettings = encoderSettings;
            return this;
        }

        public final void setEncoderSettings(EncoderSettings.BuilderImpl encoderSettings) {
            this.encoderSettings = encoderSettings != null ? encoderSettings.build() : null;
        }

        public final Collection<InputAttachment.Builder> getInputAttachments() {
            return this.inputAttachments != null ? (Collection)this.inputAttachments.stream().map(InputAttachment::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder inputAttachments(Collection<InputAttachment> inputAttachments) {
            this.inputAttachments = ___listOfInputAttachmentCopier.copy(inputAttachments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputAttachments(InputAttachment ... inputAttachments) {
            this.inputAttachments(Arrays.asList(inputAttachments));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputAttachments(Consumer<InputAttachment.Builder> ... inputAttachments) {
            this.inputAttachments(Stream.of(inputAttachments).map(c -> (InputAttachment)((InputAttachment.Builder)InputAttachment.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setInputAttachments(Collection<InputAttachment.BuilderImpl> inputAttachments) {
            this.inputAttachments = ___listOfInputAttachmentCopier.copyFromBuilder(inputAttachments);
        }

        public final InputSpecification.Builder getInputSpecification() {
            return this.inputSpecification != null ? this.inputSpecification.toBuilder() : null;
        }

        @Override
        public final Builder inputSpecification(InputSpecification inputSpecification) {
            this.inputSpecification = inputSpecification;
            return this;
        }

        public final void setInputSpecification(InputSpecification.BuilderImpl inputSpecification) {
            this.inputSpecification = inputSpecification != null ? inputSpecification.build() : null;
        }

        public final String getLogLevelAsString() {
            return this.logLevel;
        }

        @Override
        public final Builder logLevel(String logLevel) {
            this.logLevel = logLevel;
            return this;
        }

        @Override
        public final Builder logLevel(LogLevel logLevel) {
            this.logLevel(logLevel == null ? null : logLevel.toString());
            return this;
        }

        public final void setLogLevel(String logLevel) {
            this.logLevel = logLevel;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateChannelRequest build() {
            return new UpdateChannelRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends MediaLiveRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateChannelRequest> {
        public Builder channelId(String var1);

        public Builder destinations(Collection<OutputDestination> var1);

        public Builder destinations(OutputDestination ... var1);

        public Builder destinations(Consumer<OutputDestination.Builder> ... var1);

        public Builder encoderSettings(EncoderSettings var1);

        default public Builder encoderSettings(Consumer<EncoderSettings.Builder> encoderSettings) {
            return this.encoderSettings((EncoderSettings)((EncoderSettings.Builder)EncoderSettings.builder().applyMutation(encoderSettings)).build());
        }

        public Builder inputAttachments(Collection<InputAttachment> var1);

        public Builder inputAttachments(InputAttachment ... var1);

        public Builder inputAttachments(Consumer<InputAttachment.Builder> ... var1);

        public Builder inputSpecification(InputSpecification var1);

        default public Builder inputSpecification(Consumer<InputSpecification.Builder> inputSpecification) {
            return this.inputSpecification((InputSpecification)((InputSpecification.Builder)InputSpecification.builder().applyMutation(inputSpecification)).build());
        }

        public Builder logLevel(String var1);

        public Builder logLevel(LogLevel var1);

        public Builder name(String var1);

        public Builder roleArn(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

