/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.medialive.model.InputDestinationRequest;
import software.amazon.awssdk.services.medialive.model.InputSourceRequest;
import software.amazon.awssdk.services.medialive.model.MediaLiveRequest;
import software.amazon.awssdk.services.medialive.model.___listOfInputDestinationRequestCopier;
import software.amazon.awssdk.services.medialive.model.___listOfInputSourceRequestCopier;
import software.amazon.awssdk.services.medialive.model.___listOf__stringCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateInputRequest
extends MediaLiveRequest
implements ToCopyableBuilder<Builder, UpdateInputRequest> {
    private static final SdkField<List<InputDestinationRequest>> DESTINATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(UpdateInputRequest.getter(UpdateInputRequest::destinations)).setter(UpdateInputRequest.setter(Builder::destinations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(InputDestinationRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> INPUT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateInputRequest.getter(UpdateInputRequest::inputId)).setter(UpdateInputRequest.setter(Builder::inputId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("inputId").build()}).build();
    private static final SdkField<List<String>> INPUT_SECURITY_GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(UpdateInputRequest.getter(UpdateInputRequest::inputSecurityGroups)).setter(UpdateInputRequest.setter(Builder::inputSecurityGroups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputSecurityGroups").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateInputRequest.getter(UpdateInputRequest::name)).setter(UpdateInputRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<List<InputSourceRequest>> SOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(UpdateInputRequest.getter(UpdateInputRequest::sources)).setter(UpdateInputRequest.setter(Builder::sources)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sources").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(InputSourceRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESTINATIONS_FIELD, INPUT_ID_FIELD, INPUT_SECURITY_GROUPS_FIELD, NAME_FIELD, SOURCES_FIELD));
    private final List<InputDestinationRequest> destinations;
    private final String inputId;
    private final List<String> inputSecurityGroups;
    private final String name;
    private final List<InputSourceRequest> sources;

    private UpdateInputRequest(BuilderImpl builder) {
        super(builder);
        this.destinations = builder.destinations;
        this.inputId = builder.inputId;
        this.inputSecurityGroups = builder.inputSecurityGroups;
        this.name = builder.name;
        this.sources = builder.sources;
    }

    public List<InputDestinationRequest> destinations() {
        return this.destinations;
    }

    public String inputId() {
        return this.inputId;
    }

    public List<String> inputSecurityGroups() {
        return this.inputSecurityGroups;
    }

    public String name() {
        return this.name;
    }

    public List<InputSourceRequest> sources() {
        return this.sources;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.destinations());
        hashCode = 31 * hashCode + Objects.hashCode(this.inputId());
        hashCode = 31 * hashCode + Objects.hashCode(this.inputSecurityGroups());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.sources());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateInputRequest)) {
            return false;
        }
        UpdateInputRequest other = (UpdateInputRequest)((Object)obj);
        return Objects.equals(this.destinations(), other.destinations()) && Objects.equals(this.inputId(), other.inputId()) && Objects.equals(this.inputSecurityGroups(), other.inputSecurityGroups()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.sources(), other.sources());
    }

    public String toString() {
        return ToString.builder((String)"UpdateInputRequest").add("Destinations", this.destinations()).add("InputId", (Object)this.inputId()).add("InputSecurityGroups", this.inputSecurityGroups()).add("Name", (Object)this.name()).add("Sources", this.sources()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Destinations": {
                return Optional.ofNullable(clazz.cast(this.destinations()));
            }
            case "InputId": {
                return Optional.ofNullable(clazz.cast(this.inputId()));
            }
            case "InputSecurityGroups": {
                return Optional.ofNullable(clazz.cast(this.inputSecurityGroups()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Sources": {
                return Optional.ofNullable(clazz.cast(this.sources()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateInputRequest, T> g) {
        return obj -> g.apply((UpdateInputRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MediaLiveRequest.BuilderImpl
    implements Builder {
        private List<InputDestinationRequest> destinations = DefaultSdkAutoConstructList.getInstance();
        private String inputId;
        private List<String> inputSecurityGroups = DefaultSdkAutoConstructList.getInstance();
        private String name;
        private List<InputSourceRequest> sources = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateInputRequest model) {
            super(model);
            this.destinations(model.destinations);
            this.inputId(model.inputId);
            this.inputSecurityGroups(model.inputSecurityGroups);
            this.name(model.name);
            this.sources(model.sources);
        }

        public final Collection<InputDestinationRequest.Builder> getDestinations() {
            return this.destinations != null ? (Collection)this.destinations.stream().map(InputDestinationRequest::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder destinations(Collection<InputDestinationRequest> destinations) {
            this.destinations = ___listOfInputDestinationRequestCopier.copy(destinations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder destinations(InputDestinationRequest ... destinations) {
            this.destinations(Arrays.asList(destinations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder destinations(Consumer<InputDestinationRequest.Builder> ... destinations) {
            this.destinations(Stream.of(destinations).map(c -> (InputDestinationRequest)((InputDestinationRequest.Builder)InputDestinationRequest.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setDestinations(Collection<InputDestinationRequest.BuilderImpl> destinations) {
            this.destinations = ___listOfInputDestinationRequestCopier.copyFromBuilder(destinations);
        }

        public final String getInputId() {
            return this.inputId;
        }

        @Override
        public final Builder inputId(String inputId) {
            this.inputId = inputId;
            return this;
        }

        public final void setInputId(String inputId) {
            this.inputId = inputId;
        }

        public final Collection<String> getInputSecurityGroups() {
            return this.inputSecurityGroups;
        }

        @Override
        public final Builder inputSecurityGroups(Collection<String> inputSecurityGroups) {
            this.inputSecurityGroups = ___listOf__stringCopier.copy(inputSecurityGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputSecurityGroups(String ... inputSecurityGroups) {
            this.inputSecurityGroups(Arrays.asList(inputSecurityGroups));
            return this;
        }

        public final void setInputSecurityGroups(Collection<String> inputSecurityGroups) {
            this.inputSecurityGroups = ___listOf__stringCopier.copy(inputSecurityGroups);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Collection<InputSourceRequest.Builder> getSources() {
            return this.sources != null ? (Collection)this.sources.stream().map(InputSourceRequest::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder sources(Collection<InputSourceRequest> sources) {
            this.sources = ___listOfInputSourceRequestCopier.copy(sources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sources(InputSourceRequest ... sources) {
            this.sources(Arrays.asList(sources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sources(Consumer<InputSourceRequest.Builder> ... sources) {
            this.sources(Stream.of(sources).map(c -> (InputSourceRequest)((InputSourceRequest.Builder)InputSourceRequest.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setSources(Collection<InputSourceRequest.BuilderImpl> sources) {
            this.sources = ___listOfInputSourceRequestCopier.copyFromBuilder(sources);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateInputRequest build() {
            return new UpdateInputRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends MediaLiveRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateInputRequest> {
        public Builder destinations(Collection<InputDestinationRequest> var1);

        public Builder destinations(InputDestinationRequest ... var1);

        public Builder destinations(Consumer<InputDestinationRequest.Builder> ... var1);

        public Builder inputId(String var1);

        public Builder inputSecurityGroups(Collection<String> var1);

        public Builder inputSecurityGroups(String ... var1);

        public Builder name(String var1);

        public Builder sources(Collection<InputSourceRequest> var1);

        public Builder sources(InputSourceRequest ... var1);

        public Builder sources(Consumer<InputSourceRequest.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

