/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.medialive.model.VideoCodecSettings;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class VideoCodecSettingsMarshaller {
    private static final MarshallingInfo<StructuredPojo> H264SETTINGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("h264Settings").isBinary(false).build();
    private static final VideoCodecSettingsMarshaller INSTANCE = new VideoCodecSettingsMarshaller();

    private VideoCodecSettingsMarshaller() {
    }

    public static VideoCodecSettingsMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(VideoCodecSettings videoCodecSettings, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)videoCodecSettings, (String)"videoCodecSettings");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)videoCodecSettings.h264Settings(), H264SETTINGS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

