/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.medialive.model.ValidationError;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ValidationErrorMarshaller {
    private static final MarshallingInfo<String> ELEMENTPATH_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("elementPath").isBinary(false).build();
    private static final MarshallingInfo<String> ERRORMESSAGE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("errorMessage").isBinary(false).build();
    private static final ValidationErrorMarshaller INSTANCE = new ValidationErrorMarshaller();

    private ValidationErrorMarshaller() {
    }

    public static ValidationErrorMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ValidationError validationError, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)validationError, (String)"validationError");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)validationError.elementPath(), ELEMENTPATH_BINDING);
            protocolMarshaller.marshall((Object)validationError.errorMessage(), ERRORMESSAGE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

