/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.medialive.model.UdpGroupSettings;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class UdpGroupSettingsMarshaller {
    private static final MarshallingInfo<String> INPUTLOSSACTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("inputLossAction").isBinary(false).build();
    private static final MarshallingInfo<String> TIMEDMETADATAID3FRAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("timedMetadataId3Frame").isBinary(false).build();
    private static final MarshallingInfo<Integer> TIMEDMETADATAID3PERIOD_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("timedMetadataId3Period").isBinary(false).build();
    private static final UdpGroupSettingsMarshaller INSTANCE = new UdpGroupSettingsMarshaller();

    private UdpGroupSettingsMarshaller() {
    }

    public static UdpGroupSettingsMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(UdpGroupSettings udpGroupSettings, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)udpGroupSettings, (String)"udpGroupSettings");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)udpGroupSettings.inputLossActionString(), INPUTLOSSACTION_BINDING);
            protocolMarshaller.marshall((Object)udpGroupSettings.timedMetadataId3FrameString(), TIMEDMETADATAID3FRAME_BINDING);
            protocolMarshaller.marshall((Object)udpGroupSettings.timedMetadataId3Period(), TIMEDMETADATAID3PERIOD_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

