/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.medialive.model.TimecodeConfig;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class TimecodeConfigMarshaller {
    private static final MarshallingInfo<String> SOURCE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("source").isBinary(false).build();
    private static final MarshallingInfo<Integer> SYNCTHRESHOLD_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("syncThreshold").isBinary(false).build();
    private static final TimecodeConfigMarshaller INSTANCE = new TimecodeConfigMarshaller();

    private TimecodeConfigMarshaller() {
    }

    public static TimecodeConfigMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(TimecodeConfig timecodeConfig, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)timecodeConfig, (String)"timecodeConfig");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)timecodeConfig.sourceString(), SOURCE_BINDING);
            protocolMarshaller.marshall((Object)timecodeConfig.syncThreshold(), SYNCTHRESHOLD_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

