/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.medialive.model.StaticKeySettings;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class StaticKeySettingsMarshaller {
    private static final MarshallingInfo<StructuredPojo> KEYPROVIDERSERVER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("keyProviderServer").isBinary(false).build();
    private static final MarshallingInfo<String> STATICKEYVALUE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("staticKeyValue").isBinary(false).build();
    private static final StaticKeySettingsMarshaller INSTANCE = new StaticKeySettingsMarshaller();

    private StaticKeySettingsMarshaller() {
    }

    public static StaticKeySettingsMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(StaticKeySettings staticKeySettings, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)staticKeySettings, (String)"staticKeySettings");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)staticKeySettings.keyProviderServer(), KEYPROVIDERSERVER_BINDING);
            protocolMarshaller.marshall((Object)staticKeySettings.staticKeyValue(), STATICKEYVALUE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

