/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.ListUnmarshaller;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.medialive.model.Output;
import software.amazon.awssdk.services.medialive.transform.OutputSettingsUnmarshaller;

public class OutputUnmarshaller
implements Unmarshaller<Output, JsonUnmarshallerContext> {
    private static final OutputUnmarshaller INSTANCE = new OutputUnmarshaller();

    public Output unmarshall(JsonUnmarshallerContext context) throws Exception {
        Output.Builder outputBuilder = Output.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("audioDescriptionNames", targetDepth)) {
                    context.nextToken();
                    outputBuilder.audioDescriptionNames(new ListUnmarshaller(context.getUnmarshaller(String.class)).unmarshall(context));
                }
                if (context.testExpression("captionDescriptionNames", targetDepth)) {
                    context.nextToken();
                    outputBuilder.captionDescriptionNames(new ListUnmarshaller(context.getUnmarshaller(String.class)).unmarshall(context));
                }
                if (context.testExpression("outputName", targetDepth)) {
                    context.nextToken();
                    outputBuilder.outputName((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("outputSettings", targetDepth)) {
                    context.nextToken();
                    outputBuilder.outputSettings(OutputSettingsUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("videoDescriptionName", targetDepth)) {
                    context.nextToken();
                    outputBuilder.videoDescriptionName((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (Output)outputBuilder.build();
    }

    public static OutputUnmarshaller getInstance() {
        return INSTANCE;
    }
}

