/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.medialive.model.Output;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class OutputMarshaller {
    private static final MarshallingInfo<List> AUDIODESCRIPTIONNAMES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("audioDescriptionNames").isBinary(false).build();
    private static final MarshallingInfo<List> CAPTIONDESCRIPTIONNAMES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("captionDescriptionNames").isBinary(false).build();
    private static final MarshallingInfo<String> OUTPUTNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("outputName").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> OUTPUTSETTINGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("outputSettings").isBinary(false).build();
    private static final MarshallingInfo<String> VIDEODESCRIPTIONNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("videoDescriptionName").isBinary(false).build();
    private static final OutputMarshaller INSTANCE = new OutputMarshaller();

    private OutputMarshaller() {
    }

    public static OutputMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(Output output, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)output, (String)"output");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall(output.audioDescriptionNames(), AUDIODESCRIPTIONNAMES_BINDING);
            protocolMarshaller.marshall(output.captionDescriptionNames(), CAPTIONDESCRIPTIONNAMES_BINDING);
            protocolMarshaller.marshall((Object)output.outputName(), OUTPUTNAME_BINDING);
            protocolMarshaller.marshall((Object)output.outputSettings(), OUTPUTSETTINGS_BINDING);
            protocolMarshaller.marshall((Object)output.videoDescriptionName(), VIDEODESCRIPTIONNAME_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

