/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.medialive.model.Mp2Settings;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class Mp2SettingsMarshaller {
    private static final MarshallingInfo<Double> BITRATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DOUBLE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("bitrate").isBinary(false).build();
    private static final MarshallingInfo<String> CODINGMODE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("codingMode").isBinary(false).build();
    private static final MarshallingInfo<Double> SAMPLERATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DOUBLE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("sampleRate").isBinary(false).build();
    private static final Mp2SettingsMarshaller INSTANCE = new Mp2SettingsMarshaller();

    private Mp2SettingsMarshaller() {
    }

    public static Mp2SettingsMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(Mp2Settings mp2Settings, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)mp2Settings, (String)"mp2Settings");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)mp2Settings.bitrate(), BITRATE_BINDING);
            protocolMarshaller.marshall((Object)mp2Settings.codingModeString(), CODINGMODE_BINDING);
            protocolMarshaller.marshall((Object)mp2Settings.sampleRate(), SAMPLERATE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

