/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.medialive.model.M2tsSettings;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class M2tsSettingsMarshaller {
    private static final MarshallingInfo<String> ABSENTINPUTAUDIOBEHAVIOR_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("absentInputAudioBehavior").isBinary(false).build();
    private static final MarshallingInfo<String> ARIB_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("arib").isBinary(false).build();
    private static final MarshallingInfo<String> ARIBCAPTIONSPID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("aribCaptionsPid").isBinary(false).build();
    private static final MarshallingInfo<String> ARIBCAPTIONSPIDCONTROL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("aribCaptionsPidControl").isBinary(false).build();
    private static final MarshallingInfo<String> AUDIOBUFFERMODEL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("audioBufferModel").isBinary(false).build();
    private static final MarshallingInfo<Integer> AUDIOFRAMESPERPES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("audioFramesPerPes").isBinary(false).build();
    private static final MarshallingInfo<String> AUDIOPIDS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("audioPids").isBinary(false).build();
    private static final MarshallingInfo<String> AUDIOSTREAMTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("audioStreamType").isBinary(false).build();
    private static final MarshallingInfo<Integer> BITRATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("bitrate").isBinary(false).build();
    private static final MarshallingInfo<String> BUFFERMODEL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("bufferModel").isBinary(false).build();
    private static final MarshallingInfo<String> CCDESCRIPTOR_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ccDescriptor").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> DVBNITSETTINGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("dvbNitSettings").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> DVBSDTSETTINGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("dvbSdtSettings").isBinary(false).build();
    private static final MarshallingInfo<String> DVBSUBPIDS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("dvbSubPids").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> DVBTDTSETTINGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("dvbTdtSettings").isBinary(false).build();
    private static final MarshallingInfo<String> DVBTELETEXTPID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("dvbTeletextPid").isBinary(false).build();
    private static final MarshallingInfo<String> EBIF_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ebif").isBinary(false).build();
    private static final MarshallingInfo<String> EBPAUDIOINTERVAL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ebpAudioInterval").isBinary(false).build();
    private static final MarshallingInfo<Integer> EBPLOOKAHEADMS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ebpLookaheadMs").isBinary(false).build();
    private static final MarshallingInfo<String> EBPPLACEMENT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ebpPlacement").isBinary(false).build();
    private static final MarshallingInfo<String> ECMPID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ecmPid").isBinary(false).build();
    private static final MarshallingInfo<String> ESRATEINPES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("esRateInPes").isBinary(false).build();
    private static final MarshallingInfo<String> ETVPLATFORMPID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("etvPlatformPid").isBinary(false).build();
    private static final MarshallingInfo<String> ETVSIGNALPID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("etvSignalPid").isBinary(false).build();
    private static final MarshallingInfo<Double> FRAGMENTTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DOUBLE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("fragmentTime").isBinary(false).build();
    private static final MarshallingInfo<String> KLV_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("klv").isBinary(false).build();
    private static final MarshallingInfo<String> KLVDATAPIDS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("klvDataPids").isBinary(false).build();
    private static final MarshallingInfo<Double> NULLPACKETBITRATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DOUBLE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("nullPacketBitrate").isBinary(false).build();
    private static final MarshallingInfo<Integer> PATINTERVAL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("patInterval").isBinary(false).build();
    private static final MarshallingInfo<String> PCRCONTROL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("pcrControl").isBinary(false).build();
    private static final MarshallingInfo<Integer> PCRPERIOD_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("pcrPeriod").isBinary(false).build();
    private static final MarshallingInfo<String> PCRPID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("pcrPid").isBinary(false).build();
    private static final MarshallingInfo<Integer> PMTINTERVAL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("pmtInterval").isBinary(false).build();
    private static final MarshallingInfo<String> PMTPID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("pmtPid").isBinary(false).build();
    private static final MarshallingInfo<Integer> PROGRAMNUM_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("programNum").isBinary(false).build();
    private static final MarshallingInfo<String> RATEMODE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("rateMode").isBinary(false).build();
    private static final MarshallingInfo<String> SCTE27PIDS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("scte27Pids").isBinary(false).build();
    private static final MarshallingInfo<String> SCTE35CONTROL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("scte35Control").isBinary(false).build();
    private static final MarshallingInfo<String> SCTE35PID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("scte35Pid").isBinary(false).build();
    private static final MarshallingInfo<String> SEGMENTATIONMARKERS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("segmentationMarkers").isBinary(false).build();
    private static final MarshallingInfo<String> SEGMENTATIONSTYLE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("segmentationStyle").isBinary(false).build();
    private static final MarshallingInfo<Double> SEGMENTATIONTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DOUBLE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("segmentationTime").isBinary(false).build();
    private static final MarshallingInfo<String> TIMEDMETADATABEHAVIOR_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("timedMetadataBehavior").isBinary(false).build();
    private static final MarshallingInfo<String> TIMEDMETADATAPID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("timedMetadataPid").isBinary(false).build();
    private static final MarshallingInfo<Integer> TRANSPORTSTREAMID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("transportStreamId").isBinary(false).build();
    private static final MarshallingInfo<String> VIDEOPID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("videoPid").isBinary(false).build();
    private static final M2tsSettingsMarshaller INSTANCE = new M2tsSettingsMarshaller();

    private M2tsSettingsMarshaller() {
    }

    public static M2tsSettingsMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(M2tsSettings m2tsSettings, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)m2tsSettings, (String)"m2tsSettings");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)m2tsSettings.absentInputAudioBehaviorString(), ABSENTINPUTAUDIOBEHAVIOR_BINDING);
            protocolMarshaller.marshall((Object)m2tsSettings.aribString(), ARIB_BINDING);
            protocolMarshaller.marshall((Object)m2tsSettings.aribCaptionsPid(), ARIBCAPTIONSPID_BINDING);
            protocolMarshaller.marshall((Object)m2tsSettings.aribCaptionsPidControlString(), ARIBCAPTIONSPIDCONTROL_BINDING);
            protocolMarshaller.marshall((Object)m2tsSettings.audioBufferModelString(), AUDIOBUFFERMODEL_BINDING);
            protocolMarshaller.marshall((Object)m2tsSettings.audioFramesPerPes(), AUDIOFRAMESPERPES_BINDING);
            protocolMarshaller.marshall((Object)m2tsSettings.audioPids(), AUDIOPIDS_BINDING);
            protocolMarshaller.marshall((Object)m2tsSettings.audioStreamTypeString(), AUDIOSTREAMTYPE_BINDING);
            protocolMarshaller.marshall((Object)m2tsSettings.bitrate(), BITRATE_BINDING);
            protocolMarshaller.marshall((Object)m2tsSettings.bufferModelString(), BUFFERMODEL_BINDING);
            protocolMarshaller.marshall((Object)m2tsSettings.ccDescriptorString(), CCDESCRIPTOR_BINDING);
            protocolMarshaller.marshall((Object)m2tsSettings.dvbNitSettings(), DVBNITSETTINGS_BINDING);
            protocolMarshaller.marshall((Object)m2tsSettings.dvbSdtSettings(), DVBSDTSETTINGS_BINDING);
            protocolMarshaller.marshall((Object)m2tsSettings.dvbSubPids(), DVBSUBPIDS_BINDING);
            protocolMarshaller.marshall((Object)m2tsSettings.dvbTdtSettings(), DVBTDTSETTINGS_BINDING);
            protocolMarshaller.marshall((Object)m2tsSettings.dvbTeletextPid(), DVBTELETEXTPID_BINDING);
            protocolMarshaller.marshall((Object)m2tsSettings.ebifString(), EBIF_BINDING);
            protocolMarshaller.marshall((Object)m2tsSettings.ebpAudioIntervalString(), EBPAUDIOINTERVAL_BINDING);
            protocolMarshaller.marshall((Object)m2tsSettings.ebpLookaheadMs(), EBPLOOKAHEADMS_BINDING);
            protocolMarshaller.marshall((Object)m2tsSettings.ebpPlacementString(), EBPPLACEMENT_BINDING);
            protocolMarshaller.marshall((Object)m2tsSettings.ecmPid(), ECMPID_BINDING);
            protocolMarshaller.marshall((Object)m2tsSettings.esRateInPesString(), ESRATEINPES_BINDING);
            protocolMarshaller.marshall((Object)m2tsSettings.etvPlatformPid(), ETVPLATFORMPID_BINDING);
            protocolMarshaller.marshall((Object)m2tsSettings.etvSignalPid(), ETVSIGNALPID_BINDING);
            protocolMarshaller.marshall((Object)m2tsSettings.fragmentTime(), FRAGMENTTIME_BINDING);
            protocolMarshaller.marshall((Object)m2tsSettings.klvString(), KLV_BINDING);
            protocolMarshaller.marshall((Object)m2tsSettings.klvDataPids(), KLVDATAPIDS_BINDING);
            protocolMarshaller.marshall((Object)m2tsSettings.nullPacketBitrate(), NULLPACKETBITRATE_BINDING);
            protocolMarshaller.marshall((Object)m2tsSettings.patInterval(), PATINTERVAL_BINDING);
            protocolMarshaller.marshall((Object)m2tsSettings.pcrControlString(), PCRCONTROL_BINDING);
            protocolMarshaller.marshall((Object)m2tsSettings.pcrPeriod(), PCRPERIOD_BINDING);
            protocolMarshaller.marshall((Object)m2tsSettings.pcrPid(), PCRPID_BINDING);
            protocolMarshaller.marshall((Object)m2tsSettings.pmtInterval(), PMTINTERVAL_BINDING);
            protocolMarshaller.marshall((Object)m2tsSettings.pmtPid(), PMTPID_BINDING);
            protocolMarshaller.marshall((Object)m2tsSettings.programNum(), PROGRAMNUM_BINDING);
            protocolMarshaller.marshall((Object)m2tsSettings.rateModeString(), RATEMODE_BINDING);
            protocolMarshaller.marshall((Object)m2tsSettings.scte27Pids(), SCTE27PIDS_BINDING);
            protocolMarshaller.marshall((Object)m2tsSettings.scte35ControlString(), SCTE35CONTROL_BINDING);
            protocolMarshaller.marshall((Object)m2tsSettings.scte35Pid(), SCTE35PID_BINDING);
            protocolMarshaller.marshall((Object)m2tsSettings.segmentationMarkersString(), SEGMENTATIONMARKERS_BINDING);
            protocolMarshaller.marshall((Object)m2tsSettings.segmentationStyleString(), SEGMENTATIONSTYLE_BINDING);
            protocolMarshaller.marshall((Object)m2tsSettings.segmentationTime(), SEGMENTATIONTIME_BINDING);
            protocolMarshaller.marshall((Object)m2tsSettings.timedMetadataBehaviorString(), TIMEDMETADATABEHAVIOR_BINDING);
            protocolMarshaller.marshall((Object)m2tsSettings.timedMetadataPid(), TIMEDMETADATAPID_BINDING);
            protocolMarshaller.marshall((Object)m2tsSettings.transportStreamId(), TRANSPORTSTREAMID_BINDING);
            protocolMarshaller.marshall((Object)m2tsSettings.videoPid(), VIDEOPID_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

