/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.medialive.model.KeyProviderSettings;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class KeyProviderSettingsMarshaller {
    private static final MarshallingInfo<StructuredPojo> STATICKEYSETTINGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("staticKeySettings").isBinary(false).build();
    private static final KeyProviderSettingsMarshaller INSTANCE = new KeyProviderSettingsMarshaller();

    private KeyProviderSettingsMarshaller() {
    }

    public static KeyProviderSettingsMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(KeyProviderSettings keyProviderSettings, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)keyProviderSettings, (String)"keyProviderSettings");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)keyProviderSettings.staticKeySettings(), STATICKEYSETTINGS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

