/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.ListUnmarshaller;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.medialive.model.InputSettings;
import software.amazon.awssdk.services.medialive.transform.AudioSelectorUnmarshaller;
import software.amazon.awssdk.services.medialive.transform.CaptionSelectorUnmarshaller;
import software.amazon.awssdk.services.medialive.transform.NetworkInputSettingsUnmarshaller;
import software.amazon.awssdk.services.medialive.transform.VideoSelectorUnmarshaller;

public class InputSettingsUnmarshaller
implements Unmarshaller<InputSettings, JsonUnmarshallerContext> {
    private static final InputSettingsUnmarshaller INSTANCE = new InputSettingsUnmarshaller();

    public InputSettings unmarshall(JsonUnmarshallerContext context) throws Exception {
        InputSettings.Builder inputSettingsBuilder = InputSettings.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("audioSelectors", targetDepth)) {
                    context.nextToken();
                    inputSettingsBuilder.audioSelectors(new ListUnmarshaller((Unmarshaller)AudioSelectorUnmarshaller.getInstance()).unmarshall(context));
                }
                if (context.testExpression("captionSelectors", targetDepth)) {
                    context.nextToken();
                    inputSettingsBuilder.captionSelectors(new ListUnmarshaller((Unmarshaller)CaptionSelectorUnmarshaller.getInstance()).unmarshall(context));
                }
                if (context.testExpression("deblockFilter", targetDepth)) {
                    context.nextToken();
                    inputSettingsBuilder.deblockFilter((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("denoiseFilter", targetDepth)) {
                    context.nextToken();
                    inputSettingsBuilder.denoiseFilter((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("filterStrength", targetDepth)) {
                    context.nextToken();
                    inputSettingsBuilder.filterStrength((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
                if (context.testExpression("inputFilter", targetDepth)) {
                    context.nextToken();
                    inputSettingsBuilder.inputFilter((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("networkInputSettings", targetDepth)) {
                    context.nextToken();
                    inputSettingsBuilder.networkInputSettings(NetworkInputSettingsUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("sourceEndBehavior", targetDepth)) {
                    context.nextToken();
                    inputSettingsBuilder.sourceEndBehavior((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("videoSelector", targetDepth)) {
                    context.nextToken();
                    inputSettingsBuilder.videoSelector(VideoSelectorUnmarshaller.getInstance().unmarshall(context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (InputSettings)inputSettingsBuilder.build();
    }

    public static InputSettingsUnmarshaller getInstance() {
        return INSTANCE;
    }
}

