/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.medialive.model.InputChannelLevel;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class InputChannelLevelMarshaller {
    private static final MarshallingInfo<Integer> GAIN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("gain").isBinary(false).build();
    private static final MarshallingInfo<Integer> INPUTCHANNEL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("inputChannel").isBinary(false).build();
    private static final InputChannelLevelMarshaller INSTANCE = new InputChannelLevelMarshaller();

    private InputChannelLevelMarshaller() {
    }

    public static InputChannelLevelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(InputChannelLevel inputChannelLevel, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)inputChannelLevel, (String)"inputChannelLevel");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)inputChannelLevel.gain(), GAIN_BINDING);
            protocolMarshaller.marshall((Object)inputChannelLevel.inputChannel(), INPUTCHANNEL_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

