/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.medialive.model.HlsSettings;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class HlsSettingsMarshaller {
    private static final MarshallingInfo<StructuredPojo> AUDIOONLYHLSSETTINGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("audioOnlyHlsSettings").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> STANDARDHLSSETTINGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("standardHlsSettings").isBinary(false).build();
    private static final HlsSettingsMarshaller INSTANCE = new HlsSettingsMarshaller();

    private HlsSettingsMarshaller() {
    }

    public static HlsSettingsMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(HlsSettings hlsSettings, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)hlsSettings, (String)"hlsSettings");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)hlsSettings.audioOnlyHlsSettings(), AUDIOONLYHLSSETTINGS_BINDING);
            protocolMarshaller.marshall((Object)hlsSettings.standardHlsSettings(), STANDARDHLSSETTINGS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

