/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.medialive.model.HlsOutputSettings;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class HlsOutputSettingsMarshaller {
    private static final MarshallingInfo<StructuredPojo> HLSSETTINGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("hlsSettings").isBinary(false).build();
    private static final MarshallingInfo<String> NAMEMODIFIER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("nameModifier").isBinary(false).build();
    private static final MarshallingInfo<String> SEGMENTMODIFIER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("segmentModifier").isBinary(false).build();
    private static final HlsOutputSettingsMarshaller INSTANCE = new HlsOutputSettingsMarshaller();

    private HlsOutputSettingsMarshaller() {
    }

    public static HlsOutputSettingsMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(HlsOutputSettings hlsOutputSettings, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)hlsOutputSettings, (String)"hlsOutputSettings");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)hlsOutputSettings.hlsSettings(), HLSSETTINGS_BINDING);
            protocolMarshaller.marshall((Object)hlsOutputSettings.nameModifier(), NAMEMODIFIER_BINDING);
            protocolMarshaller.marshall((Object)hlsOutputSettings.segmentModifier(), SEGMENTMODIFIER_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

