/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.medialive.model.H264Settings;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class H264SettingsMarshaller {
    private static final MarshallingInfo<String> ADAPTIVEQUANTIZATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("adaptiveQuantization").isBinary(false).build();
    private static final MarshallingInfo<String> AFDSIGNALING_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("afdSignaling").isBinary(false).build();
    private static final MarshallingInfo<Integer> BITRATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("bitrate").isBinary(false).build();
    private static final MarshallingInfo<Integer> BUFFILLPCT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("bufFillPct").isBinary(false).build();
    private static final MarshallingInfo<Integer> BUFSIZE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("bufSize").isBinary(false).build();
    private static final MarshallingInfo<String> COLORMETADATA_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("colorMetadata").isBinary(false).build();
    private static final MarshallingInfo<String> ENTROPYENCODING_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("entropyEncoding").isBinary(false).build();
    private static final MarshallingInfo<String> FIXEDAFD_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("fixedAfd").isBinary(false).build();
    private static final MarshallingInfo<String> FLICKERAQ_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("flickerAq").isBinary(false).build();
    private static final MarshallingInfo<String> FRAMERATECONTROL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("framerateControl").isBinary(false).build();
    private static final MarshallingInfo<Integer> FRAMERATEDENOMINATOR_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("framerateDenominator").isBinary(false).build();
    private static final MarshallingInfo<Integer> FRAMERATENUMERATOR_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("framerateNumerator").isBinary(false).build();
    private static final MarshallingInfo<String> GOPBREFERENCE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("gopBReference").isBinary(false).build();
    private static final MarshallingInfo<Integer> GOPCLOSEDCADENCE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("gopClosedCadence").isBinary(false).build();
    private static final MarshallingInfo<Integer> GOPNUMBFRAMES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("gopNumBFrames").isBinary(false).build();
    private static final MarshallingInfo<Double> GOPSIZE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DOUBLE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("gopSize").isBinary(false).build();
    private static final MarshallingInfo<String> GOPSIZEUNITS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("gopSizeUnits").isBinary(false).build();
    private static final MarshallingInfo<String> LEVEL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("level").isBinary(false).build();
    private static final MarshallingInfo<String> LOOKAHEADRATECONTROL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("lookAheadRateControl").isBinary(false).build();
    private static final MarshallingInfo<Integer> MAXBITRATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("maxBitrate").isBinary(false).build();
    private static final MarshallingInfo<Integer> MINIINTERVAL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("minIInterval").isBinary(false).build();
    private static final MarshallingInfo<Integer> NUMREFFRAMES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("numRefFrames").isBinary(false).build();
    private static final MarshallingInfo<String> PARCONTROL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("parControl").isBinary(false).build();
    private static final MarshallingInfo<Integer> PARDENOMINATOR_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("parDenominator").isBinary(false).build();
    private static final MarshallingInfo<Integer> PARNUMERATOR_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("parNumerator").isBinary(false).build();
    private static final MarshallingInfo<String> PROFILE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("profile").isBinary(false).build();
    private static final MarshallingInfo<String> RATECONTROLMODE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("rateControlMode").isBinary(false).build();
    private static final MarshallingInfo<String> SCANTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("scanType").isBinary(false).build();
    private static final MarshallingInfo<String> SCENECHANGEDETECT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("sceneChangeDetect").isBinary(false).build();
    private static final MarshallingInfo<Integer> SLICES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("slices").isBinary(false).build();
    private static final MarshallingInfo<Integer> SOFTNESS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("softness").isBinary(false).build();
    private static final MarshallingInfo<String> SPATIALAQ_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("spatialAq").isBinary(false).build();
    private static final MarshallingInfo<String> SYNTAX_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("syntax").isBinary(false).build();
    private static final MarshallingInfo<String> TEMPORALAQ_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("temporalAq").isBinary(false).build();
    private static final MarshallingInfo<String> TIMECODEINSERTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("timecodeInsertion").isBinary(false).build();
    private static final H264SettingsMarshaller INSTANCE = new H264SettingsMarshaller();

    private H264SettingsMarshaller() {
    }

    public static H264SettingsMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(H264Settings h264Settings, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)h264Settings, (String)"h264Settings");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)h264Settings.adaptiveQuantizationString(), ADAPTIVEQUANTIZATION_BINDING);
            protocolMarshaller.marshall((Object)h264Settings.afdSignalingString(), AFDSIGNALING_BINDING);
            protocolMarshaller.marshall((Object)h264Settings.bitrate(), BITRATE_BINDING);
            protocolMarshaller.marshall((Object)h264Settings.bufFillPct(), BUFFILLPCT_BINDING);
            protocolMarshaller.marshall((Object)h264Settings.bufSize(), BUFSIZE_BINDING);
            protocolMarshaller.marshall((Object)h264Settings.colorMetadataString(), COLORMETADATA_BINDING);
            protocolMarshaller.marshall((Object)h264Settings.entropyEncodingString(), ENTROPYENCODING_BINDING);
            protocolMarshaller.marshall((Object)h264Settings.fixedAfdString(), FIXEDAFD_BINDING);
            protocolMarshaller.marshall((Object)h264Settings.flickerAqString(), FLICKERAQ_BINDING);
            protocolMarshaller.marshall((Object)h264Settings.framerateControlString(), FRAMERATECONTROL_BINDING);
            protocolMarshaller.marshall((Object)h264Settings.framerateDenominator(), FRAMERATEDENOMINATOR_BINDING);
            protocolMarshaller.marshall((Object)h264Settings.framerateNumerator(), FRAMERATENUMERATOR_BINDING);
            protocolMarshaller.marshall((Object)h264Settings.gopBReferenceString(), GOPBREFERENCE_BINDING);
            protocolMarshaller.marshall((Object)h264Settings.gopClosedCadence(), GOPCLOSEDCADENCE_BINDING);
            protocolMarshaller.marshall((Object)h264Settings.gopNumBFrames(), GOPNUMBFRAMES_BINDING);
            protocolMarshaller.marshall((Object)h264Settings.gopSize(), GOPSIZE_BINDING);
            protocolMarshaller.marshall((Object)h264Settings.gopSizeUnitsString(), GOPSIZEUNITS_BINDING);
            protocolMarshaller.marshall((Object)h264Settings.levelString(), LEVEL_BINDING);
            protocolMarshaller.marshall((Object)h264Settings.lookAheadRateControlString(), LOOKAHEADRATECONTROL_BINDING);
            protocolMarshaller.marshall((Object)h264Settings.maxBitrate(), MAXBITRATE_BINDING);
            protocolMarshaller.marshall((Object)h264Settings.minIInterval(), MINIINTERVAL_BINDING);
            protocolMarshaller.marshall((Object)h264Settings.numRefFrames(), NUMREFFRAMES_BINDING);
            protocolMarshaller.marshall((Object)h264Settings.parControlString(), PARCONTROL_BINDING);
            protocolMarshaller.marshall((Object)h264Settings.parDenominator(), PARDENOMINATOR_BINDING);
            protocolMarshaller.marshall((Object)h264Settings.parNumerator(), PARNUMERATOR_BINDING);
            protocolMarshaller.marshall((Object)h264Settings.profileString(), PROFILE_BINDING);
            protocolMarshaller.marshall((Object)h264Settings.rateControlModeString(), RATECONTROLMODE_BINDING);
            protocolMarshaller.marshall((Object)h264Settings.scanTypeString(), SCANTYPE_BINDING);
            protocolMarshaller.marshall((Object)h264Settings.sceneChangeDetectString(), SCENECHANGEDETECT_BINDING);
            protocolMarshaller.marshall((Object)h264Settings.slices(), SLICES_BINDING);
            protocolMarshaller.marshall((Object)h264Settings.softness(), SOFTNESS_BINDING);
            protocolMarshaller.marshall((Object)h264Settings.spatialAqString(), SPATIALAQ_BINDING);
            protocolMarshaller.marshall((Object)h264Settings.syntaxString(), SYNTAX_BINDING);
            protocolMarshaller.marshall((Object)h264Settings.temporalAqString(), TEMPORALAQ_BINDING);
            protocolMarshaller.marshall((Object)h264Settings.timecodeInsertionString(), TIMECODEINSERTION_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

