/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.ListUnmarshaller;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.medialive.model.EncoderSettings;
import software.amazon.awssdk.services.medialive.transform.AudioDescriptionUnmarshaller;
import software.amazon.awssdk.services.medialive.transform.AvailBlankingUnmarshaller;
import software.amazon.awssdk.services.medialive.transform.AvailConfigurationUnmarshaller;
import software.amazon.awssdk.services.medialive.transform.BlackoutSlateUnmarshaller;
import software.amazon.awssdk.services.medialive.transform.CaptionDescriptionUnmarshaller;
import software.amazon.awssdk.services.medialive.transform.GlobalConfigurationUnmarshaller;
import software.amazon.awssdk.services.medialive.transform.OutputGroupUnmarshaller;
import software.amazon.awssdk.services.medialive.transform.TimecodeConfigUnmarshaller;
import software.amazon.awssdk.services.medialive.transform.VideoDescriptionUnmarshaller;

public class EncoderSettingsUnmarshaller
implements Unmarshaller<EncoderSettings, JsonUnmarshallerContext> {
    private static final EncoderSettingsUnmarshaller INSTANCE = new EncoderSettingsUnmarshaller();

    public EncoderSettings unmarshall(JsonUnmarshallerContext context) throws Exception {
        EncoderSettings.Builder encoderSettingsBuilder = EncoderSettings.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("audioDescriptions", targetDepth)) {
                    context.nextToken();
                    encoderSettingsBuilder.audioDescriptions(new ListUnmarshaller((Unmarshaller)AudioDescriptionUnmarshaller.getInstance()).unmarshall(context));
                }
                if (context.testExpression("availBlanking", targetDepth)) {
                    context.nextToken();
                    encoderSettingsBuilder.availBlanking(AvailBlankingUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("availConfiguration", targetDepth)) {
                    context.nextToken();
                    encoderSettingsBuilder.availConfiguration(AvailConfigurationUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("blackoutSlate", targetDepth)) {
                    context.nextToken();
                    encoderSettingsBuilder.blackoutSlate(BlackoutSlateUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("captionDescriptions", targetDepth)) {
                    context.nextToken();
                    encoderSettingsBuilder.captionDescriptions(new ListUnmarshaller((Unmarshaller)CaptionDescriptionUnmarshaller.getInstance()).unmarshall(context));
                }
                if (context.testExpression("globalConfiguration", targetDepth)) {
                    context.nextToken();
                    encoderSettingsBuilder.globalConfiguration(GlobalConfigurationUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("outputGroups", targetDepth)) {
                    context.nextToken();
                    encoderSettingsBuilder.outputGroups(new ListUnmarshaller((Unmarshaller)OutputGroupUnmarshaller.getInstance()).unmarshall(context));
                }
                if (context.testExpression("timecodeConfig", targetDepth)) {
                    context.nextToken();
                    encoderSettingsBuilder.timecodeConfig(TimecodeConfigUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("videoDescriptions", targetDepth)) {
                    context.nextToken();
                    encoderSettingsBuilder.videoDescriptions(new ListUnmarshaller((Unmarshaller)VideoDescriptionUnmarshaller.getInstance()).unmarshall(context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (EncoderSettings)encoderSettingsBuilder.build();
    }

    public static EncoderSettingsUnmarshaller getInstance() {
        return INSTANCE;
    }
}

