/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.medialive.model.Eac3Settings;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class Eac3SettingsMarshaller {
    private static final MarshallingInfo<String> ATTENUATIONCONTROL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("attenuationControl").isBinary(false).build();
    private static final MarshallingInfo<Double> BITRATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DOUBLE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("bitrate").isBinary(false).build();
    private static final MarshallingInfo<String> BITSTREAMMODE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("bitstreamMode").isBinary(false).build();
    private static final MarshallingInfo<String> CODINGMODE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("codingMode").isBinary(false).build();
    private static final MarshallingInfo<String> DCFILTER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("dcFilter").isBinary(false).build();
    private static final MarshallingInfo<Integer> DIALNORM_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("dialnorm").isBinary(false).build();
    private static final MarshallingInfo<String> DRCLINE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("drcLine").isBinary(false).build();
    private static final MarshallingInfo<String> DRCRF_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("drcRf").isBinary(false).build();
    private static final MarshallingInfo<String> LFECONTROL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("lfeControl").isBinary(false).build();
    private static final MarshallingInfo<String> LFEFILTER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("lfeFilter").isBinary(false).build();
    private static final MarshallingInfo<Double> LOROCENTERMIXLEVEL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DOUBLE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("loRoCenterMixLevel").isBinary(false).build();
    private static final MarshallingInfo<Double> LOROSURROUNDMIXLEVEL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DOUBLE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("loRoSurroundMixLevel").isBinary(false).build();
    private static final MarshallingInfo<Double> LTRTCENTERMIXLEVEL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DOUBLE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ltRtCenterMixLevel").isBinary(false).build();
    private static final MarshallingInfo<Double> LTRTSURROUNDMIXLEVEL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DOUBLE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ltRtSurroundMixLevel").isBinary(false).build();
    private static final MarshallingInfo<String> METADATACONTROL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("metadataControl").isBinary(false).build();
    private static final MarshallingInfo<String> PASSTHROUGHCONTROL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("passthroughControl").isBinary(false).build();
    private static final MarshallingInfo<String> PHASECONTROL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("phaseControl").isBinary(false).build();
    private static final MarshallingInfo<String> STEREODOWNMIX_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("stereoDownmix").isBinary(false).build();
    private static final MarshallingInfo<String> SURROUNDEXMODE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("surroundExMode").isBinary(false).build();
    private static final MarshallingInfo<String> SURROUNDMODE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("surroundMode").isBinary(false).build();
    private static final Eac3SettingsMarshaller INSTANCE = new Eac3SettingsMarshaller();

    private Eac3SettingsMarshaller() {
    }

    public static Eac3SettingsMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(Eac3Settings eac3Settings, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)eac3Settings, (String)"eac3Settings");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)eac3Settings.attenuationControlString(), ATTENUATIONCONTROL_BINDING);
            protocolMarshaller.marshall((Object)eac3Settings.bitrate(), BITRATE_BINDING);
            protocolMarshaller.marshall((Object)eac3Settings.bitstreamModeString(), BITSTREAMMODE_BINDING);
            protocolMarshaller.marshall((Object)eac3Settings.codingModeString(), CODINGMODE_BINDING);
            protocolMarshaller.marshall((Object)eac3Settings.dcFilterString(), DCFILTER_BINDING);
            protocolMarshaller.marshall((Object)eac3Settings.dialnorm(), DIALNORM_BINDING);
            protocolMarshaller.marshall((Object)eac3Settings.drcLineString(), DRCLINE_BINDING);
            protocolMarshaller.marshall((Object)eac3Settings.drcRfString(), DRCRF_BINDING);
            protocolMarshaller.marshall((Object)eac3Settings.lfeControlString(), LFECONTROL_BINDING);
            protocolMarshaller.marshall((Object)eac3Settings.lfeFilterString(), LFEFILTER_BINDING);
            protocolMarshaller.marshall((Object)eac3Settings.loRoCenterMixLevel(), LOROCENTERMIXLEVEL_BINDING);
            protocolMarshaller.marshall((Object)eac3Settings.loRoSurroundMixLevel(), LOROSURROUNDMIXLEVEL_BINDING);
            protocolMarshaller.marshall((Object)eac3Settings.ltRtCenterMixLevel(), LTRTCENTERMIXLEVEL_BINDING);
            protocolMarshaller.marshall((Object)eac3Settings.ltRtSurroundMixLevel(), LTRTSURROUNDMIXLEVEL_BINDING);
            protocolMarshaller.marshall((Object)eac3Settings.metadataControlString(), METADATACONTROL_BINDING);
            protocolMarshaller.marshall((Object)eac3Settings.passthroughControlString(), PASSTHROUGHCONTROL_BINDING);
            protocolMarshaller.marshall((Object)eac3Settings.phaseControlString(), PHASECONTROL_BINDING);
            protocolMarshaller.marshall((Object)eac3Settings.stereoDownmixString(), STEREODOWNMIX_BINDING);
            protocolMarshaller.marshall((Object)eac3Settings.surroundExModeString(), SURROUNDEXMODE_BINDING);
            protocolMarshaller.marshall((Object)eac3Settings.surroundModeString(), SURROUNDMODE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

