/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.util.IdempotentUtils;
import software.amazon.awssdk.services.medialive.model.CreateInputRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class CreateInputRequestModelMarshaller {
    private static final MarshallingInfo<List> DESTINATIONS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("destinations").isBinary(false).build();
    private static final MarshallingInfo<List> INPUTSECURITYGROUPS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("inputSecurityGroups").isBinary(false).build();
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("name").isBinary(false).build();
    private static final MarshallingInfo<String> REQUESTID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("requestId").isBinary(false).defaultValueSupplier(IdempotentUtils.getGenerator()).build();
    private static final MarshallingInfo<List> SOURCES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("sources").isBinary(false).build();
    private static final MarshallingInfo<String> TYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("type").isBinary(false).build();
    private static final CreateInputRequestModelMarshaller INSTANCE = new CreateInputRequestModelMarshaller();

    private CreateInputRequestModelMarshaller() {
    }

    public static CreateInputRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(CreateInputRequest createInputRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)createInputRequest), (String)"createInputRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall(createInputRequest.destinations(), DESTINATIONS_BINDING);
            protocolMarshaller.marshall(createInputRequest.inputSecurityGroups(), INPUTSECURITYGROUPS_BINDING);
            protocolMarshaller.marshall((Object)createInputRequest.name(), NAME_BINDING);
            protocolMarshaller.marshall((Object)createInputRequest.requestId(), REQUESTID_BINDING);
            protocolMarshaller.marshall(createInputRequest.sources(), SOURCES_BINDING);
            protocolMarshaller.marshall((Object)createInputRequest.typeString(), TYPE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

